<?php
/**
 * ProcedimientoDao.php
 * Modelo para la persistencia de datos de procedimientos
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Procedimiento.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'DetalleProcedimiento.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class ProcedimientoDao extends Model
{
    
    public function __construct() {
        parent::__construct();
    }    
    
    public function guardarProcedimiento(Procedimiento $p)
    {
        $sql = "INSERT INTO `manuales_procedimientos` (`Folio`, `Procedimiento`, `Id_Categoria`, "
                . "`Id_Usuario`, `Status`) VALUES (?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $p->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindValue(2, $p->__get('_procedimiento'), PDO::PARAM_STR);
        $stmt->bindValue(3, $p->__get('_idCategoria'), PDO::PARAM_INT);
        $stmt->bindValue(4, $p->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(5, $p->__get('_status'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idProcedimiento'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude guardar los datos de tu procedimiento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function insertarDetalleProcedimiento($fecha, $descripcion, $documento, $ruta, $idUsuario, $idProcedimiento)
    {
        $sql = "INSERT INTO `manuales_procedimientos_detalle` (`Fecha`, `Descripcion`, `documento`, `ruta`, "
                . "`Id_Usuario`, `Id_Procedimiento`) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(3, $documento, PDO::PARAM_STR);
        $stmt->bindValue(4, $ruta, PDO::PARAM_STR);
        $stmt->bindValue(5, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(6, $idProcedimiento, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar algunos datos de tu procedimiento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerProcedimientos($inicio, $registros)
    {
        $sql = "SELECT `manuales_procedimientos`.`Id_Manual`, `manuales_procedimientos`.`Folio`, "
                . "`manuales_procedimientos`.`Procedimiento`, `manuales_procedimientos`.`Fecha`, `categorias_procedimientos`.`Categoria`, "
                . "`usuarios`.`Nombre`, `usuarios`.`Apellido_Paterno`, `usuarios`.`Apellido_Materno`, `manuales_procedimientos_detalle`.`documento` "
                . "FROM `manuales_procedimientos` INNER JOIN `categorias_procedimientos` ON `categorias_procedimientos`.`Id_Categoria` = "
                . "`manuales_procedimientos`.`Id_Categoria` INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = "
                . "`manuales_procedimientos`.`Id_Usuario` INNER JOIN `manuales_procedimientos_detalle` ON `manuales_procedimientos_detalle`.`Id_Procedimiento` = `manuales_procedimientos`.`Id_Manual` WHERE `manuales_procedimientos`.`Status` = 1 ORDER BY `categorias_procedimientos`.`Id_Categoria` "
                . "LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['procedimientos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude obtener los datos de los procedimientos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalProcedimientos()
    {
        $sql = "SELECT `Id_Manual` FROM `manuales_procedimientos` WHERE `Status` = 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude calcular el total de procedimientos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalProcedimientosAutorizar()
    {
        $sql = "SELECT `Id_Manual` FROM `manuales_procedimientos` WHERE `Status`  = 0";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude calcular el total de procedimientos por '
                    . 'autorizar. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerProcedimientosAutorizar($inicio, $registros)
    {
        $sql = "SELECT `manuales_procedimientos`.`Id_Manual`, `manuales_procedimientos`.`Folio`, "
                . "`manuales_procedimientos`.`Procedimiento`, `categorias_procedimientos`.`Categoria`, "
                . "`usuarios`.`Nombre`, `usuarios`.`Apellido_Paterno`, `usuarios`.`Apellido_Materno`, `manuales_procedimientos_detalle`.`Descripcion`, "
                . "`manuales_procedimientos_detalle`.`documento`, `manuales_procedimientos_detalle`.`Fecha`, `manuales_procedimientos_detalle`.`ruta` FROM `manuales_procedimientos` INNER JOIN `categorias_procedimientos` ON `categorias_procedimientos`.`Id_Categoria` = "
                . "`manuales_procedimientos`.`Id_Categoria` INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = "
                . "`manuales_procedimientos`.`Id_Usuario` INNER JOIN `manuales_procedimientos_detalle` ON `manuales_procedimientos_detalle`.`Id_Procedimiento` = `manuales_procedimientos`.`Id_Manual`"
                . " WHERE `manuales_procedimientos`.`Status` = 0 ORDER BY `categorias_procedimientos`.`Id_Categoria` "
                . "LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['procedimientos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude obtener los datos de los procedimientos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function totalProcedimientosCategoria(Procedimiento $p)
    {
        $sql = "SELECT `Id_Manual` FROM `manuales_procedimientos` WHERE `Id_Categoria` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $p->__get('_idCategoria'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude obtener el total de procedimentos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function cambiarStatus(Procedimiento $p)
    {   
        $sql = "UPDATE `manuales_procedimientos` SET `Status` = ? WHERE `Id_Manual` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $p->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(2, $p->__get('_idProcedimiento'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, no pude actualizar el procedimiento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerDetalleAutorizar($idProcedimiento)
    {
        $sql = "SELECT * FROM `manuales_procedimientos_detalle` WHERE `Id_Procedimiento` = ? AND `Id_Autoriza` = 0 ORDER BY `Id_Procedimiento_Detalle` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProcedimiento, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['datosDetalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener el detalle del documento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function usuarioAutoriza($idUsuario, $idProcedimiento)
    {
        $sql = "UPDATE `manuales_procedimientos_detalle` SET `Id_Autoriza` = ? WHERE `Id_Procedimiento_Detalle` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idProcedimiento, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $$e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un problema al autorizar el documento. ' . 
                    TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerProcedimiento(Procedimiento $p)
    {
        $sql = "SELECT * FROM `manuales_procedimientos` INNER JOIN `manuales_procedimientos_detalle` ON "
                . "`manuales_procedimientos_detalle`.`Id_Procedimiento` = `manuales_procedimientos`.`Id_Manual` "
                . "WHERE `manuales_procedimientos`.`Id_Manual` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $p->__get('_idProcedimiento'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['procedimiento'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ńo pude obtener los datos del procedimiento. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerListaProcedimientosPorUsuario($idUsuario)
    {
        $sql = "SELECT `Id_Manual`, `Procedimiento` FROM `manuales_procedimientos` WHERE "
                . "`Status` = 1 AND `Id_Usuario` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['procedimientos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la lista de '
                    . 'procedimientos. ' . TICKETS;
        }
        
        return $response;
    }
}