<?php
/**
 * Description of LPADao
 *
 * @author sistemas
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class RiesgosPsicologicosDao extends Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getPreguntas(){
        $SQL = "SELECT * FROM preguntas_riesgos_psicologicos where grupo != 'atencion' and grupo != 'jefeOtrosTrabajadores'   ";
        $stmt = $this->_dbh->prepare($SQL);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener las preguntas. ' . TICKETS;
        }

        return $response;
    }

    public function getPreguntasAtencionClientes(){
        $SQL = "SELECT * FROM preguntas_riesgos_psicologicos where grupo = 'atencion'  ";
        $stmt = $this->_dbh->prepare($SQL);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener las preguntas. ' . TICKETS;
        }

        return $response;
    }

    public function getPreguntasJefeOtrosTrabajadores(){
        $SQL = "SELECT * FROM preguntas_riesgos_psicologicos where grupo = 'jefeOtrosTrabajadores'  ";
        $stmt = $this->_dbh->prepare($SQL);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener las preguntas. ' . TICKETS;
        }

        return $response;
    }

}
