<?php
/**
 * RutinaDao.php
 * Modelo para el manejo de vehículos 
 * @author Ivan Santos Pérez
 * @copyright (c) 2018, Merdiz
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class RutinaDao extends Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getRutinas($idSucursal, $inicio, $registros){
        $sql = "SELECT SQL_CALC_FOUND_ROWS r.*, v.Vehiculo, v.Placas 
                    FROM `rutinas` r INNER JOIN vehiculos v ON r.Id_Vehiculo = v.Id_Vehiculo 
                        WHERE r.`Id_Sucursal` = ? AND v.Status = 1  AND v.Id_Sucursal = r.Id_Sucursal
                    ORDER BY r.Status DESC, Vehiculo, Placas LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['rutinas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de los rutinas';
        }

        return $response;
    }

    public function findRutina($idSucursal, $inicio, $registros, $termino){
        $sql = "SELECT SQL_CALC_FOUND_ROWS r.*, v.Vehiculo, v.Placas 
                    FROM `rutinas` r INNER JOIN vehiculos v ON r.Id_Vehiculo = v.Id_Vehiculo 
                        WHERE r.`Id_Sucursal` = ? AND v.Status = 1 AND v.Id_Sucursal = r.Id_Sucursal AND (Rutina LIKE ? OR Vehiculo LIKE ? OR Placas LIKE ?) 
                    ORDER BY r.Status DESC, Vehiculo, Placas LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(3, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(4, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(5, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(6, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['rutinas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las rutinas';
        }

        return $response;
    }

    public function getRutina($idRutina){
        $sql = "SELECT * FROM `rutinas` WHERE `Id_Rutina` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idRutina, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['rutina'] = $stmt->fetch(PDO::FETCH_OBJ);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de la rutina';
        }

        return $response;
    }

    public function guardaRutina($vehiculo, $rutina, $freq, $stat, $suc, $idRutina, $tipo){
    	if($tipo == 1){
	    	$SQL = "INSERT INTO rutinas 
	    					(Id_Rutina, Id_Vehiculo, Rutina, Frecuencia, Status, Id_Sucursal) 
	    				VALUES 
	    					(NULL, ?, ?, ?, ?, ?) ";
    	}else{
    		$SQL = "UPDATE rutinas SET Id_Vehiculo = ? , Rutina = ?, Frecuencia = ?, Status = ?, Id_Sucursal = ? WHERE Id_Rutina = ? ";
    	}

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $vehiculo, PDO::PARAM_INT);
        $stmt->bindValue(2, $rutina, PDO::PARAM_STR);
        $stmt->bindValue(3, $freq, PDO::PARAM_INT);
        $stmt->bindValue(4, $stat, PDO::PARAM_INT);
        $stmt->bindValue(5, $suc, PDO::PARAM_INT);
        if($tipo == 2){
	        $stmt->bindValue(6, $idRutina, PDO::PARAM_INT);
	    }

        try{
            $stmt->execute();
            if($tipo == 1) $idRutina = $this->_dbh->lastInsertId();
            $response['status'] = true;
            $response['idRutina'] = $idRutina;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar la rutina. '
                    . TICKETS;
        }
        
        return $response;
    }

    public function getRutinasVehiculoRecorrido($vehiculo, $kmFinal){
        $SQL = "SELECT SQL_CALC_FOUND_ROWS * FROM rutinas INNER JOIN vehiculos ON vehiculos.Id_Vehiculo = rutinas.Id_Vehiculo 
                    WHERE rutinas.Status = 1 AND vehiculos.Id_Vehiculo = :vehi 
                    AND (:final) >= (rutinas.Frecuencia*round(:final/rutinas.Frecuencia)-200)
                    AND (:final) <= (rutinas.Frecuencia*round(:final/rutinas.Frecuencia)+200) ";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindParam(':vehi', $vehiculo, PDO::PARAM_INT);
        $stmt->bindParam(':final', $kmFinal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['rutinas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las rutinas';
        }

        return $response;
    }
    
    
}