<?php
/**
 * ServiciosClienteDao.php
 * Modelo para la persistencia de datos de servicios_cliente
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ServiciosCliente.php';

class ServiciosClienteDao extends Model
{
	public function __construct() {
        parent::__construct();
    }

    public function getServiciosCliente($idCliente)
    {
    	$sql = "SELECT * FROM servicios_cliente WHERE Id_Cliente = ?";
    	$stmt = $this->_dbh->prepare($sql);
    	$stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
    	try{
    		$stmt->execute();
    		$response['status'] = true;
            $response['existe'] = $stmt->rowCount();
    		$response['servicios'] = $stmt->fetch();
    	}catch(PDOException $e){
    		Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
    		$response['status'] = false;
    		$response['error'] = 'Ocurrió un error al traer los servicios del cliente. ' . TICKETS;
    	}

    	return $response;
    }  

    public function obtenerServicios($idCliente)
    {
        $sql = "SELECT * FROM servicios_cliente WHERE Id_Cliente = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['existe'] = $stmt->rowCount();
            $response['servicios'] = $stmt->fetch(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los servicios del cliente. ' . TICKETS;
        }

        return $response;
    }   

    public function guardar(ServiciosCliente $s){
        $sql = "INSERT INTO servicios_cliente (Analyst, CantidadAnalyst, Videocheck, CantidadVideocheck, LubeCoach, CantidadLubeCoach,
                               LubeAdvisor, CantidadLubeAdvisor, LubeExpert, CantidadLubeExpert, LubeMatch, CantidadLubeMatch, ShellControl,
                               CantidadShellControl, LubeEquipment, CantidadLubeEquipment, LubeFilter, CantidadLubeFilter, LubeProject, CantidadLubeProject,
                               Status, Id_Cliente, LubeSupport, CantidadLubeSupport, LubePerformance, CantidadLubePerformance,
                               LubeCompetitive, CantidadLubeCompetitive, LubeOptions, CantidadLubeOptions, LubePlanner, CantidadLubePlanner) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $s->__get('_analyst'), PDO::PARAM_INT);
        $stmt->bindValue(2, $s->__get('_cantidadAnalyst'), PDO::PARAM_INT);
        $stmt->bindValue(3, $s->__get('_videocheck'), PDO::PARAM_INT);
        $stmt->bindValue(4, $s->__get('_cantidadVideocheck'), PDO::PARAM_INT);
        $stmt->bindValue(5, $s->__get('_lubcoach'), PDO::PARAM_INT);
        $stmt->bindValue(6, $s->__get('_cantidadlubcoach'), PDO::PARAM_INT);
        $stmt->bindValue(7, $s->__get('_advisor'), PDO::PARAM_INT);
        $stmt->bindValue(8, $s->__get('_cantidadAdvisor'), PDO::PARAM_INT);
        $stmt->bindValue(9, $s->__get('_lubeExpert'), PDO::PARAM_INT);
        $stmt->bindValue(10, $s->__get('_cantidadLubeExpert'), PDO::PARAM_INT);
        $stmt->bindValue(11, $s->__get('_lubeMatch'), PDO::PARAM_INT);
        $stmt->bindValue(12, $s->__get('_cantidadLubeMatch'), PDO::PARAM_INT);
        $stmt->bindValue(13, $s->__get('_shellControl'), PDO::PARAM_INT);
        $stmt->bindValue(14, $s->__get('_cantidadShellControl'), PDO::PARAM_INT);
        $stmt->bindValue(15, $s->__get('_lubeEquipment'), PDO::PARAM_INT);
        $stmt->bindValue(16, $s->__get('_cantidadLubEquipment'), PDO::PARAM_INT);
        $stmt->bindValue(17, $s->__get('_lubeFilter'), PDO::PARAM_INT); 
        $stmt->bindValue(18, $s->__get('_cantidadLubeFilter'), PDO::PARAM_INT);
        $stmt->bindValue(19, $s->__get('_lubeProject'), PDO::PARAM_INT);
        $stmt->bindValue(20, $s->__get('_cantidadLubeProject'), PDO::PARAM_INT);
        $stmt->bindValue(21, $s->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(22, $s->__get('_idCliente'), PDO::PARAM_INT);
        $stmt->bindValue(23, $s->__get('_lubeSupport'), PDO::PARAM_INT);
        $stmt->bindValue(24, $s->__get('_cantidadLubeSupport'), PDO::PARAM_INT);
        $stmt->bindValue(25, $s->__get('_lubePerformance'), PDO::PARAM_INT);
        $stmt->bindValue(26, $s->__get('_cantidadLubePerformance'), PDO::PARAM_INT);
        $stmt->bindValue(27, $s->__get('_lubeCompetitive'), PDO::PARAM_INT);
        $stmt->bindValue(28, $s->__get('_cantidadLubeCompetitive'), PDO::PARAM_INT);
        $stmt->bindValue(29, $s->__get('_lubeOptions'), PDO::PARAM_INT);
        $stmt->bindValue(30, $s->__get('_cantidadLubeOptions'), PDO::PARAM_INT);
        $stmt->bindValue(31, $s->__get('_lubePlanner'), PDO::PARAM_INT);
        $stmt->bindValue(32, $s->__get('_cantidadLubePlanner'), PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;            
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al guardar los servicios del cliente. ' . TICKETS;
        }

        return $response;
    }

    public function cambiarStatus($idServicio, $status){
        $sql = "UPDATE servicios_cliente SET Status = ? WHERE Id_Servicio_Cliente = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_INT);
        $stmt->bindValue(2, $idServicio, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al cambiar el status de los servicios. ' . TICKETS;
        }

        return $response;
    }

    public function eliminaServiciosCliente($idCliente){
        $sql = "DELETE FROM servicios_cliente WHERE Id_Cliente = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al eliminar los servicios del cliente. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerServiciosAutorizados($idCliente){
        $sql = "SELECT * FROM servicios_cliente WHERE Id_Cliente = ? AND Status = 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['servicios'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener los servicios shell. ' . TICKETS;
        }

        return $response;
    }

}
