<?php
/**
 * SeguridadDao.php
 * Modelo para la persistencia de datos de minutas
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
        'models' . DIRECTORY_SEPARATOR . 'Seguridad.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';



class SistemasCalidadDao extends Model
{
	public function __construct() {
        parent::__construct();
    }


    public function altaActividadSeguridad(Seguridad $s){
        $sql = "INSERT INTO `tareas_seguridad_sistema_calidad` ( `nombre`, `clave`, `id_responsablepachuca`, `id_responsablequeretaro`, `id_responsablepuebla`,"
            . " `dias_limites`, `id_codigo_calidad`, `descripcion`,`archivo`,`tipo`,`tipo_descripcion`, `fecha_inicio`, `id_editorarchivo`, `id_sucursal_responsable`) "
            . "VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";


        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $s->__get('_nombre'), PDO::PARAM_STR);
        $stmt->bindValue(2, $s->__get('_clave'), PDO::PARAM_STR);
        $stmt->bindValue(3, $s->__get('_idResponsablepachuca'), PDO::PARAM_INT);
        $stmt->bindValue(4, $s->__get('_idResponsablequeretaro'), PDO::PARAM_INT);
        $stmt->bindValue(5, $s->__get('_idResponsablepuebla'), PDO::PARAM_INT);
        $stmt->bindValue(6, $s->__get('_Dialimite'), PDO::PARAM_INT);
        $stmt->bindValue(7, $s->__get('_categoria'), PDO::PARAM_STR);
        $stmt->bindValue(8, $s->__get('_descripcion'), PDO::PARAM_STR);
        $stmt->bindValue(9, $s->__get('_archivo'), PDO::PARAM_STR);
        $stmt->bindValue(10, $s->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(11, $s->__get('_tipoDescripcion'), PDO::PARAM_STR);
        $stmt->bindValue(12, $s->__get('_fechaInicio'), PDO::PARAM_STR);
        $stmt->bindValue(13, $s->__get('_responsableremplazararchivo'), PDO::PARAM_INT);
        $stmt->bindValue(14, $s->__get('_idSucursal'), PDO::PARAM_INT);


        try{
            $stmt->execute();
            $response['id'] = $this->_dbh->lastInsertId();
            //$idMinuta = $this->_dbh->lastInsertId();
            //$response['idMinuta'] = $idMinuta;
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al dar de alta la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function editarActividadSeguridad(Seguridad $s, $actualizar){
        if($actualizar ==1 ){

            $sql = "UPDATE `tareas_seguridad_sistema_calidad` SET `nombre` = ?, `clave` = ?, id_responsablepachuca = ?, "
                . "id_responsablequeretaro = ?, id_responsablepuebla = ?, `dias_limites` = ?, `id_codigo_calidad` = ?, "
                . "`descripcion` = ?, `archivo` = ?, `tipo` = ?,`tipo_descripcion` = ?, `id_editorarchivo` = ?, `id_sucursal_responsable` = ? , `fecha_inicio` = ?  "
                . "WHERE id_tareas_seguridad = ?";

            $stmt = $this->_dbh->prepare($sql);
            $stmt->bindValue(1, $s->__get('_nombre'), PDO::PARAM_STR);
            $stmt->bindValue(2, $s->__get('_clave'), PDO::PARAM_STR);
            $stmt->bindValue(3, $s->__get('_idResponsablepachuca'), PDO::PARAM_INT);
            $stmt->bindValue(4, $s->__get('_idResponsablequeretaro'), PDO::PARAM_INT);
            $stmt->bindValue(5, $s->__get('_idResponsablepuebla'), PDO::PARAM_INT);
            $stmt->bindValue(6, $s->__get('_Dialimite'), PDO::PARAM_INT);
            $stmt->bindValue(7, $s->__get('_categoria'), PDO::PARAM_INT);
            $stmt->bindValue(8, $s->__get('_descripcion'), PDO::PARAM_STR);
            $stmt->bindValue(9, $s->__get('_archivo'), PDO::PARAM_STR);
            $stmt->bindValue(10, $s->__get('_tipo'), PDO::PARAM_STR);
            $stmt->bindValue(11, $s->__get('_tipoDescripcion'), PDO::PARAM_STR);
            $stmt->bindValue(12, $s->__get('_responsableremplazararchivo'), PDO::PARAM_INT);
            $stmt->bindValue(13, $s->__get('_idSucursal'), PDO::PARAM_INT);
            $stmt->bindValue(14, $s->__get('_fechaInicio'), PDO::PARAM_STR);
            $stmt->bindValue(15, $s->__get('_idSeguridad'), PDO::PARAM_INT);




        }else {
            $sql = "UPDATE `tareas_seguridad_sistema_calidad` SET `nombre` = ?, `clave` = ?, id_responsablepachuca = ?, "
                . "id_responsablequeretaro = ?, id_responsablepuebla = ?, `dias_limites` = ?, `id_codigo_calidad` = ?, "
                . "`descripcion` = ?, `tipo` = ?,`tipo_descripcion` = ?, `id_editorarchivo` = ?, `id_sucursal_responsable` = ? , `fecha_inicio` = ?  "
                . "WHERE id_tareas_seguridad = ?";

            $stmt = $this->_dbh->prepare($sql);
            $stmt->bindValue(1, $s->__get('_nombre'), PDO::PARAM_STR);
            $stmt->bindValue(2, $s->__get('_clave'), PDO::PARAM_STR);
            $stmt->bindValue(3, $s->__get('_idResponsablepachuca'), PDO::PARAM_INT);
            $stmt->bindValue(4, $s->__get('_idResponsablequeretaro'), PDO::PARAM_INT);
            $stmt->bindValue(5, $s->__get('_idResponsablepuebla'), PDO::PARAM_INT);
            $stmt->bindValue(6, $s->__get('_Dialimite'), PDO::PARAM_INT);
            $stmt->bindValue(7, $s->__get('_categoria'), PDO::PARAM_INT);
            $stmt->bindValue(8, $s->__get('_descripcion'), PDO::PARAM_STR);
            $stmt->bindValue(9, $s->__get('_tipo'), PDO::PARAM_STR);
            $stmt->bindValue(10, $s->__get('_tipoDescripcion'), PDO::PARAM_STR);
            $stmt->bindValue(11, $s->__get('_responsableremplazararchivo'), PDO::PARAM_INT);
            $stmt->bindValue(12, $s->__get('_idSucursal'), PDO::PARAM_INT);
            $stmt->bindValue(13, $s->__get('_fechaInicio'), PDO::PARAM_STR);
            $stmt->bindValue(14, $s->__get('_idSeguridad'), PDO::PARAM_INT);

        }

        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al editar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function subirArchivoSeguridadEmpleado(Seguridad $s){

        $sql = "UPDATE `tareas_asignada_sistema_calidad` SET `nota` = ? , `archivo` = ? , `status` = ? "
        . "WHERE `id_tareas_asignada` = ? and `status` = 'progreso' ";
            $stmt = $this->_dbh->prepare($sql);
            $stmt->bindValue(1, $s->__get('_nota'), PDO::PARAM_STR);
            $stmt->bindValue(2, $s->__get('_archivo'), PDO::PARAM_STR);
            $stmt->bindValue(3, $s->__get('_status'), PDO::PARAM_STR);
            $stmt->bindValue(4, $s->__get('_idSeguridad'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al editar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function SubirNoConformidad(Seguridad $s){

        $sql = "INSERT INTO `tareas_no_conformidad_sistema_calidad` ( `descripcion`, `id_tareas_asignada`, `status`, `id_empleado_subio_archivo`, `id_sucursal`, `frecuencia`, `fecha_inicio`,  `id_supervisor`) "
            . "VALUES(?, ?, ?, ?,?,?,?,?)";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $s->__get('_descripcionNoConformidad'), PDO::PARAM_STR);
        $stmt->bindValue(2, $s->__get('_idSeguridad'), PDO::PARAM_INT);
        $stmt->bindValue(3, $s->__get('_status'), PDO::PARAM_STR);
        $stmt->bindValue(4, $s->__get('_idEmpleado'), PDO::PARAM_INT);
        $stmt->bindValue(5, $s->__get('_idSucursal'), PDO::PARAM_INT);
        $stmt->bindValue(6, $s->__get('_tipoDescripcion'), PDO::PARAM_STR);
        $stmt->bindValue(7, $s->__get('_fechaInicio'), PDO::PARAM_STR);
        $stmt->bindValue(8, $s->__get('_idSupervisor'), PDO::PARAM_INT);


        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al editar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function buscarSeguridadPorId($idActividad)
    {
        $sql = "SELECT * FROM `tareas_seguridad_sistema_calidad` where `id_tareas_seguridad` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);;
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividad'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'la actividad. ' . TICKETS;
        }

        return $response;
    }


    public function obtenerActividadesSeguridad($inicio, $registros, $idSucursal)
    {
        $sql = "select tareas_seguridad_sistema_calidad.*, codigo_calidad.nombre_norma as categoria, tareas_seguridad_sistema_calidad.archivo from tareas_seguridad_sistema_calidad "
             . " inner join codigo_calidad on codigo_calidad.id_codigo_calidad = tareas_seguridad_sistema_calidad.id_codigo_calidad
                inner join responsable_tareas_sistema_calidad as rts on rts.id_tareas_seguridad = tareas_seguridad_sistema_calidad.id_tareas_seguridad
                inner join usuarios as u on u.Id_usuario = rts.id_responsable where u.Id_Sucursal = ? LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesSeguridadEmpleado($inicio, $registros, $idempleado)
    {
        $sql = "select tareas_seguridad_sistema_calidad.*, tareas_asignada_sistema_calidad.id_tareas_asignada, tareas_asignada_sistema_calidad.nota, tareas_asignada_sistema_calidad.id_supervisor, tareas_asignada_sistema_calidad.id_responsable, tareas_asignada_sistema_calidad.id_tareas_seguridad, tareas_asignada_sistema_calidad.status, tareas_asignada_sistema_calidad.created_at, codigo_calidad.nombre_norma as categoria, tareas_asignada_sistema_calidad.fecha_prorroga, tareas_asignada_sistema_calidad.razon_rechazo, tareas_seguridad_sistema_calidad.archivo from tareas_seguridad_sistema_calidad  
               inner join tareas_asignada_sistema_calidad on tareas_seguridad_sistema_calidad.id_tareas_seguridad = tareas_asignada_sistema_calidad.id_tareas_seguridad 
                 inner join codigo_calidad on codigo_calidad.id_codigo_calidad = tareas_seguridad_sistema_calidad.id_codigo_calidad
                 inner join responsable_tareas_sistema_calidad as rts on rts.id_tareas_seguridad = tareas_seguridad_sistema_calidad.id_tareas_seguridad  
             where tareas_asignada_sistema_calidad.id_responsable = ? and tareas_asignada_sistema_calidad.status = 'progreso' and rts.id_responsable = ? LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idempleado, PDO::PARAM_INT);
        $stmt->bindValue(2, $idempleado, PDO::PARAM_INT);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadEmpleado($inicio, $registros, $idempleado)
    {
        $sql = "select ac.*, tc.descripcion as tarea_principal from actividades_de_no_conformidad_sistema_calidad ac "
              . " inner join tareas_no_conformidad_sistema_calidad tc on ac.id_tarea_no_conformidad = tc.id_tarea_no_conformidad "
              . " where ac.id_nuevo_responsable = ? and ac.status = 'progreso' LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idempleado, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesSeguridadPorCategoriaEmpleado($seguridad,$inicio, $registros , $idempleado)
    {
        $sql = "select tareas_seguridad_sistema_calidad.*, tareas_asignada_sistema_calidad.*, codigo_calidad.nombre_norma as categoria, tareas_seguridad_sistema_calidad.archivo from tareas_seguridad_sistema_calidad  "
             . " inner join codigo_calidad on codigo_calidad.id_codigo_calidad = tareas_seguridad_sistema_calidad.id_codigo_calidad "
              . "  inner join tareas_asignada_sistema_calidad on tareas_seguridad_sistema_calidad.id_tareas_seguridad = tareas_asignada_sistema_calidad.id_tareas_seguridad 
                   inner join responsable_tareas_sistema_calidad as rts on rts.id_tareas_seguridad = tareas_asignada_sistema_calidad.id_tareas_seguridad "
             . " where tareas_asignada_sistema_calidad.id_responsable = ? and rts.id_responsable = ? and tareas_asignada_sistema_calidad.status = 'progreso' and tareas_seguridad_sistema_calidad.id_codigo_calidad = ?  LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idempleado, PDO::PARAM_INT);
        $stmt->bindValue(2, $idempleado, PDO::PARAM_INT);
        $stmt->bindValue(3, $seguridad, PDO::PARAM_INT);
        $stmt->bindValue(4, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(5, $registros, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function buscarActividadSeguridadPorId($idActividad)
    {
        $sql = "select ts.*, ta.*, ta.archivo as archivo_nuevo  from `tareas_seguridad_sistema_calidad` as `ts` inner join `tareas_asignada_sistema_calidad` as `ta` on `ts`.`id_tareas_seguridad` =`ta`.`id_tareas_seguridad` where `ta`.`id_tareas_asignada` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);;
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividad'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesSeguridadPorCategoria($seguridad,$inicio, $registros, $idSucursal)
    {
        $sql = "select tareas_seguridad_sistema_calidad.*, codigo_calidad.nombre_norma as categoria, rts.archivo from tareas_seguridad_sistema_calidad 
               inner join codigo_calidad on codigo_calidad.id_codigo_calidad = tareas_seguridad_sistema_calidad.id_codigo_calidad 
              inner join responsable_tareas_sistema_calidad as rts on rts.id_tareas_seguridad = tareas_seguridad_sistema_calidad.id_tareas_seguridad
                  inner join usuarios as u on u.Id_usuario = rts.id_responsable where u.Id_Sucursal = ? and tareas_seguridad_sistema_calidad.id_codigo_calidad =  ?  LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $seguridad, PDO::PARAM_STR);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }



    public function totalActividadesSeguridad($idSucursal)
    {

        $sql = "SELECT tareas_seguridad_sistema_calidad.*, rts.archivo FROM `tareas_seguridad_sistema_calidad`
                inner join responsable_tareas_sistema_calidad as rts on rts.id_tareas_seguridad = tareas_seguridad_sistema_calidad.id_tareas_seguridad
                 inner join usuarios as u on u.Id_usuario = rts.id_responsable where u.Id_Sucursal = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function totalActividadesSeguridadAsignadasEmpleado($idusuario)
    {

        $sql = "select ts.id_tareas_seguridad from `tareas_seguridad_sistema_calidad` as `ts` inner join `tareas_asignada_sistema_calidad` as `ta` on `ts`.`id_tareas_seguridad` = `ta`.`id_tareas_seguridad` where `ta`.`id_responsable` = ? and `ta`.`status` = 'progreso' ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idusuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function totalActividadesNoConformidadAsignadasEmpleado($idusuario)
    {

        $sql = "select id_actividades_de_no_conformidad from actividades_de_no_conformidad_sistema_calidad where id_nuevo_responsable = ? and status = 'progreso' ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idusuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades de no conformidad. ' . TICKETS;
        }

        return $response;
    }

    public function totalActividadesSeguridadPorCategoriaEmpleado($categoria, $idusuario)
    {
        $sql = "select ts.id_tareas_seguridad from `tareas_seguridad_sistema_calidad` as `ts` inner join `tareas_asignada_sistema_calidad` as `ta` on `ts`.`id_tareas_seguridad` = `ta`.`id_tareas_seguridad` where `ta`.`id_responsable` = ? and `ta`.`status` = 'progreso' and  `id_codigo_calidad` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idusuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $categoria, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }


    public function totalActividadesSeguridadPorCategoria($categoria)
    {

        $sql = "SELECT `id_tareas_seguridad` FROM `tareas_seguridad_sistema_calidad` where `id_codigo_calidad`like ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, "%$categoria%", PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }


    public function obtenerActividadesSeguridadForCategoria($categoria)
    {
        $sql = "SELECT * FROM `tareas_seguridad_sistema_calidad` where `categoria`like ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, "%$categoria%", PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesAsignadasASupervisorporfecha($idSupervisor, $fechainicio, $fechafin)
    {
        $sql = "select * from `tareas_no_conformidad_sistema_calidad` where `id_supervisor` = ? and `created_at` between ? and ? and status = 'pendiente'";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSupervisor, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechainicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechafin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades del supervisor. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesAsignadasAResponsableporfecha($idSupervisor, $fechainicio, $fechafin)
    {
        $sql = "select tareas_asignada_sistema_calidad.*, tareas_seguridad_sistema_calidad.nombre from `tareas_asignada_sistema_calidad` inner join `tareas_seguridad_sistema_calidad` on `tareas_seguridad_sistema_calidad`.`id_tareas_seguridad` = `tareas_asignada_sistema_calidad`.`id_tareas_seguridad` where `tareas_asignada_sistema_calidad`.`id_responsable` = ? and `tareas_asignada_sistema_calidad`.`created_at` between ? and ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSupervisor, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechainicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechafin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades del supervisor. ' . TICKETS;
        }

        return $response;
    }




    public function obtenerActividadesNoAsignadasDeSupervisorAEmpleado($idSupervisor, $fechainicio, $fechafin)
    {
        $sql = "select tareas_no_conformidad_sistema_calidad.id_tarea_no_conformidad from tareas_no_conformidad_sistema_calidad "
               . " inner join actividades_de_no_conformidad_sistema_calidad on tareas_no_conformidad_sistema_calidad.id_tarea_no_conformidad = actividades_de_no_conformidad_sistema_calidad.id_tarea_no_conformidad "
                . " where  tareas_no_conformidad_sistema_calidad.id_supervisor = ? and tareas_no_conformidad_sistema_calidad.created_at between ? and ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSupervisor, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechainicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechafin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            // $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades del supervisor. ' . TICKETS;
        }

        return $response;
    }


    public function buscarTareaSeguridadPorId($id)
    {
        $sql = "SELECT * FROM `tareas_seguridad_sistema_calidad` where `id_tareas_seguridad` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['tareas'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las tareas . ' . TICKETS;
        }

        return $response;
    }

    public function altaActividadAsignada(Seguridad $s){
        $sql = "INSERT INTO `tareas_asignada_sistema_calidad` ( `id_responsable`, `id_supervisor`, `status`, `id_tareas_seguridad`) "
            . "VALUES(?, ?, ?, ?)";


        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $s->__get('_idResponsable'), PDO::PARAM_INT);
        $stmt->bindValue(2, $s->__get('_idSupervisor'), PDO::PARAM_INT);
        $stmt->bindValue(3, $s->__get('_status'), PDO::PARAM_STR);
        $stmt->bindValue(4, $s->__get('_idSeguridad'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['id'] = $this->_dbh->lastInsertId();
            //$idMinuta = $this->_dbh->lastInsertId();
            //$response['idMinuta'] = $idMinuta;
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al dar de alta la actividad. ' . TICKETS;
        }

        return $response;
    }

    // ------------------------------------------------------------------------------

    public function totalTareasNoConformidadPorSucursalSupervisor($sucursal ,$supervisor, $status, $grupo, $clave)
    {
        $sql = "select tnc.*,  concat( ures.Nombre , ' ',ures.Apellido_Paterno, ' ', ures.Apellido_Materno) as nombresubiosarea, s.Nombre as sucursal,(select count(*) from actividades_de_no_conformidad_sistema_calidad where actividades_de_no_conformidad_sistema_calidad.id_tarea_no_conformidad = tnc.id_tarea_no_conformidad) as 'sub_tareas', ts.id_tareas_seguridad, ts.nombre as 'nombre_tarea_seguridad', concat( ns.nombre_norma , '-',ts.clave) as normaclave  from tareas_no_conformidad_sistema_calidad as tnc
 inner join usuarios as u on tnc.id_supervisor=u.Id_Usuario left join usuarios as ures on tnc.id_empleado_subio_archivo=ures.Id_Usuario
 left join sucursal as s on tnc.id_sucursal = s.Id_Sucursal inner join tareas_asignada_sistema_calidad as ta on tnc.id_tareas_asignada=ta.id_tareas_asignada
  inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad=ta.id_tareas_seguridad 
 inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad where u.Id_Sucursal = ? and tnc.id_supervisor = ? and tnc.status!='cerrado' and tnc.status!='rechazado' and ta.status = 'finalizado'";
        if ($status != ""){
            $sql = $sql."and tnc.status = ? ";
        }
        if ($grupo != ""){
            $sql = $sql."and ts.id_codigo_calidad = ? ";
        }
        if ($clave != ""){
            $sql = $sql."and ts.clave = ?";
        }
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $supervisor, PDO::PARAM_INT);

        $posisionNuevoBind=3;
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind++;
        }
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind, $clave, PDO::PARAM_STR); $posisionNuevoBind++;
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function tareasNoConformidadPorSucursalSupervisor($sucursal, $supervisor, $status, $grupo, $clave, $inicio, $registros){
        $sql = "select tnc.*,  concat( ures.Nombre , ' ',ures.Apellido_Paterno, ' ', ures.Apellido_Materno) as nombresubiosarea, s.Nombre as sucursal,(select count(*) from actividades_de_no_conformidad_sistema_calidad where actividades_de_no_conformidad_sistema_calidad.id_tarea_no_conformidad = tnc.id_tarea_no_conformidad) as 'sub_tareas', ts.id_tareas_seguridad, ts.nombre as 'nombre_tarea_seguridad', concat( ns.nombre_norma , '-',ts.clave) as normaclave  from tareas_no_conformidad_sistema_calidad as tnc
 inner join usuarios as u on tnc.id_supervisor=u.Id_Usuario left join usuarios as ures on tnc.id_empleado_subio_archivo=ures.Id_Usuario
 left join sucursal as s on tnc.id_sucursal = s.Id_Sucursal inner join tareas_asignada_sistema_calidad as ta on tnc.id_tareas_asignada=ta.id_tareas_asignada
  inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad=ta.id_tareas_seguridad 
 inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad where u.Id_Sucursal = ? and tnc.id_supervisor = ? and tnc.status!='cerrado' and tnc.status!='rechazado' and ta.status = 'finalizado'";
        if ($status != ""){
            $sql = $sql."and tnc.status = ? ";
        }
        if ($grupo != ""){
            $sql = $sql."and ts.id_codigo_calidad = ? ";
        }
        if ($clave != ""){
            $sql = $sql."and ts.clave = ?";
        }
        $sql = $sql."order by tnc.created_at LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $supervisor, PDO::PARAM_INT);
        $positionBind = 3;
        if ($status != ""){
            $stmt->bindValue($positionBind, $status, PDO::PARAM_STR);$positionBind ++;
        }
        if ($grupo != ""){
            $stmt->bindValue($positionBind, $grupo, PDO::PARAM_STR); $positionBind++;
        }
        if ($clave != ""){
            $stmt->bindValue($positionBind, $clave, PDO::PARAM_STR); $positionBind++;
        }

        $stmt->bindValue($positionBind, $inicio, PDO::PARAM_INT); $positionBind ++;
        $stmt->bindValue($positionBind, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['tareas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTareaNoConformidadPorId($idTareaNoConformidad){
        $sql = "select tnc.*, (select count(*) from actividades_de_no_conformidad_sistema_calidad where actividades_de_no_conformidad_sistema_calidad.id_tarea_no_conformidad = tnc.id_tarea_no_conformidad) as 'sub_tareas', ts.id_tareas_seguridad, ts.nombre as 'nombre_tarea_seguridad' from tareas_no_conformidad_sistema_calidad as tnc inner join tareas_asignada_sistema_calidad as ta on tnc.id_tareas_asignada=ta.id_tareas_asignada inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad=ta.id_tareas_seguridad where tnc.id_tarea_no_conformidad = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idTareaNoConformidad, PDO::PARAM_INT);;
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['tarea-no-conformidad'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'la tarea de no conformidad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadPorIdTareaNoConformidad($idTareaNoConformidad){
        $sql = "select anc.*, concat(u.Nombre, \" \", u.Apellido_Paterno, \" \", u.Apellido_Materno) as 'nombre_responsable'from actividades_de_no_conformidad_sistema_calidad as anc inner join usuarios as u on anc.id_nuevo_responsable = u.Id_Usuario where anc.id_tarea_no_conformidad = ? order by anc.created_at;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idTareaNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadPorId($idActividadNoConformidad){
        $sql = "select anc.* from actividades_de_no_conformidad_sistema_calidad as anc where anc.id_actividades_de_no_conformidad = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividadNoConformidad, PDO::PARAM_INT);;
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividad-no-conformidad'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'la actividad de no conformidad. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusTareaNoConformidad($tareaNoConformidad , $status){
        $sql = "UPDATE tareas_no_conformidad_sistema_calidad SET status=? WHERE id_tarea_no_conformidad=? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(2, $tareaNoConformidad, PDO::PARAM_INT);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['mensaje'] = 'Actualizacion de status completada';
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el status de la tarea de no conformidad. '
                . TICKETS;
        }
        return $response;
    }

    public function crearNuevaActividadNoConformidad($tareaNoConformidad , $fechaInicio, $fechaFin, $descripcion, $responsable, $tipo_alta){
        $sql = "INSERT INTO actividades_de_no_conformidad_sistema_calidad (id_nuevo_responsable, fecha_inicio, fecha_limite, porcentaje ,status, id_tarea_no_conformidad, descripcion, tipo_alta) VALUES (?, DATE ?, DATE ?, 0, 'progreso', ?, ?, ?) ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $responsable, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFin, PDO::PARAM_STR);
        $stmt->bindValue(4, $tareaNoConformidad, PDO::PARAM_INT);
        $stmt->bindValue(5, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(6, $tipo_alta, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['mensaje'] = 'Nueva tarea creada con exito';
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al crear la tarea. '
                . TICKETS;
        }
        return $response;
    }



    // ----------------------------

    public function totalTareasNoConformidadPorSupervisor($supervisor)
    {
        $sql = "SELECT id_tarea_no_conformidad FROM tareas_no_conformidad_sistema_calidad WHERE tareas_no_conformidad_sistema_calidad.id_supervisor = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $supervisor, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function totalTareasNoConformidadPorSupervisorStatus($supervisor, $status)
    {
        $sql = "SELECT id_tarea_no_conformidad FROM tareas_no_conformidad_sistema_calidad WHERE tareas_no_conformidad_sistema_calidad.id_supervisor = ? AND tareas_no_conformidad_sistema_calidad.status = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $supervisor, PDO::PARAM_INT);
        $stmt->bindValue(2, $status, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTareasNoConformidadPorSucursalSupervisor($inicio, $registros, $sucursal, $supervisor){
        $sql = "select tnc.*, ts.id_tareas_seguridad, ts.nombre as 'nombre_tarea_seguridad' from `tareas_no_conformidad_sistema_calidad` as `tnc` inner join `usuarios` as `u` on `tnc`.`id_supervisor`=`u`.`Id_Usuario` inner join `tareas_asignada_sistema_calidad` as `ta` on `tnc`.`id_tareas_asignada`=`ta`.`id_tareas_asignada` inner join `tareas_seguridad_sistema_calidad` as `ts` on `ts`.`id_tareas_seguridad`=`ta`.`id_tareas_seguridad` where `tnc`.`id_supervisor` = ? and `u`.`Id_Sucursal` = ? LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $supervisor, PDO::PARAM_INT);
        $stmt->bindValue(2, $sucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTareasNoConformidadPorSucursalSupervisorStatus($inicio, $registros, $sucursal, $supervisor, $status){
        $sql = "select tnc.*, ts.id_tareas_seguridad, ts.nombre as 'nombre_tarea_seguridad' from `tareas_no_conformidad_sistema_calidad` as `tnc` inner join `usuarios` as `u` on `tnc`.`id_supervisor`=`u`.`Id_Usuario` inner join `tareas_asignada_sistema_calidad` as `ta` on `tnc`.`id_tareas_asignada`=`ta`.`id_tareas_asignada` inner join `tareas_seguridad_sistema_calidad` as `ts` on `ts`.`id_tareas_seguridad`=`ta`.`id_tareas_seguridad` where `tnc`.`id_supervisor` = ? and `u`.`Id_Sucursal` = ? and `tnc`.`status` = ? LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $supervisor, PDO::PARAM_INT);
        $stmt->bindValue(2, $sucursal, PDO::PARAM_INT);
        $stmt->bindValue(3, $status, PDO::PARAM_STR);
        $stmt->bindValue(4, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(5, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function editarActividadNoConformidad($idActividad, $idResponsable, $fechaInicio, $fechaLimite, $porcentaje){
        $sql = "UPDATE actividades_de_no_conformidad_sistema_calidad SET id_nuevo_responsable=?, fecha_inicio=?, fecha_limite=?, porcentaje=? ";
        if($porcentaje == 100){
            $sql .= ", status = 'finalizado' ";
        }
        if($porcentaje < 100){
            $sql .= ", status = 'progreso' ";
        }
        $sql .= "WHERE id_actividades_de_no_conformidad=? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idResponsable, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaLimite, PDO::PARAM_STR);
        $stmt->bindValue(4, $porcentaje, PDO::PARAM_INT);
        $stmt->bindValue(5, $idActividad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['mensaje'] = 'Edicion de la actividad con exito';
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió al actializar la actividad'
                . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesEnProgreso($idResponsable)
    {
        $sql = " select tareas_asignada_sistema_calidad.* , tareas_seguridad_sistema_calidad.dias_limites from `tareas_asignada_sistema_calidad` "
               . " inner join `tareas_seguridad_sistema_calidad` on `tareas_seguridad_sistema_calidad`.`id_tareas_seguridad` = `tareas_asignada_sistema_calidad`.`id_tareas_seguridad` "
           . " where `tareas_asignada_sistema_calidad`.`status` = 'progreso' and `tareas_asignada_sistema_calidad`.`id_responsable` = ?  ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idResponsable, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades en aun no concluidas del responsable. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadEnProgreso($idResponsable)
    {
        $sql = " select * from actividades_de_no_conformidad_sistema_calidad where porcentaje < 100 and `id_nuevo_responsable` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idResponsable, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades en aun no concluidas del responsable. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesTipoCalendario()
    {
        $sql = " SELECT * FROM `tareas_seguridad_sistema_calidad` where `tipo` = 'calendario' ";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades principales ' . TICKETS;
        }

        return $response;
    }

    public function actualizarFachaActividadPrincipal($date, $idSeguridad)
    {
        $sql = " UPDATE `tareas_seguridad_sistema_calidad` SET `fecha_inicio`= ? WHERE `id_tareas_seguridad`= ?  ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $date, PDO::PARAM_STR);
        $stmt->bindValue(2, $idSeguridad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades principales ' . TICKETS;
        }

        return $response;
    }

    public function totalActividadesNoconformidadPorTareaStatus($idTareaNoConformidad ,$statusActividad)
    {
        $sql = "select anc.id_actividades_de_no_conformidad from actividades_de_no_conformidad_sistema_calidad as anc where anc.id_tarea_no_conformidad = ? and anc.status = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idTareaNoConformidad, PDO::PARAM_INT);
        $stmt->bindValue(2, $statusActividad, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function totalDeActividadesEnHistorial($sucursal, $grupo, $status, $desdeFecha, $hastaFecha, $clave){
        $sql = "select ta.id_tareas_asignada from tareas_asignada_sistema_calidad as ta  inner join usuarios as u on ta.id_responsable = u.Id_Usuario inner join tareas_seguridad_sistema_calidad as ts on ta.id_tareas_seguridad = ts.id_tareas_seguridad where u.Id_Sucursal = ? ";
	    if ($grupo != ""){
	        $sql = $sql." and ts.id_codigo_calidad = ? ";
        }
        if ($status != ""){
            $sql = $sql." and ta.status = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and ta.created_at >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and ta.created_at <= ? ";
        }
        if ($clave != ""){
            $sql = $sql." and ts.clave = ? ";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $posisionNuevoBind = 2;

        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR);  $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind,  $clave, PDO::PARAM_STR);
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerHistorialActividadesSeguridad($sucursal, $grupo, $status, $desdeFecha, $hastaFecha,  $inicio, $registros, $clave){
        $sql = "select ta.*, ts.nombre, ts.clave , ts.dias_limites ,ts.id_codigo_calidad, ts.tipo, ts.tipo_descripcion, concat(u.Nombre, ' ', u.Apellido_Paterno, ' ', u.Apellido_Materno) as 'nombre_responsable', ns.nombre_norma  from tareas_asignada_sistema_calidad as ta "
              . " inner join tareas_seguridad_sistema_calidad as ts on ta.id_tareas_seguridad = ts.id_tareas_seguridad "
              . " inner join usuarios as u on ta.id_responsable = u.Id_Usuario "
              . " inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad "
              . "where u.Id_Sucursal = ? ";
        if ($grupo != ""){
            $sql = $sql." and ts.id_codigo_calidad = ?";
        }
        if ($status != ""){
            $sql = $sql." and ta.status = ?";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and ta.created_at >= ?";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and ta.created_at <= ?";
        }
        if ($clave != ""){
            $sql = $sql." and ts.clave = ? ";
        }
        $sql = $sql." order by ns.nombre_norma, ts.clave, ta.created_at LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $posisionNuevoBind = 2;
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind, $clave, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        $stmt->bindValue($posisionNuevoBind, $inicio, PDO::PARAM_INT); $posisionNuevoBind ++;
        $stmt->bindValue($posisionNuevoBind, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function totalDeNoConformidadEnHistorial($sucursal, $status, $desdeFecha, $hastaFecha, $grupo, $clave){
        $sql = "select anc.id_actividades_de_no_conformidad from actividades_de_no_conformidad_sistema_calidad as anc
inner join usuarios as u on anc.id_nuevo_responsable=u.Id_Usuario 
inner join tareas_no_conformidad_sistema_calidad as tnc on anc.id_tarea_no_conformidad = tnc.id_tarea_no_conformidad
inner join tareas_asignada_sistema_calidad as ta on tnc.id_tareas_asignada=ta.id_tareas_asignada 
inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad=ta.id_tareas_seguridad
where u.Id_Sucursal = ?";
        if ($status != ""){
            $sql = $sql." and anc.status = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and anc.fecha_inicio >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and anc.fecha_inicio <= ? ";
        }
        if ($grupo != ""){
            $sql = $sql." and ts.id_codigo_calidad = ? ";
        }
        if ($clave != ""){
            $sql = $sql." and ts.clave like ? ";
        }

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $posisionNuevoBind = 2;

        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR);  $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind,  "%$clave%", PDO::PARAM_STR);
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }
        return $response;
    }

    public function obtenerHistorialNoConformidad($sucursal, $status, $desdeFecha, $hastaFecha,  $inicio, $registros,$grupo, $clave){
        $sql = "select anc.*,concat(u.Nombre, \" \", u.Apellido_Paterno, \" \", u.Apellido_Materno) as 'nombre_responsable', tnc.descripcion as 'descripcion_no_conformidad', ts.nombre as 'nombre_tarea_seguridad', ts.clave, ns.nombre_norma from actividades_de_no_conformidad_sistema_calidad as anc
inner join usuarios as u on anc.id_nuevo_responsable=u.Id_Usuario 
inner join tareas_no_conformidad_sistema_calidad as tnc on anc.id_tarea_no_conformidad = tnc.id_tarea_no_conformidad
inner join tareas_asignada_sistema_calidad as ta on tnc.id_tareas_asignada=ta.id_tareas_asignada 
inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad=ta.id_tareas_seguridad
inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad
where u.Id_Sucursal = ?";
        if ($status != ""){
            $sql = $sql." and anc.status = ? ";
        }
        if ($desdeFecha != ""){
            $sql = $sql." and anc.fecha_inicio >= ? ";
        }
        if ($hastaFecha != ""){
            $sql = $sql." and anc.fecha_inicio <= ? ";
        }
        if ($grupo != ""){
            $sql = $sql." and ts.id_codigo_calidad = ?";
        }
        if ($clave != ""){
            $sql = $sql." and ts.clave like ? ";
        }
        $sql = $sql." order by ns.nombre_norma, ts.clave, tnc.created_at LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_INT);
        $posisionNuevoBind = 2;

        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($desdeFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $desdeFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($hastaFecha != ""){
            $stmt->bindValue($posisionNuevoBind, $hastaFecha, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind, "%$clave%", PDO::PARAM_STR); $posisionNuevoBind ++;
        }
        $stmt->bindValue($posisionNuevoBind, $inicio, PDO::PARAM_INT); $posisionNuevoBind ++;
        $stmt->bindValue($posisionNuevoBind, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['sql'] = $stmt;
            $response['errorBD'] = $e->getMessage();
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }
        $response['sql'] = $stmt;

        return $response;
    }

    public function buscarActividadesDeNoConformidadPorId($idActividad)
    {
        $sql = "select anc.*, tnc.descripcion as noconformidad from actividades_de_no_conformidad_sistema_calidad anc "
               . " inner join tareas_no_conformidad_sistema_calidad tnc on tnc.id_tarea_no_conformidad = anc.id_tarea_no_conformidad "
               . "  where id_actividades_de_no_conformidad = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);;
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividad'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function completarActividadNoConformidad(Seguridad $s, $actualizar){

	    if($actualizar ==1 ){
            $sql = "update actividades_de_no_conformidad_sistema_calidad set `status` = ? , archivo = ? , porcentaje = ? where id_actividades_de_no_conformidad = ?  ";
            $stmt = $this->_dbh->prepare($sql);
            $stmt->bindValue(1, $s->__get('_status'), PDO::PARAM_STR);
            $stmt->bindValue(2, $s->__get('_archivo'), PDO::PARAM_STR);
            $stmt->bindValue(3, $s->__get('_porcentaje'), PDO::PARAM_INT);
            $stmt->bindValue(4, $s->__get('_idSeguridad'), PDO::PARAM_INT);
        }else {
            $sql = "update actividades_de_no_conformidad_sistema_calidad set `status` = ? , porcentaje = ? where id_actividades_de_no_conformidad = ?  ";
            $stmt = $this->_dbh->prepare($sql);
            $stmt->bindValue(1, $s->__get('_status'), PDO::PARAM_STR);
            $stmt->bindValue(2, $s->__get('_porcentaje'), PDO::PARAM_INT);
            $stmt->bindValue(3, $s->__get('_idSeguridad'), PDO::PARAM_INT);
        }

        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al completar la actividad de no comformidad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadPorSupervisor($idSupervisor, $fechainicio, $fechafin)
    {
        $sql = "select * from tareas_no_conformidad_sistema_calidad as tnc
inner join tareas_asignada_sistema_calidad as ta on ta.id_tareas_asignada = tnc.id_tareas_asignada
where tnc.id_supervisor = ? and tnc.status = 'pendiente' and ta.status = 'finalizado' ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSupervisor, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
             $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades del supervisor. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadAResponsableporfecha($idSupervisor, $fechainicio, $fechafin)
    {
        $sql = "select * from actividades_de_no_conformidad_sistema_calidad where id_nuevo_responsable = ? and fecha_inicio between ? and ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSupervisor, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechainicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechafin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades del supervisor. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerAsignadaPorId( $idasignada)
    {
        $sql = " select * from tareas_asignada_sistema_calidad where id_tareas_asignada = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idasignada, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de la actividad asignada. ' . TICKETS;
        }

        return $response;
    }

    public function obteneractividadesNoconformidadAbiertas( $idSeguridad,$idSucursal )
    {
        $sql = " select tareas_no_conformidad_sistema_calidad.* from tareas_no_conformidad_sistema_calidad "
               . " inner join  tareas_asignada_sistema_calidad on tareas_asignada_sistema_calidad.id_tareas_asignada = tareas_no_conformidad_sistema_calidad.id_tareas_asignada "
               . " inner join usuarios on tareas_asignada_sistema_calidad.id_responsable = usuarios.Id_Usuario "
               . "  inner join  tareas_seguridad_sistema_calidad on tareas_seguridad_sistema_calidad.id_tareas_seguridad = tareas_asignada_sistema_calidad.id_tareas_seguridad "
               . " where tareas_seguridad_sistema_calidad.id_tareas_seguridad = ? and tareas_no_conformidad_sistema_calidad.status != 'finalizado' and usuarios.Id_Sucursal = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSeguridad, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades de no conformidad pendientes. ' . TICKETS;
        }

        return $response;
    }


    public function actualizarResponsableTareaAsignada($idResponsable, $idTareaSeguridad, $idSucursal){
            $sql = "update tareas_asignada_sistema_calidad inner join usuarios on tareas_asignada_sistema_calidad.id_responsable = usuarios.Id_Usuario  set tareas_asignada_sistema_calidad.id_responsable = ? "
                 . " where tareas_asignada_sistema_calidad.status = 'progreso' and tareas_asignada_sistema_calidad.id_tareas_seguridad = ? and usuarios.Id_Sucursal = ? and tareas_asignada_sistema_calidad.id_responsable != ? ";

            $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idResponsable, PDO::PARAM_INT);
        $stmt->bindValue(2, $idTareaSeguridad, PDO::PARAM_INT);
        $stmt->bindValue(3, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(4, $idResponsable, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al editar la actividad. ' . TICKETS;
        }

        return $response;
    }


    public function obtenerNormasDeSeguridad( )
    {
        $sql = " select * from codigo_calidad where `status` = 1";
        $stmt = $this->_dbh->prepare($sql);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['normas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de los codigos de calidad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTodasLasNormasDeSeguridad( )
    {
        $sql = " select * from codigo_calidad";
        $stmt = $this->_dbh->prepare($sql);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['normas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las codigos de calidad. ' . TICKETS;
        }

        return $response;
    }

    public function editarArchivoActividadSeguridad(Seguridad $s){

        $sql = "UPDATE `tareas_seguridad_sistema_calidad` SET `archivo` = ? "
            . "WHERE `id_tareas_seguridad` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $s->__get('_archivo'), PDO::PARAM_STR);
        $stmt->bindValue(2, $s->__get('_idSeguridad'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al editar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTodasLasNormasDeSeguridadActivas( )
    {
        $sql = "select * from codigo_calidad where status = 1";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['normas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de los codigos de calidad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTodasLasNormasDeSeguridadActivasExceptoId($idNorma)
    {
        $sql = "select * from codigo_calidad where status = 1 and id_codigo_calidad!=?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idNorma, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['normas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las normas de seguridad. ' . TICKETS;
        }

        return $response;
    }

    public function insertarNuevaNormaSeguridad($nombre , $descripcion, $archivo){
        $sql = "INSERT INTO codigo_calidad (nombre_norma, descripcion, status, archivo) VALUES (?, ?, 1, ?); ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $nombre, PDO::PARAM_STR);
        $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(3, $archivo, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['mensaje'] = 'Nueva norma de seguridad creada con exito';
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al crear la nueva norma de seguridad. '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarNormaDeSeguridad($idNorma, $nombre , $descripcion, $archivo, $actualizar){
	    if($actualizar == 1){
            $sql = "UPDATE codigo_calidad SET nombre_norma=?, descripcion=?, archivo = ? WHERE id_codigo_calidad=?; ";
            $stmt = $this->_dbh->prepare($sql);
            $stmt->bindValue(1, $nombre, PDO::PARAM_STR);
            $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
            $stmt->bindValue(3, $archivo, PDO::PARAM_STR);
            $stmt->bindValue(4, $idNorma, PDO::PARAM_INT);

        } else {
            $sql = "UPDATE codigo_calidad SET nombre_norma=?, descripcion=? WHERE id_codigo_calidad=?; ";
            $stmt = $this->_dbh->prepare($sql);
            $stmt->bindValue(1, $nombre, PDO::PARAM_STR);
            $stmt->bindValue(2, $descripcion, PDO::PARAM_STR);
            $stmt->bindValue(3, $idNorma, PDO::PARAM_INT);
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['mensaje'] = 'Nueva norma de seguridad creada con exito';
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al crear la nueva norma de seguridad. '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarStatusNormaDeSeguridad($idNorma, $status){
        $sql = "UPDATE codigo_calidad SET status=? WHERE id_codigo_calidad=?; ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_INT);
        $stmt->bindValue(2, $idNorma, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['mensaje'] = 'Nueva norma de seguridad creada con exito';
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al crear la nueva norma de seguridad. '
                . TICKETS;
        }
        return $response;
    }

    public function subirArchivoSeguridadEmpleadoRemplazo(Seguridad $s){

        $sql = "UPDATE `tareas_asignada_sistema_calidad` SET `nota` = ? , `archivo` = ? , `status` = ? "
            . "WHERE `id_tareas_seguridad` = ? and `status` = 'progreso' ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $s->__get('_nota'), PDO::PARAM_STR);
        $stmt->bindValue(2, $s->__get('_archivo'), PDO::PARAM_STR);
        $stmt->bindValue(3, $s->__get('_status'), PDO::PARAM_STR);
        $stmt->bindValue(4, $s->__get('_idSeguridad'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al editar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadincompletas()
    {
        $sql = " select actividades_de_no_conformidad_sistema_calidad.*, usuarios.Status as status_usuario, tareas_no_conformidad_sistema_calidad.id_supervisor from actividades_de_no_conformidad_sistema_calidad "
               . " inner join usuarios on usuarios.Id_Usuario = actividades_de_no_conformidad_sistema_calidad.id_nuevo_responsable "
               . " inner join tareas_no_conformidad_sistema_calidad on tareas_no_conformidad_sistema_calidad.id_tarea_no_conformidad = actividades_de_no_conformidad_sistema_calidad.id_tarea_no_conformidad "
               . " where actividades_de_no_conformidad_sistema_calidad.porcentaje < 100 ";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades en aun no concluidas y sin responsable. ' . TICKETS;
        }

        return $response;
    }

    public function quitarResponsableInactivo($actividadNoConformidad ){
        $sql = "update actividades_de_no_conformidad_sistema_calidad set id_nuevo_responsable = null where id_actividades_de_no_conformidad = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $actividadNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo al actualizar el responsable de una tarea de no conformidad '
                . TICKETS;
        }
        return $response;
    }

    public function obtenerTareasNoConformidadincompletas()
    {
        $sql = " select tareas_no_conformidad_sistema_calidad.*, usuarios.Status as status_usuario, usuarios.Tipo, usuarios.Id_Sucursal from tareas_no_conformidad_sistema_calidad "
            . " inner join usuarios on usuarios.Id_Usuario = tareas_no_conformidad_sistema_calidad.id_supervisor "
            . " where (tareas_no_conformidad_sistema_calidad.status = 'progreso' or tareas_no_conformidad_sistema_calidad.status = 'pendiente') ";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las tareas de no conformidad ' . TICKETS;
        }

        return $response;
    }

    public function actualizarSupervisorTareasNoConformidad($supervisorNuevo, $supervisorViejo ){
        $sql = "update tareas_no_conformidad_sistema_calidad set id_supervisor = ? where id_supervisor= ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $supervisorNuevo, PDO::PARAM_INT);
        $stmt->bindValue(2, $supervisorViejo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo al actualizar las tareas de no conformidad del supervisor '
                . TICKETS;
        }
        return $response;
    }

    public function altaResponsableSeguridad($responsable, $seguridad, $archivo){
        $sql = "INSERT INTO `responsable_tareas_sistema_calidad` ( `id_responsable`, `id_tareas_seguridad`,  `archivo` ) "
            . "VALUES(?, ?, ?)";


        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $responsable, PDO::PARAM_INT);
        $stmt->bindValue(2, $seguridad, PDO::PARAM_INT);
        $stmt->bindValue(3, $archivo, PDO::PARAM_STR);


        try{
            $stmt->execute();
            $response['id'] = $this->_dbh->lastInsertId();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al asignar un responsable a la tarea de sistema de calidad ' . TICKETS;
        }

        return $response;
    }

    public function borrarResponsableSeguridad( $seguridad){
        $sql = "delete from responsable_tareas_sistema_calidad where id_tareas_seguridad = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $seguridad, PDO::PARAM_INT);


        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al borrar a los responsables de sistema de calidad ' . TICKETS;
        }

        return $response;
    }


    public function buscarResponsablesPorSeguridadId($idActividad)
    {
        $sql = "select responsable_tareas_sistema_calidad.*, usuarios.Id_Sucursal from responsable_tareas_sistema_calidad "
           . " inner join usuarios on usuarios.Id_Usuario = responsable_tareas_sistema_calidad.id_responsable "
           . " where responsable_tareas_sistema_calidad.id_tareas_seguridad = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);;
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['usuarios'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'los responsables de la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerNormaPorId($idNorma)
    {
        $sql = "select * from codigo_calidad where id_codigo_calidad =?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idNorma, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['normas'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'del codigo de calidad. ' . TICKETS;
        }

        return $response;
    }


    public function obtenerActividadesSeguridadEnProgreso($idResponsable)
    {
        $sql = " select tareas_asignada_sistema_calidad.* , tareas_seguridad_sistema_calidad.* from `tareas_asignada_sistema_calidad` "
            . " inner join `tareas_seguridad_sistema_calidad` on `tareas_seguridad_sistema_calidad`.`id_tareas_seguridad` = `tareas_asignada_sistema_calidad`.`id_tareas_seguridad` "
            . " where `tareas_asignada_sistema_calidad`.`status` = 'progreso' and `tareas_asignada_sistema_calidad`.`id_responsable` = ?  ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idResponsable, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades en aun no concluidas del responsable. ' . TICKETS;
        }

        return $response;
    }


    public function obtenerActividadesNoConformidadPendientes($idSupervisor )
    {
        $sql = " select * from tareas_no_conformidad_sistema_calidad as tnc
 inner join tareas_asignada_sistema_calidad as ta on ta.id_tareas_asignada = tnc.id_tareas_asignada
 where tnc.id_supervisor = ? and tnc.status = 'pendiente' and ta.status = 'finalizado' ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSupervisor, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
             $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades del supervisor. ' . TICKETS;
        }

        return $response;
    }

    public function totalActividadesPorAutorizar()
    {

        $sql = "select ts.*,ta.*, ns.nombre_norma, ta.archivo as archivo_nuevo, u.Nombre, u.Apellido_Paterno, u.Apellido_Materno from tareas_asignada_sistema_calidad as ta
inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad = ta.id_tareas_seguridad
inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad
inner join usuarios as u on u.Id_Usuario = ta.id_responsable
where (ta.status = 'autorizacion'and ts.id_sucursal_responsable is not null and ts.id_editorarchivo = ta.id_responsable) || 
ta.status = 'autorizacion'and (ts.id_sucursal_responsable is null || ts.id_sucursal_responsable = 0 ) ";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades por autorizar. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesPorAutorizar($inicio, $registros)
    {
        $sql = "select ts.*,ta.*, ns.nombre_norma, ta.archivo as archivo_nuevo, u.Nombre, u.Apellido_Paterno, u.Apellido_Materno from tareas_asignada_sistema_calidad as ta
inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad = ta.id_tareas_seguridad
inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad
inner join usuarios as u on u.Id_Usuario = ta.id_responsable
where (ta.status = 'autorizacion'and ts.id_sucursal_responsable is not null and ts.id_editorarchivo = ta.id_responsable) || 
ta.status = 'autorizacion'and (ts.id_sucursal_responsable is null || ts.id_sucursal_responsable = 0 )  LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusActividadAsignadaNoRemplazo($status, $idAsignada ){
        $sql = "update tareas_asignada_sistema_calidad set status = ? where id_tareas_asignada = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idAsignada, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento ocurrio un error al actualizar el status de la actividad '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarStatusActividadAsignadaRemplazo($status, $idSeguridad, $statusActual ){
        $sql = "update tareas_asignada_sistema_calidad set status = ? where id_tareas_seguridad = ? and status = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idSeguridad, PDO::PARAM_INT);
        $stmt->bindValue(3, $statusActual, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento ocurrio un error al actualizar el status de la actividad '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarFechaYRazonRechazoNoRemplazo($razon, $fecha, $idAsignada ){
        $sql = "update tareas_asignada_sistema_calidad set razon_rechazo = ?, fecha_prorroga = ?  where id_tareas_asignada = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $razon, PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(3, $idAsignada, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento ocurrio un error al actualizar la fecha y la razon '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarFechaYRazonRechazoRemplazo($razon, $fecha, $idSeguridad, $statusActual ){
        $sql = "update tareas_asignada_sistema_calidad set razon_rechazo = ?, fecha_prorroga = ?  where id_tareas_seguridad = ? and status = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $razon, PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(3, $idSeguridad, PDO::PARAM_INT);
        $stmt->bindValue(4, $statusActual, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento ocurrio un error al actualizar la fecha y la razon '
                . TICKETS;
        }
        return $response;
    }

    public function totalTareasNoConformidad( $status,  $grupo, $clave)
    {
        $sql = "select tnc.*,  concat( ures.Nombre , ' ',ures.Apellido_Paterno, ' ', ures.Apellido_Materno) as nombresubiosarea, s.Nombre as sucursal, (select count(*) from actividades_de_no_conformidad_sistema_calidad where actividades_de_no_conformidad_sistema_calidad.id_tarea_no_conformidad = tnc.id_tarea_no_conformidad) as 'sub_tareas', ts.id_tareas_seguridad, ts.nombre as 'nombre_tarea_seguridad', concat( ns.nombre_norma , '-',ts.clave) as normaclave  from tareas_no_conformidad_sistema_calidad as tnc 
inner join usuarios as u on tnc.id_supervisor=u.Id_Usuario  left join usuarios as ures on tnc.id_empleado_subio_archivo=ures.Id_Usuario
 left join sucursal as s on tnc.id_sucursal = s.Id_Sucursal inner join tareas_asignada_sistema_calidad as ta on tnc.id_tareas_asignada=ta.id_tareas_asignada inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad=ta.id_tareas_seguridad 
 inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad where tnc.status!='cerrado' and tnc.status!='rechazado'";
        if ($status != ""){
            $sql = $sql."and tnc.status = ? ";
        }
        if ($grupo != ""){
            $sql = $sql."and ts.id_codigo_calidad = ? ";
        }
        if ($clave != ""){
            $sql = $sql."and ts.clave = ?";
        }
        $stmt = $this->_dbh->prepare($sql);
        $posisionNuevoBind=1;
        if ($status != ""){
            $stmt->bindValue($posisionNuevoBind, $status, PDO::PARAM_STR); $posisionNuevoBind++;
        }
        if ($grupo != ""){
            $stmt->bindValue($posisionNuevoBind, $grupo, PDO::PARAM_STR); $posisionNuevoBind++;
        }
        if ($clave != ""){
            $stmt->bindValue($posisionNuevoBind, $clave, PDO::PARAM_STR); $posisionNuevoBind++;
        }
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function tareasNoConformidad( $status, $grupo, $clave, $inicio, $registros){
        $sql = "select tnc.*, concat( ures.Nombre , ' ',ures.Apellido_Paterno, ' ', ures.Apellido_Materno) as nombresubiosarea, s.Nombre as sucursal, (select count(*) from actividades_de_no_conformidad where actividades_de_no_conformidad.id_tarea_no_conformidad = tnc.id_tarea_no_conformidad) as 'sub_tareas', ts.id_tareas_seguridad, ts.nombre as 'nombre_tarea_seguridad', concat( ns.nombre_norma , '-',ts.clave) as normaclave from tareas_no_conformidad as tnc inner join usuarios as u on tnc.id_supervisor=u.Id_Usuario left join usuarios as ures on tnc.id_empleado_subio_archivo=ures.Id_Usuario left join sucursal as s on tnc.id_sucursal = s.Id_Sucursal inner join tareas_asignada_sistema_calidad as ta on tnc.id_tareas_asignada=ta.id_tareas_asignada inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad=ta.id_tareas_seguridad inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad where tnc.status!='cerrado' and tnc.status!='rechazado'";
        if ($status != ""){
            $sql = $sql."and tnc.status = ? ";
        }
        if ($grupo != ""){
            $sql = $sql."and ts.id_codigo_calidad = ? ";
        }
        if ($clave != ""){
            $sql = $sql."and ts.clave = ?";
        }
        $sql = $sql."order by tnc.created_at LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $positionBind = 1;
        if ($status != ""){
            $stmt->bindValue($positionBind, $status, PDO::PARAM_STR);$positionBind ++;
        }
        if ($grupo != ""){
            $stmt->bindValue($positionBind, $grupo, PDO::PARAM_STR); $positionBind++;
        }
        if ($clave != ""){
            $stmt->bindValue($positionBind, $clave, PDO::PARAM_STR); $positionBind++;
        }
        $stmt->bindValue($positionBind, $inicio, PDO::PARAM_INT); $positionBind ++;
        $stmt->bindValue($positionBind, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['tareas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerInfoPdfActividadNoConformidad( $idActividad){
        $sql = "select anc.*,tnc.*, concat(u.Nombre, ' ', u.Apellido_Paterno, ' ', u.Apellido_Materno)  as responsable, concat(ures.Nombre, ' ', ures.Apellido_Paterno, ' ', ures.Apellido_Materno)  as supervisor from actividades_de_no_conformidad_sistema_calidad as anc
inner join tareas_no_conformidad_sistema_calidad as tnc on tnc.id_tarea_no_conformidad = anc.id_tarea_no_conformidad
inner join usuarios as u on u.Id_Usuario = anc.id_nuevo_responsable
inner join usuarios as ures on ures.Id_Usuario = tnc.id_supervisor
where anc.id_actividades_de_no_conformidad =  ?";

        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividad'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades para el pdf. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarFrecuenciaNoConformidad($frecuencia, $fechaInicio, $idTareaNoConformidad){

        $sql = "update tareas_no_conformidad_sistema_calidad set frecuencia = ?, fecha_inicio = ? where id_tarea_no_conformidad = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $frecuencia, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $idTareaNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al actualizar la frecuencia. ' . TICKETS;
        }

        return $response;
    }


    public function obtenerActividadesNoConformidadTipoCalendario()
    {
        $sql = "  SELECT * FROM `tareas_no_conformidad_sistema_calidad` as tnc
inner join tareas_asignada_sistema_calidad as ta on ta.id_tareas_asignada = tnc.id_tareas_asignada
 where (tnc.frecuencia != 'evento' and tnc.frecuencia is not null) and tnc.status != 'cerrado' and tnc.status != 'rechazado' and ta.status = 'finalizado'  ";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades de no conformidad ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadPorIdTarea($idTareaNoConformidad)
    {
        $sql = "select * from tareas_no_conformidad_sistema_calidad as tnc
 inner join actividades_de_no_conformidad_sistema_calidad as anc on anc.id_tarea_no_conformidad = tnc.id_tarea_no_conformidad
 where tnc.id_tarea_no_conformidad = ? and anc.tipo_alta = 'manual'";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idTareaNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades del supervisor. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarFechaDeInicioTareaNoConformidad($fechaInicio, $tareaNoConformidad){
        $sql = "update tareas_no_conformidad_sistema_calidad set fecha_inicio = ? where id_tarea_no_conformidad = ?";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(2, $tareaNoConformidad, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió al actializar la fecha de la actividad'
                . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesNoConformidadPorIdTareaNoConformidadProgramadas($idTareaNoConformidad){
        $sql = "select anc.*
from actividades_de_no_conformidad_sistema_calidad as anc 
inner join tareas_no_conformidad_sistema_calidad as tnc on tnc.id_tarea_no_conformidad = anc.id_tarea_no_conformidad
 where anc.id_tarea_no_conformidad = ? and anc.tipo_alta = 'manual' and tnc.frecuencia != 'evento' order by anc.created_at";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idTareaNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function cambiarActividadNoProgramable($idActividadNoConformidad){

        $sql = "update actividades_de_no_conformidad_sistema_calidad set tipo_alta = 'no programable' where id_actividades_de_no_conformidad = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividadNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al eliminar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function razonRechazoTareaAsignada($razon, $idAsignada ){

        $sql = "INSERT INTO `razones_rechazo_tarea_asignada` ( `razon`, `id_tareas_asignada`) "
            . "VALUES(?, ?)";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $razon, PDO::PARAM_STR);
        $stmt->bindValue(2, $idAsignada, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento ocurrio un error al agregar la razon de rechazo'
                . TICKETS;
        }
        return $response;
    }


    public function obtenerRazonesDeRechazo($idAsignada ){

        $sql = "select * from razones_rechazo_tarea_asignada where id_tareas_asignada = ? ";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idAsignada, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['razones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento ocurrio un error al agregar la razon de rechazo'
                . TICKETS;
        }
        return $response;
    }


    public function buscarClaves($grupo)
    {
        $sql = "select * from tareas_seguridad_sistema_calidad where id_codigo_calidad = ? group by clave";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $grupo, PDO::PARAM_INT);;
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['claves'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'las claves. ' . TICKETS;
        }

        return $response;
    }

    public function rechazarTareaNoConformidad($idTareaNoConformidad, $razon){

        $sql = "update tareas_no_conformidad_sistema_calidad set status = 'rechazado', razon_rechazon = ? where id_tarea_no_conformidad = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $razon, PDO::PARAM_STR);
        $stmt->bindValue(2, $idTareaNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al rechazar la tarea de no conformidad ' . TICKETS;
        }

        return $response;
    }

    public function totalTareasNoConformidadRechazadas($idusuario)
    {

        $sql = "select ts.nombre, tnc.descripcion, tnc.razon_rechazon from tareas_no_conformidad_sistema_calidad as tnc
inner join tareas_asignada_sistema_calidad as ta on ta.id_tareas_asignada = tnc.id_tareas_asignada
inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad = ta.id_tareas_seguridad
 where tnc.status = 'rechazado' and tnc.id_empleado_subio_archivo = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idusuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las tareas de no conformidad rechazadas. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTareasNoConformidadRechazadas($inicio, $registros, $idempleado)
    {
        $sql = "select ts.nombre, tnc.* from tareas_no_conformidad_sistema_calidad as tnc
inner join tareas_asignada_sistema_calidad as ta on ta.id_tareas_asignada = tnc.id_tareas_asignada
inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad = ta.id_tareas_seguridad
 where tnc.status = 'rechazado' and tnc.id_empleado_subio_archivo = ? LIMIT ?, ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idempleado, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['tareas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos '
                . 'de las tareas rechazadas ' . TICKETS;
        }

        return $response;
    }

    public function actualizarTareaNoConformidad($idTareaNoConformidad, $descripcion, $frecuencia, $fechafinal){

        $sql = "update tareas_no_conformidad_sistema_calidad set descripcion = ?, frecuencia = ?, fecha_inicio = ?, status = 'pendiente' where id_tarea_no_conformidad = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $descripcion, PDO::PARAM_STR);
        $stmt->bindValue(2, $frecuencia, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechafinal, PDO::PARAM_STR);
        $stmt->bindValue(4, $idTareaNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al actualizar la tarea de no conformidad ' . TICKETS;
        }

        return $response;
    }

    public function actualizarInicioTareaNoConformidad($fechaTarea, $fechaInicio, $idtareaNoConformidad){

        $sql = "update tareas_no_conformidad_sistema_calidad set created_at = ? , fecha_inicio = ?  where id_tarea_no_conformidad = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaTarea, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $idtareaNoConformidad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al actualizar la tarea de no conformidad ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTareasNoConformidadPorIdTareaAsingnada($idtareaAsingnada){

        $sql = "select * from tareas_no_conformidad_sistema_calidad where id_tareas_asignada = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idtareaAsingnada, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['tareas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al obtener las tareas de no confrmidad  ' . TICKETS;
        }

        return $response;
    }


    public function borrarActividadNoConformidadPorIdTareaNoConformidad($idtareaNoConformidad){

        $sql = " delete from actividades_de_no_conformidad_sistema_calidad where id_tarea_no_conformidad = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1,$idtareaNoConformidad,  PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al borrar las tareas de no conformidad  ' . TICKETS;
        }

        return $response;
    }

    public function borrarTareasNoConformidadPorIdTareaAsignada($idtareaAsignada){

        $sql = "delete from tareas_no_conformidad_sistema_calidad where id_tareas_asignada = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1,$idtareaAsignada,  PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al borrar las tareas de no conformidad  ' . TICKETS;
        }

        return $response;
    }

    public function totalTipoDeCalidad($tipoCalidad){

        $sql = "select * from tareas_seguridad_sistema_calidad as tssc
inner join codigo_calidad as cc on  tssc.id_codigo_calidad = cc.id_codigo_calidad
where cc.nombre_norma like ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, '%'.$tipoCalidad.'%',  PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al obtener el total  ' . TICKETS;
        }

        return $response;
    }

    public function obtenerTipoDeCalidad($tipoCalidad, $inicio, $registros){

        $sql = "select * from tareas_seguridad_sistema_calidad as tssc
inner join codigo_calidad as cc on  tssc.id_codigo_calidad = cc.id_codigo_calidad
where cc.nombre_norma like ? LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, '%'.$tipoCalidad.'%',  PDO::PARAM_STR);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['calidad'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al obtener la actividades de calidad  ' . TICKETS;
        }

        return $response;
    }

    public function totalActividadesPorAutorizarPorFecha($fecha, $fechaFinal)
    {

        $sql = "select ts.*,ta.*, ns.nombre_norma, ta.archivo as archivo_nuevo, u.Nombre, u.Apellido_Paterno, u.Apellido_Materno from tareas_asignada_sistema_calidad as ta
inner join tareas_seguridad_sistema_calidad as ts on ts.id_tareas_seguridad = ta.id_tareas_seguridad
inner join codigo_calidad as ns on ns.id_codigo_calidad = ts.id_codigo_calidad
inner join usuarios as u on u.Id_Usuario = ta.id_responsable
where (ta.status = 'autorizacion'and ts.id_sucursal_responsable is not null and ts.id_editorarchivo = ta.id_responsable) || 
ta.status = 'autorizacion'and (ts.id_sucursal_responsable is null || ts.id_sucursal_responsable = 0 ) and ta.updated_at between ? and ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al calcular el total de las actividades por autorizar. ' . TICKETS;
        }

        return $response;
    }

    public function buscarSeguridadPorIdYSucursal($idActividad, $idSucursal)
    {
        $sql = "SELECT * FROM `tareas_seguridad_sistema_calidad`
inner join responsable_tareas_sistema_calidad as rts on rts.id_tareas_seguridad = tareas_seguridad_sistema_calidad.id_tareas_seguridad 
 inner join usuarios as u on u.Id_usuario = rts.id_responsable
 where tareas_seguridad_sistema_calidad.id_tareas_seguridad = ?  and u.Id_Sucursal = ?
 ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSucursal, PDO::PARAM_INT);;
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividad'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function updateArchivoByIdSeguridad( $seguridad, $archivo ){
        $sql = "UPDATE `responsable_tareas_sistema_calidad` set archivo = ? where id_tareas_seguridad = ? ";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $archivo, PDO::PARAM_STR);
        $stmt->bindValue(2, $seguridad, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['id'] = $this->_dbh->lastInsertId();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al actualiar el archivo  ' . TICKETS;
        }

        return $response;
    }

    public function updateArchivoByIdSeguridadandResponsable( $seguridad, $archivo, $idResponsable ){
        $sql = "UPDATE `responsable_tareas_sistema_calidad` set archivo = ? where id_tareas_seguridad = ? and id_responsable = ?";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $archivo, PDO::PARAM_STR);
        $stmt->bindValue(2, $seguridad, PDO::PARAM_INT);
        $stmt->bindValue(3, $idResponsable, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['id'] = $this->_dbh->lastInsertId();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrio un error al actualiar el archivo  ' . TICKETS;
        }

        return $response;
    }
    
      public function getArchivoCalidad($idSeguridad)
    {
        $sql = "SELECT `archivo` FROM `tareas_seguridad_sistema_calidad` where `id_tareas_seguridad` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSeguridad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividad'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener  '
                . 'la actividad. ' . TICKETS;
        }

        return $response;
    }




}
