<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SubcategoriaHigiene.php';

class SubcategoriaHigienDao extends Model {

	public function __construct(){
		parent::__construct();
	}

	public function obtenerSubcategorias($idCategoria){
		$sql = "SELECT * FROM subcategoria_higiene WHERE Id_Categoria = ?";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $idCategoria, PDO::PARAM_INT);
		try {
			$stmt->execute();
			$response['status'] = true;
			$response['subcategorias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		} catch (PDOException $e) {
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = ':( Lo siento, ocurrió un error al obtener las subcategorias. ' . TICKETS;
		}

		return $response;
	}
}