<?php
/**
 * SugerenciaDao.php
 * Modelo para la persistencia de datos de sugerencias
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Sugerencia.php';

class SugerenciaDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function obtenerSugerenciasPorUsuario($idUsuario, $fechaInicio, $fechaFin)
    {
        $sql = "SELECT *, DATE_FORMAT(Fecha,'%d/%m/%Y') AS FechaF FROM `sugerencias` WHERE `Id_Usuario` = ? AND `Fecha` BETWEEN ? AND ? and id_tareas_seguridad is null";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['sugerencias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['totalSugerencias'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las '
                    . 'sugerencias de mejora. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function totalSugerenciasPorUsuario($idUsuario, $fechaInicio, $fechaFin)
    {
        $sql = "SELECT `Id_Sugerencia` FROM `sugerencias` WHERE `Id_Usuario` = ? AND `Fecha` BETWEEN ? AND ? and id_tareas_seguridad is null";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFin, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['totalSugerencias'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el total de Sugerencias. '
                    . TICKETS;
        }
        
        return $response;
    }

    public function obtenerSugerenciasPorSucursal($fecha, $idSucursal)
    {
        $sql = "SELECT * FROM `sugerencias` WHERE `Fecha` >= ? AND `Fecha` <= ? AND `Id_Sucursal` = ? and id_tareas_seguridad is null";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha . ' 23:59:59', PDO::PARAM_STR);
        $stmt->bindValue(3, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al validar las sugerencias de mejora. ' . TICKETS;
        }

        return $response;
    }
    
     public function obtenerSugerenciasPorSucursalBloquea($fecha, $fecha2, $idSucursal)
    {
        $sql = "SELECT * FROM `sugerencias` WHERE `Fecha` >= ? AND `Fecha` <= ? AND `Id_Sucursal` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha2, PDO::PARAM_STR);
        $stmt->bindValue(3, $idSucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['sugerencias'] =  $stmt->fetchAll(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al validar las sugerencias de mejora. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerSugerenciasPorUsuarioYFecha($idUsuario, $fecha)
    {
        $sql = "SELECT * FROM `sugerencias` WHERE `Fecha` >= ? AND `Fecha` <= ? AND `Id_Usuario` = ? and id_tareas_seguridad is null";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha . ' 00:00:00', PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha . ' 23:59:59', PDO::PARAM_STR);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener las sugerencias por persona. ' . TICKETS;
        }

        return $response;
    }
    
    /*** by isantosp *********/
    public function getSigFolioDao(){
        $sql = "SELECT Folio FROM sugerencias ORDER BY Id_Sugerencia DESC LIMIT 1 ";        
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();

            if($stmt->rowCount() == 0){
                $folio = "S-".date("ym")."001";
            }else{
                $last = $stmt->fetch(PDO::FETCH_OBJ)->Folio;
                
                $num = intval(substr($last,7,strlen($last))) + 1;
                if ($num < 10) $numStr = '00'.$num;
                elseif ($num < 100) $numStr = '0'.$num;
                else $numStr = $num;
                
                $folio = "S-".date("ym")."".$numStr;
            }

            $response['status'] = true;
            $response['folio'] = $folio;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los datos solicitados. ' . TICKETS;
        }
        
        return $response;
    }

    public function guardaSugerenciaDAO(Sugerencia $s, $user){

        $SQL = "INSERT INTO sugerencias 
                        (Id_Sugerencia, Id_Sucursal, Folio, Id_Usuario, Descripcion, Nivel, Causa_1, Causa_2, Causa_3, Causa_4, Causa_5, Accion, 
                        Id_Responsable, Fecha, Fecha_Accion, Resultado_Esperado, Resultado_Real, Avance, Status, id_tareas_seguridad)
                    VALUES 
                        (NULL,?,?,?,?,?,?,?,?,?,?,?,?,NOW(),?,?,?,?,0, ?)";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $s->__get('_idSucursal'), PDO::PARAM_INT);
        $stmt->bindValue(2, $s->__get('_folio'), PDO::PARAM_STR);
        $stmt->bindValue(3, $s->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(4, $s->__get('_descripcion'), PDO::PARAM_STR);
        $stmt->bindValue(5, $s->__get('_nivel'), PDO::PARAM_STR);
        $stmt->bindValue(6, $s->__get('_causa1'), PDO::PARAM_STR);
        $stmt->bindValue(7, $s->__get('_causa2'), PDO::PARAM_STR);
        $stmt->bindValue(8, $s->__get('_causa3'), PDO::PARAM_STR);
        $stmt->bindValue(9, $s->__get('_causa4'), PDO::PARAM_STR);
        $stmt->bindValue(10, $s->__get('_causa5'), PDO::PARAM_STR);
        $stmt->bindValue(11, $s->__get('_accion'), PDO::PARAM_STR);
        $stmt->bindValue(12, $s->__get('_idResponsable'), PDO::PARAM_INT);
        $stmt->bindValue(13, $s->__get('_fechaAccion'), PDO::PARAM_STR);
        $stmt->bindValue(14, $s->__get('_resultadoEsperado'), PDO::PARAM_STR);
        $stmt->bindValue(15, $s->__get('_resultadoReal'), PDO::PARAM_STR);
        $stmt->bindValue(16, $s->__get('_avance'), PDO::PARAM_STR);
        $stmt->bindValue(17, $s->__get('_idTareaSeguridad'), PDO::PARAM_INT);


        try{
            $stmt->execute();

            $idSugerencia = $this->_dbh->lastInsertId();
            $response['status'] = true;
            $response['idSugerencia'] = $idSugerencia;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar la sugerencia. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerSugerenciasDiarias($idSucursal, $fecha1, $fecha2)
    {
        $sql = "SELECT * FROM `sugerencias` WHERE `Id_Sucursal` = ? AND `Fecha` BETWEEN ? AND ? and id_tareas_seguridad is null";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha1, PDO::PARAM_STR);
        $stmt->bindValue(3, $fecha2, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['sugerencias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener las sugerencias diarias. ' . TICKETS;
        }
        
        return $response;
    }
    
        public function obtenerSugerenciasProgreso($fechaInicio, $fechaFin, $idUsuario)
    {
        $sql = "SELECT * FROM `sugerencias` INNER JOIN `comentarios` ON `comentarios`.`Id_Sospechoso` = `sugerencias`.`Id_Sugerencia` WHERE `comentarios`.`Status` < 2 AND `comentarios`.`Tipo` = 'sugerencias' AND `comentarios`.`Progreso` < 100 AND `comentarios`.`Cuando` BETWEEN ? AND ? AND `sugerencias`.`Id_Responsable` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFin, PDO::PARAM_STR);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['sugerencias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['totalSugerencias'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las '
                . 'sugerencias de mejora. ' . TICKETS;
        }

        return $response;
    }
    
}
