<?php
/**
 * VehiculoDao.php
 * Modelo para el manejo de vehículos 
 * @author José Francisco Montaño Andriano
 * @copyright (c) 2017, Merdiz
 * @version 1.0 Beta
 * @package balance
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Vehiculo.php';

class VehiculoDao extends Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function getVehiculos($idSucursal, $inicio, $registros){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM `vehiculos` WHERE `Id_Sucursal` = ? ORDER BY Status DESC, Marca, Vehiculo LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['vehiculos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de los vehiculos';
        }

        return $response;
    }

    public function findVehiculo($idSucursal, $inicio, $registros, $termino){
        $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM `vehiculos` WHERE `Id_Sucursal` = ? 
        				AND (Marca LIKE ? OR Vehiculo LIKE ? OR Placas LIKE ? OR Serie LIKE ?) 
        			ORDER BY Status DESC, Marca, Vehiculo LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(3, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(4, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(5, '%'.$termino.'%', PDO::PARAM_STR);
        $stmt->bindValue(6, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(7, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['vehiculos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de los vehiculos';
        }

        return $response;
    }

    public function getVehiculo($idVehiculo){
        $sql = "SELECT * FROM `vehiculos` WHERE `Id_Vehiculo` = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idVehiculo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['vehiculo'] = $stmt->fetch(PDO::FETCH_OBJ);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del vehiculo';
        }

        return $response;
    }


    public function getProximaVerificacion($fechaSemana){
        $sql = "SELECT * FROM `vehiculos` WHERE `fecha_verificacion` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaSemana, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['verificacion'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener fecha de verificacion';
        }

        return $response;
    }

    public function getVencimientoSeguro($fechaSemana){
        $sql = "SELECT * FROM `vehiculos` WHERE `fecha_seguro` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaSemana, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['seguro'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener fecha de verificacion';
        }

        return $response;
    }




    public function guardaVehiculo(Vehiculo $v, $tipo){
    	if($tipo == 1){
            Utils::logInfo("INSERT", "", "");
	    	$SQL = "INSERT INTO vehiculos 
	    					(Id_Vehiculo, Id_Sucursal, Status, Kilometraje, Marca, Vehiculo, Ano, Color, Placas, Serie, Tanque, Conf_Vehicular, Aseguradora, Poliza, Asignado, km_Servicio, fecha_verificacion, fecha_tarjeta_circulacion, fecha_servicio, fecha_seguro, kilometraje_restant, peso_vehiculo) 
	    				VALUES 
	    					(NULL, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
    	}else{
    	    Utils::logInfo("HACE UN UPDATE", "", "");
    		$SQL = "UPDATE vehiculos SET Id_Sucursal = ?, Status = ?, Kilometraje = ?, 
                     Marca = ?, Vehiculo = ?, Ano =?, Color = ?, Placas = ?, Serie = ?, Tanque = ?,
                     Conf_Vehicular = ?, Aseguradora = ?, Poliza = ?, Asignado = ?, km_Servicio = ?, fecha_verificacion = ?, fecha_tarjeta_circulacion = ?, fecha_servicio = ?, fecha_seguro = ?, kilometraje_restante = ?, peso_vehiculo = ? WHERE Id_Vehiculo = ? ";
    	}

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $v->__get('_idSucursal'), PDO::PARAM_INT);
        $stmt->bindValue(2, $v->__get('_status'), PDO::PARAM_INT);
	    $stmt->bindValue(3, $v->__get('_kilometraje'), PDO::PARAM_STR);

        if($tipo == 1){
            Utils::logInfo("TIPO 1", "", "");
	        $stmt->bindValue(4, $v->__get('_marca'), PDO::PARAM_STR);
	        $stmt->bindValue(5, $v->__get('_vehiculo'), PDO::PARAM_STR);
	        $stmt->bindValue(6, $v->__get('_year'), PDO::PARAM_INT);
	        $stmt->bindValue(7, $v->__get('_color'), PDO::PARAM_STR);
	        $stmt->bindValue(8, $v->__get('_placas'), PDO::PARAM_STR);
	        $stmt->bindValue(9, $v->__get('_serie'), PDO::PARAM_STR);
	        $stmt->bindValue(10, $v->__get('_tanque'), PDO::PARAM_STR);
            $stmt->bindValue(11, $v->__get('_confVehicular'), PDO::PARAM_STR);
            $stmt->bindValue(12, $v->__get('_aseguradora'), PDO::PARAM_STR);
            $stmt->bindValue(13, $v->__get('_poliza'), PDO::PARAM_STR);
            $stmt->bindValue(14, $v->__get('_asignado'), PDO::PARAM_INT);
            $stmt->bindValue(15, $v->__get('_kmServicio'), PDO::PARAM_INT);
            $stmt->bindValue(16, $v->__get('_verificacion'), PDO::PARAM_STR);
            $stmt->bindValue(17, $v->__get('_tarjetaCirculacion'), PDO::PARAM_STR);
            $stmt->bindValue(18, $v->__get('_fechaServicio'), PDO::PARAM_STR);
            $stmt->bindValue(19, $v->__get('_fechaSeguro'), PDO::PARAM_STR);
            $stmt->bindValue(20, $v->__get('_kmRestante'), PDO::PARAM_INT);
            $stmt->bindValue(21, $v->__get('_pesoBruto'), PDO::PARAM_INT);

        }else{
            Utils::logInfo("NO ES TIPO 1", "", "");
            $stmt->bindValue(4, $v->__get('_marca'), PDO::PARAM_STR);
            $stmt->bindValue(5, $v->__get('_vehiculo'), PDO::PARAM_STR);
            $stmt->bindValue(6, $v->__get('_year'), PDO::PARAM_INT);
            $stmt->bindValue(7, $v->__get('_color'), PDO::PARAM_STR);
            $stmt->bindValue(8, $v->__get('_placas'), PDO::PARAM_STR);
            $stmt->bindValue(9, $v->__get('_serie'), PDO::PARAM_STR);
            $stmt->bindValue(10, $v->__get('_tanque'), PDO::PARAM_STR);
            $stmt->bindValue(11, $v->__get('_confVehicular'), PDO::PARAM_STR);
            $stmt->bindValue(12, $v->__get('_aseguradora'), PDO::PARAM_STR);
            $stmt->bindValue(13, $v->__get('_poliza'), PDO::PARAM_STR);
            $stmt->bindValue(14, $v->__get('_asignado'), PDO::PARAM_INT);
            $stmt->bindValue(15, $v->__get('_kmServicio'), PDO::PARAM_INT);
            $stmt->bindValue(16, $v->__get('_verificacion'), PDO::PARAM_STR);
            $stmt->bindValue(17, $v->__get('_tarjetaCirculacion'), PDO::PARAM_STR);
            $stmt->bindValue(18, $v->__get('_fechaServicio'), PDO::PARAM_STR);
            $stmt->bindValue(19, $v->__get('_fechaSeguro'), PDO::PARAM_STR);
            $stmt->bindValue(20, $v->__get('_kmRestante'), PDO::PARAM_INT);
            $stmt->bindValue(21, $v->__get('_pesoBruto'), PDO::PARAM_INT);
            $stmt->bindValue(22, $v->__get('_idVehiculo'), PDO::PARAM_INT);
	        $idVehiculo = $v->__get('_idVehiculo');
	    }

        try{
            $stmt->execute();
            if($tipo == 1) $idVehiculo = $this->_dbh->lastInsertId();
            $response['status'] = true;
            $response['idVehiculo'] = $idVehiculo;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el vehiculo. '
                    . TICKETS;
        }
        
        return $response;
    }

    public function guardaExpedienteVehiculo(Vehiculo $expedienteVerificacion, $idVehiculo){
            Utils::logInfo("INSERT EXPEDIUENTE", "", "");
            $SQL = "INSERT INTO `expediente_vehicular` (`id_expediente_vehicular`, `nombre_archivo`, `fecha_subida`, `fecha_doc`, `id_vehiculo`) VALUES (NULL, ?, ?, ?, ?) ";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $expedienteVerificacion->__get('_nombreArc'), PDO::PARAM_STR);
        $stmt->bindValue(2, $expedienteVerificacion->__get('_fechaSubida'), PDO::PARAM_STR);
        $stmt->bindValue(3, $expedienteVerificacion->__get('_fechaDoc'), PDO::PARAM_STR);
        $stmt->bindValue(4, $expedienteVerificacion->__get('_id_vehiculo'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idVehiculo'] = $idVehiculo;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el expediente vehicular. '
                . TICKETS;
        }

    }

    public function getExpedienteVehiculo($idVehiculo, $arcNombre){
        $sql = "SELECT `nombre_archivo` FROM `expediente_vehicular` WHERE `id_vehiculo` = ? AND `nombre_archivo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idVehiculo, PDO::PARAM_INT);
        $stmt->bindValue(2, $arcNombre, PDO::PARAM_STR);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['expediente'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los vehiculos. '
                . TICKETS;
        }

        return $response;
    }

    public function getExpedienteVehicular($idVehiculo, $arcNombre, $page = -1){
        $limit = '';
        if($page > -1){
            $ini = $page * 20;
            $limit = " LIMIT $ini, 20 ";
        }
        $sql = "SELECT * FROM `expediente_vehicular` WHERE `id_vehiculo` = ? AND `nombre_archivo` LIKE '%$arcNombre%' ORDER BY `id_expediente_vehicular` DESC $limit";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idVehiculo, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['expedienteVeri'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los vehiculos. '
                . TICKETS;
        }

        return $response;
    }

    public function getVehiculosSinPoliza(){
        $sql = "SELECT * FROM `vehiculos` t1 WHERE NOT EXISTS (SELECT NULL FROM `expediente_vehicular` t2 WHERE t2.`id_vehiculo` = t1.`Id_Vehiculo` AND t2.`nombre_archivo` LIKE '%Poliza-%') ORDER BY `Id_Vehiculo` ";
        $stmt = $this->_dbh->prepare($sql);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['sinPoliza'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener vehiculos sin poliza. '
                . TICKETS;
        }

        return $response;
    }

    public function getVehiculosSinServicio(){
        $sql = "SELECT * FROM `vehiculos` t1 WHERE NOT EXISTS (SELECT NULL FROM `expediente_vehicular` t2 WHERE t2.`id_vehiculo` = t1.`Id_Vehiculo` AND t2.`nombre_archivo` LIKE '%Servicio-%') ORDER BY `Id_Vehiculo` ";
        $stmt = $this->_dbh->prepare($sql);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['sinServicio'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener vehiculos sin poliza. '
                . TICKETS;
        }

        return $response;
    }

    public function getVehiculosSinVerificacion(){
        $sql = "SELECT * FROM `vehiculos` t1 WHERE NOT EXISTS (SELECT NULL FROM `expediente_vehicular` t2 WHERE t2.`id_vehiculo` = t1.`Id_Vehiculo` AND t2.`nombre_archivo` LIKE '%Verificacion-%') ORDER BY `Id_Vehiculo` ";
        $stmt = $this->_dbh->prepare($sql);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['sinVeri'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener vehiculos sin poliza. '
                . TICKETS;
        }

        return $response;
    }

    public function getVehiculosSinTarjetaC(){
        $sql = "SELECT * FROM `vehiculos` t1 WHERE NOT EXISTS (SELECT NULL FROM `expediente_vehicular` t2 WHERE t2.`id_vehiculo` = t1.`Id_Vehiculo` AND t2.`nombre_archivo` LIKE '%TarjetaC-%') ORDER BY `Id_Vehiculo` ";
        $stmt = $this->_dbh->prepare($sql);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['sinTarjeta'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener vehiculos sin poliza. '
                . TICKETS;
        }

        return $response;
    }

    public function setFecha($vehiculo, $fechaServ){

        $SQL = "UPDATE vehiculos SET fecha_servicio = ? WHERE Id_Vehiculo = ?; ";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $fechaServ, PDO::PARAM_STR);
        $stmt->bindValue(2, $vehiculo, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idVehiculo'] = $vehiculo;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el kilometraje. '
                . TICKETS;
        }

        return $response;

    }


    public function setKilometraje($vehiculo, $km){
        $SQL = "UPDATE vehiculos SET Kilometraje = ? WHERE Id_Vehiculo = ?; ";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $km, PDO::PARAM_INT);
        $stmt->bindValue(2, $vehiculo, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idVehiculo'] = $vehiculo;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el kilometraje. '
                    . TICKETS;
        }
        
        return $response;
    }

    public function setKmRestantes($vehiculo, $kmRestantes){
        $SQL = "UPDATE vehiculos SET kilometraje_restante = ? WHERE Id_Vehiculo = ?; ";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $kmRestantes, PDO::PARAM_INT);
        $stmt->bindValue(2, $vehiculo, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idVehiculo'] = $vehiculo;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el kilometraje restante. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerVehiculosSucursales($idSucursal, $idSucursalEntrega){
        $sql = "SELECT * FROM vehiculos WHERE (Id_Sucursal = ? || Id_Sucursal = ? ) AND Status = 1 and `Asignado` IS NOT NULL  and `Asignado` != 0 ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSucursalEntrega, PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['vehiculos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los vehiculos. '
                    . TICKETS;
        }

        return $response;
    }

    public function obtenerVehiculosSucursal($idSucursal){
        $sql = "SELECT * FROM vehiculos WHERE Id_Sucursal = ? AND Status = 1 and `Asignado` IS NOT NULL  and `Asignado` != 0 ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['vehiculos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los vehiculos. '
                . TICKETS;
        }

        return $response;
    }

    public function getVehiculoKmCero(){
        $sql = "SELECT * FROM `vehiculos` WHERE `Status` = 1 AND `kilometraje_restante` <= 0 ";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
            $response['vehiculo'] = $stmt->fetch(PDO::FETCH_OBJ);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del vehiculo';
        }

        return $response;
    }

    public function bloquearVehiculo($vehiculo){
        $SQL = "UPDATE `vehiculos` SET `Status` = 0 WHERE `Id_Vehiculo` = ?";

        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $vehiculo, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idVehiculo'] = $vehiculo;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el kilometraje restante. '
                . TICKETS;
        }

        return $response;
    }
    
    public function obtenerConductores($fecha)
    {
        $sql = "SELECT * FROM `usuarios` WHERE `Status` >= 1 AND Vigencia_Licencia >= ? AND Licencia != ''";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['usuarios'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la lista '
                . 'de usuarios. ' . TICKETS;
        }

        return $response;
    }
    
}
