<?php
/**
 * AjaxComprasController.php
 * Controlador para el módulo de compras con ajax
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package compras
 */

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxComprasController {

    public function obtenerRequisicionesAutorizar() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $d = new DocumentoDao();
        $t = $d->totalRequisicionesIndirectosAutorizar(Sesion::obtener('idSucursal'));
        if ($t['status']) {
            $total = $t['total'];
            $requisiciones = $d->obtenerRequisicionesIndirectosAutorizar(Sesion::obtener('idSucursal'), $inicio, $registros);
            if ($requisiciones['status']){
                $paginas = ceil($total / $registros);
                $response['status'] = true;
                $response['requisiciones'] = $requisiciones['requisiciones'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $requisiciones['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }
        
        echo json_encode($response);
    }

    public function leerXML() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DireccionDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleRequisicionDao.php';

        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'archivos_entrada' . DIRECTORY_SEPARATOR;
        if (isset($_FILES['xmlRequisicion']['name'])) {
            if ($_FILES['xmlRequisicion']['type'] == 'text/xml') {
                if (move_uploaded_file($_FILES['xmlRequisicion']['tmp_name'], $ruta . $_FILES['xmlRequisicion']['name'])) {
                    $xml = $ruta . $_FILES['xmlRequisicion']['name'];
                    chmod($ruta . $_FILES['xmlRequisicion']['name'], 0777);
                    $xml = simplexml_load_file($ruta . $_FILES['xmlRequisicion']['name']);
                    if ($xml) {
                        $ns = $xml->getNamespaces(true);
                        $xml->registerXPathNamespace('c', $ns['cfdi']);
                        $xml->registerXPathNamespace('t', $ns['tfd']);
                        if (array_key_exists('aerolineas', $ns)) {
                            $xml->registerXPathNamespace('a', $ns['aerolineas']);
                        }
                        if (array_key_exists('terceros', $ns)) {
                            $xml->registerXPathNamespace('tr', $ns['terceros']);
                        }

                        foreach ($xml->xpath('//cfdi:Comprobante') as $comprobante) {
                            $lugarexpedicion = $comprobante['LugarExpedicion'];
                            $version = $comprobante['version'];
                            $serie = $comprobante['serie'];
                            $folioFactura = $comprobante['folio'];
                            if (!$folioFactura) {
                                $folioFactura = '';
                            }
                            $fecha = $comprobante['fecha'];
                            $formadepago = $comprobante['formaDePago'];
                            $nocertificado = $comprobante['noCertificado'];
                            $subtotal = $comprobante['subTotal'];
                            $total = $comprobante['total'];
                            $nocuenta = $comprobante['NumCtaPago'];
                            $tipodecomprobante = $comprobante['tipoDeComprobante'];
                            $metododepago = $comprobante['metodoDePago'];
                            $condicionesdepago = $comprobante['condicionesDePago'];
                            $tipoCambio = (float) $comprobante['TipoCambio'];
                            $moneda = $comprobante['Moneda'];
                        }

                        foreach ($xml->xpath('//cfdi:Comprobante//cfdi:Emisor') as $emisor) {
                            $nombre_emisor = $emisor['nombre'];
                            $rfc_emisor = $emisor['rfc'];
                        }

                        foreach ($xml->xpath('//cfdi:Comprobante//cfdi:Emisor//cfdi:DomicilioFiscal') as $domicilioemisor) {
                            $calle_emisor = $domicilioemisor['calle'];
                            $exterior_emisor = $domicilioemisor['noExterior'];
                            $interior_emisor = $domicilioemisor['noInterior'];
                            $colonia_emisor = $domicilioemisor['colonia'];
                            $municipio_emisor = $domicilioemisor['municipio'];
                            $estado_emisor = $domicilioemisor['estado'];
                            $pais_emisor = $domicilioemisor['pais'];
                            $cp_emisor = $domicilioemisor['codigoPostal'];
                        }


                        foreach ($xml->xpath('//cfdi:Comprobante//cfdi:Impuestos') as $impuestos) {
                            $totalimpuestostrasladados = (float) $impuestos['totalImpuestosTrasladados'];
                        }


                        $retenciones = 0;
                        if ($xml->xpath('//cfdi:Impuestos//cfdi:Retenciones//cfdi:Retencion')) {
                            foreach ($xml->xpath('//cfdi:Impuestos//cfdi:Retenciones//cfdi:Retencion') as $retencion) {
                                $retenciones += (float) $retencion['importe'];
                            }
                        } else {
                            $retenciones = 0;
                        }

                        $importetraslado = 0;
                        $tasatraslado = 0;
                        $impuesto = 0;
                        foreach ($xml->xpath('//cfdi:Comprobante//cfdi:Impuestos//cfdi:Traslados//cfdi:Traslado') as $traslado) {
                            $importetraslado += (float) $traslado['importe'];
                            $tasatraslado += (float) $traslado['tasa'];
                            $impuesto += (float) $traslado['impuesto'];
                        }

                        foreach ($xml->xpath('//t:TimbreFiscalDigital') as $timbre) {
                            $versiontimbre = $timbre['version'];
                            $uuid = $timbre['UUID'];
                            $fechatimbrado = $timbre['FechaTimbrado'];
                            $sellocfd = $timbre['selloCFD'];
                            $nocertificadosat = $timbre['noCertificadoSAT'];
                            $sellosat = $timbre['selloSAT'];
                        }

                        foreach ($xml->xpath('//cfdi:Comprobante//cfdi:Conceptos//cfdi:Concepto') as $productos) {
                            $descripcion[] = $productos['descripcion'];
                            $unidad[] = $productos['unidad'];
                            $noidentificacion[] = $productos['noIdentificacion'];
                            $cantidad[] = $productos['cantidad'];
                            $valorunitario[] = $productos['valorUnitario'];
                            $importe[] = $productos['importe'];
                        }

                        $fechaValida = explode('T', $fechatimbrado);
                        $fechaValidar = explode('-', $fechaValida[0]);
                        $mesValido = $fechaValidar[1];
                        $anioValido = $fechaValidar[0];
                        $mesActual = date("m");
                        $anioActual = date("Y");
                        $diaActual = date("d");
                        //$mesValido != $mesActual || $anioValido != $anioActual
                        //AQUI
                        if (($mesValido != $mesActual || $anioValido != $anioActual) && intval($diaActual) > 99) {
                            unlink($ruta . $_FILES['xml']['name']);
                            $response['status'] = false;
                            $response['mensaje'] = 'Lo siento, la fecha del xml no corresponde '
                                . 'al mes y año actual.';
                        }else{
                            //validar uuid
                            $d = new DocumentoDao();
                            $valido = $d->validarUUID($uuid);
                            if ($valido['status']) {
                                if ($valido['existe'] == 0) {
                                    //validamos el proveedor
                                    $pr = new ProveedorIndirectoDao();
                                    $proveedor = $pr->obtenerProveedorPorRFC($rfc_emisor);
                                    if ($proveedor['status']) {
                                        if ($proveedor['existeProveedor'] > 0) {                                            
                                            $idProveedor = $proveedor['datosProveedor']->Id_Proveedor;
                                        } else {
                                            $d = new Direccion();
                                            $d->__set('_calle', $calle_emisor);
                                            $d->__set('_interior', $interior_emisor);
                                            $d->__set('_exterior', $exterior_emisor);
                                            $d->__set('_colonia', $colonia_emisor);
                                            $d->__set('_cp', $cp_emisor);
                                            $d->__set('_ciudad', $municipio_emisor);
                                            $d->__set('_estado', $estado_emisor);
                                            $d->__set('_telefono', '');
                                            $d->__set('_celular', '');
                                            $dir = new DireccionDao();
                                            $direccion = $dir->guardar($d, 1);
                                            $idDireccion = $direccion['idDireccion'];
                                            $p = new ProveedorIndirecto();
                                            $p->__set('_nombre', $emisor);
                                            $p->__set('_idContacto', 0);
                                            $p->__set('_idDireccion', $idDireccion);
                                            $p->__set('_diasCredito', 0);
                                            $p->__set('_limiteCredito', 0);
                                            $p->__set('_status', 1);
                                            $p->__set('_idSucursal', Sesion::obtener('idSucursal'));
                                            $p->__set('_lab', 'LAB');
                                            $p->__set('_cuantaBanco', '0000');
                                            $proveedor = $pr->guardar($p, 1);
                                            $idProveedor = $proveedor['idProveedor'];
                                        }
                                        //generamos la requisicion
                                        $doc = new DocumentoDao();
                                            if (Sesion::obtener('idSucursal') == 1){
                                                $suc = "PA";
                                            }
                                            if (Sesion::obtener('idSucursal') == 2){
                                                $suc = "PU";
                                            }
                                            if (Sesion::obtener('idSucursal') == 5){
                                                $suc = "QU";
                                            }
                                            
                                            $folio = "REQ" . $suc . "-" . date("YmdHi");
                                            $d = new Documento();
                                            $d->__set('_idCliente', 0);
                                            $d->__set('_idConfiguracion', 0);
                                            $d->__set('_status', 0);
                                            $d->__set('_fecha', date("Y-m-d"));
                                            $d->__set('_idSucursal', Sesion::obtener('idSucursal'));
                                            $d->__set('_subtotal', $subtotal);
                                            $d->__set('_total', $total);
                                            $d->__set('_idUsuario', Sesion::obtener('idUsuario'));
                                            $d->__set('_folioDocumento', $folio);
                                            $d->__set('_condicionesPago', '');
                                            $d->__set('_formaPago', '');
                                            $d->__set('_metodoPago', '');
                                            $d->__set('_tipoComprobante', $folioFactura);
                                            $d->__set('_noCuenta', 0);
                                            $d->__set('_tipoDocumento', 22);
                                            $d->__set('_idProveedor', $proveedor['datosProveedor']->Id_Proveedor);
                                            $d->__set('_observaciones', '');
                                            $d->__set('_tipoCambio', 1);
                                            $d->__set('_moneda', $moneda);
                                            $d->__set('_idPedido', 0);
                                            $d->__set('_idAlmacen', 0);
                                            $d->__set('_uuid', $uuid);
                                            $req = $doc->generarDocumento($d);
                                            if ($req['status']){
                                                $idDocumento = $req['idDocumento'];
                                                //generamos el detalle de la requisicion
                                                $totalProductos = count($descripcion);
                                                for ($i = 0; $i < $totalProductos; $i++){
                                                    $dr = new DetalleRequisicion();
                                                    $dr->__set('_producto', $descripcion[$i]);
                                                    $dr->__set('_cantidad', $cantidad[$i]);
                                                    $dr->__set('_precio', $valorunitario[$i]);
                                                    $dr->__set('_idDocumento', $idDocumento);
                                                    $detr = new DetalleRequisicionDao();
                                                    $detalle = $detr->guardar($dr);
                                                }
                                                                                               
                                                $response['status'] = true;
                                                $response['proveedor'] = $idProveedor;
                                                $response['rfcProveedor'] = $rfc_emisor;
                                                $response['descripcion'] = $descripcion;
                                                $response['unidades'] = $unidad;
                                                $response['noIdentificacion'] = $noidentificacion;
                                                $response['valorUnitario'] = $valorunitario;
                                                $response['importe'] = $importe;
                                                $response['subtotal'] = $subtotal;
                                                $response['total'] = $total;
                                                $response['moneda'] = $moneda;
                                                $response['cantidades'] = $cantidad;
                                                $response['iva'] = $importetraslado;
                                                $response['retenciones'] = $retenciones;
                                                $response['fecha'] = date("Y-m-d", strtotime($fechaValida[0]));
                                                $response['idRequisicion'] = $idDocumento;
                                                unlink($ruta . $_FILES['xmlRequisicion']['name']);
                                            }
                                            else{
                                                unlink($ruta . $_FILES['xmlRequisicion']['name']);
                                                $response['status'] = false;
                                                $response['mensaje'] = $req['error'];
                                            }
                                    } else {
                                        unlink($ruta . $_FILES['xmlRequisicion']['name']);
                                        $response['status'] = false;
                                        $response['mensaje'] = $proveedor['error'];
                                    }
                                } else {
                                    unlink($ruta . $_FILES['xmlRequisicion']['name']);
                                    $response['status'] = false;
                                    $response['mensaje'] = 'El XML ya ha sido registrado anteriormente';
                                }
                            } else {
                                unlink($ruta . $_FILES['xmlRequisicion']['name']);
                                $response['status'] = false;
                                $response['mensaje'] = ':( Lo siento, ocurrió un error al validar tu factura. ' . TICKETS;
                            }
                        }
                    } else {
                        unlink($ruta . $_FILES['xmlRequisicion']['name']);
                        $response['status'] = false;
                        $response['mensaje'] = 'Lo siento, ocurrió un error al leer '
                                . 'el XML o no es un XML válido. ' . TICKETS;
                    }
                } else {
                    unlink($ruta . $_FILES['xmlRequisicion']['name']);
                    $response['status'] = false;
                    $response['mensaje'] = 'Lo siento, ocurrió un error al validar '
                            . 'el XML. ' . TICKETS;
                }
            } else {
                unlink($ruta . $_FILES['xmlRequisicion']['name']);
                $response['status'] = false;
                $response['mensaje'] = 'Debes adjuntar un archivo XML';
            }
        } else {
            unlink($ruta . $_FILES['xmlRequisicion']['name']);
            $response['status'] = false;
            $response['mensaje'] = 'Debes adjuntar un archivo XML';
        }

        echo json_encode($response);
    }        
    
    public function generarRequisicion()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        $idRequisicion = filter_input(INPUT_POST, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        $idCuenta = filter_input(INPUT_POST, 'idCuenta', FILTER_SANITIZE_NUMBER_INT);
        
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR .
                'archivos_entrada' . DIRECTORY_SEPARATOR;
        
        $d = new Documento();
        $d->__set('_idDocumento', $idRequisicion);
        $doc = new DocumentoDao();
        $documento = $doc->obtenerDocumento($d);
        if ($documento['status']){
            $datosDocumento = $documento['documento'];
            $folioDocumento = $datosDocumento->Folio_Documento;
            if (move_uploaded_file($_FILES['xmlRequisicion']['tmp_name'], $ruta . $folioDocumento . '.xml')){
                if (move_uploaded_file($_FILES['pdfRequisicion']['tmp_name'], $ruta . $folioDocumento . '.pdf')){
                    $generarRequisicion = $doc->cambiaStatus($idRequisicion, 1);
                    if ($generarRequisicion['status']){
                        //enviamos el email
                        $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                        $contenido = 'Tiene una requisición pendiente de autorizar con número de folio ' . $folioDocumento . '. Para autorizarla haga click <a href="http://prueba.merdizshell.com/">aquí</a>.';
                        $datos = array("contenido" => $contenido);
                        $opciones = array(
                            'http' => array(
                                'method' => 'POST',
                                'header' => 'Content-type: application/x-www-form-urlencoded',
                                'content' => http_build_query($datos)
                            )
                        );
                        
                        $contexto = stream_context_create($opciones);
                        $contenidoEmail = file_get_contents($url, false, $contexto);
                        
                        $asunto = 'Nueva Requisición';
                        Email::enviarEmail('porfiriomercado.merdiz@gmail.com', '', $asunto, $contenidoEmail);
                        Email::enviarEmail('arturomercado.merdiz@gmail.com', '', $asunto, $contenidoEmail);
                        $response['status'] = true;
                        $response['mensaje'] = 'Requisición generada correctamente. Ha sido enviada para autorización.';
                    }
                    else{
                        $response['status'] = false;
                        $response['mensaje'] = ':( Lo siento, ocurrió un error al generar tu requisición. ' . TICKETS;
                    }
                }
                else{
                    $response['status'] = false;
                    $response['mensaje'] = ':( Lo siento, ocurrió un error al subir los archivos. ' . TICKETS;
                }
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = ':( Lo siento, ocurrió un error al subir los archivos. ' . TICKETS;
            }
        }
        else{
            
        }
        
        echo json_encode($response);
    }
    
    public function buscarProductoRequisicion()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'ProductoIndirectoDao.php';        
        
        $producto = filter_input(INPUT_GET, 'producto', FILTER_SANITIZE_STRING);
        $concepto = filter_input(INPUT_GET, 'idConcepto', FILTER_SANITIZE_NUMBER_INT);
        
        $p = new ProductoIndirectoDao();
        $productos = $p->buscarProductosRequisicion($producto, $concepto, Sesion::obtener('idSucursal'));
        if ($productos['status']){
            $arrayProductos = new ArrayObject($productos['productos']);
            $iteradorProductos = $arrayProductos->getIterator();
            $productosArray = array();
            while($iteradorProductos->valid()){
                $productosArray[] = array('label' => $iteradorProductos->current()->Nombre, 'value' => $iteradorProductos->current()->Id_Producto, 'costo' => $iteradorProductos->current()->Precio);
                $iteradorProductos->next();
            }
            
            $response['status'] = true;
            $response['productos'] = $productosArray;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $productos['error'];
        }
        
        echo json_encode($response);        
    }
    
    public function cambiaConcepto()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . 
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RelacionCuentaConceptoDao.php';
        
        $idConcepto = filter_input(INPUT_POST, 'idConcepto', FILTER_SANITIZE_NUMBER_INT);
        $idRequisicion = filter_input(INPUT_POST, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        //obtenemos la cuenta
        $r = new RelacionCuentaConceptoDao();
        $rel = $r->obtenerCuentaConcepto($idConcepto);
        if ($rel['status']){
            $datosCuenta = $rel['cuenta'];
            $d = new DocumentoDao();
            $cambia = $d->cambiaCuenta($datosCuenta->Id_Cuenta, $idRequisicion);
            if ($cambia['status']){
                $response['status'] = true;
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $cambia['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $rel['error'];
        }
        
        echo json_encode($response);
    }
    
    public function agregaProductoRequisicion()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'RelacionCuentaClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'almacenes' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProductoIndirectoDao.php';

        $idProducto = filter_input(INPUT_POST, 'idProducto', FILTER_SANITIZE_NUMBER_INT);
        $cantidad = filter_input(INPUT_POST, 'cantidad', FILTER_SANITIZE_NUMBER_INT);
        $costo = filter_input(INPUT_POST, 'costo', FILTER_SANITIZE_STRING);
        $iva = filter_input(INPUT_POST, 'iva', FILTER_SANITIZE_STRING);
        $costoTotal = filter_input(INPUT_POST, 'costoTotal', FILTER_SANITIZE_STRING);
        $idDocumento = filter_input(INPUT_POST, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        //validamos que no exista el producto
        //obtenemos los datos del producto
        $pr = new ProductoIndirectoDao();
        $producto = $pr->obtenerProducto($idProducto);
        if ($producto['status']){
            $datosProducto = $producto['producto'];
            $doc = new DetalleDocumentoDao();
            $existe = $doc->validarItemRequisicionCompra($idProducto, $idDocumento);
            if ($existe['status']){
                if ($existe['total'] == 0){
                    $d = new DetalleDocumento();
                    $d->__set('_idProducto', $idProducto);
                    $d->__set('_cantidad', $cantidad);
                    $d->__set('_precio', $costo);
                    $d->__set('_descuento', 0);
                    $d->__set('_idDocumento', $idDocumento);
                    $d->__set('_observaciones', '');
                    $d->__set('_status', 1);
                    $d->__set('_idLista', 0);

                    //obtenemos la cuenta 
                    $rc = new RelacionCuentaClienteDao();
                    $cta = $rc->obtenerCuenta($idProducto, 'ProductoIndirecto');                
                    $agregar = $doc->guardar($d);
                    if ($agregar['status']){
                        $response['status'] = true;
                        $d = new DocumentoDao();
                        $cambia = $d->cambiaCuenta($datosProducto->Id_Cuenta, $idDocumento);
                    }
                    else{
                        $response['status'] = false;
                        $response['mensaje'] = $agregar['error'];
                    }
                }
                else{
                    $response['status'] = false;
                    $response['mensaje'] = 'Ya existe el producto en la requisición. -_-';
                }
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $existe['error'];
            } 
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $producto['error'];
        }
        
        echo json_encode($response);
    }
    
    public function cargaDetalleRequisicion()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
        
        $idRequisicion = filter_input(INPUT_GET, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        
        $d = new DetalleDocumentoDao();
        $detalle = $d->obtenerDetalleDocumentoIndirectos($idRequisicion);
        if ($detalle['status']){
            $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
            $iteradorDetalle = $arrayDetalle->getIterator();
            $productos = array();
            while($iteradorDetalle->valid()){
                $productos[] = array(
                    "producto" => $iteradorDetalle->current()->Nombre,
                    "cantidad" => $iteradorDetalle->current()->Cantidad,
                    "costo" => $iteradorDetalle->current()->Precio,
                    "idDetalle" => $iteradorDetalle->current()->Id_Detalle_Documento
                );
                $iteradorDetalle->next();
            }
            
            $response['status'] = true;
            $response['productos'] = $productos;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $detalle['error'];
        }
        
        echo json_encode($response);
    }
    
    public function validarRequisicion()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
        
        $idRequisicion = filter_input(INPUT_POST, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        
        $d = new DetalleDocumentoDao();
        $valido = $d->validarDetalle($idRequisicion);
        if ($valido['status']){
            if ($valido['total'] > 0){
                $response['status'] = true;
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = 'Por favor agrega por lo menos un producto a la requisición. -_-';
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $valido['error'];
        }
        
        echo json_encode($response);
    }
    
    public function generaRequisicion()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'NotificacionesDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR . 
            'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';
        
        $idRequisicion = filter_input(INPUT_POST, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
        $proveedor = filter_input(INPUT_POST, 'proveedor', FILTER_SANITIZE_NUMBER_INT);
        $moneda = filter_input(INPUT_POST, 'moneda', FILTER_SANITIZE_STRING);
        $concepto = filter_input(INPUT_POST, 'concepto', FILTER_SANITIZE_NUMBER_INT);        
        $d = new DocumentoDao();
        $actualizaFecha = $d->actualizaFecha($idRequisicion, $fecha);
        if ($actualizaFecha['status']){
            $actualizaProveedor = $d->actualizaProveedor($idRequisicion, $proveedor);
            if ($actualizaProveedor['status']){
                $actualizaMoneda = $d->cambiaMoneda($idRequisicion, $moneda);                
                if ($actualizaMoneda['status']){
                    //obtenemos el detalle del documento
                    $de = new DetalleDocumentoDao();
                    $det = $de->obtenerDetalleDocumentoIndirectos($idRequisicion);
                    if ($det['status']){
                        $arrayDetalle = new ArrayObject($det['detalleDocumento']);
                        $iteradorDetalle = $arrayDetalle->getIterator();
                        $subtotal = 0;
                        $total = 0;
                        while($iteradorDetalle->valid()){
                            $subtotal += $iteradorDetalle->current()->Precio;
                            $iteradorDetalle->next();
                        }
                        
                        $total = $subtotal * 1.16;
                        $actualizatotal = $d->actualizarSubtotalTotal($idRequisicion, $subtotal, $total);
                        if ($actualizatotal['status']){
                            //cambiamos el status
                            $d->cambiaStatus($idRequisicion, 1);
                            $d->actualizaMetodoPago($concepto, $idRequisicion);
                            //obtenemos el folio de la requisición
                            $dc = new Documento();
                            $dc->__set('_idDocumento', $idRequisicion);
                            $doc = $d->obtenerDocumento($dc)['documento'];
                            //obtenemos el concepto
                            $con = new Concepto();
                            $con->__set('_idConcepto', $concepto);
                            $conce = new ConceptoDao();
                            $concepto = $conce->obtenerConcepto($con)['concepto'];
                            //generamos la notificación y enviamos el mail de autorización
                            $n = new Notificaciones();
                            $asunto = 'Nueva Requisición de compra.';
                            $mensaje = 'Se ha generado una nueva requisición de compra por concepto de ' . $concepto->Concepto . ' y con número de folio ' . $doc->Folio_Documento . '. Para autorizarla haga click <a href="' . BASEURL . 'compras/autorizaciones/">aqui</a>';
                            $n->__set('_asunto', $asunto);
                            $n->__set('_descripcion', $mensaje);
                            $n->__set('_fecha', date("Y-m-d"));
                            $n->__set('_hora', date("H:i:s"));
                            $n->__set('_url', 'compras/autorizaciones/');
                            $n->__set('_status', 1);
                            $n->__set('_idUsuario', 17);
                            $n->__set('_idSolicita', Sesion::obtener('idUsuario'));
                            
                            $not = new NotificacionesDao();
                            $not->crearNotificacion($n);
                            
                            $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                            $datos = array("contenido" => $mensaje);
                            $opciones = array(
                                'http' => array(
                                    'method' => 'POST',
                                    'header' => 'Content-type: application/x-www-form-urlencoded',
                                    'content' => http_build_query($datos)
                                )
                            );
                            
                            $contexto = stream_context_create($opciones);
                            $contenidoEmail = file_get_contents($url, false, $contexto);
                            Email::enviarEmail('porfiriomercado.merdiz@gmail.com', '', $asunto, $contenidoEmail);
                            Email::enviarEmail('arturomercado.merdiz@gmail.com', '', $asunto, $contenidoEmail);
                            $response['status'] = true;
                            $response['mensaje'] = 'Requisición generada correctamente con número de folio ' . $doc->Folio_Documento;
                        }
                        else{
                            $response['status'] = false;
                        }
                    }
                    else{
                        $response['status'] = false;
                        $response['mensaje'] = $det['error'];
                    }
                }
                else{
                    $response['status'] = false;
                    $response['mensaje'] = $actualizaMoneda['error'];
                }
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $actualizaProveedor['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $actualizaFecha['error'];
        }
        
        echo json_encode($response);        
    }
    
    public function autorizaRequisicion()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'NotificacionesDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        
        $idDocumento = filter_input(INPUT_POST, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        $d = new Documento();
        $d->__set('_idDocumento', $idDocumento);
        
        $doc = new DocumentoDao();
        $docu = $doc->obtenerDocumento($d);
        if ($docu['status']){
            $datosDocumento = $docu['documento'];
            
            $p = new ProveedorIndirecto();
            $p->__set('_idProveedor', $datosDocumento->Id_Proveedor);
            $pr = new ProveedorIndirectoDao();
            $proveedor = $pr->obtenerProveedor($p);
            if ($proveedor['status']){
                $datosProveedor = $proveedor['proveedor'];
                if ($datosProveedor->Dias_Credito == 0)
                    $status = 5;
                else
                    $status = 4;
                
                //cambiamos el status
                $autoriza = $doc->cambiaStatus($idDocumento, $status);
                if ($autoriza['status']){
                    //generamos la notificación y el correo
                    $asunto = 'Requisición Autorizada';
                    $mensaje = 'Tu requisición con número de folio ' . $datosDocumento->Folio_Documento . ' ha sido autorizada.';
                    $n = new Notificaciones();
                    $n->__set('_asunto', $asunto);
                    $n->__set('_descripcion', $mensaje);
                    $n->__set('_fecha', date("Y-m-d"));
                    $n->__set('_hora', date("H:i:s"));
                    $n->__set('_url', 'compras/');
                    $n->__set('_status', 1);
                    $n->__set('_idUsuario', $datosDocumento->Id_Usuario);
                    $n->__set('_idSolicita', Sesion::obtener('idUsuario'));
                    $not = new NotificacionesDao();
                    $not->crearNotificacion($n);
                    $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                    $datos = array("contenido" => $mensaje);
                    $opciones = array(
                        'http' => array(
                            'method' => 'POST',
                            'header' => 'Content-type: application/x-www-form-urlencoded',
                            'content' => http_build_query($datos)
                        )
                    );
                    
                    $us = new UsuarioDao();
                    $datosUsuario = $us->obtenerUsuario($datosDocumento->Id_Usuario)['usuarios'];
                    
                    $contexto = stream_context_create($opciones);
                    $contenidoEmail = file_get_contents($url, false, $contexto);
                    Email::enviarEmail($datosUsuario->Mail, '', $asunto, $contenidoEmail);
                    $response['status'] = true;
                    $response['mensaje'] = 'Requisición autorizada correctamente.';
                }
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $proveedor['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $docu['error'];
        }
        
        echo json_encode($response);
    }
    
    public function rechazaRequisicion()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'NotificacionesDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        
         $idDocumento = filter_input(INPUT_POST, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        $d = new Documento();
        $d->__set('_idDocumento', $idDocumento);
        
        $doc = new DocumentoDao();
        $docu = $doc->obtenerDocumento($d);
        if ($docu['status']){
            $datosDocumento = $docu['documento'];
            $rechaza = $doc->cambiaStatus($idDocumento, 3);
            if ($rechaza['status']){
                $us = new UsuarioDao();
                $datosUsuario = $us->obtenerUsuario($datosDocumento->Id_Usuario)['usuarios'];
                //generamos la notificación y el correo
                    $asunto = 'Requisición Rechazada';
                    $mensaje = 'Tu requisición con número de folio ' . $datosDocumento->Folio_Documento . ' ha sido rechazada.';
                    $n = new Notificaciones();
                    $n->__set('_asunto', $asunto);
                    $n->__set('_descripcion', $mensaje);
                    $n->__set('_fecha', date("Y-m-d"));
                    $n->__set('_hora', date("H:i:s"));
                    $n->__set('_url', 'compras/');
                    $n->__set('_status', 1);
                    $n->__set('_idUsuario', $datosDocumento->Id_Usuario);
                    $n->__set('_idSolicita', Sesion::obtener('idUsuario'));
                    $not = new NotificacionesDao();
                    $not->crearNotificacion($n);
                    $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
                    $datos = array("contenido" => $mensaje);
                    $opciones = array(
                        'http' => array(
                            'method' => 'POST',
                            'header' => 'Content-type: application/x-www-form-urlencoded',
                            'content' => http_build_query($datos)
                        )
                    );                                        
                    
                    $contexto = stream_context_create($opciones);
                    $contenidoEmail = file_get_contents($url, false, $contexto);
                    Email::enviarEmail($datosUsuario->Mail, '', $asunto, $contenidoEmail);
                    $response['status'] = true;
                    $response['mensaje'] = 'Requisición rechazada correctamente.';
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $rechaza['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $docu['error'];
        }
        
        echo json_encode($response);
    }
    
    public function cancelarRequisicion()
    {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        
        $idRequisicion = filter_input(INPUT_POST, 'idRequisicion', FILTER_SANITIZE_NUMBER_INT);
        
        $d = new DocumentoDao();
        $cancelar = $d->cambiaStatus($idRequisicion, 3);
        if ($cancelar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Requisición cancelada correctamente.';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = ':( Lo siento, ocurrió un error al cancelar la requisición. ' . TICKETS;
        }
        
        echo json_encode($response);
    }
    
    public function eliminarDetalleRequisicion()
    {        
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
        
        $idDetalle = filter_input(INPUT_POST, 'idDetalle', FILTER_SANITIZE_NUMBER_INT);        
        
        $d = new DetalleDocumentoDao();
        $elimina = $d->eliminaItem($idDetalle);
        if ($elimina['status']){
            $response['status'] = true;
        }
        else{
            $response['status'] = false;
            $response['error'] = $elimina['error'];
        }
        
        echo json_encode($response);
    }
}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        } else {
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxComprasController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}