<?php
/**
 * ComprasController.php
 * Controlador para el módulo de compras
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package compras
 */

class ComprasController extends Controller {

    private $_module = 10;
    private $_tarea;

    public function __construct() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'TareasDao.php';
        $this->_modulo = 'compras';

        $t = new TareasDao();
        $tareas = $t->obtenerTareasModuloUsuario($this->_module, Sesion::obtener('idUsuario'));
        if (!$tareas['status']) {
            ErrorController::mostrarError(1, $tareas['error']);
        }
        $tareasLista = $tareas['tareas'];
        $arrayTareas = new ArrayObject($tareasLista);
        $iteradorTareas = $arrayTareas->getIterator();
        $this->_datos['tareas'] = $iteradorTareas;
    }

    /**
     * Método para cargar la vista por defecto
     * @access public
     */
    public function index() {
        $this->_vista = 'index';
        $this->existeVista();
        $this->_datos['accion'] = '';
        $this->cargarVista();
    }

    // public function formatoRequisicion() {
    //     $this->_tarea = 50;
    //     $t = new TareasDao();
    //     $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
    //     if ($perm['status']) {
    //         if ($perm['acceso'] == 0) {
    //             ErrorController::mostrarError(403);
    //         }

    //         require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
    //                 DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
    //         require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
    //                 DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
    //         require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' .
    //                 DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';
    //         require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
    //                 DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
    //         require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
    //         require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
    //         require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';

    //         //obtenemos los datos de la sucursal
    //         $s = new SucursalDao();
    //         $sucursal = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'));
    //         if ($sucursal['status']) {
    //             $datosSucural = $sucursal['sucursal'];
    //             //obtenemos el usuario
    //             $u = new UsuarioDao();
    //             $usuario = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
    //             if ($usuario['status']) {
    //                 $datosUsuario = $usuario['usuarios'];
    //                 //cargamos los conceptos
    //                 $c = new ConceptoDao();
    //                 $conceptos = $c->obtenerListaConceptos();
    //                 if ($conceptos['status']) {
    //                     $arrayConceptos = new ArrayObject($conceptos['conceptos']);
    //                     $iteradorConceptos = $arrayConceptos->getIterator();

    //                     $p = new ProveedorIndirectoDao();
    //                     $proveedores = $p->listaProveedoresIndirectos(Sesion::obtener('idSucursal'));
    //                     if ($proveedores['status']) {
    //                         $arrayProveedores = new ArrayObject($proveedores['proveedores']);
    //                         $iteradorProveedores = $arrayProveedores->getIterator();
    //                         //obtenemos el último folio
    //                         $fechaInicial = date("Y") . '-' . date("m") . '-01';
    //                         $fechaFinal = date("Y-m-t");

    //                         switch (Sesion::obtener('idSucursal')) {
    //                             case 1:
    //                                 $prefijo = "REQPA";
    //                                 break;
    //                             case 2:
    //                                 $prefijo = "REQPU";
    //                                 break;
    //                             case 5:
    //                                 $prefijo = "REQQU";
    //                                 break;
    //                         }                            

    //                         $doc = new DocumentoDao();
    //                         //validamos si hay requisición abierta
    //                       $hay = $doc->validaRequisicionUsuario(Sesion::obtener('idUsuario'),  Sesion::obtener('idSucursal'));
    //                         if ($hay['status']) {
    //                             if ($hay['total'] > 0) {
    //                                 $idRequisicion = $hay['requisicion']->Id_Documento;
    //                                 //obtenemos el detalle de la requisición
    //                                 $d = new DetalleDocumentoDao();
    //                                 $detalle = $d->obtenerDetalleDocumentoIndirectos($idRequisicion);
    //                                 if ($detalle['status']) {
    //                                     $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
    //                                     $iteradorDetalle = $arrayDetalle->getIterator();
    //                                     $productos = array();
    //                                     while ($iteradorDetalle->valid()) {
    //                                         $productos[] = array(
    //                                             "producto" => $iteradorDetalle->current()->Nombre,
    //                                             "cantidad" => $iteradorDetalle->current()->Cantidad,
    //                                             "costo" => $iteradorDetalle->current()->Precio,
    //                                             "idDetalle" => $iteradorDetalle->current()->Id_Detalle_Documento
    //                                         );
    //                                         $iteradorDetalle->next();
    //                                     }
    //                                     $this->_vista = 'formatoRequisicion';
    //                                     $this->_datos['accion'] = 'requisiciones';
    //                                     $this->_datos['sucursal'] = $datosSucural;
    //                                     $this->_datos['usuario'] = $datosUsuario;
    //                                     $this->_datos['conceptos'] = $iteradorConceptos;
    //                                     $this->_datos['proveedores'] = $iteradorProveedores;
    //                                     $this->_datos['idRequisicion'] = $idRequisicion;
    //                                     $this->_datos['detalle'] = $productos;
    //                                     $this->existeVista();
    //                                     $this->cargarVista();
    //                                 } else {
    //                                     ErrorController::mostrarError(1, $detalle['error']);
    //                                 }
    //                             } else {
    //                                 $f = $doc->obtenerFolioRequisicion($fechaInicial, $fechaFinal, Sesion::obtener('idSucursal'));
    //                                 if ($f['status']) {
    //                                     if ($f['total'] == 0) {
    //                                         $folio = $prefijo . date("Ymd") . '-001';
    //                                     } else {
    //                                         $fo = $f['folio']->Folio_Documento;
    //                                         $fo = explode('-', $fo);
    //                                         $conse = (int) $fo[2];
    //                                         $conse = $conse + 1;
    //                                         $consecutivo = Utils::zerofill($conse, 3);
    //                                         $folio = $prefijo . '-' . date("YmdHis") . '-' . $consecutivo;
    //                                     }                                                                            

    //                                     //generamos la requisición 
    //                                     $d = new Documento();
    //                                     $d->__set('_idCliente', 0);
    //                                     $d->__set('_idConfiguracion', 1);
    //                                     $d->__set('_status', 0);
    //                                     $d->__set('_idSucursal', Sesion::obtener('idSucursal'));
    //                                     $d->__set('_fecha', date("Y-m-d H:i:s"));
    //                                     $d->__set('_subtotal', 0);
    //                                     $d->__set('_total', 0);
    //                                     $d->__set('_idUsuario', Sesion::obtener('idUsuario'));
    //                                     $d->__set('_folioDocumento', $folio);
    //                                     $d->__set('_condicionesPago', '');
    //                                     $d->__set('_formaPago', '');
    //                                     $d->__set('_metodoPago', '');
    //                                     $d->__set('_tipoComprobante', '');
    //                                     $d->__set('_noCuenta', '');
    //                                     $d->__set('_tipoDocumento', 22);
    //                                     $d->__set('_idProveedor', 0);
    //                                     $d->__set('_observaciones', '');
    //                                     $d->__set('_tipoCambio', 1);
    //                                     $d->__set('_moneda', 'MXN');
    //                                     $d->__set('_idPedido', 0);
    //                                     $d->__set('_idAlmacen', 0);
    //                                     $d->__set('_uuid', '');

    //                                     $req = $doc->generarDocumento($d);
    //                                     if ($req['status']) {                                            
    //                                         $idRequisicion = $req['idDocumento'];
    //                                         $d = new DetalleDocumentoDao();
    //                                         $detalle = $d->obtenerDetalleDocumentoIndirectos($idRequisicion);
    //                                         if ($detalle['status']) {
    //                                             $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
    //                                             $iteradorDetalle = $arrayDetalle->getIterator();
    //                                             $productos = array();
    //                                             while ($iteradorDetalle->valid()) {
    //                                                 $productos[] = array(
    //                                                     "producto" => $iteradorDetalle->current()->Nombre,
    //                                                     "cantidad" => $iteradorDetalle->current()->Cantidad,
    //                                                     "costo" => $iteradorDetalle->current()->Precio,
    //                                                     "idDetalle" => $iteradorDetalle->current()->Id_Detalle_Documento
    //                                                 );
    //                                                 $iteradorDetalle->next();
    //                                             }
    //                                             $this->_vista = 'formatoRequisicion';
    //                                             $this->_datos['accion'] = 'requisiciones';
    //                                             $this->_datos['sucursal'] = $datosSucural;
    //                                             $this->_datos['usuario'] = $datosUsuario;
    //                                             $this->_datos['conceptos'] = $iteradorConceptos;
    //                                             $this->_datos['proveedores'] = $iteradorProveedores;
    //                                             $this->_datos['idRequisicion'] = $idRequisicion;
    //                                             $this->_datos['detalle'] = $productos;
    //                                             $this->existeVista();
    //                                             $this->cargarVista();
    //                                         } else {
    //                                             ErrorController::mostrarError(1, $detalle['error']);
    //                                         }
    //                                     } else {
    //                                         ErrorController::mostrarError(1, $req['error']);
    //                                     }
    //                                 } else {
    //                                     ErrorController::mostrarError(1, $f['error']);
    //                                 }
    //                             }
    //                         } else {
    //                             ErrorController::mostrarError(1, $hay['error']);
    //                         }
    //                     } else {
    //                         ErrorController::mostrarError(1, $proveedores['error']);
    //                     }
    //                 } else {
    //                     ErrorController::mostrarError(1, $conceptos['error']);
    //                 }
    //             } else {
    //                 ErrorController::mostrarError(1, $usuario);
    //             }
    //         } else {
    //             ErrorController::mostrarError(1, $sucursal['error']);
    //         }
    //     } else {
    //         ErrorController::mostrarError(1, $perm['error']);
    //     }
    // }
    
    public function formatoRequisicion() {
        $this->_tarea = 50;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                    DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                    DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' .
                    DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                    DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'MovimientosPagosDao.php';

            //obtenemos los datos de la sucursal
            $s = new SucursalDao();
            $sucursal = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'));
            if ($sucursal['status']) {
                $datosSucural = $sucursal['sucursal'];
                //obtenemos el usuario
                $u = new UsuarioDao();
                $usuario = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
                if ($usuario['status']) {
                    $datosUsuario = $usuario['usuarios'];
                    //cargamos los conceptos
                    $c = new ConceptoDao();
                    $conceptos = $c->obtenerListaConceptos();
                    if ($conceptos['status']) {
                        $arrayConceptos = new ArrayObject($conceptos['conceptos']);
                        $iteradorConceptos = $arrayConceptos->getIterator();

                        $p = new ProveedorIndirectoDao();
                        $proveedores = $p->listaProveedoresIndirectos(Sesion::obtener('idSucursal'));
                        if ($proveedores['status']) {
                            $arrayProveedores = new ArrayObject($proveedores['proveedores']);
                            $iteradorProveedores = $arrayProveedores->getIterator();
                            //obtenemos el último folio
                            $fechaInicial = date("Y") . '-' . date("m") . '-01';
                            $fechaFinal = date("Y-m-t");


                            switch (Sesion::obtener('idSucursal')) {
                                case 1:
                                    $prefijo = "REQPA";
                                    break;
                                case 2:
                                    $prefijo = "REQPU";
                                    break;
                                case 5:
                                    $prefijo = "REQQU";
                                    break;
                            }                            

                            $doc = new DocumentoDao();
                            //validamos si hay requisición abierta
                           $hay = $doc->validaRequisicionUsuario(Sesion::obtener('idUsuario'),  Sesion::obtener('idSucursal'));

                            if ($hay['status']) {
                                $creaNuevaRequisicion = true;
                                if ($hay['total'] > 0) {
                                    $pag = new MovimientosPagosDao();
                                    $idDocRequisicion = $hay['requisicion']->Id_Documento;
                                    $pagos = $pag->obtenerPagosDocumento($idDocRequisicion)['total'];
                                    $creaNuevaRequisicion = ($pagos > 0) ? true : false;
                                    Utils::logInfo('Hay pagos? '.$pagos ,'Crea nueva requisicion? '.$creaNuevaRequisicion, '');
                                }

                                if (!$creaNuevaRequisicion) {
                                    $idRequisicion = $hay['requisicion']->Id_Documento;
                                    Utils::logInfo('Ya existe requisicion activa '.$idRequisicion ,'Folio: '.$hay['requisicion']->Folio_Documento, '');

                                    //obtenemos el detalle de la requisición
                                    $d = new DetalleDocumentoDao();
                                    $detalle = $d->obtenerDetalleDocumentoIndirectos($idRequisicion);
                                    if ($detalle['status']) {
                                        $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                                        $iteradorDetalle = $arrayDetalle->getIterator();
                                        $productos = array();
                                        while ($iteradorDetalle->valid()) {
                                            $productos[] = array(
                                                "producto" => $iteradorDetalle->current()->Nombre,
                                                "cantidad" => $iteradorDetalle->current()->Cantidad,
                                                "costo" => $iteradorDetalle->current()->Precio,
                                                "idDetalle" => $iteradorDetalle->current()->Id_Detalle_Documento
                                            );
                                            $iteradorDetalle->next();
                                        }
                                        $this->_vista = 'formatoRequisicion';
                                        $this->_datos['accion'] = 'requisiciones';
                                        $this->_datos['sucursal'] = $datosSucural;
                                        $this->_datos['usuario'] = $datosUsuario;
                                        $this->_datos['conceptos'] = $iteradorConceptos;
                                        $this->_datos['proveedores'] = $iteradorProveedores;
                                        $this->_datos['idRequisicion'] = $idRequisicion;
                                        $this->_datos['detalle'] = $productos;
                                        $this->existeVista();
                                        $this->cargarVista();
                                    } else {
                                        ErrorController::mostrarError(1, $detalle['error']);
                                    }
                                } else {
                                    $f = $doc->obtenerFolioRequisicion($fechaInicial, $fechaFinal, Sesion::obtener('idSucursal'));

                                    if ($f['status']) {
                                        if ($f['total'] == 0) {
                                            $folio = $prefijo . date("Ymd") . '-001';
                                        } else {
                                            $fo = $f['folio']->Folio_Documento;
                                            $fo = explode('-', $fo);
                                            $conse = (int) $fo[2];
                                            $conse = $conse + 1;
                                            $consecutivo = Utils::zerofill($conse, 3);
                                            $folio = $prefijo . '-' . date("YmdHis") . '-' . $consecutivo;
                                        }

                                        //generamos la requisición
                                        $d = new Documento();
                                        $d->__set('_idCliente', 0);
                                        $d->__set('_idConfiguracion', 1);
                                        $d->__set('_status', 0);
                                        $d->__set('_idSucursal', Sesion::obtener('idSucursal'));
                                        $d->__set('_fecha', date("Y-m-d H:i:s"));
                                        $d->__set('_subtotal', 0);
                                        $d->__set('_total', 0);
                                        $d->__set('_idUsuario', Sesion::obtener('idUsuario'));
                                        $d->__set('_folioDocumento', $folio);
                                        $d->__set('_condicionesPago', '');
                                        $d->__set('_formaPago', '');
                                        $d->__set('_metodoPago', '');
                                        $d->__set('_tipoComprobante', '');
                                        $d->__set('_noCuenta', '');
                                        $d->__set('_tipoDocumento', 22);
                                        $d->__set('_idProveedor', 0);
                                        $d->__set('_observaciones', '');
                                        $d->__set('_tipoCambio', 1);
                                        $d->__set('_moneda', 'MXN');
                                        $d->__set('_idPedido', 0);
                                        $d->__set('_idAlmacen', 0);
                                        $d->__set('_uuid', '');

                                        $req = $doc->generarDocumento($d);
                                        if ($req['status']) {                                            
                                            $idRequisicion = $req['idDocumento'];
                                            $d = new DetalleDocumentoDao();
                                            $detalle = $d->obtenerDetalleDocumentoIndirectos($idRequisicion);
                                            if ($detalle['status']) {
                                                $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                                                $iteradorDetalle = $arrayDetalle->getIterator();
                                                $productos = array();
                                                while ($iteradorDetalle->valid()) {
                                                    $productos[] = array(
                                                        "producto" => $iteradorDetalle->current()->Nombre,
                                                        "cantidad" => $iteradorDetalle->current()->Cantidad,
                                                        "costo" => $iteradorDetalle->current()->Precio,
                                                        "idDetalle" => $iteradorDetalle->current()->Id_Detalle_Documento
                                                    );
                                                    $iteradorDetalle->next();
                                                }
                                                $this->_vista = 'formatoRequisicion';
                                                $this->_datos['accion'] = 'requisiciones';
                                                $this->_datos['sucursal'] = $datosSucural;
                                                $this->_datos['usuario'] = $datosUsuario;
                                                $this->_datos['conceptos'] = $iteradorConceptos;
                                                $this->_datos['proveedores'] = $iteradorProveedores;
                                                $this->_datos['idRequisicion'] = $idRequisicion;
                                                $this->_datos['detalle'] = $productos;
                                                $this->existeVista();
                                                $this->cargarVista();
                                            } else {
                                                ErrorController::mostrarError(1, $detalle['error']);
                                            }
                                        } else {
                                            ErrorController::mostrarError(1, $req['error']);
                                        }
                                    } else {
                                        ErrorController::mostrarError(1, $f['error']);
                                    }
                                }
                            } else {
                                ErrorController::mostrarError(1, $hay['error']);
                            }
                        } else {
                            ErrorController::mostrarError(1, $proveedores['error']);
                        }
                    } else {
                        ErrorController::mostrarError(1, $conceptos['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $usuario);
                }
            } else {
                ErrorController::mostrarError(1, $sucursal['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }    

    public function reportes() {

        $this->_tarea = 50;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'reportes';
            $this->_datos['accion'] = 'reportes';
            $this->existeVista();
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteRequisiciones() {

        $this->_tarea = 50;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'MovimientoBancoPagos.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'MovimientosPagosDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

            $fechaInicial = filter_input(INPUT_POST, 'fechaInicial', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'fechaFinal', FILTER_SANITIZE_STRING);

            $d = new DocumentoDao();

            $req = $d->obtenerRequisicionesSucursal(Sesion::obtener('idSucursal'), $fechaInicial, $fechaFinal);

            if ($req['status']) {
                $arrayRequisiciones = new ArrayObject($req['requisiciones']);
                $iteradorRequisiciones = $arrayRequisiciones->getIterator();
                $this->_vista = 'reporteRequisiciones';
                $this->_datos['accion'] = 'reportes';
                $this->_datos['requisiciones'] = $iteradorRequisiciones;
                $this->existeVista();
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $req['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function autorizaciones() {
        $this->_tarea = 49;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'autorizaciones';
            $this->_datos['accion'] = 'autorizaciones';
            $this->existeVista();
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function detalleRequisicion() {
        $this->_tarea = 50;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';

            $idRequisicion = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            if (is_numeric($idRequisicion)) {

                $d = new Documento();
                $d->__set('_idDocumento', $idRequisicion);
                $do = new DocumentoDao();
                $doc = $do->obtenerDocumento($d);
                if ($doc['status']) {

                    $de = new DetalleDocumentoDao();
                    $detalle = $de->obtenerDetalleDocumentoIndirectos($idRequisicion);
                    if ($detalle['status']) {
                        $datosDocumento = $doc['documento'];
                        $idProveedor = $datosDocumento->Id_Proveedor;
                        $p = new ProveedorIndirecto();
                        $p->__set('_idProveedor', $idProveedor);
                        $pr = new ProveedorIndirectoDao();
                        $proveedor = $pr->obtenerProveedor($p);
                        if ($proveedor['status']) {
                            switch ($datosDocumento->Id_Sucursal):
                                case 1:
                                    $unidad = 'Pachuca';
                                    break;
                                case 2:
                                    $unidad = 'Puebla';
                                    break;
                                case 5:
                                    $unidad = 'Querétaro';
                                    break;
                            endswitch;
                            $u = new UsuarioDao();
                            $usuario = $u->obtenerUsuario($datosDocumento->Id_Usuario);
                            if ($usuario['status']) {
                                $c = new Concepto();
                                $c->__set('_idConcepto', $datosDocumento->Metodo_Pago);
                                $con = new ConceptoDao();
                                $concepto = $con->obtenerConcepto($c);
                                if ($concepto['status']) {
                                    $datosUsuario = $usuario['usuarios'];
                                    $datosProveedor = $proveedor['proveedor'];
                                    $datosConcepto = $concepto['concepto'];
                                    $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                                    $iteradorDetalle = $arrayDetalle->getIterator();
                                    $this->_vista = 'detalleRequisicion';
                                    $this->_datos['accion'] = 'requisiciones';
                                    $this->_datos['detalle'] = $iteradorDetalle;
                                    $this->_datos['requisicion'] = $datosDocumento;
                                    $this->_datos['proveedor'] = $datosProveedor;
                                    $this->_datos['unidad'] = $unidad;
                                    $this->_datos['usuario'] = $datosUsuario;
                                    $this->_datos['concepto'] = $datosConcepto;
                                    $this->existeVista();
                                    $this->cargarVista();
                                } else {
                                    
                                }
                            } else {
                                ErrorController::mostrarError(1, $usuario['error']);
                            }
                        } else {
                            ErrorController::mostrarError(1, $proveedor['error']);
                        }
                    } else {
                        ErrorController::mostrarError(1, $detalle['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $doc['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'URL mal formada.');
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }
    
    public function muestraRequisicion() {
        $this->_tarea = 50;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';

            $idRequisicion = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            if (is_numeric($idRequisicion)) {

                $d = new Documento();
                $d->__set('_idDocumento', $idRequisicion);
                $do = new DocumentoDao();
                $doc = $do->obtenerDocumento($d);
                if ($doc['status']) {

                    $de = new DetalleDocumentoDao();
                    $detalle = $de->obtenerDetalleDocumentoIndirectos($idRequisicion);
                    if ($detalle['status']) {
                        $datosDocumento = $doc['documento'];
                        $idProveedor = $datosDocumento->Id_Proveedor;
                        $p = new ProveedorIndirecto();
                        $p->__set('_idProveedor', $idProveedor);
                        $pr = new ProveedorIndirectoDao();
                        $proveedor = $pr->obtenerProveedor($p);
                        if ($proveedor['status']) {
                            switch ($datosDocumento->Id_Sucursal):
                                case 1:
                                    $unidad = 'Pachuca';
                                    break;
                                case 2:
                                    $unidad = 'Puebla';
                                    break;
                                case 5:
                                    $unidad = 'Querétaro';
                                    break;
                            endswitch;
                            $u = new UsuarioDao();
                            $usuario = $u->obtenerUsuario($datosDocumento->Id_Usuario);
                            if ($usuario['status']) {
                                $c = new Concepto();
                                $c->__set('_idConcepto', $datosDocumento->Metodo_Pago);
                                $con = new ConceptoDao();
                                $concepto = $con->obtenerConcepto($c);
                                if ($concepto['status']) {
                                    $datosUsuario = $usuario['usuarios'];
                                    $datosProveedor = $proveedor['proveedor'];
                                    $datosConcepto = $concepto['concepto'];
                                    $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                                    $iteradorDetalle = $arrayDetalle->getIterator();
                                    $this->_vista = 'muestraRequisicion';
                                    $this->_datos['accion'] = 'requisiciones';
                                    $this->_datos['detalle'] = $iteradorDetalle;
                                    $this->_datos['requisicion'] = $datosDocumento;
                                    $this->_datos['proveedor'] = $datosProveedor;
                                    $this->_datos['unidad'] = $unidad;
                                    $this->_datos['usuario'] = $datosUsuario;
                                    $this->_datos['concepto'] = $datosConcepto;
                                    $this->existeVista();
                                    $this->cargarVista();
                                } else {
                                    
                                }
                            } else {
                                ErrorController::mostrarError(1, $usuario['error']);
                            }
                        } else {
                            ErrorController::mostrarError(1, $proveedor['error']);
                        }
                    } else {
                        ErrorController::mostrarError(1, $detalle['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $doc['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'URL mal formada.');
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function generaPdf() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
        require_once BASEPATH . 'libs/pdf/vendor/autoload.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                    'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';
        
        $idDocumento = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

        $d = new Documento();
        $d->__set('_idDocumento', $idDocumento);
        $doc = new DocumentoDao();

        $requisicion = $doc->obtenerDocumento($d);
        if ($requisicion['status']) {
            $datosRequisicion = $requisicion['documento'];

            $p = new ProveedorIndirecto();
            $p->__set('_idProveedor', $datosRequisicion->Id_Proveedor);
            $pr = new ProveedorIndirectoDao();
            $proveedor = $pr->obtenerProveedor($p);
            if ($proveedor['status']) {
                $datosProveedor = $proveedor['proveedor'];

                $de = new DetalleDocumentoDao();
                $detalle = $de->obtenerDetalleDocumentoIndirectos($idDocumento);
                if ($detalle['status']) {
                    $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                    $iteradorDetalle = $arrayDetalle->getIterator();
                    $u = new UsuarioDao();
                    $usuario = $u->obtenerUsuario($datosRequisicion->Id_Usuario);
                    if ($usuario['status']) {
                        $c = new Concepto();
                        $c->__set('_idConcepto', $datosRequisicion->Metodo_Pago);
                        $con = new ConceptoDao();
                        $concepto = $con->obtenerConcepto($c);
                        if ($concepto['status']) {
                            $datosUsuario = $usuario['usuarios'];
                            $datosProveedor = $proveedor['proveedor'];
                            $datosConcepto = $concepto['concepto'];
                            $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                            $iteradorDetalle = $arrayDetalle->getIterator();
                            switch ($datosRequisicion->Id_Sucursal):
                                case 1:
                                    $unidad = 'Pachuca';
                                    break;
                                case 2:
                                    $unidad = 'Puebla';
                                    break;
                                case 5:
                                    $unidad = 'Querétaro';
                                    break;
                            endswitch;
                            $this->_vista = 'generaPdf';
                            $this->_datos['accion'] = 'requisiciones';
                            $this->_datos['detalle'] = $iteradorDetalle;
                            $this->_datos['requisicion'] = $datosRequisicion;
                            $this->_datos['proveedor'] = $datosProveedor;
                            $this->_datos['unidad'] = $unidad;
                            $this->_datos['usuario'] = $datosUsuario;
                            $this->_datos['concepto'] = $datosConcepto;
                            $this->existeVista();
                            $this->cargarVista();
                        } else {
                            
                        }
                    } else {
                        ErrorController::mostrarError(1, $usuario['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $detalle['error']);
                }
            } else {
                ErrorController::mostrarError(1, $proveedor['error']);
            }
        } else {
            ErrorController::mostrarError(1, $requisicion['error']);
        }
    }
    
    public function formatoRequisicionActivos() {
        $this->_tarea = 104;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SucursalDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';

            //obtenemos los datos de la sucursal
            $s = new SucursalDao();
            $sucursal = $s->obtenerDatosSucursal(Sesion::obtener('idSucursal'));
            if ($sucursal['status']) {
                $datosSucural = $sucursal['sucursal'];
                //obtenemos el usuario
                $u = new UsuarioDao();
                $usuario = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
                if ($usuario['status']) {
                    $datosUsuario = $usuario['usuarios'];
                    //cargamos los conceptos
                    $c = new ConceptoDao();
                    $conceptos = $c->obtenerListaConceptos();
                    if ($conceptos['status']) {
                        $arrayConceptos = new ArrayObject($conceptos['conceptos']);
                        $iteradorConceptos = $arrayConceptos->getIterator();

                        $p = new ProveedorIndirectoDao();
                        $proveedores = $p->listaProveedoresIndirectos(Sesion::obtener('idSucursal'));
                        if ($proveedores['status']) {
                            $arrayProveedores = new ArrayObject($proveedores['proveedores']);
                            $iteradorProveedores = $arrayProveedores->getIterator();
                            //obtenemos el último folio
                            $fechaInicial = date("Y") . '-' . date("m") . '-01';
                            $fechaFinal = date("Y-m-t");

                            switch (Sesion::obtener('idSucursal')) {
                                case 1:
                                    $prefijo = "REQPAAC";
                                    break;
                                case 2:
                                    $prefijo = "REQPUAC";
                                    break;
                                case 5:
                                    $prefijo = "REQQUAC";
                                    break;
                            }

                            $doc = new DocumentoDao();
                            //validamos si hay requisición abierta
                            $hay = $doc->validaRequisicionActivoUsuario(Sesion::obtener('idUsuario'),  Sesion::obtener('idSucursal') );
                            if ($hay['status']) {
                                if ($hay['total'] > 0) {
                                    $idRequisicion = $hay['requisicion']->Id_Documento;
                                    //obtenemos el detalle de la requisición
                                    $d = new DetalleDocumentoDao();
                                    $detalle = $d->obtenerDetalleDocumentoActivosFijos($idRequisicion);
                                    if ($detalle['status']) {
                                        $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                                        $iteradorDetalle = $arrayDetalle->getIterator();
                                        $productos = array();
                                        while ($iteradorDetalle->valid()) {
                                            $productos[] = array(
                                                "producto" => $iteradorDetalle->current()->Nombre,
                                                "cantidad" => $iteradorDetalle->current()->Cantidad,
                                                "costo" => $iteradorDetalle->current()->Precio,
                                                "idDetalle" => $iteradorDetalle->current()->Id_Detalle_Documento
                                            );
                                            $iteradorDetalle->next();
                                        }
                                        $this->_vista = 'formatoRequisicionActivos';
                                        $this->_datos['accion'] = 'Requisiciones de activos Fijos';
                                        $this->_datos['sucursal'] = $datosSucural;
                                        $this->_datos['usuario'] = $datosUsuario;
                                        $this->_datos['conceptos'] = $iteradorConceptos;
                                        $this->_datos['proveedores'] = $iteradorProveedores;
                                        $this->_datos['idRequisicion'] = $idRequisicion;
                                        $this->_datos['detalle'] = $productos;
                                        $this->existeVista();
                                        $this->cargarVista();
                                    } else {
                                        ErrorController::mostrarError(1, $detalle['error']);
                                    }
                                } else {
                                    $f = $doc->obtenerFolioRequisicionActivo($fechaInicial, $fechaFinal, Sesion::obtener('idSucursal'));
                                    if ($f['status']) {
                                        if ($f['total'] == 0) {
                                            $folio = $prefijo . date("Ymd") . '-001';
                                        } else {
                                            $fo = $f['folio']->Folio_Documento;
                                            $fo = explode('-', $fo);
                                            $conse = (int) $fo[2];
                                            $conse = $conse + 1;
                                            $consecutivo = Utils::zerofill($conse, 3);
                                            $folio = $prefijo . '-' . date("YmdHis") . '-' . $consecutivo;
                                        }

                                        //generamos la requisición
                                        $d = new Documento();
                                        $d->__set('_idCliente', 0);
                                        $d->__set('_idConfiguracion', 1);
                                        $d->__set('_status', 0);
                                        $d->__set('_idSucursal', Sesion::obtener('idSucursal'));
                                        $d->__set('_fecha', date("Y-m-d H:i:s"));
                                        $d->__set('_subtotal', 0);
                                        $d->__set('_total', 0);
                                        $d->__set('_idUsuario', Sesion::obtener('idUsuario'));
                                        $d->__set('_folioDocumento', $folio);
                                        $d->__set('_condicionesPago', '');
                                        $d->__set('_formaPago', '');
                                        $d->__set('_metodoPago', '');
                                        $d->__set('_tipoComprobante', '');
                                        $d->__set('_noCuenta', '');
                                        $d->__set('_tipoDocumento', 102);
                                        $d->__set('_idProveedor', 0);
                                        $d->__set('_observaciones', '');
                                        $d->__set('_tipoCambio', 1);
                                        $d->__set('_moneda', 'MXN');
                                        $d->__set('_idPedido', 0);
                                        $d->__set('_idAlmacen', 0);
                                        $d->__set('_uuid', '');

                                        $req = $doc->generarDocumento($d);
                                        if ($req['status']) {
                                            $idRequisicion = $req['idDocumento'];
                                            $d = new DetalleDocumentoDao();
                                            $detalle = $d->obtenerDetalleDocumentoActivosFijos($idRequisicion);
                                            if ($detalle['status']) {
                                                $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                                                $iteradorDetalle = $arrayDetalle->getIterator();
                                                $productos = array();
                                                while ($iteradorDetalle->valid()) {
                                                    $productos[] = array(
                                                        "producto" => $iteradorDetalle->current()->Nombre,
                                                        "cantidad" => $iteradorDetalle->current()->Cantidad,
                                                        "costo" => $iteradorDetalle->current()->Precio,
                                                        "idDetalle" => $iteradorDetalle->current()->Id_Detalle_Documento
                                                    );
                                                    $iteradorDetalle->next();
                                                }
                                                $this->_vista = 'formatoRequisicionActivos';
                                                $this->_datos['accion'] = 'Requisiciones de activos Fijos';
                                                $this->_datos['sucursal'] = $datosSucural;
                                                $this->_datos['usuario'] = $datosUsuario;
                                                $this->_datos['conceptos'] = $iteradorConceptos;
                                                $this->_datos['proveedores'] = $iteradorProveedores;
                                                $this->_datos['idRequisicion'] = $idRequisicion;
                                                $this->_datos['detalle'] = $productos;
                                                $this->existeVista();
                                                $this->cargarVista();
                                            } else {
                                                ErrorController::mostrarError(1, $detalle['error']);
                                            }
                                        } else {
                                            ErrorController::mostrarError(1, $req['error']);
                                        }
                                    } else {
                                        ErrorController::mostrarError(1, $f['error']);
                                    }
                                }
                            } else {
                                ErrorController::mostrarError(1, $hay['error']);
                            }
                        } else {
                            ErrorController::mostrarError(1, $proveedores['error']);
                        }
                    } else {
                        ErrorController::mostrarError(1, $conceptos['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $usuario);
                }
            } else {
                ErrorController::mostrarError(1, $sucursal['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function detalleRequisicionActivo() {
        $this->_tarea = 50;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';

            $idRequisicion = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            if (is_numeric($idRequisicion)) {

                $d = new Documento();
                $d->__set('_idDocumento', $idRequisicion);
                $do = new DocumentoDao();
                $doc = $do->obtenerDocumento($d);
                if ($doc['status']) {

                    $de = new DetalleDocumentoDao();
                    $detalle = $de->obtenerDetalleDocumentoActivosFijos($idRequisicion);
                    if ($detalle['status']) {
                        $datosDocumento = $doc['documento'];
                        $idProveedor = $datosDocumento->Id_Proveedor;
                        $p = new ProveedorIndirecto();
                        $p->__set('_idProveedor', $idProveedor);
                        $pr = new ProveedorIndirectoDao();
                        $proveedor = $pr->obtenerProveedor($p);
                        if ($proveedor['status']) {
                            switch ($datosDocumento->Id_Sucursal):
                                case 1:
                                    $unidad = 'Pachuca';
                                    break;
                                case 2:
                                    $unidad = 'Puebla';
                                    break;
                                case 5:
                                    $unidad = 'Querétaro';
                                    break;
                            endswitch;
                            $u = new UsuarioDao();
                            $usuario = $u->obtenerUsuario($datosDocumento->Id_Usuario);
                            if ($usuario['status']) {
                                $c = new Concepto();
                                $c->__set('_idConcepto', $datosDocumento->Metodo_Pago);
                                $con = new ConceptoDao();
                                $concepto = $con->obtenerConcepto($c);
                                if ($concepto['status']) {
                                    $datosUsuario = $usuario['usuarios'];
                                    $datosProveedor = $proveedor['proveedor'];
                                    $datosConcepto = $concepto['concepto'];
                                    $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                                    $iteradorDetalle = $arrayDetalle->getIterator();
                                    $this->_vista = 'detalleRequisicionActivo';
                                    $this->_datos['accion'] = '';
                                    $this->_datos['detalle'] = $iteradorDetalle;
                                    $this->_datos['requisicion'] = $datosDocumento;
                                    $this->_datos['proveedor'] = $datosProveedor;
                                    $this->_datos['unidad'] = $unidad;
                                    $this->_datos['usuario'] = $datosUsuario;
                                    $this->_datos['concepto'] = $datosConcepto;
                                    $this->existeVista();
                                    $this->cargarVista();
                                } else {

                                }
                            } else {
                                ErrorController::mostrarError(1, $usuario['error']);
                            }
                        } else {
                            ErrorController::mostrarError(1, $proveedor['error']);
                        }
                    } else {
                        ErrorController::mostrarError(1, $detalle['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $doc['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'URL mal formada.');
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reportesActivos() {

        $this->_tarea = 105;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $this->_vista = 'reportesActivos';
            $this->_datos['accion'] = 'reportesActivos';
            $this->existeVista();
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteRequisicionesActivos() {

        $this->_tarea = 105;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'MovimientoBancoPagos.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'MovimientosPagosDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

            $fechaInicial = filter_input(INPUT_POST, 'fechaInicial', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'fechaFinal', FILTER_SANITIZE_STRING);

            $d = new DocumentoDao();

            $req = $d->obtenerRequisicionesActivosSucursal(Sesion::obtener('idSucursal'), $fechaInicial, $fechaFinal);

            if ($req['status']) {
                $arrayRequisiciones = new ArrayObject($req['requisiciones']);
                $iteradorRequisiciones = $arrayRequisiciones->getIterator();
                $this->_vista = 'reporteRequisicionesActivos';
                $this->_datos['accion'] = 'reportes';
                $this->_datos['requisiciones'] = $iteradorRequisiciones;
                $this->existeVista();
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $req['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function muestraRequisicionActivos() {
        $this->_tarea = 105;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';

            $idRequisicion = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

            if (is_numeric($idRequisicion)) {

                $d = new Documento();
                $d->__set('_idDocumento', $idRequisicion);
                $do = new DocumentoDao();
                $doc = $do->obtenerDocumento($d);
                if ($doc['status']) {

                    $de = new DetalleDocumentoDao();
                    $detalle = $de->obtenerDetalleDocumentoActivosFijos($idRequisicion);
                    if ($detalle['status']) {
                        $datosDocumento = $doc['documento'];
                        $idProveedor = $datosDocumento->Id_Proveedor;
                        $p = new ProveedorIndirecto();
                        $p->__set('_idProveedor', $idProveedor);
                        $pr = new ProveedorIndirectoDao();
                        $proveedor = $pr->obtenerProveedor($p);
                        if ($proveedor['status']) {
                            switch ($datosDocumento->Id_Sucursal):
                                case 1:
                                    $unidad = 'Pachuca';
                                    break;
                                case 2:
                                    $unidad = 'Puebla';
                                    break;
                                case 5:
                                    $unidad = 'Querétaro';
                                    break;
                            endswitch;
                            $u = new UsuarioDao();
                            $usuario = $u->obtenerUsuario($datosDocumento->Id_Usuario);
                            if ($usuario['status']) {
                                $c = new Concepto();
                                $c->__set('_idConcepto', $datosDocumento->Metodo_Pago);
                                $con = new ConceptoDao();
                                $concepto = $con->obtenerConcepto($c);
                                if ($concepto['status']) {
                                    $datosUsuario = $usuario['usuarios'];
                                    $datosProveedor = $proveedor['proveedor'];
                                    $datosConcepto = $concepto['concepto'];
                                    $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                                    $iteradorDetalle = $arrayDetalle->getIterator();
                                    $this->_vista = 'muestraRequisicionActivos';
                                    $this->_datos['accion'] = 'requisiciones';
                                    $this->_datos['detalle'] = $iteradorDetalle;
                                    $this->_datos['requisicion'] = $datosDocumento;
                                    $this->_datos['proveedor'] = $datosProveedor;
                                    $this->_datos['unidad'] = $unidad;
                                    $this->_datos['usuario'] = $datosUsuario;
                                    $this->_datos['concepto'] = $datosConcepto;
                                    $this->existeVista();
                                    $this->cargarVista();
                                } else {

                                }
                            } else {
                                ErrorController::mostrarError(1, $usuario['error']);
                            }
                        } else {
                            ErrorController::mostrarError(1, $proveedor['error']);
                        }
                    } else {
                        ErrorController::mostrarError(1, $detalle['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $doc['error']);
                }
            } else {
                ErrorController::mostrarError(1, 'URL mal formada.');
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function generaPdfActivos() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DocumentoDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DetalleDocumentoDao.php';
        require_once BASEPATH . 'libs/pdf/vendor/autoload.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ProveedorIndirectoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'ConceptoDao.php';

        $idDocumento = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

        $d = new Documento();
        $d->__set('_idDocumento', $idDocumento);
        $doc = new DocumentoDao();

        $requisicion = $doc->obtenerDocumento($d);
        if ($requisicion['status']) {
            $datosRequisicion = $requisicion['documento'];

            $p = new ProveedorIndirecto();
            $p->__set('_idProveedor', $datosRequisicion->Id_Proveedor);
            $pr = new ProveedorIndirectoDao();
            $proveedor = $pr->obtenerProveedor($p);
            if ($proveedor['status']) {
                $datosProveedor = $proveedor['proveedor'];

                $de = new DetalleDocumentoDao();
                $detalle = $de->obtenerDetalleDocumentoActivosFijos($idDocumento);
                if ($detalle['status']) {
                    $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                    $iteradorDetalle = $arrayDetalle->getIterator();
                    $u = new UsuarioDao();
                    $usuario = $u->obtenerUsuario($datosRequisicion->Id_Usuario);
                    if ($usuario['status']) {
                        $c = new Concepto();
                        $c->__set('_idConcepto', $datosRequisicion->Metodo_Pago);
                        $con = new ConceptoDao();
                        $concepto = $con->obtenerConcepto($c);
                        if ($concepto['status']) {
                            $datosUsuario = $usuario['usuarios'];
                            $datosProveedor = $proveedor['proveedor'];
                            $datosConcepto = $concepto['concepto'];
                            $arrayDetalle = new ArrayObject($detalle['detalleDocumento']);
                            $iteradorDetalle = $arrayDetalle->getIterator();
                            switch ($datosRequisicion->Id_Sucursal):
                                case 1:
                                    $unidad = 'Pachuca';
                                    break;
                                case 2:
                                    $unidad = 'Puebla';
                                    break;
                                case 5:
                                    $unidad = 'Querétaro';
                                    break;
                            endswitch;
                            $this->_vista = 'generaPdf';
                            $this->_datos['accion'] = 'requisiciones';
                            $this->_datos['detalle'] = $iteradorDetalle;
                            $this->_datos['requisicion'] = $datosRequisicion;
                            $this->_datos['proveedor'] = $datosProveedor;
                            $this->_datos['unidad'] = $unidad;
                            $this->_datos['usuario'] = $datosUsuario;
                            $this->_datos['concepto'] = $datosConcepto;
                            $this->existeVista();
                            $this->cargarVista();
                        } else {

                        }
                    } else {
                        ErrorController::mostrarError(1, $usuario['error']);
                    }
                } else {
                    ErrorController::mostrarError(1, $detalle['error']);
                }
            } else {
                ErrorController::mostrarError(1, $proveedor['error']);
            }
        } else {
            ErrorController::mostrarError(1, $requisicion['error']);
        }
    }

}
