/**
 * Compras.js
 * Clase y funciones para el módulo de compras
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package compras
 */

var urlCompras = url + 'application/compras/controllers/AjaxComprasController.php';

var Compras = (function () {
    function Compras() {}
    ;

    Compras.prototype.obtenerRequisicionesAutorizar = function (pagina, registros, inferior, superior) {
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'obtenerRequisicionesAutorizar',
                pagina: pagina,
                registros: registros,
                inferior: inferior,
                superior: superior
            },
            beforeSend: function () {
                $('.refresh-container-table').show();
            },
            success: function (response) {
                $('.refresh-container-table').hide();
                if (response.status) {
                  c = new Compras();
                  c.renderRequisicionesAutorizar(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Compras.prototype.renderRequisicionesAutorizar = function (response) {
        _this = this;
        var html = '';
        if (response.requisiciones.length > 0) {
            $.each(response.requisiciones, function (registro, item) {
                html += '<tr>';
                html += '<td><a href="' + url + 'compras/detalleRequisicion/' + item.Id_Documento + '/">' + item.Folio_Documento + '</a></td>';
                html += '<td>' + item.Usuario + '</td>';
                html += '<td>' + date("d/m/Y", strtotime(item.Fecha)) + '</td>';
                html += '<td>$ ' + number_format(item.Total, 2, '.', ',') + '</td>';
                html += '<td>' + item.Moneda + '</td>';
                html += '<td>En autorización</td>';
                html += '</tr>';
            });
        } else {
            html += '<tr>';
            html += '<td colspan="6">No existen autorizaciones pendientes</td>';
            html += '</tr>';
        }

        $('#requisicionesAutorizar tbody').html(html);
    };

    Compras.prototype.validaXML = function (nombreArchivo) {
        _this = this;
        archivo = $('#xmlRequisicion')[0].files;
        formulario = new FormData($('#formReq')[0]);
        formulario.append('accion', 'leerXML');
        formulario.append('xml', archivo, nombreArchivo);
        $.ajax({
            url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: formulario,
            processData: false,
            contentType: false,
            beforeSend: function () {
                $('#btnXmlRequisicion').prop('disabled', true);
            },
            success: function (response) {
                if (response.status) {
                    $('#moneda').val(response.moneda[0]);
                    var html = '';
                    totalProductos = response.descripcion.length;
                    for (i = 0; i < totalProductos; i++) {
                        html += '<tr>';
                        html += '<td>' + response.cantidades[i][0] + '</td>';
                        html += '<td>' + response.descripcion[i][0] + '</td>';
                        html += '<td>' + response.unidades[i][0] + '</td>';
                        html += '<td class="text-right">$ ' + response.valorUnitario[i][0] + '</td>';
                        html += '<td class="text-right">$ ' + response.importe[i][0] + '</td>';
                        html += '</tr>';
                    }

                    iva = response.total[0] - response.subtotal[0];
                    $('#requisicionCompra tbody').html(html);
                    $('#subtotalRequisicion').html('$ ' + response.subtotal[0]);
                    $('#ivaRequisicion').html('$ ' + iva);
                    $('#retIva').html('$ ' + response.retenciones);
                    $('#totalRequisicion').html('$ ' + response.total[0]);
                    $('#fecha').val(response.fecha);
                    $('#proveedor').val(response.proveedor);
                    $('#proveedor').selectpicker('refresh');
                    $('#proveedor').selectpicker('render');
                    $('#idRequisicion').val(response.idRequisicion);
                    $('#xmlValido').val(1);
                } else {
                    $('#btnXmlRequisicion').prop('disabled', false);
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                $('#btnXmlRequisicion').prop('disabled', false);
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };
    
    
    Compras.prototype.cambiaConcepto = function(idConcepto, idRequisicion){
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cambiaConcepto',
                idConcepto: idConcepto,
                idRequisicion: idRequisicion
            },
            beforeSend: function(){
                
            },
            success: function(response){
                if (!response.status){
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };
    
    Compras.prototype.agregaProductoRequisicion = function(cantidad, idProducto, costo, iva, costoTotal, idRequisicion){
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'agregaProductoRequisicion',
                cantidad: cantidad,
                idProducto: idProducto,
                costo: costo,
                iva: iva,
                costoTotal: costoTotal,
                idRequisicion: idRequisicion
            },
            beforeSend: function(){
                $('#btnAgregarProducto').prop('disabled', true).html('<i class="fa fa-spinner fa-spin fa-fw"></i><span class="sr-only">Agregando...</span> Agregando...');
            },
            success: function(response){
                $('#btnAgregarProducto').prop('disabled', false).html('<span class="fa fa-plus"></span> Agregar');
                if (response.status){     
                    $('#buscaProducto').val('');
                    $('#cantidad').val('');
                    $('#idProducto').val(0);
                    $('#unidad').val('');
                    $('#costo').val('');
                    $('#iva').val('');
                    $('#costoTotal').val('');
                    _this.cargaDetalleRequisicion(idRequisicion);
                }
                else{                    
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                $('#btnAgregarProducto').prop('disabled', false).html('<span class="fa fa-plus"></span> Agregar');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };
    
    Compras.prototype.cargaDetalleRequisicion = function(idRequisicion){
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cargaDetalleRequisicion',
                idRequisicion: idRequisicion
            },
            beforeSend: function(){
                
            },
            success: function(response){
                if (response.status){
                    _this.renderProductosRequisicion(response);
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };
    
    Compras.prototype.renderProductosRequisicion = function(response){
        _this = this;        
        if (response.productos.length > 0){
            subtotalGlobal = 0;
            ivaGlobal = 0;
            totalTotal = 0;
            $.each(response.productos, function(registro, item){
                subtotalGlobal += item.costo;
                iva = item.costo * 0.16;
                iva = iva.toFixed(2);
                total = item.costo * 1.16;
                total = total.toFixed(2);
                ivaGlobal += iva;
                totalTotal += total;
                tr = $('<tr></tr>');
                tr.append('<td>' + item.cantidad + '</td>');
                tr.append('<td>' + item.producto + '</td>');
                tr.append('<td></td>');
                tr.append('<td>$ ' + number_format(item.costo, 2, '.', ',') + '</td>');
                tr.append('<td>$' + number_format(iva, 2, '.', ',') + '</td>');
                tr.append('<td>$ ' + number_format(total, 2, '.', ',') + '</td>');
                tr.append('<td><a href="javascript:void(0);" data-id="' + item.idDetalle + '" class="eliminaProductoRequisicion"><span class="fa fa-trash"></span></a></td>');                
            });
            
            $('#subtotalRequisicion').html('$ ' + number_format(subtotalGlobal, 2, '.', ','));
            $('#ivaRequisicion').html('$ ' + number_format(ivaGlobal, 2, '.', ','));
            $('#totalRequisicion').html('$ ' + number_format(totalTotal, 2, '.', ','));
        }
        else{
            $('#requisicionCompra tbody').html('');
            tr = $('<tr></tr>');
            tr.append('<td colspan="7">No se encontraron resultados.</td>');
        }
        
        $('#requisicionCompra tbody').append(tr);
    };
    
    Compras.prototype.validarRequisicion = function(idRequisicion, concepto, fecha, proveedor, moneda){
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'validarRequisicion',
                idRequisicion: idRequisicion
            },
            beforeSend: function(){
                $('#guardaRequisicion').html('<i class="fa fa-spinner fa-spin fa-fw"></i><span class="sr-only">Procesando...</span> Procesando...');
            },
            success: function(response){                
                if (response.status){
                    _this.generaRequisicion(idRequisicion, concepto, fecha, proveedor, moneda);
                }
                else{
                    $('#guardaRequisicion').html('<span class="fa fa-save"></span> Guardar');
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                $('#guardaRequisicion').prop('disabled', false).html('<span class="fa fa-save"></span> Guardar');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };
    
    Compras.prototype.generaRequisicion = function(idRequisicion, concepto, fecha, proveedor, moneda){
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'generaRequisicion',
                idRequisicion: idRequisicion,
                concepto: concepto,
                fecha: fecha,
                proveedor: proveedor,
                moneda: moneda
            },
            beforeSend: function(){
                $('#guardaRequisicion').prop('disabled', true).html('<i class="fa fa-spinner fa-spin fa-fw"></i><span class="sr-only">Procesando...</span> Procesando...');
            },
            success: function(response){
                abreAlerta(response.mensaje);
                if (response.status){
                   setTimeout(function(){
                        window.location = url + 'compras/';
                    }, 2000);
                }
            },
            error: function(xhr, responseText, thrownError){
                $('#guardaRequisicion').prop('disabled', false).html('<span class="fa fa-save"></span> Guardar');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 25000
        });
    };
    
    Compras.prototype.autorizaRequisicion = function(idRequisicion){
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'autorizaRequisicion',
                idRequisicion: idRequisicion,
                status: status
            },
            beforeSend: function(){
                $('#autorizaRequisicion').prop('disabled', true).html('<i class="fa fa-spinner fa-spin fa-fw"></i><span class="sr-only">Procesando...</span> Procesando...');
            },
            success: function(response){
                abreAlerta(response.mensaje);
                if (response.status){
                    setTimeout(function(){
                        window.location = url + 'compras/autorizaciones/';
                    }, 2000);
                }
                else{
                    $('#autorizaRequisicion').prop('disabled', false).html('<span class="fa fa-check"></span> Autorizar');
                }
            },
            error: function(xhr, responseText, thrownError){
                $('#autorizaRequisicion').prop('disabled', false).html('<span class="fa fa-check"></span> Autorizar');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000            
        });
    };
    
    Compras.prototype.rechazaRequisicion = function(idRequisicion){
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'rechazaRequisicion',
                idRequisicion: idRequisicion,                
            },
            beforeSend: function(){
                $('#cancelaRequisicion').prop('disabled', true).html('<i class="fa fa-spinner fa-spin fa-fw"></i><span class="sr-only">Procesando...</span> Procesando...');
            },
            success: function(response){
                abreAlerta(response.mensaje);
                if (response.status){
                    setTimeout(function(){
                        window.location = url + 'compras/autorizaciones/';
                    }, 2000);
                }
                else{
                    $('#cancelaRequisicion').prop('disabled', false).html('<span class="fa fa-times"></span> Cancelar');
                }
            },
            error: function(xhr, responseText, thrownError){
                $('#cancelaRequisicion').prop('disabled', false).html('<span class="fa fa-times"></span> Cancelar');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000            
        });
    };
    
    Compras.prototype.eliminarDetalleRequisicion = function(idDetalle, idRequisicion){
        _this = this;
        $.ajax({
             url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'eliminarDetalleRequisicion',
                idDetalle: idDetalle,
                idRequision: idRequisicion
            },
            beforeSend: function(){
               
            },
            success: function(response){
                if (response.status){
                    _this.cargaDetalleRequisicion(idRequisicion);
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){                
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000 
        });
    };
    
    Compras.prototype.cancelarRequisicion = function(idRequisicion){
        _this = this;
        $.ajax({
            url: urlCompras,
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cancelarRequisicion',
                idRequisicion: idRequisicion,                
            },
            beforeSend: function(){
                $('#cancelaRequisicion').prop('disabled', true).html('<i class="fa fa-spinner fa-spin fa-fw"></i><span class="sr-only">Procesando...</span> Procesando...');
            },
            success: function(response){
                abreAlerta(response.mensaje);
                if (response.status){
                    setTimeout(function(){
                        window.location = url + 'compras/';
                    }, 2000);
                }
                else{
                    $('#cancelaRequisicion').prop('disabled', false).html('<span class="fa fa-times"></span> Cancelar');
                }
            },
            error: function(xhr, responseText, thrownError){
                $('#cancelaRequisicion').prop('disabled', false).html('<span class="fa fa-times"></span> Cancelar');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000            
        });
    };

    return Compras;
})();

$(function () {
    if ($('#requisicionesAutorizar').length > 0) {
        c = new Compras();
        pagina = $('#pagina').val();
        registros = 10;
        inferior = $('#inferior').val();
        superior = $('#superior').val();
        c.obtenerRequisicionesAutorizar(pagina, registros, inferior, superior);
    }

    if ($('#buscaProducto').length > 0) {
        $('#buscaProducto').autocomplete({
            source: function (request, response) {
                idSucursal = $('#sucursal').val();
                idConcepto = $('#concepto').val();
                if (idConcepto == ''){
                    abreAlerta('Por favor selecciona un concepto. -_-');
                     $('#concepto').focus();
                    return false;
                }
                
                $.ajax({
                    url: url + 'application/compras/controllers/AjaxComprasController.php',
                    type: 'get',
                    dataType: 'json',
                    cache: false,
                    data: {
                        accion: 'buscarProductoRequisicion',
                        producto: request.term,
                        idConcepto: idConcepto
                    },
                    success: function (data) {
                        if (data.status) {
                            response(data.productos);
                        } else {
                            abreAlerta(response.mensaje);
                        }
                    },
                    error: function (xhr, responseText, thrownError) {
                        error = mostrarMensajeError(xhr, responseText, thrownError);
                        abreAlerta(error);
                    },
                    timeout: 15000
                });
            },
            focus: function (event, ui) {
                $('#buscaProducto').val(ui.item.label);
                return false;
            },
            select: function (event, ui) {
                $('#buscaProducto').val(ui.item.label);
                $('#idProducto').val(ui.item.value);
                $('#costo').val(ui.item.costo);
                iva = ui.item.costo * 0.16;
                total = ui.item.costo * 1.16;
                $('#iva').val(Math.round(iva, 2));
                $('#costoTotal').val(Math.round(total, 2));
                $('#cantidad').focus();
                return false;
            }
        });
    }
    
    
});

$(document).on('click', '#btnXmlRequisicion', function () {
    $('#xmlRequisicion').click();
});

$(document).on('change', '#xmlRequisicion', function (e) {
    e.preventDefault();
    archivo = this.files[0];
    tipo = archivo.type;

    if (tipo != 'text/xml') {
        abreAlerta('Debes subir un archivo XML. -_-');
        return false;
    }

    nombreArchivo = archivo.name;
    c = new Compras(nombreArchivo);
    c.validaXML();
})

$(document).on('click', '#btnPdfRequisicion', function () {
    $('#pdfRequisicion').click();
});

$(document).on('change', '#pdfRequisicion', function (e) {
    e.preventDefault();
    archivo = this.files[0];
    tipo = archivo.type;
    console.log(tipo);
    if (tipo != 'application/pdf') {
        abreAlerta('Debes subir un archivo PDF. -_-');
        return false;
    }

    $('#pdfValido').val(1);
});

$(document).on('submit', '#formReq', function (e) {
    e.preventDefault();

    xmlValido = $('#xmlValido').val();
    pdfValido = $('#pdfValido').val();
    idCuenta = $('#concepto').val();

    if (xmlValido == 0) {
        abreAlerta('Debes ingresar un xml válido.');
        return false;
    }

    if (pdfValido == 0) {
        abreAlerta('Debes ingresar un pdf válido.');
        return false;
    }

    if (idCuenta == '' || idCuenta == 0) {
        abreAlerta('Por favor selecciona el concepto de la requisición. -_-');
        return false;
    }
    c = new Compras();
    c.generarRequisicion();
});

$(document).on('change', '#concepto', function(){    
    idConcepto = $(this).val();
    idDocumento = $('#idRequisicion').val();   
    c = new Compras();
    c.cambiaConcepto(idConcepto, idDocumento);
});

$(document).on('click', '#btnAgregarProducto', function(){
    cantidad = $('#cantidad').val();
    idProducto = $('#idProducto').val();
    costo = $('#costo').val();
    iva = $('#iva').val();
    costoTotal = $('#costoTotal').val();
    idRequisicion = $('#idRequisicion').val(); 
    
    if (cantidad == '' || cantidad == 0){
        abreAlerta('Por favor ingresa una cantidad válida');
        return false;
    }
    
    if(idProducto == '' || idProducto == 0){
        abreAlerta('Por favor selecciona un producto de la lista. -_-');
        return false;
    }
    
    if (costo == '' || costo == 0){
        abreAlerta('Por favor ingresa el costo correcto. -_-');
        return false;
    }        
    
    c = new Compras();
    c.agregaProductoRequisicion(cantidad, idProducto, costo, iva, costoTotal, idRequisicion);
});

$(document).on('blur', '#costo', function(){
    costo = $(this).val();
    iva = costo * 0.16;
    iva = Math.round(iva * 100) / 100;
    total = costo * 1.16;
    total = Math.round(total * 100) / 100;    
    $('#iva').val(iva);
    $('#costoTotal').val(total);
});

$(document).on('blur', '#costoTotal', function(){
    total = $(this).val();
    costo = total / 1.16;
    iva = costo * 0.16;
    $('#costo').val(costo.toFixed(2));
    $('#iva').val(iva.toFixed(2));
    console.log(costo.toFixed(2));
    console.log(iva.toFixed(2));
    console.log('entra');
});

$(document).on('click', '#guardaRequisicion', function(){
    //validamos los datos
    concepto = $('#concepto').val();
    fecha = $('#fecha').val();
    proveedor = $('#proveedor').val();
    moneda = $('#moneda').val();
    idRequisicion = $('#idRequisicion').val();
    
    if (concepto == '' || concepto == 0){
        abreAlerta('Por favor selecciona un concepto. -_-');
        return false;
    }
    
    if (fecha == ''){
        abreAlerta('Por favor selecciona una fecha válida. -_-');
        return false;
    }
    
    if (proveedor == 0 || proveedor == ''){
        abreAlerta('Por favor selecciona un proveedor. -_-');
        return false;
    }
    
    if (moneda == ''){
        abreAlerta('Por favor selecciona una moneda. -_-');
        return false;
    }
    
    c = new Compras();
    c.validarRequisicion(idRequisicion, concepto, fecha, proveedor, moneda);
    
});

$(document).on('click', '#autorizaRequisicion', function(){
    idRequisicion = $('#idRequisicion').val();
    
    c = new Compras();
    c.autorizaRequisicion(idRequisicion);
});

$(document).on('click', '#cancelaRequisicion', function(){
    idRequisicion = $('#idRequisicion').val();
    
    c = new Compras();
    c.rechazaRequisicion(idRequisicion);
});

$(document).on('click', '.eliminaProductoRequisicion', function(){
    id = $(this).attr('data-id');
    c = new Compras();
    c.eliminarDetalleRequisicion(id);
});

$(document).on('click', '#cancelaRequisicion2', function(){
    idRequisicion = $('#idRequisicion').val();
    
    c = new Compras();
    c.cancelarRequisicion(idRequisicion);
});