/**
 * SeguridadHigiene.js
 * Clase y funciones para el m?dulo Seguridad e higiene
 * @copyright (c) 2018 Merdiz
 * @author Ivan Santos P?rez
 * @version 1.0 Beta
 * @package inicio
 */
$(document).ready(function () {
    obtenerUsuariosAccionesPopsa();
});
function cargarAccionesPopsa(indicador, pagina, registros, inferior, superior, idUsuario) {
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxAccionesPopsa.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        async: false,
        data: {
            accion: 'obtenerAccionesPopsaDelResponsableEnProgreso',
            pagina: pagina,
            registros: registros,
            inferior: inferior,
            superior: superior,
            idUsuario : idUsuario
        },
        success: function(response){
            if (response.status){
                renderAccionesPopsa(response);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}
function obtenerUsuariosAccionesPopsa() {
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxAccionesPopsa.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'obtenerUsuariosAccionesPopsa'
        },
        success: function(response){
            if (response.status){
                renderUsuarios(response);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}
function renderAccionesPopsa(response){
    tabla = $('#acciones-popsa tbody');
    // tabla.html('');
    tareas = response.acciones;
    sabado = getLastSaturday();

    if (tareas.length > 0){
        $.each(tareas, function(registro, item){
            if(item.consumo == null) item.consumo =0;

            var tr2 = $('<tr data-id ="'+item.id_acciones_popsa+'" ></tr>');

            if(sabado+ ' 00-00-00' <= item.Fecha && sabado+ ' 23-23-23' >= item.Fecha  ){
                if(item.Tipo_Visita == "conferencia")
                tr2.append('<td><span  class="fa fa-phone" ></span></td>');
                else {
                    tr2.append('<td><span  class="fa fa-bus" ></span></td>');
                }
            }else{
                tr2.append('<td ></td>');
            }

            tr2.append('<td id="fecha">' + item.fecha + '</td>');
            tr2.append('<td id="cliente">' + item.Cliente + '</td>');
            tr2.append('<td id="consumo">' + item.consumo + '</td>');
            tr2.append('<td id="estrategia">' + item.estrategia + '</td>');
            tr2.append('<td id="accion">' + item.acciones + '</td>');
            tr2.append('<td id="progreso">' + formatoPorcentaje(item.porcentaje) + '</td>');
            tr2.append('<td><a href="' + url + 'inicio/completarAccionPopsa/'+item.id_acciones_popsa+'/" title="Editar tarea"><span class="fa fa-edit"></span></a></td>');
            tr2.appendTo(tabla);
        });
    }
    else{
        var tr2 = $('<tr></tr>');
        tr2.append('<td colspan="6">No se encontraron acciones</td>');
        tr2.appendTo(tabla);
    }
}
function zero(n) {
    return (n>9 ? '' : '0') + n;
}

function getLastSaturday() {
    var curr = new Date;
    var lastday = new Date(curr.setDate(curr.getDate() - curr.getDay()-1));

    var first = curr.getDate() - (curr.getDay());
    var saturday = first  -1;

    var dateString2 = (curr.getFullYear() + '-'
        + ('0' + (curr.getMonth() + 1)).slice(-2)
        + '-' + ('0' + (curr.getDate())).slice(-2));


    return dateString2;
}


function renderUsuarios(response){
    tabla = $('#acciones-popsa tbody');
    tabla.html('');
    usuarios = response.usuarios;
    indicador = $('#indicador').val();
    pagina = $('#pagina').val();
    registros = 10;
    inferior = $('#inferior').val();
    superior = $('#superior').val();
    if (usuarios.length > 0){
        $.each(usuarios, function(registro, item){
            var tr = $('<tr ></tr>');
            tr.append('<td colspan="7" style="background-color: #fcf8e3" >' + item.Nombre + ' ' + item.Apellido_Paterno  + ' ' + item.Apellido_Materno  + '</td>');
            tr.appendTo(tabla);
            idUsuario = item.Id_Usuario;
            cargarAccionesPopsa(indicador,pagina, registros, inferior, superior, idUsuario );
        });
    }
    else{
        var tr = $('<tr></tr>');
        tr.append('<td colspan="6">No se encontraron acciones</td>');
        tr.appendTo(tabla);
    }
}
function formatoPorcentaje(porcentaje){
    if(porcentaje == null){
        return 0 + "%";
    } else{
        return porcentaje + "%" ;
    }
}
