/**
 * Actividades.js
 * Clase y funciones para el módulo de actividades
 * @copyright (c) 2015 Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package inicio
 */

var Actividades = (function () {
    function Actividades() {}
    ;

    Actividades.prototype.cargarActividades = function (tipo, pagina, registros, inferior, superior) {
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxActividadesController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'cargarActividades',
                tipo: tipo,
                pagina: pagina,
                registros: registros,
                inferior: inferior,
                superior: superior
            },
            bsforeSend: function () {
                $('.refresh-container-table').show();
            },
            success: function (response) {
                $('.refresh-container-table').hide();
                if (response.status) {
                    _this.renderActividades(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function () {
                abreAlerta('Ocurrió un error al obtener la lista de actividades. ' + msjTicket);
            },
            timeout: 15000
        });
    };

    Actividades.prototype.renderActividades = function (response) {
        _this = this;
        var html = '';
        if (response.actividades.length > 0) {

            $.each(response.actividades, function (registro, item) {

            });


            var ul = $('<ul class="pagination" />');
            pagina = parseInt(response.pagina);
            paginas = parseInt(response.paginas);
            if (pagina > 1) {
                $('<li />').html('<a class="pagina" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
            }
            inferior = response.inferior;
            superior = response.superior;
            paginas = parseInt(response.paginas);
            if (paginas < superior) {
                limite = paginas;
            } else {
                limite = superior;
            }
            for (i = inferior; i <= limite; i++) {
                if (pagina == i) {
                    $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
                } else {
                    $('<li />').html('<a class="pagina" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
                }
            }
            if (pagina < paginas) {
                $('<li />').html('<a class="pagina" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
            }
            $('#paginacion').html(ul);
        } else {
            html += '<tr data="0">';
            html += '<td colspan="7">No se encontraron resultados</td>';
            html += '</tr>';
        }

        $('#listaAlertas tbody').html(html);
    };

    Actividades.prototype.actividadesConcluidasJuntaCierre = function () {
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxActividadesController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'obtenerActividadesConcluidasJuntaCierre'
            },
            success: function (response) {

            }
        });
    };

    Actividades.prototype.cargarAcciones = function (idKey) {
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxActividadesController.php',
            type: 'GET',
            dataType: 'json',
            data: {
                idKey: idKey,
                accion: 'obtenerAccionesEstrategia'
            },
            beforeSend: function () {

            },
            success: function (response) {
                if (response.status) {
                    html = '';
                    html += '<option value="">Selecciona...</option>';
                    $.each(response.acciones, function (registro, item) {
                        html += '<option value="' + item.Id_Accion + '">' + item.Accion + '</option>';
                    });

                    $('#accion').html(html);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Actividades.prototype.cargarEstrategias = function (idKey) {
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxActividadesController.php',
            type: 'GET',
            dataType: 'json',
            data: {
                idKey: idKey,
                accion: 'obtenerEstrategiasKeyIssue'
            },
            beforeSend: function () {

            },
            success: function (response) {
                if (response.status) {
                    html = '';
                    html += '<option value="">Selecciona...</option>';
                    $.each(response.estrategias, function (registro, item) {
                        html += '<option value="' + item.Id_Estrategia + '">' + item.Estrategia + '</option>';
                    });

                    $('#estrategia').html(html);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Actividades.prototype.cargarActividad = function (idKey) {
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxActividadesController.php',
            type: 'GET',
            dataType: 'json',
            data: {
                idKey: idKey,
                accion: 'obtenerActividadesKeyIssue'
            },
            beforeSend: function () {

            },
            success: function (response) {
                if (response.status) {
                    html = '';
                    html += '<option value="">Selecciona...</option>';
                    $.each(response.actividades, function (registro, item) {
                        html += '<option value="' + item.Id_Actividad + '" data-usuario="' + item.Id_Usuario + '">' + item.Actividad + '</option>';
                    });

                    $('#actividad').html(html);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Actividades.prototype.cargarActividades2018 = function (idKey) {
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxActividadesController.php',
            type: 'GET',
            dataType: 'json',
            data: {
                accion: 'cargarActividades2018',
                idKey: idKey
            },
            beforeSend: function () {
                $('.refresh-container-table').show();
            },
            success: function (response) {
                console.log(response);
                $('.refresh-container-table').hide();
                if (response.status) {
                    _this.renderActividades2018(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                $('.refresh-container-table').hide();
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Actividades.prototype.renderActividades2018 = function (response) {
        _this = this;
        var cProg = $('<select class="cboProgress2018"></select>');
        cProg.append('<option value="0">0 %</option>');
        cProg.append('<option value="10">10 %</option>');
        cProg.append('<option value="20">20 %</option>');
        cProg.append('<option value="30">30 %</option>');
        cProg.append('<option value="40">40 %</option>');
        cProg.append('<option value="50">50 %</option>');
        cProg.append('<option value="60">60 %</option>');
        cProg.append('<option value="70">70 %</option>');
        cProg.append('<option value="80">80 %</option>');
        cProg.append('<option value="90">90 %</option>');
        cProg.append('<option value="100">100 %</option>');
        var cStatus = $('<select class="cboStatus2018"></select>');
        cStatus.append('<option value="0">No Iniciado</option>');
        cStatus.append('<option value="1">En Proceso</option>');
        cStatus.append('<option value="2">Cerrado</option>');
        $('#act2018 tbody').html('');
        if (response.actividades.length > 0) {
            $.each(response.actividades, function (registro, item) {
                tr = $('<tr data="' + item.Id_Comentario + '"></tr>');
                tr.append('<td>' + item.Comentarios + '</td>');
                tr.append('<td>' + item.Quien + '</td>');
                if (response.usuario == 44 || response.usuario == 16){
                    tr.append('<td><input type="text" name="fecha2018" class="cambiaFecha2018 calendario form-control" value="' + item.Cuando + '"></td>');
                }
                else{
                    tr.append('<td>' + item.Cuando + '</td>');
                }
                
                tr.append('<td>Plan 2018</td>');
                tr.append('<td>' + item.Avance + '</td>');
                td = $('<td></td>');
                td.append(cProg.clone());
                td.find('select').val(item.Progreso);
                tr.append(td);
                tda = $('<td></td>');
                tda.append(cStatus.clone());
                tda.find('select').val(item.Status);
                tr.append(tda);
                tr.append('<td><a href="javascript:void(0);" class="eliminaActividad2018" data-id="' + item.Id_Comentario + '"><span class="fa fa-trash-o"></span></a></td>');
                $('#act2018 tbody').append(tr);
               
            });
            $.datepicker.regional['es'] = {
                closeText: 'Cerrar',
                prevText: '<Ant',
                nextText: 'Sig>',
                currentText: 'Hoy',
                monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
                monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
                dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
                dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié', 'Juv', 'Vie', 'Sáb'],
                dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
                weekHeader: 'Sm',
                dateFormat: 'yy-mm-dd',
                firstDay: 1,
                isRTL: false,
                showMonthAfterYear: false,
                yearSuffix: ''
            };
            
            $.datepicker.setDefaults($.datepicker.regional['es']);
            $('.calendario').datepicker();
        }
        else{
            tr = $('<tr></tr>');
            tr.append('<td colspan="8">No se encontraron actividades</td>');
            $('#act2018 tbody').append(tr);
        }
    };

    Actividades.prototype.cambiarProgresoActividad = function(progreso, idActividad){
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxActividadesController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cambiarProgresoActividad',
                idActividad: idActividad,
                progreso: progreso
            },
            beforeSend: function(){

            },
            success: function(response){
                abreAlerta(response.mensaje);
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    };

    Actividades.prototype.cambiaStatusActividad = function(status, idActividad){
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxActividadesController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cambiaStatusActividad',
                idActividad: idActividad,
                status: status
            },
            beforeSend: function(){

            },
            success: function(response){
                abreAlerta(response.mensaje);
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    }

    return Actividades;
})();


$(function () {

    $('#modalActividadesJuntaCierre').modal({
        show: false,
        backdrop: 'static'
    });

    if ($('#listaAlertas').length > 0) {
        tipo = $('#tipo').val();
        a = new Actividades();
        pagina = $('#pagina').val();
        registros = 10;
        inferior = $('#inferior').val();
        superior = $('#superior').val();
        a.cargarActividades(tipo, pagina, registros, inferior, superior);
    }
});

$(document).on('click', '.asignaActividadJuntaCierre', function () {
    tipoActividad = $(this).attr('data-tipo');
    $('#modalActividadesJuntaCierre').modal('show');
});

$(document).on('change', '#estrategia', function () {
    idKey = $(this).val();
    if (idKey != '') {
        a = new Actividades();
        a.cargarAcciones(idKey);
    } else {
        abreAlerta('Por favor selecciona una estrategias');
    }
});

$(document).on('change', '#accion', function () {
    idKey = $(this).val();
    if (idKey != '') {
        a = new Actividades();
        a.cargarActividad(idKey);
    } else {
        abreAlerta('Por favor selecciona una acción');
    }
});

$(document).on('change', '#actividad', function () {
    idKey = $(this).val();
    var seleccionado = $(this).find('option:selected');

    idUsuario = seleccionado.data('usuario');

    if (idKey != '') {
        window.location = url + 'inicio/alertasSupervisor2018/' + idUsuario + '/' + idKey + '/';
    } else {
        abreAlerta('Por favor selecciona una actividad');
    }
});

$(document).on('change', '#keyIssue', function () {
    idKey = $(this).val();

    a = new Actividades();
    a.cargarActividades2018(idKey);
});

$(document).on('change', '.cboProgress2018', function(){
    progreso = $(this).val();
    idActividad = $(this).parent().parent().attr('data');
    a = new Actividades();
    a.cambiarProgresoActividad(progreso, idActividad);
});

$(document).on('change', '.progresoActividadSecuencia', function(){
    progreso = $(this).val();
    idActividad = $(this).parent().parent().attr('data');
    a = new Actividades();
    a.cambiarProgresoActividad(progreso, idActividad);
});

$(document).on('change', '.statusActividadSecuencia', function(){
    status = $(this).val();
    idActividad = $(this).parent().parent().attr('data');
    a = new Actividades();
    a.cambiaStatusActividad(status, idActividad);
});

$(document).on('change', '.cboStatus2018', function(){
    status = $(this).val();
    idActividad = $(this).parent().parent().attr('data');
    a = new Actividades();
    a.cambiaStatusActividad(status, idActividad);
});