/**
 * Secuencias.js
 * Clase y funciones para el módulo de secuencias
 * @copyright (c) 2015 Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package ventas
 */

var productos = [];
var pintaProductos = 1;
var eventos = [];
var Agenda = (function(){
    function Agenda(){};

    Agenda.prototype.cargarCotizacionesCliente = function (idCliente, idSecuencia, tipoCliente) {
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cargarCotizacionesCliente',
                idSecuencia: idSecuencia,
                idAlmacen: idCliente,
                tipoCliente: tipoCliente
            },
            beforeSend: function () {
                $('.refresh-container-table').show();
            },
            success: function (response) {
                $('.refresh-container-table').hide();
                if (response.status) {
                    _this.renderCotizacionesCliente(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                $('.refresh-container-table').hide();
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };
    Agenda.prototype.renderCotizacionesCliente = function (response) {
        _this = this;
        $('.tabla-productos-secuencia').html('')
        var html = '<table class="table table-striped" id="listaProductosPedidoCliente" style="font-size: 14px;"><thead> ' +
            '<tr class="info">' +
            '<th>Seleccionar</th> ' +
            '<th>Clave</th> ' +
            '<th>Producto</th> ' +
            '<th>Litraje</th> ' +
            '<th>Unidades a vender</th> ' +
            '</tr> </thead> <tbody>';
        var html2 = '';
        if (response.productos.length > 0) {
            if (response.inactivos > 0) {
                html2 += '<div class="col-xs-12 col-sm-12 col-md-12col-lg-12 alert alert-warning">  Algunos productos se encuentran inactivos.' +
                    ' podrás utilizar los demás para hacer pedidos. contacta a dirección para activarlos. </div>';
            }
            $.each(response.productos, function (registro, item) {
                html += '<tr>';
                if (item.status == "1") {
                    if (item.diaEntrega > -1) {
                        productos.push({
                            idProducto: item.idProducto,
                            litraje: item.litraje,
                            cantidad: item.cantidadPedido
                        });
                        html += '<td><input checked type="checkbox" value="' + item.idProducto + '" id="idProducto_' + item.idProducto + '" data-moneda="' + item.moneda + '" data-cotizacion="' + item.idCotizacion + '" class="checkbox selecciona"></td>';
                    } else {
                        html += '<td><input type="checkbox" value="' + item.idProducto + '" id="idProducto_' + item.idProducto + '" data-moneda="' + item.moneda + '" data-cotizacion="' + item.idCotizacion + '" class="checkbox selecciona"></td>';
                    }
                } else {
                    html += '<td><input type="checkbox" value="' + item.idProducto + '" id="idProducto_' + item.idProducto + '" data-moneda="' + item.moneda + '" data-cotizacion="' + item.idCotizacion + '" class="checkbox selecciona ayuda" title="Producto Bloqueado" disabled="disabled"></td>';
                }
                html += '<td>' + item.clave_prod + '</td>';
                html += '<td>' + item.producto + '</td>';
                html += '<td id="litraje_' + item.idProducto + '" data="' + item.litraje + '">' + item.litraje + '</td>';
                html += '<td><input type="number" id="cantidad_' + item.idProducto + '" class="form-control selecciona2" value="' + item.cantidadPedido + '">';
                html += '</tr>';
            });
        } else {
            html += '<tr>';
            html += '<td colspan="7">No se encontraron resultados</td>';
            html += '</tr>';
        }
        html += '</tbody> </table>';
        $('.tabla-productos-secuencia').append(html);
        $('#inactivo div').html(html2);
        console.log(productos);
    };

    Agenda.prototype.validarCliente = function (idCliente, tipo, fecha, idSecuencia){
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'validarCliente',
                idCliente: idCliente,
                tipo: tipo,
                fecha: fecha,
                idSecuencia: idSecuencia
            },
            success: function(response){
                if (response.status){

                    $('#latitud').val(response.latitud);
                    $('#longitud').val(response.longitud);
                    $('#modalTipoVisita').modal('show');

                   // $('#popsa').modal('show');
                    console.log(response.proposito, 'respuesta');
                        $('#proposito').val(response.proposito);
                        if( response.proposito == null || response.proposito == '') {
                            document.getElementById("proposito").readOnly = false;
                        } else {
                            document.getElementById("proposito").readOnly = true;
                        }

                    var html = '';
                        $.each(response.premisas, function (registro, item) {
                            html += '<li class="listaPremisas">' + item.premisa + '</li>';
                        });
                    $('#listapremisas').html(html);

                    $('#litraje').val(response.litraje);



                }
                else{
                    abreAlerta(response.mensaje);
                    _this.obtenerSecuencia(idSecuencia);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
            }
        });
    };

    Agenda.prototype.agregarClienteSecuencia = function(idSecuencia, formulario){
        $('#popsa').modal('hide');
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            contentType: false,
            processData: false,
            data: formulario,
            success: function(response){
                $('#formPopsa').trigger('reset');
                abreAlerta(response.mensaje);
                _this.obtenerSecuencia(idSecuencia);
              //  window.location.reload();
                //setTimeout(window.location.reload(), 2000);


            },
            error: function(xhr, responseText, thrownError){
                $('#formPopsa').trigger('reset');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.popsa2 = function(){
        $('#popsaCierre').modal('hide');
        _this = this;
        formulario = new FormData($('#formPopsaCierre')[0]);
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            contentType: false,
            processData: false,
            data: formulario,
            success: function(response){
                $('#formPopsaCierre').trigger('reset');
                abreAlerta(response.mensaje);
                window.location.reload();
            },
            error: function(xhr, responseText, thrownError){
                $('#formPopsaCierre').trigger('reset');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.obtenerSecuencia = function(idSecuencia){
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxAgendaController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cargarDatosAgenda',
                idSecuencia: idSecuencia
            },
            success: function(response){
                if (response.status){
                    eventos = [];

                    $.each(response.secuencia, function(registro, item){
                        eventos.push(item);
                    });
                    $('#calendario').fullCalendar('destroy');
                    renderCalendar(eventos);
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.cerrarSecuencia = function(idSecuencia){
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cerrarSecuencia',
                idSecuencia: idSecuencia
            },
            beforeSend: function(){
                abreAlerta('Mandando secuencia semanal a revision');
            },
            success: function(response){
                if (response.status){
                    abreAlerta('Mandando secuencia semanal a revision');
                    window.location = url + 'ventas/secuencias/';
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    };

    Agenda.prototype.validarSecuencia = function(idSecuencia){
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'validarSecuencia',
                idSecuencia: idSecuencia
            },
            success: function(response){
                if (response.status){
                    abreAlerta('Secuencia validada correctamente');
                    window.location.reload();
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    };

    Agenda.prototype.devolverSecuencia = function(idSecuencia){
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'devolverSecuencia',
                idSecuencia: idSecuencia
            },
            success: function(response){
                if (response.status){
                    abreAlerta('Secuencia devuelta correctamente');
                    window.location.reload();
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            }
        });
    };

    Agenda.prototype.eliminarDetalle = function(idDetalle, idSecuencia, tipo, idCliente){
        _this = this;
        $('#modalEliminaDetalleSecuencia').modal('hide');
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType:'json',
            cache: false,
            data: {
                accion: 'eliminarDetalle',
                idDetalle: idDetalle,
                tipo: tipo,
                idCliente: idCliente,
                idSecuencia: idSecuencia
            },
            beforeSend: function(){
              $('#mostrarPopsa').modal('hide');
            },
            success: function(response){                
                abreAlerta(response.mensaje);
                _this.obtenerSecuencia(idSecuencia);
                // window.location.reload();
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.editarCita = function(idDetalle, fecha, idSecuencia){
        $('#editarCitaModal').modal('hide');
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cambiarFechaDetalle',
                fecha: fecha,
                idDetalle: idDetalle
            },
            success: function(response){
                abreAlerta(response.mensaje);
                _this.obtenerSecuencia(idSecuencia);
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.eliminaActividadCita = function(idActividadAgenda){
        $('#eliminarCitaModal').modal('hide');
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxAgendaController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'eliminaActividadAgendada',
                idActividadAgenda: idActividadAgenda
            },
            success: function(response){
                if(response.status){
                    idSecuencia = $('#idSecuencia').val();
                    _this.obtenerSecuencia(idSecuencia);
                }else{
                    abreAlerta('Ocurrio un error al eliminar la actividad');

                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.editarActividadAgendada = function(idActividad, fecha, horaCierreeditar){


        $('#editarCitaNuevaActividadModal').modal('hide');
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxAgendaController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'editarActividadAgendada',
                fecha: fecha,
                idActividad: idActividad,
                horaCierreeditar: horaCierreeditar
            },
            success: function(response){
                if(response.status){
                    idSecuencia = $('#idSecuencia').val();
                    _this.obtenerSecuencia(idSecuencia);
                }else{
                    abreAlerta('Ocurrio un error al actualizar la actividad');

                }

            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };


    Agenda.prototype.cambiarFechaPopsaDiario = function(idDetalle, fecha, idSecuencia, tipo, idCliente ){
        $('#editarCitaModal').modal('hide');
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cambiarFechaPopsaDiario',
                fecha: fecha,
                idDetalle: idDetalle,
                idSecuencia: idSecuencia,
                tipo: tipo,
                idCliente: idCliente
            },
            success: function(response){
                abreAlerta(response.mensaje);
                console.log(response.status, 'response.status');
                if(response.status == false ){
                    $('#modal-cambiar-fecha').modal('hide');
                }else {
                    $('#modal-cambiar-fecha').modal('hide');
                    setTimeout(window.location.reload(), 2000);
                }



            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.actualizaPopsa = function(idDetalle, campo, valor){
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'actualizaPopsa',
                idDetalle: idDetalle,
                campo: campo,
                valor: valor
            },
            success: function(response){
                if (!response.status){
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.confirmarSecuenciaDiaria = function(clientes, tipo, idSecuencia){
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'confirmarSecuenciaDiaria',
                clientes: clientes,
                tipo: tipo,
                idSecuencia: idSecuencia
            },
            success: function(response){
                abreAlerta(response.mensaje);
                if (response.status){
                    window.location.reload();
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.agregarPasos = function(idCliente, idSecuencia, pasos, tipo, fecha) {
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'agregarPasos',
                idCliente: idCliente,
                idSecuencia: idSecuencia,
                tipo: tipo,
                pasos: pasos, 
                fecha: fecha
            },
            beforeSend: function(){
                $('#btnAgregaPasos').prop('disabled', true).text('Agregando actividades.');
            },
            success: function(response){
                $('#btnAgregaPasos').prop('disabled', false).html('<i class="fa fa-plus"></i> Agregar');
                if (response.status){
                    $('#pasos').val('');
                }else{
                    $('#msjValidaPopsa2').removeClass().addClass('alert alert-danger').html(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                $('#msjValidaPopsa2').removeClass().addClass('alert alert-danger').text(error);
            }
        });
    };

    Agenda.prototype.mostrarPopsa = function(idCliente, tipo, idSecuencia){
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'mostrarPopsa',
                idCliente: idCliente,
                tipo: tipo,
                idSecuencia: idSecuencia
            },
            success: function(response){
                if (response.status){

                    $('#latitudEdicion').val(response.latitud);
                    $('#longitudEdicion').val(response.longitud);
                    var html = '';
                    $.each(response.premisas, function (registro, item) {
                        html += '<li>' + item.premisa + '</li>';
                    });

                    renderEstrategias(response);
                    renderAcciones(response);

                    $('#listapremisasPopsa').html(html);
                    $('#propositoPopsa').val(response.proposito);
                    $('#litrajePopsa').val(response.litraje);
                    $('#idPopsaSecuencia').val(response.popsa.Id_Popsa);
                    $('#mostrarPopsaIdSecuencia').val(response.popsa.Id_Secuencia);
                    $('#idClientePopsa').val(response.popsa.Id_Cliente);

                    $("#objetivoPopsa").val([]);
                    var arrayDeCadenas = response.popsa.Objetivo_Visita.split(',');
                    $.each(arrayDeCadenas, function (registro, item) {
                        $("#objetivoPopsa option[value='" + item + "']").prop('selected', true);

                        if (item == 'Obtener pedido') {
                            s.cargarCotizacionesCliente(idCliente, idSecuencia, tipo);
                            // pintaProductos = 0;
                        }

                    });
                    $('#objetivoPopsa').selectpicker('refresh').selectpicker('render');
                    $('#modalTipoVisitaEdicion').modal('show');
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.cerrarSecuenciaSemanal = function(idSecuencia) {
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'POST',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cerrarSecuenciaSemanal',
                idSecuencia: idSecuencia
            },
            beforeSend: function(){

            },
            success: function(response){
                if (response.status){
                    window.location = url + 'ventas/secuencias/';
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.editarPopsa = function(formulario) {
        $('#mostrarPopsa').modal('hide');
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            contentType: false,
            processData: false,
            data: formulario,

            success: function(response){
                abreAlerta(response.mensaje);
                idSecuencia = $('#idSecuencia').val();
                _this.obtenerSecuencia(idSecuencia);

                $('.tabla-productos-secuencia').html('')
                // pintaProductos = 1;
                productos = [];
            //    window.location.reload();
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
            }
        });
    };

    Agenda.prototype.mostrarPopsaDiario = function(idCliente, tipo, idSecuencia){
        _this = this;
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'mostrarPopsaDiario',
                idCliente: idCliente,
                tipo: tipo,
                idSecuencia: idSecuencia
            },
            success: function(response){
                if (response.status){

                    var html = '';
                    $.each(response.premisas, function (registro, item) {
                        html += '<li>' + item.premisa + '</li>';
                    });
                    $('#listapremisasDiarias').html(html);

                    var htmlEstrategias = '';
                    $.each(response.estrategias, function (registro, item) {
                        htmlEstrategias += '<li>' + item.estrategia + '</li>';
                    });
                    $('#listaEstrategiasDiarias').html(htmlEstrategias);

                    var optionEstrategias = '';
                    $.each(response.estrategias, function (registro, item) {
                    optionEstrategias += '<option value="' + item.id_estrategias_popsa + '">' + item.estrategia + '</option>';
                    $('#estrategiasAccionDiario').append(optionEstrategias);
                    });

                    renderAccionesDiario(response);
                    $('#popsaCierre').modal('show');
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.eliminarClientePopsa = function( idSecuencia, tipo, idCliente){
        _this = this;
        $('#formPopsaCierre').modal('hide');
        $.ajax({
            url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
            type: 'post',
            dataType:'json',
            cache: false,
            data: {
                accion: 'eliminarClientePopsa',
                tipo: tipo,
                idCliente: idCliente,
                idSecuencia: idSecuencia
            },
            success: function(response){
                abreAlerta(response.mensaje);
                 window.location.reload();
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.buscarCliente = function (termino, rol) {
        _this = this;
        $.ajax({
            url: url + 'application/administracion/controllers/AjaxClientesController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'buscarClientesSecuenciaSemanal',
                termino: termino,
                rol: rol
            },
            beforeSend: function () {

            },
            success: function (response) {
                if (response.status) {
                    _this.renderClientes(response);
                }
            },
            error: function (xhr, responseText, thrownError) {
                $('.refresh-container-table').show();
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.renderClientes = function (response) {
        var html = '';
        if (response.clientes.length > 0) {
            $.each(response.clientes, function (registro, item) {
                html += '<div class="arrastrar" data-tipo="cliente" data-idCliente="'  + item.Id_Cliente + '">' + item.Cliente + '</div> ';
            });

        }

        $('#listaClientes ').html(html);
        _this.arrastra();
    };

    Agenda.prototype.arrastra = function () {
        renderCalendar(eventos);
        s = new Agenda();
        s.obtenerSecuencia($('#idSecuencia').val());

        $('.arrastrar, .fc-event').each(function () {
            $(this).data('event', {
                title: $(this).text(),
                stick: true
            });

            $(this).draggable({
                zIndex: 999,
                revert: true,
                revertDuration: 0
            });

        });
    };

    Agenda.prototype.buscarSospechoso = function (termino, rol) {
        _this = this;
        $.ajax({
            url: url + 'application/administracion/controllers/AjaxClientesController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'buscarSospechososSecuenciaSemanal',
                termino: termino,
                rol: rol
            },
            beforeSend: function () {

            },
            success: function (response) {
                if (response.status) {
                    _this.renderSospechoso(response);
                }
            },
            error: function (xhr, responseText, thrownError) {
                $('.refresh-container-table').show();
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.renderSospechoso = function (response) {
        var html = '';
        if (response.sospechosos.length > 0) {
            $.each(response.sospechosos, function (registro, item) {
                html += '<div class="arrastrar" data-tipo="prospecto" data-idCliente="'  + item.Id_Sospechoso + '">' + item.Cliente + '</div> ';
            });

        }

        $('#listaSospechosos ').html(html);
        _this.arrastra();
    };

    Agenda.prototype.seleccionarUsuario = function(idUsuario){
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxAgendaController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'seleccionarUsuario',
                idUsuario: idUsuario
            },
            success: function(response){
                console.log(response, " response");
                if (response.status){
                    $('#idSecuencia').val(response.idSecuencia);
                    _this.obtenerSecuencia(response.idSecuencia);
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Agenda.prototype.agregarNuevaActividad = function(fecha, nuevaActividad, idSecuencia, horaCierre){
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxAgendaController.php',
            type: 'get',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'agregarNuevaActividad',
                fecha: fecha,
                nuevaActividad: nuevaActividad,
                idSecuencia: idSecuencia,
                horaCierre: horaCierre
            },
            success: function(response){
                if(response.status){
                    abreAlerta('actividad agregada');
                   idSecuencia = $('#idSecuencia').val();
                    _this.obtenerSecuencia(idSecuencia);

                }else{
                    abreAlerta(response.mensaje);
                }



            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };




    return Agenda;
})();

$(document).on('blur', '.selecciona2', function () {
    console.log('Input change...', $(this).val());
    idProducto = $(this).attr('id').replace('cantidad_', '');
    cantidad = $(this).val();
    const index = productos.findIndex(item => item.idProducto === idProducto);
    if (index !== -1) {
        productos[index].cantidad = cantidad;
    }
    // this.setAttribute("value", cantidad);
    document.getElementById(`cantidad_${idProducto}`).value = cantidad;
    console.log('input value: ', document.getElementById(`cantidad_${idProducto}`))
    console.log(productos);
});
$(document).on('click', '.selecciona', function () {
    idProducto = $(this).val();
    // console.log('Check...', $('#cantidad_' + idProducto));
    if ($(this).prop('checked')) {
        if( $('#cantidad_' + idProducto).val() > 0 && $('#litraje_' + idProducto).attr('data') > 0){
            prodData = {
                idProducto: idProducto,
                litraje: $('#litraje_' + idProducto).attr('data'),
                cantidad: $('#cantidad_' + idProducto).val()
            }
            productos.push(prodData);
            console.log('Check ', prodData, 'Array', productos);
        } else {
            $('#msjPopsa1').removeClass().addClass('alert alert-danger').text('La cantidad y litraje del producto deben ser mayor a cero...');
            return false;
        }
    } else {
        if (productos.length > 0) {
            productos = productos.filter(aux => aux.idProducto != idProducto);
        }
    }

    console.log('New array', productos);
});
$("#objetivo").on("change", function () {
    console.log('tipoCliente', tipo);
    muestraOcultaProductosPedido("#objetivo", idCliente, idSecuencia, tipo);
});
$("#objetivoPopsa").on("change", function () {
    console.log('tipoCliente', tipoCliente);
    muestraOcultaProductosPedido("#objetivoPopsa", idCliente, idSecuencia, tipoCliente);
});
function muestraOcultaProductosPedido(selector, idCliente, idSecuencia, tipoCliente) {
    if ($(selector).val() != null) {
        if ($(selector).val().includes('Obtener pedido')) {
            // if (pintaProductos) {
                s.cargarCotizacionesCliente(idCliente, idSecuencia, tipoCliente);
                // pintaProductos = 0;
            // }
        } else {
            $('.tabla-productos-secuencia').html('');
            // pintaProductos = 1;
            productos = [];
        }
    }
}

$(function () {
    
    if ($('#calendario').length > 0){
        renderCalendar(eventos);
        s = new Agenda();
        s.obtenerSecuencia($('#idSecuencia').val());

        $('.arrastrar, .fc-event').each(function () {
            $(this).data('event', {
                    title: $(this).text(),
                    stick: true
            });
          
            $(this).draggable({
                zIndex: 999,
                revert: true, 
                revertDuration: 0 
            });

        });    
    }

    $('#popsaCierre').modal({
        show: false,
        backdrop: 'static'
    });

    $('#popsa').modal({
        show: false,
        backdrop: 'static'
    });
    
    if ($('#buscarClienteSecuenciaDiaria').length > 0){
        $('#buscarClienteSecuenciaDiaria').autocomplete({
            source: function(request, response){
                tipoBusqueda = $('input[id=tipoBusqueda]:checked').val();
                console.log(tipoBusqueda, 'tipobusqueda');
                $.ajax({
                    url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
                    type: 'get',
                    dataType: 'json',
                    cache: false,
                    data: {
                        accion: 'buscarCliente',
                        cliente: request.term,
                        tipoBusqueda: tipoBusqueda
                    },
                    success: function(data){
                        response(data.clientes);
                    },
                    error: function (xhr, responseText, thrownError) {
                    error = mostrarMensajeError(xhr, responseText, thrownError);
                    abreAlerta(error);
                    },
                    timeout: 15000
                });
            },
            focus: function(e, ui){
                $('#buscarClienteSecuenciaDiaria').val(ui.item.label);
                return false;                
            },
            select: function(e, ui){
                $('#buscarClienteSecuenciaDiaria').val(ui.item.label);
                $('#idCliente').val(ui.item.value);
                $('#tipo').val(ui.item.tipo);

                return false;
            }
        });
    }
    
    $(document).on('click', '#btnPopsaAceptar', function(){

        formulario = new FormData($('#formPopsa')[0]);

        proposito = $('#proposito').val();
        objetivo = $('#objetivo').val();
      num =  $('#listapremisas li').length;

        if (objetivo == '' || objetivo == undefined){
            $('#msjPopsa1').removeClass().addClass('alert alert-danger').text('Por favor ingresa el objetivo de la visita');
            return false;
        }
        var numAcciones=document.getElementById("tablaAcciones").rows.length;
        if (numAcciones <= 2 ){
            $('#msjPopsa1').removeClass().addClass('alert alert-danger').text('Por favor agrega una accion por lo menos');
            return false;
        }

        var numEstrategias=document.getElementById("tablaEstrategias").rows.length;
        if (numEstrategias <= 2 ){
            $('#msjPopsa1').removeClass().addClass('alert alert-danger').text('Por favor agrega una estrategia por lo menos');
            return false;
        }

        numPremisas =  $('#tablaPremisas tbody tr').length;
        if(num == 0 && numPremisas == 0 ){
            $('#msjPopsa1').removeClass().addClass('alert alert-danger').text('Por favor agrega una premisa por lo menos');
            return false;
        }

        if (proposito == '' || proposito == undefined){
                 $('#msjPopsa1').removeClass().addClass('alert alert-danger').text('Por favor ingresa el proposito de la visita');
                 return false;
        }

        if (objetivo.includes('Obtener pedido')) {
            if (productos.length > 0) {
                formulario.append('arrayProductos', JSON.stringify(productos));
            } else {
                $('#msjPopsa1').removeClass().addClass('alert alert-danger').text('Por favor selecciona que productos serán considerados dentro del pedido');
                return false;
            }
        }

        idSecuencia = $('#idSecuencia').val();
        s = new Agenda();
        s.agregarClienteSecuencia(idSecuencia, formulario);
    });
    
    $('#formPopsa').trigger('reset');
    
    $('#cerrarSecuencia').on('click', function(e){
        e.preventDefault();
        idSecuencia = $('#idSecuencia').val();
        s = new Agenda();
        s.cerrarSecuencia(idSecuencia);
    });

    $('#btnEliminaDetalleSecuencia').on('click', function(){
        console.log('entra');
        idDetalle = $('#idEliminaClienteSecuencia').val();
        idSecuencia = $('#idSecuencia').val();
        tipo = $('#tipoClienteElimina').val();
        idCliente = $('#idClienteEliminaSecuencia').val();
        s = new Agenda();
        s.eliminarDetalle(idDetalle, idSecuencia, tipo, idCliente);
    });

    $('#btnEditaDetalleSecuencia').on('click', function(){
        idDetalle = $('#idEditaClienteSecuencia').val();
        fecha = $('#fechaEditaClienteSecuencia').val();
        idSecuencia = $('#idSecuencia').val();
        s = new Agenda();
        s.editarCita(idDetalle, fecha, idSecuencia);
    });

    $('#btnEditaNuevaActividad').on('click', function(){
        idActividad = $('#idActividad').val();
        fecha = $('#fechaEditaNuevaActividad').val();
        horaCierreeditar = $('#horaCierreeditar').val();
        var tiempo = new Date(fecha);
        var hora = addZero(tiempo.getHours());
        var minuto = addZero(tiempo.getMinutes());
        var segundo = addZero(tiempo.getSeconds());
        horainicio = hora + ":" + minuto + ":" + segundo;

        if(horainicio> horaCierreeditar ){
            setError($('.divHoraCierre'),'hora de cierre menor a hora de inicio');

        }else{
            s = new Agenda();
            s.editarActividadAgendada(idActividad, fecha, horaCierreeditar);
        }



    });

    $('.btnValidaSecuencia').on('click', function(){
        idSecuencia = $(this).attr('data-secuencia');
        s = new Agenda();
        s.validarSecuencia(idSecuencia);
    });

   /* $('.actualizaPopsa').on('blur', function(){
        campo = $(this).attr('data-campo');
        valor = $(this).val();
        idDetalle = $(this).attr('data-detalle');
        s = new Agenda();
        validarNoVacio= validateNotNullOrEmptyInput(valor,$(this).closest ('td'));
        if (validarNoVacio){
            s.actualizaPopsa(idDetalle, campo, valor);
        }
    });*/

    $('#btnAgregarClienteSecuenciaDiaria').on('click', function(){
        $('#msjPopsa1').removeClass().text('');
        $('#proposito').val('');
        $('#objetivo').val('');
        $('#premisas').val('');
        $('#estrategia').val('');
        $('#anticipacion').val('');
        $('#tecnico').prop('checked', false);
        $('#gerencia').prop('checked', false);

        idCliente = $('#idCliente').val();
        tipo = $('#tipo').val();
        fecha = $('#fecha').val();
        idSecuencia = $('#idSecuencia').val();

        if(idCliente == ''){
            abreAlerta('Por favor ingresa un cliente o un prospecto');
        }else {
            s = new Agenda();
            s.validarCliente(idCliente, tipo, fecha, idSecuencia);
        }

    });

    $('#confirmaSecuenciaDiaria').on('click', function(){
        $('#modalContinuar').modal('show');

    });

    $('.popsaCierre').on('click', function(){
        console.log('popsacierre');
        //if ($(this).prop('checked', true)){
            idCliente = $(this).attr('data-idCliente2');
            tipo = $(this).attr('data-tipo2');
            $('#idClienteCierre').val(idCliente);
            $('#tipoCierre').val(tipo);
            idSecuencia = $('#idSecuencia').val();
            console.log(idSecuencia, 'idSecuencia');
            console.log(idCliente, 'idCliente');
            console.log(tipo, 'tipo');
            s = new Agenda();
            s.mostrarPopsaDiario(idCliente, tipo, idSecuencia);


        //}
    });

    $('#btnPopsa2Aceptar').on('click', function(){


        var numacciones=document.getElementById("tablaNuevasAccionesDiario").rows.length;
        if (numacciones <= 2 ){
            $('#msjPopsaDiario').removeClass().addClass('alert alert-danger').text('Por favor agrega una accion por lo menos');
            return false;
        }

        s = new Agenda();
        s.popsa2();
    });

    $('#cerrarSecuenciaDiaria').on('click', function(){
        dia = parseInt($('#dia').val());            
        if (dia <= 6){            
            window.location = url + 'ventas/secuenciaDiaria/' + (dia + 1) + '/';    
        }
        else{
            window.location = url + 'ventas/';
        }
        
    });
});

function renderCalendar(eventos)
{
    hoy = date("Y-m-d");
    semana = date("Y-m-d", strtotime(hoy + '+2 day'));    
    $('#calendario').fullCalendar({
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay'
        },
        selectable: true,
        selectHelper: true,
        locale: 'es',
        theme: true,
        defaultView: 'agendaWeek',
        droppable: true,
        editable: true,
        defaultDate: semana,
        events: eventos,
        drop: function (start, end) {
            idCliente = $(this).attr('data-idCliente');
            tipo = $(this).attr('data-tipo');

            //validamos que no se agregue doble el cliente
            $('#fecha').val(start.format());    
            $('#idCliente').val(idCliente);
            $('#tipo').val(tipo);
            fecha = $('#fecha').val();      
            dia = date("N", strtotime(fecha));
            dia = start._d.getDay();
            $('#dia').val(dia);
            console.log(dia, " dia");
            idSecuencia = $('#idSecuencia').val();
            s = new Agenda();
            s.validarCliente(idCliente, tipo, fecha, idSecuencia);

        },
        eventClick: function(event, jsEvent, view){

            dia = date("N", strtotime(event.start.format()));
            dia = event.start._d.getDay();
            $('#diaPopsa').val(dia);
            console.log(dia, " dia");

            tipoCliente = event.tipo;
            idCliente = event.idCliente;
            idSecuencia = event.idSecuencia;

            console.log(event, " event");
            if(event.idSecuencia == null){

                switch(event.tipoActividad) {
                    case "juntaDiaria":
                        window.open(url + '/balance/minutaDiaria/', '_blank');
                        break;
                    case "sugerencias":
                        window.open(url + '/balance/sugerenciaMejora/', '_blank');
                        break;
                    case "inventarioCiclico":
                        window.open(url + '/almacenes/registroConteo/', '_blank');
                        break;
                    case "razonesCobranza":
                        window.open(url + '/cobranza/razonesSaldosVencidos/', '_blank');
                        break;
                    case "tareasSeguridad":
                        window.open(url + '/inicio/actividadesSeguridadEmpleado/', '_blank');
                        break;
                    case "tareasCalidad":
                        window.open(url + '/inicio/actividadesSistemaCalidadEmpleado/', '_blank');
                        break;
                    case "Forecast":
                        window.open(url + '/balance/reporteForecastMensual/', '_blank');
                        break;
                    case "secuenciaSemanal":
                        window.open(url + '/ventas/secuenciaSemanal/', '_blank');
                        break;
                    case "secuenciaDiaria":
                        window.open(url + '/ventas/secuenciaDiaria/', '_blank');
                        break;
                    case "facturasSelladas":
                        window.open(url + '/cobranza/razonesSaldosVencidos/', '_blank');
                        break;
                    case "razonesSaldosContabilidad":
                        window.open(url + '/cobranza/razonesSaldosVencidosContabilidad/', '_blank');
                        break;
                    case "razonesSaldosProveedoresContabilidad":
                        window.open(url + '/cobranza/razonesSaldosVencidosProveedores/', '_blank');
                        break;
                    case "cierreMensual":
                        window.open(url + '/contabilidad/pagoProvisional/', '_blank');
                        break;
                    case "aplicacionCobranza":
                        window.open(url + '/cobranza/pagosEncontrados/', '_blank');
                        break;
                    case "facturaSinSello":
                        window.open(url + '/cobranza/evidenciaFactura/', '_blank');
                        break;
                    case "actividadAgregada":
                        break;
                    case "autorizacionSaldosProveedores":
                        window.open(url + '/cobranza/autorizarSaldosVencidosProveedor/', '_blank');
                        break;
                    case "autorizacionSaldosClientes":
                        window.open(url + '/cobranza/autorizarSaldosVencidosContabilidad/', '_blank');
                        break;
                    case "autorizacionfacturasSelladas":
                        window.open(url + '/cobranza/autorizarRazonesFaltaFacturasSelladas/', '_blank');
                        break;
                    case "AutorizacionCierreMes":
                        window.open(url + '/contabilidad/pagoProvisional/', '_blank');
                        break;
                    case "AutorizacionForecast":
                        window.open(url + '/balance/autorizaciones/', '_blank');
                        break;
                    case "tarjetasAsistencia":
                        window.open(url + '/contabilidad/tarjetaAsistencia/', '_blank');
                        break;
                    case "autorizarRazonesClientes":
                        window.open(url + '/cobranza/autorizarSaldosVencidos/', '_blank');
                        break;
                    case "autorizarSecuencias":
                        window.open(url + '/ventas/revisionSecuencia/', '_blank');
                        break;
                    case "desbloqueoPersonal":
                        window.open(url + '/usuarios/autorizaciones/', '_blank');
                        break;
                    case "pedidosProveedores":
                        window.open(url + '/almacenes/autorizar/', '_blank');
                        break;
                    case "pedidosCliente":
                        window.open(url + '/almacenes/autorizarPromesas/', '_blank');
                        break;
                    case "notascredito":
                        window.open(url + '/cobranza/autorizarPagos/', '_blank');
                        break;
                    case "autorizacionCotizaciones":
                        window.open(url + '/almacenes/autorizarPromesas/', '_blank');
                        break;
                    case "autorizacionRequisiciones":
                        window.open(url + '/compras/autorizaciones/', '_blank');
                        break;
                    case "autorizacionTareasSeguridad":
                        window.open(url + '/balance/autorizacionesSeguridad/', '_blank');
                        break;
                    case "autorizacionTareasCalidad":
                        window.open(url + '/balance/autorizacionesSistemaCalidad/', '_blank');
                        break;
                    case "autorizacionProspectos":
                        window.open(url + '/administracion/autorizarCliente/', '_blank');
                        break;
                    case "autorizacionCliente":
                        window.open(url + '/administracion/autorizarCliente/', '_blank');
                        break;
                    case "actividadgregada":
                        $('#idEliminaActividadCita').val(event.idActividad);
                        $('#eliminarCitaModal').modal('show');
                        break;




                }

            }else{
                $("#actualizaPopsaForm")[0].reset();
                $('#actualizaPopsaForm').trigger("reset");
                $('#tablaPremisasPopsa tbody > tr').remove();
                $('#tablaEstrategiasPopsa tbody > tr').remove();
                $('#tablaAccionesPopsa tbody > tr').remove();
                $('#idEliminaClienteSecuencia').val(event.idDetalle);
                $('#tipoClienteElimina').val(tipoCliente);
                $('#idClienteEliminaSecuencia').val(idCliente);
                $('#idSecuencia').val(idSecuencia);

                s = new Agenda();
                s.mostrarPopsa(idCliente, tipoCliente, idSecuencia);
            }

        },
        eventDrop: function(event, delta, revertFunc){
            idDetalle = event.idDetalle;


            if(event.tipoActividad == 'actividadgregada' ){
                $('#fechaEditaNuevaActividad').val(event.start.format());
                $('#horaCierreeditar').val('00:00:00');
                $('#idActividad').val(event.idActividad);
                $('#msjEditaNuevaActividad').text('La cita será movida a la fecha ' + event.start.format() + '. Deseas continuar??');
                $('#editarCitaNuevaActividadModal').modal('show');
            }else if(event.idSecuencia == null){
                $('#tareasFijasModal').modal('show');
                idSecuencia = $('#idSecuencia').val();
                a = new Agenda();
                a.obtenerSecuencia(idSecuencia);
            }else{
                $('#idEditaClienteSecuencia').val(idDetalle);
                $('#fechaEditaClienteSecuencia').val(event.start.format());
                $('#msjEditaClienteSecuencia').text('La cita será movida a la fecha ' + event.start.format() + '. Deseas continuar??');
                $('#editarCitaModal').modal('show');
            }



        },
        dayClick: function(date, jsEvent, view){
            console.log(date, " evento");
            $('#fechaAltaActividad').val(date.format());
            $('#nuevaActividad').val('');
            $('#horaCierre').val('00:00:00');

            $('#msjAgregarActividad').text('La actividad se programara para ' + date.format() + '.');
            $("#agregarTarea").modal("show");

        }
    });
}



$(document).on('click', '#btnAgregarTarea', function(){
   fecha = $('#fechaAltaActividad').val();
    var tiempo = new Date(fecha);
    var hora = addZero(tiempo.getHours());
    var minuto = addZero(tiempo.getMinutes());
    var segundo = addZero(tiempo.getSeconds());
    horainicio = hora + ":" + minuto + ":" + segundo;

    nuevaActividad = $('#nuevaActividad').val();
    horaCierre = $('#horaCierre').val();
    idSecuencia = $('#idSecuencia').val();

    if(nuevaActividad == "" ){
        setError($('#divnuevaActividad'),'agrega una descripcion de la actividad');

    } else if(horainicio> horaCierre ){
        setError($('.divHoraCierre'),'hora de cierre menor a hora de inicio');

    }else{
        a = new Agenda();
        a.agregarNuevaActividad(fecha, nuevaActividad, idSecuencia, horaCierre );
        $("#agregarTarea").modal("hide");
    }

});

function addZero(i) {
    if (i < 10) {
        i = "0" + i;
    }
    return i;
}

$(document).on('click', '#btnAgregaPasos', function(){
    pasos = $('#pasos').val();
    idCliente = $('#idClienteCierre').val();
    idSecuencia = $('#idSecuencia').val();
    tipo = $('#tipoCierre').val();
    fecha = $('#fechaAccion').val();    

    if ($('#pasos').val() == ''){
        $('#msjValidaPopsa2').removeClass().addClass('alert alert-danger').text('Por favor ingresa tus comentarios de la visita');
        return false;
    }

    s = new Agenda();
    s.agregarPasos(idCliente, idSecuencia, pasos, tipo, fecha);
});

$(document).on('click', '#cerrarSecuenciaSemanal', function(){
    idSecuencia = $('#idSecuencia').val();
    s = new Agenda();
    s.cerrarSecuenciaSemanal(idSecuencia);
});



$(document).on('click', '#btnagregarPremisa', function () {
    descripcion = $('#agregarPremisa').val();

    // Validar si existe la premisa
    coincidenciaDePremisa = false;
    $('#tablaPremisas > tbody > tr').each(function (index, tr) {
        input = $(this).find('[name="premisa[]"]');
        if(input.val() == descripcion){
            console.log('Concidencia de la premisa: ',input.val()," = ",descripcion);
            coincidenciaDePremisa = true;
        }
    });
    $('#listapremisas > li').each(function (index, li) {
        text = $(this).text();
        if(text == descripcion){
            console.log('Concidencia de la premisa: ',text," = ",descripcion);
            coincidenciaDePremisa = true;
        }
    });
    if(coincidenciaDePremisa){ return false }


    if (descripcion == '') {
        //abreAlerta('Por favor ingresa una premisa');
        return false;
    }

    var i = 0;
    //   var fila = '<tr id="row' + i + '"><td name="nombreNoConformidad[]" id="nombreNoConformidad' + i + '" >' + nombre + '</td><td name="descripcionNoConformidad[]" id="descripcionNoConformidad' + i + '" >' + descripcion + '</td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove">Quitar</button></td></tr>'; //esto seria lo que contendria la fila
    var fila = '<tr id="row' + i + '"><td ><input readonly type="text" name="premisa[]" id="premisa' + i + '" class="form-control" value="' + descripcion + '"></td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove">Quitar</button></td></tr>'; //esto seria lo que contendria la fila


    i++;



    $('#tablaPremisas ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaPremisas tr").length;
    $("#adicionados").append(nFilas - 1);
    document.getElementById("agregarPremisa").value = "";
});

$(document).on('click', '.btn_remove', function() {
    var button_id = $(this).attr("id");
    $('#row' + button_id + '').remove(); //borra la fila
    $("#adicionados").text("");
    var nFilas = $("#tablaPremisas tr").length;
    $("#adicionados").append(nFilas - 1);
});

$(document).on('click', '#agregarAccion', function () {
    console.log('as');
    descripcion = $('#acciones').val();
    estrategias = $('#estrategias').val();
    responsable = $('#responsables').val();
    fecha = $('#fechas').val();

    var combo = document.getElementById("responsables");
    var selected = combo.options[combo.selectedIndex].text;

    if (descripcion == '') {
        return false;
    }
    if (estrategias == '' || estrategias == null) {
        return false;
    }
    if (responsable == '' || responsable == null) {
        return false;
    }
    if (fecha == '' || fecha == null) {
        return false;
    }

    var i = 0;
    var fila = '<tr id="rowAccion' + i + '" class="filasAccion">' +
        '<td >' +
        '<input readonly type="text" name="accionPopsa[]" id="accionPopsa' + i + '" class="form-control" value="' + descripcion + '">' +
        '</td>' +
        '<td >' +
        '<input readonly type="text" name="estrategiaAccion[]" id="estrategiaAccion' + i + '" class="form-control" value="' + estrategias + '">' +
        '</td>' +
        '<td >' +
    '<select type="text" name="responsableAccion[]" id="responsableAccion' + i + '" class="form-control ">' +
    '<option value="' + responsable + '" selected> ' + selected + '</option></select>' +
    '</td>' +
        '<td >' +
        '<input readonly type="text" name="fechaAccion[]" id="fechaAccion' + i + '" class="form-control" value="' + fecha + '">' +
        '</td>' +
        '<td>' +
        '<button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove_accion">Quitar</button>' +
        '</td>' +
        '</tr>';

    i++;


    $('#tablaAcciones ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaAcciones tr").length;
    $("#adicionados").append(nFilas - 1);
    document.getElementById("acciones").value = "";
});

$(document).on('click', '.btn_remove_accion', function() {
    var button_id = $(this).attr("id");
    $('#rowAccion' + button_id + '').remove();
    $("#adicionados").text("");
    var nFilas = $("#tablaAcciones tr").length;
    $("#adicionados").append(nFilas - 1);
});

$(document).on('click', '#agregarEstrategia', function () {
    descripcion = $('#estrategia').val();

    //validar si existe estrategia
    coincidenciaDeEstrategia = false;

    $('#tablaEstrategias > tbody > tr').each(function (index, tr) {
        input = $(this).find('[name="estrategia[]"]');
        if(input.val() == descripcion){
            console.log('Concidencia de la estrategia: ',input.val()," = ",descripcion);
            coincidenciaDeEstrategia = true;
        }
    });
    if(coincidenciaDeEstrategia){ return false }

    if (descripcion == '') {
        //abreAlerta('Por favor ingresa una premisa');
        return false;
    }

    var i = 0;
    //   var fila = '<tr id="row' + i + '"><td name="nombreNoConformidad[]" id="nombreNoConformidad' + i + '" >' + nombre + '</td><td name="descripcionNoConformidad[]" id="descripcionNoConformidad' + i + '" >' + descripcion + '</td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove">Quitar</button></td></tr>'; //esto seria lo que contendria la fila
    var fila = '<tr id="rowEstrategia' + i + '"><td ><input readonly type="text" name="estrategia[]" id="estrategia' + i + '" class="form-control" value="' + descripcion + '"></td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove_estrategia">Quitar</button></td></tr>'; //esto seria lo que contendria la fila

    var html = '';
    html += '<option id="option' + i + '" value="' + descripcion + '">' + descripcion + '</option>';
    $('#estrategias').append(html);


    i++;



    $('#tablaEstrategias ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaEstrategias tr").length;
    $("#adicionados").append(nFilas - 1);
    document.getElementById("estrategia").value = "";
});

$(document).on('click', '.btn_remove_estrategia', function() {
    var button_id = $(this).attr("id");
    estrategia = $(this).closest('tr').find('[name="estrategia[]"]').val();
    console.log('Remover estrategia-> '+estrategia);

    $('#tablaAcciones > tbody > tr').each(function (index, tr) {
        input = $(this).find('[name="estrategiaAccion[]"]');
        if(input.val() == estrategia){
            $(this).remove();
        }
    });

    $(' #estrategias > option ').each(function (index, option) {
        optionContet = $(this).val();
        if(optionContet == estrategia){
            $(this).remove();
        }
    });

    $(this).closest ('tr').remove ();
});

$(document).on('click', '.btn_remove_estrategia_popsa', function() {
    var button_id = $(this).attr("id");
    estrategia = $(this).closest('tr').find('[name="estrategia[]"]').val();
    console.log('Remover estrategia-> '+estrategia);

    $('#tablaAccionesPopsa > tbody > tr').each(function (index, tr) {
        input = $(this).find('[name="estrategiaAccion[]"]');
        if(input.val() == estrategia){
            $(this).remove();
        }
    });

    $(' #estrategiasPopsa > option ').each(function (index, option) {
        optionContet = $(this).val();
        if(optionContet == estrategia){
            $(this).remove();
        }
    });
    $(this).closest ('tr').remove ();
});

$(document).on('click', '#btn_editar_popsa', function(){

    proposito = $('#propositoPopsa').val();
    objetivo = $('#objetivoPopsa').val();

    formulario = new FormData($('#actualizaPopsaForm')[0]);

    if (objetivo == '' || objetivo == undefined){
        $('#msjMuestraPopsa').removeClass().addClass('alert alert-danger').text('Por favor ingresa el objetivo de la visita');
        return false;
    }
    var numAcciones1=document.getElementById("tablaAccionesPopsa").rows.length;
    console.log(numAcciones1, 'numacc');
    if (numAcciones1 <= 2 ){
        $('#msjMuestraPopsa').removeClass().addClass('alert alert-danger').text('Por favor agrega una accion por lo menos');
        return false;
    }

    var numEstrategias1=document.getElementById("tablaEstrategiasPopsa").rows.length;
    if (numEstrategias1 <= 2 ){
        $('#msjMuestraPopsa').removeClass().addClass('alert alert-danger').text('Por favor agrega una estrategia por lo menos');
        return false;
    }

    if (objetivo.includes('Obtener pedido')) {
        s = new Agenda();
        if (productos.length > 0) {
            s.editarPopsa();
            formulario.append('arrayProductos', JSON.stringify(productos));
        } else {
            $('#msjMuestraPopsa').removeClass().addClass('alert alert-danger').text('Por favor selecciona que productos serán considerados dentro del pedido');
            return false;
        }
    }

    s = new Agenda();
    s.editarPopsa(formulario);

});


$(document).on('click', '#btnPopsaCancelar', function(){
    idSecuencia = $('#idSecuencia').val();
    s = new Agenda();
    s.obtenerSecuencia(idSecuencia);
   // window.location = url + 'ventas/secuenciaSemanal/';
    window.location.reload();
});

$(document).on('click', '#cerrarModal', function(){
    idSecuencia = $('#idSecuencia').val();
    s = new Agenda();
    s.obtenerSecuencia(idSecuencia);
  //  window.location = url + 'ventas/secuenciaSemanal/';
    window.location.reload();
});


$(document).on('click', '#cerrarModalPopsa', function(){
    idSecuencia = $('#idSecuencia').val();
    s = new Agenda();
    s.obtenerSecuencia(idSecuencia);

});

$(document).on('click', '#cerrarModalDiario', function(){
    window.location.reload();
});

$(document).on('click', '#btnagregarPremisaPopsa', function () {
    descripcion = $('#agregarPremisaPopsa').val();

    // Validar si existe la premisa
    coincidenciaDePremisa = false;
    $('#tablaPremisasPopsa > tbody > tr').each(function (index, tr) {
        input = $(this).find('[name="premisa[]"]');
        if(input.val() == descripcion){
            console.log('Concidencia de la premisa: ',input.val()," = ",descripcion);
            coincidenciaDePremisa = true;
        }
    });
    $('#listapremisasPopsa > li').each(function (index, li) {
        text = $(this).text();
        if(text == descripcion){
            console.log('Concidencia de la premisa: ',text," = ",descripcion);
            coincidenciaDePremisa = true;
        }
    });
    if(coincidenciaDePremisa){ return false }

    if (descripcion == '') {
        return false;
    }


    var i = 0;
    var fila = '<tr id="rowPopsa' + i + '"><td ><input readonly type="text" name="premisa[]" id="premisa' + i + '" class="form-control" value="' + descripcion + '"></td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove">Quitar</button></td></tr>'; //esto seria lo que contendria la fila

    i++;

    $('#tablaPremisasPopsa ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaPremisasPopsa tr").length;
    $("#adicionados").append(nFilas - 1);
    document.getElementById("agregarPremisaPopsa").value = "";
});

$(document).on('click', '.btn_remove', function() {
    var button_id = $(this).attr("id");
    $('#rowPopsa' + button_id + '').remove(); //borra la fila
    $("#adicionados").text("");
    var nFilas = $("#tablaPremisasPopsa tr").length;
    $("#adicionados").append(nFilas - 1);
});

$(document).on('click', '#agregarAccionPopsa', function () {
    descripcion = $('#accionesPopsa').val();
    estrategias = $('#estrategiasPopsa').val();
    responsable = $('#responsablesPopsa').val();
    fecha = $('#fechasPopsa').val();

    var combo = document.getElementById("responsablesPopsa");
    var selected = combo.options[combo.selectedIndex].text;

    if (descripcion == '') {
        return false;
    }
    if (estrategias == '' || estrategias == null) {
        return false;
    }
    if (responsable == '' || responsable == null) {
        return false;
    }
    if (fecha == '' || fecha == null) {
        return false;
    }

    var i = 0;
    var fila = '<tr id="rowAccionPopsa' + i + '" >' +
        '<td >' +
        '<input readonly type="text" name="accionPopsa[]" id="accionPopsa' + i + '" class="form-control" value="' + descripcion + '">' +
        '</td>' +
        '<td >' +
        '<input readonly type="text" name="estrategiaAccion[]" id="estrategiaAccion' + i + '" class="form-control" value="' + estrategias + '">' +
        '</td>' +
        '<td >' +
        '<select type="text" name="responsableAccion[]" id="responsableAccion' + i + '" class="form-control ">' +
        '<option value="' + responsable + '" selected> ' + selected + '</option></select>' +
        '</td>' +
        '<td >' +
        '<input readonly type="text" name="fechaAccion[]" id="fechaAccion' + i + '" class="form-control" value="' + fecha + '">' +
        '</td>' +
        '<td>' +
        '<button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove_accion">Quitar</button>' +
        '</td>' +
        '</tr>';
    i++;

    $('#tablaAccionesPopsa ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaAccionesPopsa tr").length;
    $("#adicionados").append(nFilas - 1);
    document.getElementById("accionesPopsa").value = "";
});

$(document).on('click', '.btn_remove_accion', function() {
    var button_id = $(this).attr("id");
    $('#rowAccionPopsa' + button_id + '').remove();
    $("#adicionados").text("");
    var nFilas = $("#tablaAccionesPopsa tr").length;
    $("#adicionados").append(nFilas - 1);
});

$(document).on('click', '#agregarEstrategiaPopsa', function () {
    descripcion = $('#estrategiaPopsa').val();

    //validar si existe estrategia
    coincidenciaDeEstrategia = false;

    $('#tablaEstrategiasPopsa > tbody > tr').each(function (index, tr) {
        input = $(this).find('[name="estrategia[]"]');
        if(input.val() == descripcion){
            console.log('Concidencia de la estrategia: ',input.val()," = ",descripcion);
            coincidenciaDeEstrategia = true;
        }
    });
    if(coincidenciaDeEstrategia){ return false }

    if (descripcion == '') {
        //abreAlerta('Por favor ingresa una premisa');
        return false;
    }





    var i = 0;
    var fila = '<tr id="rowEstrategiaPopsa' + i + '"><td ><input readonly type="text" name="estrategia[]" id="estrategia' + i + '" class="form-control" value="' + descripcion + '"></td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove_estrategia_popsa">Quitar</button></td></tr>'; //esto seria lo que contendria la fila
    var html = '';
    html += '<option id="optionPopsa' + i + '" value="' + descripcion + '">' + descripcion + '</option>';
    $('#estrategiasPopsa').append(html);

    i++;

    $('#tablaEstrategiasPopsa ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaEstrategiasPopsa tr").length;
    $("#adicionados").append(nFilas - 1);
    document.getElementById("estrategiaPopsa").value = "";
});

$(document).on('click', '.btn_remove_estrategia', function() {
    var button_id = $(this).attr("id");
    $('#rowEstrategiaPopsa' + button_id + '').remove(); //borra la fila
    $('#optionPopsa' + button_id + '').remove(); //borra la fila
    $("#adicionados").text("");
    var nFilas = $("#tablaEstrategiasPopsa tr").length;
    $("#adicionados").append(nFilas - 1);
});

function renderEstrategias(response) {
    var html = '';
    var i = 0;
    if (response.estrategias.length > 0) {
        $.each(response.estrategias, function (registro, item) {
            var fila = '<tr id="rowEstrategiaPopsa' + i + '"><td ><input readonly type="text" name="estrategia[]" id="estrategia' + i + '" class="form-control" value="' + item.estrategia + '"></td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove_estrategia_popsa">Quitar</button></td></tr>'; //esto seria lo que contendria la fila
            var html = '';
            html += '<option id="optionPopsa' + i + '" value="' + item.estrategia + '">' + item.estrategia + '</option>';
            $('#estrategiasPopsa').append(html);

            i++;

            $('#tablaEstrategiasPopsa ').append(fila);
            $("#adicionados").text("");
            var nFilas = $("#tablaEstrategiasPopsa tr").length;
            $("#adicionados").append(nFilas - 1);
        });
    }
}


function renderAcciones(response) {
    var html = '';
    var i = 0;
    if (response.acciones.length > 0) {
        $.each(response.acciones, function (registro, item) {
            var i = 0;
            var fila = '<tr id="rowAccionPopsa' + i + '">' +
                '<td >' +
                '<input readonly type="text" name="accionPopsa[]" id="accionPopsa' + i + '" class="form-control" value="' + item.acciones + '">' +
                '</td>' +
                '<td >' +
                '<input readonly type="text" name="estrategiaAccion[]" id="estrategiaAccion' + i + '" class="form-control" value="' + item.estrategia + '">' +
                '</td>' +
                '<td >' +
                '<select readonly type="text" name="responsableAccion[]" id="responsableAccion' + i + '" class="form-control ">' +
                '<option value="' + item.id_responsable + '" selected> ' + item.Nombre + ' ' + item.Apellido_Paterno + ' '+ item.Apellido_Materno + '</option></select>' +
                '</td>' +
                '<td >' +
                '<input readonly type="text" name="fechaAccion[]" id="fechaAccion' + i + '" class="form-control" value="' + item.fecha + '">' +
                '</td>' +
                '<td>' +
                '<button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove_accion">Quitar</button>' +
                '</td>' +
                '</tr>';
            i++;

            $('#tablaAccionesPopsa ').append(fila);
            $("#adicionados").text("");
            var nFilas = $("#tablaAccionesPopsa tr").length;
            $("#adicionados").append(nFilas - 1);
        });
    }
}

$(document).on('click', '#accion-estrategia', function () {
    idAccion = $(this).attr("data-id");
    obtenerAccionDeEstrategia(idAccion);
    $('#modal-accion-popsa').modal('show');
});

function obtenerAccionDeEstrategia(idAccion) {
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'get',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'obtenerAccionPopsa',
            idAccion: idAccion
        },
        success: function(response){
            if (response.status){
                renderAccionEstrategia(response.accionPopsa);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}

function renderAccionEstrategia(accion) {
    $('#modal-accion-popsa #id-accion-popsa').val(accion.id_acciones_popsa);
    $('#modal-accion-popsa #fecha-accion-estrategia').val(accion.fecha);
    $('#modal-accion-popsa #responsable-accion-estrategia').val(accion.id_responsable);

    $('#modal-accion-popsa #actualizar-anticipacion-accion-popsa').attr("data-prev",accion.acciones);
    $('#modal-accion-popsa #actualizar-anticipacion-accion-popsa').val(accion.acciones);
}

/*$(document).on('blur', '#actualiza-premisa', function () {
    idPremisa = $(this).attr("data-id");
    tipoPremisa =  $(this).attr("data-tipo");
    premisaPrevia =  $(this).attr("data-prev");
    premisaNueva =  $(this).val();
    validarNoVacio = validateNotNullOrEmptyInput(premisaNueva,$(this).closest ('div'));

    if(validarNoVacio && premisaPrevia != premisaNueva){
        modificarPremisa(idPremisa, tipoPremisa, premisaNueva);
    }
});*/

function modificarPremisa(idPremisa, tipoPremisa, premisa) {
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'post',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'modificarPremisaDeAcuerdoATipo',
            idPremisa: idPremisa,
            tipoPremisa:tipoPremisa,
            premisa: premisa
        },
        success: function(response){
            if (response.status){
                abreAlerta(response.mensaje);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}



function modificarEstrategiaPopsa(idEstrategia, estrategia) {
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'post',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'modificarEstartegiaPopsa',
            idEstrategia: idEstrategia,
            estrategia: estrategia
        },
        success: function(response){
            if (response.status){
                abreAlerta(response.mensaje);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}

$(document).on('change paste keyup', '#actualizar-anticipacion-accion-popsa', function () {
    accionPrevia =  $(this).attr("data-prev");
    accionNueva =  $(this).val();

    validarNoVacio= validateNotNullOrEmptyInput(accionNueva,$(this).closest ('div'));
    if(validarNoVacio && accionPrevia != accionNueva){
        $('#btnModificarAccionPopsa').prop("disabled", false);
    } else {
        $('#btnModificarAccionPopsa').prop("disabled", true);
    }
});

$(document).on('click', '#btnModificarAccionPopsa', function () {
    idAccionPopsa = $('#modal-accion-popsa #id-accion-popsa').val();
    fechaAccionPopsa = $('#modal-accion-popsa #fecha-accion-estrategia').val();
    idResponsableAccionPopsa = $('#modal-accion-popsa #responsable-accion-estrategia').val();
    accionPopsa= $('#modal-accion-popsa #actualizar-anticipacion-accion-popsa').val();
    console.log(idAccionPopsa, fechaAccionPopsa, idResponsableAccionPopsa, accionPopsa);
    modificarAccionPopsa(idAccionPopsa, fechaAccionPopsa, idResponsableAccionPopsa, accionPopsa);

});

function modificarAccionPopsa(idAccionPopsa, fechaAccionPopsa, idResponsableAccionPopsa, accionPopsa) {
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'post',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'modificarAccionPopsa',
            idAccionPopsa: idAccionPopsa,
            accionDes: accionPopsa,
            idResponsable: idResponsableAccionPopsa,
            fecha: fechaAccionPopsa
        },
        success: function(response){
            if (response.status){
                $('#modal-accion-popsa').modal('hide');
                abreAlerta(response.mensaje);
                setTimeout(function(){
                    window.location = url + 'ventas/revisionSecuencia/';
                }, 2000);
            }
            else{
                $('#modal-accion-popsa').modal('hide');
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}



function renderAccionesDiario(response) {
    var html = '';
    var i = 0;
    if (response.acciones.length > 0) {
        $.each(response.acciones, function (registro, item) {
            var i = 0;
            var fila = '<tr id="rowAccionDiario' + i + '">' +
                '<td >' +

                '<select readonly=""  name="accionDiario[]" id="accionDiario' + i + '" class="form-control ">' +
                '<option value="' + item.id_acciones_popsa + '" > ' + item.acciones + ' </option></select>' +


              //  '<input readonly type="text" name="accionDiario[]" id="accionDiario' + i + '" class="form-control" value="' + item.acciones + '">' +
                '</td>' +
                '<td >' +
                '<select  name="pocentaje[]" id="porcentaje' + i + '" class="form-control ">' +
                //'<option value="' + item.porcentaje + '" selected> ' + item.porcentaje + ' </option>' +
                '<option value="0" > 0% </option>' +
                '<option value="10" > 10% </option>' +
                '<option value="20" > 20% </option>' +
                '<option value="30" > 30% </option>' +
                '<option value="40" > 40% </option>' +
                '<option value="50" > 50% </option>' +
                '<option value="60" > 60% </option>' +
                '<option value="70" > 70% </option>' +
                '<option value="80" > 80% </option>' +
                '<option value="90" > 90% </option>' +
                '<option value="100" > 100% </option></select>' +
                '</td>' +
                '<td >' +
                '<input type="text" name="fechaAccion[]" id="fechaAccion' + i + '" class="form-control calendario" placeholder="YYYY-MM-DD" autocomplete="off" readonly value="' + item.fecha + '">' +
                '</td>' +
                '</tr>';
            i++;

            $('#tablaAccionesDiario ').append(fila);
            $("#adicionados").text("");
            var nFilas = $("#tablaAccionesDiario tr").length;
            $("#adicionados").append(nFilas - 1);
        });
    }
}

$(document).on('click', '#btnagregarPremisaDiario', function () {
    descripcion = $('#agregarPremisaDiario').val();

    if (descripcion == '') {
        return false;
    }

    var i = 0;
    var fila = '<tr id="rowDiario' + i + '"><td ><input readonly type="text" name="premisaDiario[]" id="premisaDiario' + i + '" class="form-control" value="' + descripcion + '"></td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove_diario">Quitar</button></td></tr>'; //esto seria lo que contendria la fila
    i++;
    $('#tablaPremisasDiario ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaPremisasDiario tr").length;
    $("#adicionados").append(nFilas - 1);
    document.getElementById("agregarPremisaDiario").value = "";
});

$(document).on('click', '.btn_remove_diario', function() {
    var button_id = $(this).attr("id");
    $('#rowDiario' + button_id + '').remove(); //borra la fila
    $("#adicionados").text("");
    var nFilas = $("#tablaPremisasDiario tr").length;
    $("#adicionados").append(nFilas - 1);
});

$(document).on('click', '#agregarAccionDiario', function () {
    descripcion = $('#accionesDiario').val();
    estrategias = $('#estrategiasAccionDiario').val();
    responsable = $('#responsablesDiario').val();
    fecha = $('#fechasDiario').val();

    var combo = document.getElementById("responsablesDiario");
    var selected = combo.options[combo.selectedIndex].text;

    var comboEstrastegias = document.getElementById("estrategiasAccionDiario");
    var selectedEstrategias = comboEstrastegias.options[comboEstrastegias.selectedIndex].text;

    if (descripcion == '') {
        return false;
    }
    if (estrategias == '' || estrategias == null) {
        return false;
    }
    if (responsable == '' || responsable == null) {
        return false;
    }
    if (fecha == '' || fecha == null) {
        return false;
    }

    var i = 0;
    var fila = '<tr id="rowNuevaAccionDiario' + i + '" >' +
        '<td >' +
        '<input readonly type="text" name="nuevaAccion[]" id="nuevaAccion' + i + '" class="form-control" value="' + descripcion + '">' +
        '</td>' +
        '<td >' +
        '<select type="text" name="nuevaEstrategiaAccion[]" id="nuevaEstrategiaAccion' + i + '" class="form-control ">' +
        '<option value="' + estrategias + '" selected> ' + selectedEstrategias + '</option></select>' +
        '</td>' +
        '<td >' +
        '<select type="text" name="nuevoResponsable[]" id="nuevoResponsable' + i + '" class="form-control ">' +
        '<option value="' + responsable + '" selected> ' + selected + '</option></select>' +
        '</td>' +
        '<td >' +
        '<input readonly type="text" name="nuevaFecha[]" id="nuevaFecha' + i + '" class="form-control" value="' + fecha + '">' +
        '</td>' +
        '<td>' +
        '<button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove_nueva_accion_Diario">Quitar</button>' +
        '</td>' +
        '</tr>';

    i++;


    $('#tablaNuevasAccionesDiario ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaNuevasAccionesDiario tr").length;
    $("#adicionados").append(nFilas - 1);
    document.getElementById("accionesDiario").value = "";
});

$(document).on('click', '.btn_remove_nueva_accion_Diario', function() {
    var button_id = $(this).attr("id");
    $('#rowNuevaAccionDiario' + button_id + '').remove();
    $("#adicionados").text("");
    var nFilas = $("#tablaNuevasAccionesDiario tr").length;
    $("#adicionados").append(nFilas - 1);
});

$('#btnEliminaClienteSecuencia').on('click', function(){

    idSecuencia = $('#idSecuencia').val();
    tipo = $('#tipoCierre').val();
    idCliente = $('#idClienteCierre').val();
    console.log(idSecuencia, 'idSecuencia');
    console.log(tipo, 'tipo');
    console.log(idCliente, 'idCliente');

    s = new Agenda();
    s.eliminarClientePopsa( idSecuencia, tipo, idCliente);
});



$.datepicker.regional['es'] = {
    closeText: 'Cerrar',
    prevText: '<Ant',
    nextText: 'Sig>',
    currentText: 'Hoy',
    monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
    monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
    dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
    dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié', 'Juv', 'Vie', 'Sáb'],
    dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
    weekHeader: 'Sm',
    dateFormat: 'yy-mm-dd',
    firstDay: 1,
    isRTL: false,
    minDate: 0,
    showMonthAfterYear: false,
    yearSuffix: '',
    changeMonth: true,
    changeYear: true
};
$.datepicker.setDefaults($.datepicker.regional['es']);
$('.calendario').datepicker();

function validateNotNullOrEmptyInput(val, element) {
    if (val != ""){
        element.removeClass('has-error');
        return true;
    } else{
        element.addClass('has-error');
        return false;
    }
}

$('.btnEliminaCliente').on('click', function(){

    idCliente = $(this).parent().parent().attr('data-filacliente');
    tipo = $(this).parent().parent().attr('data-filatipo');
    idSecuencia = $('#idSecuencia').val();
    // s = new Agenda();
   // s.eliminarClientePopsa( idSecuencia, tipo, idCliente);
    $('#modalEliminarCliente').modal('show');
    $('#idClienteEliminar').val(idCliente);
    $('#tipoEliminar').val(tipo);
    $('#idSecuenciaEliminar').val(idSecuencia);
});

$('#btnConfirmarEliminar').on('click', function(){

    idCliente =  $('#idClienteEliminar').val();
    tipo = $('#tipoEliminar').val();
    idSecuencia =  $('#idSecuenciaEliminar').val();
     s = new Agenda();
     s.eliminarClientePopsa( idSecuencia, tipo, idCliente);

});


$('#btnContinuar').on('click', function(){
     clientes = [];
      tipo = [];

      idSecuencia = $('#idSecuencia').val();
      $.each($('input[type=checkbox]:checked'), function(){
          clientes.push($(this).val());
          tipo.push($(this).attr('data-tipo'));
      })

      if(clientes.length == 0){
          abreAlerta('selecciona al menos a un cliente o prospecto');
      } else {
          s = new Agenda();
          s.confirmarSecuenciaDiaria(clientes, tipo, idSecuencia);
      }


});

$('.btnCambiarDia').on('click', function(){
    idCliente = $(this).parent().parent().attr('data-filacliente');
    tipo = $(this).parent().parent().attr('data-filatipo');
    detalleSecuencia = $(this).parent().parent().attr('data-detalleSecuencia');
    idSecuencia = $('#idSecuencia').val();



    $('#modal-cambiar-fecha').modal('show');
    $('#idClienteCambiarFecha').val(idCliente);
    $('#tipoCambiarFecha').val(tipo);
    $('#idSecuenciaCambiarFecha').val(idSecuencia);
    $('#idDetalleSecuenciaCambiarFecha').val(detalleSecuencia);

});

$('#btnCambiarFecha').on('click', function(){

  idCliente =  $('#idClienteCambiarFecha').val();
  idSecuencia = $('#idSecuenciaCambiarFecha').val();
  detalleSecuencia = $('#idDetalleSecuenciaCambiarFecha').val();
  cambiarFecha = $('#cambiarfecha').val();
  horaCita = $('#horaCita').val();
  tipo = $('#tipoCambiarFecha').val();

  fecha = cambiarFecha + ' ' + horaCita;

    if (cambiarFecha == '' || cambiarFecha == undefined){
        $('#msjCambiarFecha').removeClass().addClass('alert alert-danger').text('Por favor ingresa una fecha');
        return false;
    }

    if (horaCita == '' || horaCita == undefined){
        $('#msjCambiarFecha').removeClass().addClass('alert alert-danger').text('Por favor ingresa una hora');
        return false;
    }

    s = new Agenda();
    s.cambiarFechaPopsaDiario(detalleSecuencia, fecha, idSecuencia, tipo, idCliente );


});

$(document).on('keyup', '#buscarCliente', function () {
    cliente = $(this).val();
    idRol = $('#idRol').val();

    s = new Agenda();
    s.buscarCliente(cliente,  idRol);
});

$(document).on('keyup', '#buscarSospechoso', function () {
    cliente = $(this).val();
    idRol = $('#idRol').val();

    s = new Agenda();
    s.buscarSospechoso(cliente,  idRol);
});

$('.btnDevolverSecuencia').on('click', function(){
    idSecuencia = $(this).attr('data-secuencia');
    s = new Agenda();
    s.devolverSecuencia(idSecuencia);
});

$(document).on('click', '#ver-proposito', function () {
    idPopsa = $(this).attr("data-id");
    obtenerPropositoPopsa(idPopsa);
    $('#modal-proposito').modal('show');
});

function obtenerPropositoPopsa(idPopsa) {
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'get',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'obtenerPropositoPopsa',
            idPopsa: idPopsa
        },
        success: function(response){
            if (response.status){
                renderProposito(response.proposito);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}

function renderProposito(popsa) {
   // $('#modal-proposito #Id_Popsa').val(proposito.Id_Popsa);

    $('#modal-proposito #actualizar-proposito-popsa').val(popsa.Razones);
    $('#modal-proposito #id-accion-popsa').val(popsa.Id_Popsa);
    $('#modal-objetivo #actualizar-objetivo-popsa').val(popsa.Objetivo_Visita);
    $('#modal-objetivo #id-accion-popsa').val(popsa.Id_Popsa);
    //$('#modal-accion-popsa #responsable-accion-estrategia').val(accion.id_responsable);

  //  $('#modal-accion-popsa #actualizar-anticipacion-accion-popsa').attr("data-prev",accion.acciones);
   // $('#modal-accion-popsa #actualizar-anticipacion-accion-popsa').val(accion.acciones);
}


$(document).on('click', '#ver-objetivo', function () {
    idPopsa = $(this).attr("data-detalle");
    obtenerPropositoPopsa(idPopsa);
    $('#modal-objetivo').modal('show');
});

$(document).on('click', '#btnModificarObjetivoPopsa', function () {
    campo = $(this).attr('data-campo');
    idAccionPopsa = $('#modal-objetivo #id-accion-popsa').val();
    objetivoPopsa= $('#modal-objetivo #actualizar-objetivo-popsa').val();
    s = new Agenda();
    s.actualizaPopsa(idAccionPopsa, campo, objetivoPopsa);
    setTimeout(window.location.reload(), 2000);
});

$(document).on('click', '#actualiza-premisa', function () {
    premisa = $(this).val();
    idPremisa = $(this).attr("data-id");
    tipo = $(this).attr("data-tipo");
    $('#modal-premisa #actualizar-premisa-popsa').val(premisa);
    $('#modal-premisa #id-premisa').val(idPremisa);
    $('#modal-premisa #tipo').val(tipo);
    $('#modal-premisa').modal('show');
});

$(document).on('click', '#btnModificarPremisaPopsa', function () {
    idPremisa =  $('#modal-premisa #id-premisa').val();
    tipo =  $('#modal-premisa #tipo').val();
    premisaNueva =  $('#modal-premisa #actualizar-premisa-popsa').val();
    modificarPremisa(idPremisa, tipo, premisaNueva);
    setTimeout(window.location.reload(), 2000);

});

$(document).on('click', '#actualiza-estrategia-popsa', function () {
    idEstrategia = $(this).attr("data-id");
    estrategiaPrevia =  $(this).attr("data-prev");


    $('#modal-estrategia #actualizar-estrategia-popsa').val(estrategiaPrevia);
    $('#modal-estrategia #id-estrategia').val(idEstrategia);
    //$('#modal-premisa #tipo').val(tipo);
    $('#modal-estrategia').modal('show');
});

$(document).on('click', '#btnModificarEstrategiaPopsa', function () {
    idEstrategia =  $('#modal-estrategia #id-estrategia').val();
    estrategia =  $('#modal-estrategia #actualizar-estrategia-popsa').val();
    modificarEstrategiaPopsa(idEstrategia, estrategia);
    setTimeout(window.location.reload(), 2000);
});

$(document).on('click', '#btnModificarPropositoPopsa', function () {
    campo = $(this).attr('data-campo');
    idAccionPopsa = $('#modal-proposito #id-accion-popsa').val();
    propositoPopsa= $('#modal-proposito #actualizar-proposito-popsa').val();
    s = new Agenda();
    s.actualizaPopsa(idAccionPopsa, campo, propositoPopsa);
    setTimeout(window.location.reload(), 2000);
});

$(document).on('change', '.tipoVisita', function(){
    tipoVisita = $('input:radio[name=tipoVisita]:checked').val();
    latitud = $('#latitud').val();
    longitud = $('#longitud').val();
    console.log(longitud, " longitud visita");


    if(tipoVisita == "cita" && latitud == "" &&  longitud == ""){
        $('.mostrarLatitud').show();
    }else{
        $('.mostrarLatitud').hide();
    }



});

$(document).on('click', '#btnguardaTipoVisita', function(){

   tipoVisita = $('input:radio[name=tipoVisita]:checked').val();
   latitud = $('#latitud').val();
   longitud = $('#longitud').val();

   if(tipoVisita == "cita"){
       if (latitud == '' || latitud == undefined){
           $('#msjtipoVisita').removeClass().addClass('alert alert-danger').text('Por favor ingresa la latitud');
           return false;
       }

       if (longitud == '' || longitud == undefined){
           $('#msjtipoVisita').removeClass().addClass('alert alert-danger').text('Por favor ingresa la longitud');
           return false;
       }
   }

    validadSucursalPachuca = validarDirecciones(latitud, 20.124055, longitud, -98.812632 );
    validadSucursalPuebla = validarDirecciones(latitud,    19.081482, longitud, -98.154707);
    validadSucursalQueretaro= validarDirecciones(latitud,   20.751169, longitud, -100.446526);
   if(!validadSucursalPachuca || !validadSucursalPuebla ){
       $('#msjtipoVisita').removeClass().addClass('alert alert-danger').text('Coordenadas no validas');
       return false;
   }

    $('#modalTipoVisita').modal('hide');
    $('#popsa').modal('show');

    console.log(tipoVisita, " tipo visita");

    $('#tipoVisitaPopsa').val(tipoVisita);
    $('#latitudPopsa').val(latitud);
    $('#longitudPopsa').val(longitud);



});

function validarDirecciones(lat2, lat1, lon2, lon1) {
    const R = 6378.137;
    const dLat = rad(lat2 - lat1);
    const dLong = rad(lon2 - lon1);
    const a = Math.sin(dLat / 2) * Math.sin(dLat / 2) + Math.cos(rad(- lat1)) * Math.cos(rad(lat2)) * Math.sin(dLong / 2) * Math.sin(dLong / 2);
    const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
    const d = R * c;
    distancia = d.toFixed(3) * 1000;
    if(distancia <= 200){
        $('#msjtipoVisita').removeClass().addClass('alert alert-danger').text(' Coordenadas no validas');
        return false;
    } else {
        return true;
    }
}

function  rad(x) {
    return x * Math.PI / 180;
}


$(document).on('click', '#btnguardaTipoVisitaEdicion', function(){

    tipoVisita = $('input:radio[name=tipoVisitaEdicion]:checked').val();
    latitud = $('#latitudEdicion').val();
    longitud = $('#longitudEdicion').val();

    if(tipoVisita == "cita"){
        if (latitud == '' || latitud == undefined){
            $('#msjtipoVisita').removeClass().addClass('alert alert-danger').text('Por favor ingresa la latitud');
            return false;
        }

        if (longitud == '' || longitud == undefined){
            $('#msjtipoVisita').removeClass().addClass('alert alert-danger').text('Por favor ingresa la longitud');
            return false;
        }
    }

    validadSucursalPachuca = validarDirecciones(latitud, 20.124055, longitud, -98.812632 );
    validadSucursalPuebla = validarDirecciones(latitud,  19.081482, longitud, -98.154707);
    validadSucursalQueretaro= validarDirecciones(latitud, 20.751169, longitud, -100.446526);
    if(!validadSucursalPachuca || !validadSucursalPuebla ){
        $('#msjtipoVisita').removeClass().addClass('alert alert-danger').text('Coordenadas no validas');
        return false;
    }


    $('#modalTipoVisitaEdicion').modal('hide');
    $('#mostrarPopsa').modal('show');

    console.log(tipoVisita, " tipo visita");

    $('#tipoVisitaMostrarPopsa').val(tipoVisita);
    $('#latitudMostrarPopsa').val(latitud);
    $('#longitudMostrarPopsa').val(longitud);



});

$(document).on('change', '.tipoVisitaEdicion', function(){
    tipoVisita = $('input:radio[name=tipoVisitaEdicion]:checked').val();
    latitud = $('#latitudEdicion').val();
    longitud = $('#longitudEdicion').val();
    console.log(longitud, " longitud visita");


    if(tipoVisita == "cita" && latitud == "" &&  longitud == ""){
        $('.mostrarLatitudEdicion').show();
    }else{
        $('.mostrarLatitudEdicion').hide();
    }



});

$(document).on('change', '#usuario', function(){

    idUsuario = $(this).val();

    if(idUsuario == 0 ){
        abreAlerta('Por favor selecciona un usuario');
        return false;
    }
    s = new Agenda();
    s.seleccionarUsuario(idUsuario);
});

$('#btnEliminaCita').on('click', function(){

    idActividadAgenda = $('#idEliminaActividadCita').val();
    s = new Agenda();
    s.eliminaActividadCita(idActividadAgenda);
});

function setError(elem, msg){
    $('span.error').remove();
    divp = elem.parents('.form-group').addClass('has-error');
    padre = elem.parent();


    if(elem.hasClass('total')) padre = elem.parent().parent();
    //if(elem.attr('type') == 'radio') padre = elem.parents('.btn-group').parent();
    padre.append('<span class="help-block error" style="color: red">'+msg+'</span>');
    elem.focus();
}
