/**
 * SeguridadHigiene.js
 * Clase y funciones para el módulo Seguridad e higiene
 * @copyright (c) 2018 Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package inicio
 */


// $(document).ready(function () {
// });


$(document).on('click', '#guardarAccionPopsa', function(){
    idAccionPopsa = $('#idAccionPopsa').val();
    observacion = $('#observaciones').val();
    porcentaje = $('#porcentaje').val();
    fechaNueva = $('#fecha').val();
    fechaPrevia = $('#fecha').data('prev');

    validarFecha = validarFechaLimite(fechaPrevia, fechaNueva, $('#fecha-group'));
    if(validarFecha){
        actualizarAccionPopsa(idAccionPopsa, porcentaje, observacion, fechaNueva);
    }
});

function actualizarAccionPopsa(idAccionPopsa, porcentaje, observaciones, fecha){
    accionPopsa = {
        id_accion_popsa: idAccionPopsa,
        porsentaje: porcentaje,
        status: determinarStatusAccionPopsa(porcentaje),
        observaciones: observaciones,
        fecha: fecha
    };

    guardarCambiosAccionPopsa(accionPopsa);
}

function determinarStatusAccionPopsa(porcentaje) {
    if(porcentaje == 100){
        return 'finalizado';
    } else {
        return 'progreso';
    }
}

function guardarCambiosAccionPopsa(accionPopsa) {
    $.post(
        url + 'application/inicio/controllers/AjaxAccionesPopsa.php',
        {
            accion: 'editarAccionPopsa',
            accionPopsa: JSON.stringify(accionPopsa)
        },
        function (response) {
            if (response.status) {
                abreAlerta(response.mensaje);
                setTimeout(function(){
                    window.location = url + 'inicio/accionesPopsa/';
                }, 2000);
            } else {
                abreAlerta(response.mensaje);
            }
        },
        'json');
}

function validarFechaLimite(fechaPrevia, fechaNueva, element){
    fechaPrevia = new Date(fechaPrevia);
    fechaNueva = new Date(fechaNueva);
    fechaPrevia.setHours(0,0,0,0);
    fechaNueva.setHours(0,0,0,0);
    if (fechaNueva >= fechaPrevia){
        element.removeClass('has-error');
        return true;
    } else{
        abreAlerta('La fecha limite debe ser mayor o igual a la fecha previamente designada');
        element.addClass('has-error');
        return false;
    }
}



