/**
 * SeguridadHigiene.js
 * Clase y funciones para el módulo Seguridad e higiene
 * @copyright (c) 2018 Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package inicio
 */


$(document).ready(function () {
});


$(document).on('click', '#guardar-actividad', function(){
    guardarCambiosDeActividad();
});

function guardarCambiosDeActividad() {
    actividad = {
        id_actividad: $('#id-actividad-no-conformidad').val(),
        fecha_inicio: $('#fecha-inicio').val(),
        fecha_limite: $('#fecha-fin').val(),
        id_responsable: $('#responsable').val(),
        porcentaje:  $('#porcentaje').val()
    };

    validadorInicio = validarNoEmptyString(actividad.fecha_inicio,$('#inicio-group'));
    validadorFin = validarNoEmptyString(actividad.fecha_limite,$('#fin-group'));
    validadorFechas = validarFechaLimite(actividad.fecha_inicio, actividad.fecha_limite, $('#fin-group'));

    if (validadorInicio && validadorFin && validadorFechas){
        if( actividad.fecha_inicio != $('#inicio-group').data('prev') ||
            actividad.fecha_limite != $('#fin-group').data('prev') ||
            actividad.id_responsable != $('#responsable-group').data('prev') ||
            actividad.porcentaje != $('#porcentaje-group').data('prev')
            ){
            actualizarActividad(actividad);
        }
        else{
            abreAlerta('No hay cambios que guardar')
        }
    }
}

function actualizarActividad(actividad){
    $.post(
            url + 'application/inicio/controllers/AjaxSeguridadHigieneController.php',
            {
                accion: 'editarActividadNoConformidad',
                actividad: JSON.stringify(actividad)
            },
            function (resp) {
                if (resp.status) {
                    actualizacionAutomaticaStatusTareaNoConformidad();
                } else {
                    abreAlerta(resp.mensaje);
                }
            },
            'json');
}

function actualizacionAutomaticaStatusTareaNoConformidad() {
    idTareaNoConformidad = $('#id-tarea-no-conformidad').val();
    $.post(
        url + 'application/inicio/controllers/AjaxSeguridadHigieneController.php',
        {
            accion: 'actualizaStatusTareaNoConformidadAutomaticamente',
            tareaNoConformidad: idTareaNoConformidad
        },
        function (resp) {
            if (resp.status) {
                abreAlerta('Se guardaron los cambios de la actividad correctamente');
                setTimeout(function(){
                    window.location = url + 'inicio/editarNoConformidad/'+ idTareaNoConformidad +'/';
                }, 2000);
            } else {
                abreAlerta(resp.mensaje);
            }
        },
        'json');
}

function validarFechaLimite(fechaInicio, fechaFin, element){
    fechaInicio = new Date(fechaInicio);
    fechaFin = new Date(fechaFin);
    fechaInicio.setHours(0,0,0,0);
    fechaFin.setHours(0,0,0,0);
    if (fechaFin > fechaInicio){
        element.removeClass('has-error');
        return true;
    } else{
        abreAlerta('La fecha limite debe ser mayor a la fecha de inicio');
        element.addClass('has-error');
        return false;
    }
}

function validarNoEmptyString(responsable, element) {
    if (responsable != ""){
        element.removeClass('has-error');
        return true;
    } else{
        element.addClass('has-error');
        return false;
    }
}

function formatoStatus(status){
    if(status == "pendiente") {
        return "Pendiente";
    }
    if(status == "progreso") {
        return "En Ejecución";
    }
    if(status == "finalizado") {
        return "Terminada";
    }
}
