/**
 * sistemaCalidadHigiene.js
 * Clase y funciones para el módulo Seguridad e higiene
 * @copyright (c) 2018 Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package inicio
 */

$(document).ready(function () {
    idTareaNoConformidad = $('#id-tarea-no-conformidad').val();
    cargarActividadesNoConformidad(idTareaNoConformidad);

});

$(document).on('click', '#agregar-actividad', function(){
    agregarActividad();
});

function agregarActividad() {
    botonAgregar = $('#gregar-actividad');

    idTareaNoConformidad = $('#id-tarea-no-conformidad').val();
    fechaInicio = $('#agregar-fecha-inicio').val();
    fechaFin = $('#agregar-fecha-fin').val();
    descripcion = $('#agregar-descripcion').val();
    idresponsable = $('#agregar-responsable').val();

    actividad = {
        idTarea: idTareaNoConformidad,
        descripcion: descripcion,
        responsable: idresponsable,
        fechaInicio: fechaInicio,
        fechaFin: fechaFin
    };
    botonAgregar.addClass('disabled');
    validadorDescripcion = validarEmptyString(descripcion, $('#descripcion-group'));
    validadorinicio = validarEmptyString(fechaInicio, $('#inicio-group'));
    validadorFin = validarEmptyString(fechaFin, $('#fin-group'));
    validarFechas = validarFechaLimite(fechaInicio,fechaFin,$('#fin-group'));
    validadorResponsable = validarEmptyString(idresponsable, $('#responsable-group'));

    if (validadorDescripcion && validadorinicio && validadorFin && validarFechas && validadorResponsable){
        // console.log(actividad);
        $.post(
            url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
            {
                accion: 'agregarActividadNoConformidad',
                actividad: JSON.stringify(actividad)
            },
            function (resp) {
                botonAgregar.removeClass('disabled');
                if (resp.status) {
                    abreAlerta(resp.mensaje);
                    setTimeout(function(){ location.reload(); }, 2000);
                } else {
                    abreAlerta(resp.mensaje);
                }
            },
            'json');
    }

}

function cargarActividadesNoConformidad(idTareaNoconformidad) {
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'obtenerActividadesNoConformidadPorTarea',
            tareaNoConformidad: idTareaNoconformidad
        },
        success: function(response){
            if (response.status){
                renderActividades(response);
                renderActividadesProgramadas(response);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}

function renderActividades(response){
    tabla = $('#actividadesNoConformidad tbody');
    tabla.html('');
    actividades = response.actividades;
    if (actividades.length > 0){
        $.each(actividades, function(registro, item){
            var tr = $('<tr data-id ="'+item.id_actividades_de_no_conformidad+'" ></tr>');

            tr.append('<td id="descipcion">' + item.descripcion + '</td>');
            tr.append('<td id="inicio">' + item.fecha_inicio + '</td>');
            tr.append('<td id="limite">' + item.fecha_limite + '</td>');
            tr.append('<td id="limite">' + item.nombre_responsable + '</td>');
            tr.append('<td id="limite">' + item.porcentaje + '%' +'</td>');
            tr.append('<td id="status" data-prev ="'+ item.status +'" >' + formatoStatus(item.status) + '</td>');
            tr.append('<td><a href="' + url + 'inicio/editarActividadNoConformidadSistemaCalidad/'+item.id_actividades_de_no_conformidad+'/" title="Editar actividad"><span class="fa fa-edit"></span></a></td>');

            tr.appendTo(tabla);

        });
    }
    else{
        var tr = $('<tr></tr>');
        tr.append('<td colspan="7">No se encontraron actividades</td>');
        tr.appendTo(tabla);
    }

}

$(document).on('click', '#cerrar-tarea', function(){
    cerrarTareaNoConformidad();
});

$(document).on('click', '#cambiar-frecuencia', function(){
    $('#cambiar-frecuencia-modal').modal('show');
});

$(document).on('change', '#frecuencia', function(){

   frecuencia = $('#frecuencia').val();
    console.log("cambio", frecuencia);
   if(frecuencia == "evento"){
       $(".fechainicio").css("display", "none");
   }else {
       $(".fechainicio").css("display", "block");
   }

});

$(document).on('click', '#btnCambiarFrecuencia', function(){

    $('span.error').remove();
    $('.has-error').removeClass('has-error');
    idTareaNoConformidad = $('#id-tarea-no-conformidad').val();
    frecuencia = $('#frecuencia').val();
    fecha = $('#fecha').val();



    if(frecuencia != "evento"){
        console.log(fecha, " fecha");
        if(fecha == null || fecha == "" ){
            console.log(fecha, " fecha");
            setError($('#fecha'),'Ingresa una fecha');
            return false;
        }
    }

    // if(frecuencia != "evento"){
    //     var d = new Date();
    //
    //     Fuente: https://www.iteramos.com/pregunta/12517/como-obtengo-el-mes-y-la-fecha-de-javascript-en-2-digitos-formato
    //     var strDate = d.getFullYear() + "-" + ("0" + (d.getMonth() + 1)).slice(-2) + "-" + d.getDate();
    //     console.log(strDate, " fechahoy");
    //     if(strDate> fecha ){
    //
    //         setError($('#fecha'),'La fecha de inicio debe ser mayor a la de hoy');
    //         return false;
    //     }else{
    //         cambiarFrecuenciaNoConformidad(idTareaNoConformidad, frecuencia, fecha);
    //     }
    //
    // } else {
        cambiarFrecuenciaNoConformidad(idTareaNoConformidad, frecuencia, fecha);
    // }


});

function setError(elem, msg){
    divp = elem.parents('.form-group').addClass('has-error');
    divp.find('span.error').remove();

    padre = elem.parent();
    if(elem.hasClass('calendario')) padre = elem.parent().parent();
    if(elem.attr('type') == 'radio') padre = elem.parents('.btn-group').parent();
    padre.append('<span class="help-block error">'+msg+'</span>');
    elem.focus();
}

function cambiarFrecuenciaNoConformidad(idTareaNoconformidad, frecuencia, fecha ) {
    $('#cambiar-frecuencia-modal').modal('hide');
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'cambiarFrecuenciaNoConformidad',
            idTareaNoconformidad: idTareaNoconformidad,
            frecuencia: frecuencia,
            fecha: fecha

        },
        success: function(response){
                abreAlerta(response.mensaje);
            setTimeout(function(){
                window.location.reload();
            }, 700);

        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}



function cerrarTareaNoConformidad() {
    idTareaNoConformidad = $('#id-tarea-no-conformidad').val();
    $.post(
        url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
        {
            accion: 'cerrarTareaNoConformidad',
            tareaNoConformidad: idTareaNoConformidad
        },
        function (resp) {
            if (resp.status) {
                abreAlerta('Se cerró correctamente la tarea de no conformidad');
                setTimeout(function(){
                    window.location = url + 'inicio/sistemaCalidadHigiene/';
                }, 2000);
            } else {
                abreAlerta(resp.mensaje);
            }
        },
        'json');
}


function formatNull(element){
    if( element == "" ) {
        return null;
    } else {
        return element;
    }
}

function validarFechaLimite(fechaInicio, fechaFin, element){
    fechaInicio = new Date(fechaInicio);
    fechaFin = new Date(fechaFin);
    fechaInicio.setHours(0,0,0,0);
    fechaFin.setHours(0,0,0,0);
    if (fechaFin > fechaInicio){
        element.removeClass('has-error');
        return true;
    } else{
        abreAlerta('La fecha limite debe ser mayor a la fecha de inicio');
        element.addClass('has-error');
        return false;
    }
}

function validarEmptyString(responsable, element) {
    if (responsable != ""){
        element.removeClass('has-error');
        return true;
    } else{
        element.addClass('has-error');
        return false;
    }
}

function validarNoNull(responsable, elementResponsable) {
    if (responsable != null){
        element.removeClass('has-error');
        return true;
    } else{
        elementResponsable.addClass('has-error');
        return false;
    }
}

function formatoStatus(status){
    if(status == "pendiente") {
        return "Pendiente";
    }
    if(status == "progreso") {
        return "En Ejecución";
    }
    if(status == "finalizado") {
        return "Terminada";
    }
}

$(document).on('click', '#mostrar-actividades-programadas', function(){
    $('#actividades-programadas-modal').modal('show');

});

function renderActividadesProgramadas(response){
    tabla = $('#tareas-no-conformidad-programadas tbody');
    tabla.html('');
    actividades = response.actividadesProgramadas;
    if (actividades.length > 0){
        $.each(actividades, function(registro, item){
            var tr = $('<tr data-id ="'+item.id_actividades_de_no_conformidad+'" ></tr>');

            tr.append('<td id="descipcion">' + item.descripcion + '</td>');
            tr.append('<td><button type="button" data-id ="' + item.id_actividades_de_no_conformidad + '" id="eliminarProgramacion' + item.id_actividades_de_no_conformidad + '" class="btn btn-danger rechazar" >Eliminar</button></td>');

            tr.appendTo(tabla);

        });
    }
    else{
        var tr = $('<tr></tr>');
        tr.append('<td colspan="7">No se encontraron actividades programadas</td>');
        tr.appendTo(tabla);
    }

}

$(document).on('click', '.rechazar', function () {
    var idActividadAsignada = $(this).data('id');
    cambiarActividadNoProgramable(idActividadAsignada);
});

function cambiarActividadNoProgramable(idActividadAsignada) {
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'cambiarActividadNoProgramable',
            idActividadAsignada: idActividadAsignada
        },
        success: function(response){
            if (response.status){
                idTareaNoConformidad = $('#id-tarea-no-conformidad').val();
                cargarActividadesNoConformidadProgramadas(idTareaNoConformidad);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}

function cargarActividadesNoConformidadProgramadas(idTareaNoconformidad) {
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'obtenerActividadesNoConformidadPorTarea',
            tareaNoConformidad: idTareaNoconformidad
        },
        success: function(response){
            if (response.status){

                renderActividadesProgramadas(response);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}




