/**
 * Secuencias.js
 * Clase y funciones para el módulo de secuencias
 * @copyright (c) 2015 Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package ventas
 */

$(document).on('click', '#mostrarAccionesCompletas', function () {
    idPopsa = $(this).attr("data-id");

    obtenerAccionesPopsa(idPopsa);
});

function obtenerAccionesPopsa(idPopsa){
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'get',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'obtenerAccionesIniciales',
            idPopsa: idPopsa
        },
        success: function(response){
            if (response.status){
                mostrarAccionPopsaEnModal(response.accionPopsa);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}

function mostrarAccionPopsaEnModal(accionesResponse){
    tabla = $('#modalAccionesCompletadasPopsa #tabla-acciones-completas tbody');
    tabla.html('');
    var filas;
    if (accionesResponse.length > 0){
        $.each(accionesResponse, function (registro, item) {
            filas = filas +
                '<tr>' +
                '<td>' + item.fecha + '</td>' +
                '<td>' + item.acciones + '</td>' +
                '<td>' + item.Nombre + ' ' + item.Apellido_Paterno + ' ' + item.Apellido_Materno + '</td>' +
                '<td>' + item.porcentaje + '%' + '</td>' +
                '</tr>';
        });
    } else {
        filas =
            '<tr>' +
            '<td>' + 'No hay acciones' + '</td>' +
            '</tr>';
    }
    tabla.append(filas);
    $('#modalAccionesCompletadasPopsa').modal('show');
}

function obtenerEstrategias(idPopsa){
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'get',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'obtenerEstrategias',
            idPopsa: idPopsa
        },
        success: function(response){
            if (response.status){
                mostrarEstrategiasEnModal(response.estrategiaPopsa);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}

function mostrarEstrategiasEnModal(estrategiasResponse){
    tabla = $('#modalEstrategiasPopsa #tabla-estrategias tbody');
    tabla.html('');
    var filas;
    if (estrategiasResponse.length > 0){
        $.each(estrategiasResponse, function (registro, item) {
            filas = filas +
                '<tr>' +
                '<td>' + item.estrategia + '</td>' +
                '</tr>';
        });
    } else {
        filas =
            '<tr>' +
            '<td>' + 'No hay acciones' + '</td>' +
            '</tr>';
    }
    tabla.append(filas);
    $('#modalEstrategiasPopsa').modal('show');
}


$(document).on('click', '#mostrarAccionesNoCompletas', function () {
    idPopsa = $(this).attr("data-id");

    obtenerAccionesNoCompletasPopsa(idPopsa);
});

function obtenerAccionesNoCompletasPopsa(idPopsa){
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'get',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'obtenerAccionesCierre',
            idPopsa: idPopsa
        },
        success: function(response){
            if (response.status){
                mostrarAccionNoCompletaPopsaEnModal(response.accionPopsa);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}

function mostrarAccionNoCompletaPopsaEnModal(accionesResponse){
    tabla = $('#modalAccionesNoCompletadasPopsa #tabla-acciones-Nocompletas tbody');
    tabla.html('');
    var filas;
    if (accionesResponse.length > 0){
        $.each(accionesResponse, function (registro, item) {
            filas = filas +
                '<tr>' +
                '<td>' + item.fecha + '</td>' +
                '<td>' + item.acciones + '</td>' +
                '<td>' + item.Nombre + ' ' + item.Apellido_Paterno + ' ' + item.Apellido_Materno + '</td>' +
                '<td>' + item.porcentaje + '%' + '</td>' +
                '</tr>';
        });
    } else {
        filas =
            '<tr>' +
            '<td>' + 'No hay acciones' + '</td>' +
            '</tr>';
    }
    tabla.append(filas);
    $('#modalAccionesNoCompletadasPopsa').modal('show');
}
















$(document).on('click', '#mostrarPremisas', function () {
    idPopsa = $(this).attr("data-id");
    obtenerPremisasPopsa(idPopsa);
});

$(document).on('click', '#mostrarEstrategias', function () {
    idPopsa = $(this).attr("data-id");
    obtenerEstrategias(idPopsa);
});

function obtenerPremisasPopsa(idPopsa){
    $.ajax({
        url: url + 'application/ventas/controllers/AjaxSecuenciasController.php',
        type: 'get',
        dataType: 'json',
        cache: false,
        data: {
            accion: 'obtenerPremisasPopsa',
            idPopsa: idPopsa
        },
        success: function(response){
            if (response.status){
                mostrarPremisasEnModal(response.premisas);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        },
        timeout: 15000
    });
}

function mostrarPremisasEnModal(premisasResponse){
    tabla = $('#modalPremisas #tabla-premisas tbody');
    tabla.html('');
    var filas;

    if (premisasResponse.length > 0){
        $.each(premisasResponse, function (registro, item) {
            filas = filas +
                '<tr>' +
                '<td>' + item.premisa + '</td>' +
                '</tr>';
        });
    } else {
        filas =
            '<tr>' +
            '<td>' + 'No hay premisas' + '</td>' +
            '</tr>';
    }
    tabla.append(filas);
    $('#modalPremisas').modal('show');
}


$(document).on('click', '#mostrarMenuPopsa', function () {
    iddetalleSecuencia = $(this).attr('data-id');


    $('#idDetalle').val(iddetalleSecuencia);
    $('#modalMenuPopsa').modal('show');
});

$(document).on('click', '#irTelemarketing', function () {
    idDetalle = $('#idDetalle').val();
    setTimeout(function(){
        window.location = url + 'ventas/telemarketing/'+idDetalle+'/';
    });
});

$(document).on('click', '#irSecuenciaDiaria', function () {
    idDetalle = $('#idDetalle').val();
    setTimeout(function(){
        window.location = url + 'ventas/secuenciaDiaria/';
    });
});

