/**
 * Seguridad.js
 * Clase y funciones para el módulo de Vehiculos
 * @copyright (c) 2018 Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package balance
 */

var Seguridad = (function () {
    function Seguridad() { };


    Seguridad.prototype.completarActividad = function () {
        var formData = new FormData($('#subirArchivoSeguridadEmpleadoForm')[0]);

        $.ajax({
            url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
            type: 'post',
            dataType: 'json',
            contentType: false,
            processData: false,
            data: formData,
            beforeSend: function(){
                $('#btnSave').prop('disabled', true);
                abreAlerta('Completando actividad de seguridad. Por favor espere..');
                $('#btnCerrarModalAlerta').addClass('hide');
            },
            success: function(response){
                $('#btnCerrarModalAlerta').removeClass('hide');
                if (response.status){
                    abreAlerta(response.mensaje);
                    //guardado = true;
                    setTimeout(function(){
                        window.location = url + 'inicio/actividadesSeguridadEmpleado/';
                    }, 2000);
                }else{
                    $('#btnSave').button('reset').prop('disabled', false);
                    abreAlerta(resp.mensaje);
                }
            },
            error: function(){
                $('#btnSave').button('reset').prop('disabled', false);
                abreAlerta('Lo siento, ocurrió un error al guardar tus datos. ' + msjTicket);
            }
        });

    }

    Seguridad.prototype.completarActividadNoConformidad = function () {
        var formData = new FormData($('#completarActividadNoConformidadForm')[0]);

        $.ajax({
            url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
            type: 'post',
            dataType: 'json',
            contentType: false,
            processData: false,
            data: formData,
            beforeSend: function(){
                $('#btnSave').prop('disabled', true);
                abreAlerta('Guardando actividad de no conformidad. Por favor espere..');
                $('#btnCerrarModalAlerta').addClass('hide');
            },
            success: function(response){
                $('#btnCerrarModalAlerta').removeClass('hide');
                if (response.status){
                    abreAlerta(response.mensaje);
                    //guardado = true;
                    setTimeout(function(){
                        window.location = url + 'inicio/actividadesSeguridadEmpleado/';
                    }, 2000);
                }else{
                    $('#btnSave').button('reset').prop('disabled', false);
                    abreAlerta(resp.mensaje);
                }
            },
            error: function(){
                $('#btnSave').button('reset').prop('disabled', false);
                abreAlerta('Lo siento, ocurrió un error al guardar tus datos. ' + msjTicket);
            }
        });

    }


    Seguridad.prototype.cargaActividadesSeguridad = function (pagina, registros, inferior, superior) {
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'obtenerActividadesSeguridad',
                pagina: pagina,
                registros: registros,
                inferior: inferior,
                superior: superior
            },
            beforeSend: function () {

            },
            success: function (response) {
                console.log('success');
                if (response.status) {
                    _this.renderActividadesSeguridad(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                console.log('error');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Seguridad.prototype.cargaActividadesNoConformidad = function (pagina, registros, inferior, superior) {
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'obtenerActividadesNoConformidad',
                pagina: pagina,
                registros: registros,
                inferior: inferior,
                superior: superior
            },
            beforeSend: function () {

            },
            success: function (response) {
                console.log('success');
                if (response.status) {
                    _this.renderActividadesNoConformidad(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                console.log('error');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Seguridad.prototype.cargaActividadesNoConformidadPendientes = function (idActividadAsignada) {
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'obtenerActividadesNoConformidadPendientes',
                idActividadAsignada: idActividadAsignada
            },
            beforeSend: function () {

            },
            success: function (response) {
                console.log('success');
                if (response.status) {
                    _this.renderActividadesNoConformidadPendientes(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                console.log('error');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };


    Seguridad.prototype.buscarActividadesPorCategoria = function (seguridad,pagina,registros,inferior,superior) {
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'buscarActividadesPorCategoria',
                seguridad: seguridad,
                pagina: pagina,
                registros: registros,
                inferior: inferior,
                superior: superior
            },
            beforeSend: function () {

            },
            success: function (response) {
                if (response.status) {
                    _this.renderActividadesSeguridad(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

    Seguridad.prototype.renderActividadesSeguridad = function (response) {
        var html = '';
        id_usuario = $('#idUsuario').val();
        if (response.actividades.length > 0) {
            $.each(response.actividades, function (registro, item) {
                html += '<tr>';
                html += '<td>' + item.nombre + '</td>';
                html += '<td>' + item.clave + '</td>';
                html += '<td>' + item.created_at + '</td>';
                if( item.fecha_prorroga == null){
                    html += '<td>' + item.fechaFin + '</td>';
                }else{
                    html += '<td>' + item.fecha_prorroga + '</td>';
                }
                html += '<td>' + item.categoria + '</td>';
                html += '<td><a href="' + url + 'application/balance/archivos/' + item.archivo + '" target="_blank"><span class="fa fa-file"></span></a></td>';
                html += '<td>' + item.tipo + '</td>';
                html += '<td>' + item.tipo_descripcion + '</td>';
                if(item.id_editorarchivo == null){
                    html += '<td><a href="' + url + 'inicio/subirArchivoSeguridadEmpleado/' + item.id_tareas_asignada + '/" title="Editar" class="ayuda"><span class="fa fa-edit"></span></a></td>';
                } else if (item.id_editorarchivo != null && item.id_editorarchivo == id_usuario ){
                    html += '<td><a href="' + url + 'inicio/subirArchivoSeguridadEmpleado/' + item.id_tareas_asignada + '/" title="Editar" class="ayuda"><span class="fa fa-edit"></span></a></td>';
                } else if (item.id_editorarchivo != null && item.id_editorarchivo != id_usuario ){
                    html += '<td><a href="' + url + 'inicio/subirArchivoSeguridadEmpleado/' + item.id_tareas_asignada + '/" title="Editar" class="ayuda"><span class="fa fa-edit"></span></a></td>';
                }

                html += '</tr>';
            });

            var ul = $('<ul class="pagination" />');
            pagina = parseInt(response.pagina);
            paginas = parseInt(response.paginas);
            if (pagina > 1) {
                $('<li />').html('<a class="paginaAltaSeguridad" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
            }
            inferior = response.inferior;
            superior = response.superior;
            paginas = parseInt(response.paginas);
            if (paginas < superior) {
                limite = paginas;
            } else {
                limite = superior;
            }
            for (i = inferior; i <= limite; i++) {
                if (pagina == i) {
                    $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
                } else {
                    $('<li />').html('<a class="paginaAltaSeguridad" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
                }
            }
            if (pagina < paginas) {
                $('<li />').html('<a class="paginaAltaSeguridad" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
            }
            $('#paginacion').html(ul);
        } else {
            html += '<tr>';
            html += '<td colspan="9">No se encontraron resultados</td>';
            html += '</tr>';
        }

        $('#listadoActividadesSeguridad tbody').html(html);
    };

    Seguridad.prototype.renderActividadesNoConformidad = function (response) {
        var html = '';
        console.log( response);
        if (response.actividades.length > 0) {
            $.each(response.actividades, function (registro, item) {
                html += '<tr>';
                html += '<td>' + item.tarea_principal + '</td>';
                html += '<td>' + item.descripcion + '</td>';
                html += '<td>' + item.fecha_inicio + '</td>';
                html += '<td>' + item.fecha_limite + '</td>';
                html += '<td>' + item.porcentaje + '%</td>';
                html += '<td><a href="' + url + 'inicio/completarActividadNoConformidad/' + item.id_actividades_de_no_conformidad + '/" title="Editar" class="ayuda"><span class="fa fa-edit"></span></a></td>';
                html += '</tr>';
            });

            var ul = $('<ul class="pagination" />');
            pagina = parseInt(response.pagina);
            paginas = parseInt(response.paginas);
            if (pagina > 1) {
                $('<li />').html('<a class="paginaAltaSeguridadNoConformidad" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
            }
            inferior = response.inferior;
            superior = response.superior;
            paginas = parseInt(response.paginas);
            if (paginas < superior) {
                limite = paginas;
            } else {
                limite = superior;
            }
            for (i = inferior; i <= limite; i++) {
                if (pagina == i) {
                    $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
                } else {
                    $('<li />').html('<a class="paginaAltaSeguridadNoConformidad" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
                }
            }
            if (pagina < paginas) {
                $('<li />').html('<a class="paginaAltaSeguridadNoConformidad" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
            }
            $('#paginacionNoConformidad').html(ul);
        } else {
            html += '<tr>';
            html += '<td colspan="6">No se encontraron resultados</td>';
            html += '</tr>';
        }

        $('#listadoActividadesNoConformidad tbody').html(html);
    };

    Seguridad.prototype.renderActividadesNoConformidadPendientes = function (response) {
        var html = '';
        console.log( response);
        if (response.actividades.length > 0) {
            $.each(response.actividades, function (registro, item) {
                html += '<tr>';
                html += '<td>' + item.descripcion + '</td>';
                html += '</tr>';
            });

        } else {
            html += '<tr>';
            html += '<td colspan="1">No se encontraron Actividades de conformidad pendientes</td>';
            html += '</tr>';
        }

        $('#NoConformidadPendientes tbody').html(html);
    };


    Seguridad.prototype.actividadNoConformidad = function () {
        var formData = new FormData($('#subirArchivoSeguridadEmpleadoForm')[0]);

        $.ajax({
            url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
            type: 'post',
            dataType: 'json',
            contentType: false,
            processData: false,
            data: formData,
            beforeSend: function(){
               // $('#btnSave').prop('disabled', true);
               // abreAlerta('Guardando alerta. Por favor espere..');
               // $('#btnCerrarModalAlerta').addClass('hide');
            },
            success: function(response){
                $('#btnCerrarModalAlerta').removeClass('hide');
                if (response.status){
                    abreAlerta(response.mensaje);
                    //guardado = true;
                    setTimeout(function(){
                        window.location = url + 'inicio/actividadesSeguridadEmpleado/';
                    }, 2000);
                }else{
                    $('#btnSave').button('reset').prop('disabled', false);
                    abreAlerta(resp.mensaje);
                }
            },
            error: function(){
                $('#btnSave').button('reset').prop('disabled', false);
                abreAlerta('Lo siento, ocurrió un error al guardar tus datos de la actividad de no conformidad. ' + msjTicket);
            }
        });

    };

    Seguridad.prototype.cargaTareasNoConformidadRechazadas = function (pagina, registros, inferior, superior) {
        _this = this;
        $.ajax({
            url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
            type: 'GET',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cargaTareasNoConformidadRechazadas',
                pagina: pagina,
                registros: registros,
                inferior: inferior,
                superior: superior
            },
            beforeSend: function () {

            },
            success: function (response) {

                if (response.status) {
                    _this.renderTareasNoConformidadRechazadas(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function (xhr, responseText, thrownError) {
                console.log('error');
                error = mostrarMensajeError(xhr, responseText, thrownError);
                abreAlerta(error);
            },
            timeout: 15000
        });
    };

   Seguridad.prototype.renderTareasNoConformidadRechazadas = function (response) {
        var html = '';
        console.log( response);
        if (response.tareas.length > 0) {
            $.each(response.tareas, function (registro, item) {
                html += '<tr>';
                html += '<td>' + item.nombre + '</td>';
                html += '<td>' + item.descripcion + '</td>';
                html += '<td>' + item.razon_rechazon + '</td>';



                if(item.tipo == 'cuestionario' ){
                    html += '<td><a  title="Editar" class="editarTareaNoConformidadCuestionario" data-id-frecuencia="'+item.frecuencia+'" data-id-cuestionario-usuario="'+item.id_cuestionario_usuario+'"' +
                        '  data-id-tarea="'+item.id_tarea_no_conformidad+'" data-pregunta="'+item.pregunta+'"><span class="fa fa-edit"></span></a></td>';

                }else{
                    html += '<td><a  title="Editar" class="editarTareaNoConformidad" data-id-frecuencia="'+item.frecuencia+'" data-id-tarea="'+item.id_tarea_no_conformidad+'"><span class="fa fa-edit"></span></a></td>';
                }

                html += '</tr>';
            });

            var ul = $('<ul class="pagination" />');
            pagina = parseInt(response.pagina);
            paginas = parseInt(response.paginas);
            if (pagina > 1) {
                $('<li />').html('<a class="paginaAltaSeguridadNoConformidadNoAprobadas" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
            }
            inferior = response.inferior;
            superior = response.superior;
            paginas = parseInt(response.paginas);
            if (paginas < superior) {
                limite = paginas;
            } else {
                limite = superior;
            }
            for (i = inferior; i <= limite; i++) {
                if (pagina == i) {
                    $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
                } else {
                    $('<li />').html('<a class="paginaAltaSeguridadNoConformidadNoAprobadas" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
                }
            }
            if (pagina < paginas) {
                $('<li />').html('<a class="paginaAltaSeguridadNoConformidadNoAprobadas" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
            } else {
                $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
            }
            $('#paginacionNoConformidadNoAprobadas').html(ul);
        } else {
            html += '<tr>';
            html += '<td colspan="4">No se encontraron resultados</td>';
            html += '</tr>';
        }

        $('#listadoActividadesNoConformidadNoAprobadas tbody').html(html);
    };




    return Seguridad;
})();

$(document).on('click', '.paginaAltaSeguridad', function () {
    actividad = $('#buscar').val();
    if(actividad == 'todos'){
        pagina = $(this).attr('data-pagina');
        superior = parseInt($('#superior').val());
        inferior = parseInt($('#inferior').val());
        registros = parseInt($('#registros').val());
        s = new Seguridad();
        s.cargaActividadesSeguridad(pagina, registros, inferior, superior);
    } else {
        seguridad = $('#buscar').val();
        pagina = $(this).attr('data-pagina');
        registros = $('#registros').val();
        inferior = $('#inferior').val();
        superior = $('#superior').val();
        s = new Seguridad();
        s.buscarActividadesPorCategoria(seguridad, pagina,registros,inferior,superior);

    }


});

$(document).on('click', '.paginaAltaSeguridadNoConformidad', function () {
    actividad = $('#buscar').val();
        pagina = $(this).attr('data-pagina');
        superior = parseInt($('#superiorNoConformidad').val());
        inferior = parseInt($('#inferiorNoConformidad').val());
        registros = parseInt($('#registrosNoConformidad').val());
        s = new Seguridad();
        s.cargaActividadesNoConformidad(pagina, registros, inferior, superior);



});







$(document).ready(function () {
    $(".razon").click(function (event) {

        var valor = $(this).val();

        if (valor == 'calendario') {
            $("#tipocalendario").css("display", "block");
            $("#tipoevento").css("display", "none");
            console.log('hola');
        } else {
            $("#tipocalendario").css("display", "none");
            $("#tipoevento").css("display", "block");
        }
    });
});



$(document).on('click', '#adjuntar', function(e){
    e.preventDefault();
    $('#adjunto').click();
});


$(document).on('change', '#adjunto', function(){
    adjunto = this.files[0];
    console.log(adjunto, 'este es un adjunto')
    var clase = $('#infoAdjunto').attr('class');
    tipo = adjunto.type;
    nombreDocumento = adjunto.name;
    // if (tipo.indexOf('image/') == -1){
    //    $('#infoFoto').removeClass(clase).addClass('alert alert-danger')
    //      .text('No se permite ese tipo de documento');
    //  return false;
    //}else{
    $('#infoAdjunto').removeClass(clase).addClass('alert alert-success')
        .text(nombreDocumento);
    return true;
    //}
});


function validar(){
    $('span.error').remove();
    $('.has-error').removeClass('has-error');
    if($('input[type=radio]').parent('.active').length == 0){
        setError($('#accidente'),'Debes seleccionar el tipo.');
        return false;
    }else if($.trim($('#nombre').val()) == ''){
        setError($('#nombre'),'Debes ingresar el nombre.');
        return false;
    }
    return true;
}

function setError(elem, msg){
    divp = elem.parents('.form-group').addClass('has-error');
    divp.find('span.error').remove();

    padre = elem.parent();
    if(elem.hasClass('calendario')) padre = elem.parent().parent();
    if(elem.attr('type') == 'radio') padre = elem.parents('.btn-group').parent();
    padre.append('<span class="help-block error">'+msg+'</span>');
    elem.focus();
}

$(document).on('change', '#buscar', function () {
    actividad = $(this).val();
    if(actividad == 'todos'){
        pagina = $('#pagina').val();
        registros = $('#registros').val();
        inferior = $('#inferior').val();
        superior = $('#superior').val();
        s = new Seguridad();
        s.cargaActividadesSeguridad(pagina, registros, inferior, superior);
    } else {
        seguridad = $(this).val();
        pagina = $('#pagina').val();
        registros = $('#registros').val();
        inferior = $('#inferior').val();
        superior = $('#superior').val();
        s = new Seguridad();
        s.buscarActividadesPorCategoria(seguridad, pagina,registros,inferior,superior);
    }
});


$(function () {

    if ($('#listadoActividadesSeguridad').length > 0) {
        pagina = parseInt($('#pagina').val());
        superior = parseInt($('#superior').val());
        inferior = parseInt($('#inferior').val());
        registros = parseInt($('#registros').val());
        s = new Seguridad();
        s.cargaActividadesSeguridad(pagina, registros, inferior, superior);
    }

    if ($('#listadoActividadesNoConformidad').length > 0) {
        console.log('aqui no conformidad');
        pagina = parseInt($('#paginaNoConformidad').val());
        superior = parseInt($('#superiorNoConformidad').val());
        inferior = parseInt($('#inferiorNoConformidad').val());
        registros = parseInt($('#registrosNoConformidad').val());
        s = new Seguridad();
        s.cargaActividadesNoConformidad(pagina, registros, inferior, superior);
    }

    if ($('#NoConformidadPendientes').length > 0) {
        console.log( $('#idSeguridad').val());
        idActividadAsignada = $('#idSeguridad').val();
        s = new Seguridad();
        s.cargaActividadesNoConformidadPendientes(idActividadAsignada);
    }

    if ($('#listadoActividadesNoConformidadNoAprobadas').length > 0) {

        pagina = parseInt($('#paginaNoConformidadNoAprobadas').val());
        superior = parseInt($('#superiorNoConformidadNoAprobadas').val());
        inferior = parseInt($('#inferiorNoConformidadNoAprobadas').val());
        registros = parseInt($('#registrosNoConformidadNoAprobadas').val());
        s = new Seguridad();
        s.cargaTareasNoConformidadRechazadas(pagina, registros, inferior, superior);
    }







});



$(document).on('change', '#registros', function(){
    registros = $(this).val();
    pagina = parseInt($('#pagina').val());
    inferior = parseInt($('#inferior').val());
    superior = parseInt($('#superior').val());
    s = new Seguridad();
    s.cargaActividadesSeguridad(pagina, registros, inferior, superior);
});

$(document).on('change', '#registrosNoConformidad', function(){
    registros = $(this).val();
    pagina = parseInt($('#paginaNoConformidad').val());
    inferior = parseInt($('#inferiorNoConformidad').val());
    superior = parseInt($('#superiorNoConformidad').val());
    s = new Seguridad();
    s.cargaActividadesNoConformidad(pagina, registros, inferior, superior);
});




if ($('#subirArchivoSeguridadEmpleadoForm').length > 0){
    $('#subirArchivoSeguridadEmpleadoForm').validate({
            submitHandler: function (form) {
                s = new Seguridad();
                s.completarActividad();

            },
            rules: {
                adjunto: "required"

            },
            messages: {
                adjunto: "Por favor ingresa un archivo"
            },
            errorElement: 'span',
            errorClass: 'help-block',
            highlight: function (element) {
                $(element).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else {
                    error.insertAfter(element);
                }
            }
        }
    );
}

if ($('#completarActividadNoConformidadForm').length > 0){
    $('#completarActividadNoConformidadForm').validate({
            submitHandler: function (form) {
                s = new Seguridad();
                s.completarActividadNoConformidad();

            },
            rules: {
                adjunto: "required"
            },
            messages: {
                adjunto: "Por favor ingresa un archivo"
            },  
            errorElement: 'span',
            errorClass: 'help-block',
            highlight: function (element) {
                $(element).closest('.form-group').addClass('has-error');
            },
            unhighlight: function (element) {
                $(element).closest('.form-group').removeClass('has-error');
            },
            errorPlacement: function (error, element) {
                if (element.parent('.input-group').length) {
                    error.insertAfter(element.parent());
                } else {
                    error.insertAfter(element);
                }
            }
        }
    );
}



$(document).on('click', '#agregarTareaNoConformidad', function () {
  //  nombre = $('#nombreTareaNoConformidad').val();
    descripcion = $('#descripcionTareaNoConformidad').val();
    frecuencia = $('#frecuencia').val();
    var formData = new FormData($('#subirArchivoSeguridadEmpleadoForm')[0]);
    console.log(formData, ' formData');
    //console.log(nombre, 'nombre');
    console.log(descripcion, 'descripcion');

    if (nombre == '') {
        abreAlerta('Por favor ingresa un nombre');
        return false;
    }

    if (descripcion == '') {
        abreAlerta('Por favor ingresa una descripcion');
        return false;
    }

    var i = 0;
 //   var fila = '<tr id="row' + i + '"><td name="nombreNoConformidad[]" id="nombreNoConformidad' + i + '" >' + nombre + '</td><td name="descripcionNoConformidad[]" id="descripcionNoConformidad' + i + '" >' + descripcion + '</td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove">Quitar</button></td></tr>'; //esto seria lo que contendria la fila
    var fila = '<tr id="row' + i + '"><td ><input readonly type="text" name="descripcionNoConformidad[]" id="descripcionNoConformidad' + i + '" class="form-control" value="' + descripcion + '"></td>'; //esto seria lo que contendria la fila
    fila += '<td ><input readonly type="text" name="frecuencia[]" id="frecuencia' + i + '" class="form-control" value="' + frecuencia + '"></td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove">Quitar</button></td></tr>';


    i++;


   $('#descripcionTareaNoConformidad').val('');
    console.log("limpio ", $('#descripcionTareaNoConformidad').val());

    $('#tablaTareasNoConformidad ').append(fila);
    $("#adicionados").text("");
    var nFilas = $("#tablaTareasNoConformidad tr").length;
    $("#adicionados").append(nFilas - 1);




});



    $(document).on('click', '.btn_remove', function() {


        var button_id = $(this).attr("id");
        descripcionNoConformidad = $(this).closest('tr').find('[name="descripcionNoConformidad[]"]').val();

        $('#tablaTareasNoConformidad > tbody > tr').each(function (index, tr) {
            input = $(this).find('[name="descripcionNoConformidad[]"]');
            if(input.val() == descripcionNoConformidad){
                $(this).remove();
            }
    });

       /* $(' #estrategias > option ').each(function (index, option) {
            optionContet = $(this).val();
            if(optionContet == estrategia){
                $(this).remove();
            }
        });*/

        $(this).closest ('tr').remove ();

    });

$(document).on('click', '.editarTareaNoConformidad', function() {


    var frecuencia = $(this).data("id-frecuencia");
    var idTareaNoConformidad = $(this).data("id-tarea");
    $('#idTarea').val(idTareaNoConformidad);
    $('#frecuencia').val(frecuencia);

    $('#modal-actualiza-tarea_no_conformidad').modal('show');

});

$(document).on('click', '#btnActualizarTareaNoConformidad', function() {

   idTareaNoConformidad = $('#idTarea').val();
   frecuencia = $('#frecuencia').val();
    descripcionTareaNoConformidad = $('#descripcionTareaNoConformidad').val();


    if (descripcionTareaNoConformidad == '') {
        $('#modal-actualiza-tarea_no_conformidad').modal('hide');
        abreAlerta('Por favor ingresa una descripcion');
        return false;
    }


    actualizarTareaNoConformidad(idTareaNoConformidad, frecuencia, descripcionTareaNoConformidad  );

});



function actualizarTareaNoConformidad(idTareaNoConformidad, frecuencia, descripcionTareaNoConformidad) {
    $('#modal-actualiza-tarea_no_conformidad').modal('hide');
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxSeguridadEmpleadoController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'actualizarTareaNoConformidad',
            idTareaNoConformidad: idTareaNoConformidad,
            frecuencia: frecuencia,
            descripcionTareaNoConformidad: descripcionTareaNoConformidad
        },
        success: function(response){

            if (response.status){
                pagina = parseInt($('#paginaNoConformidadNoAprobadas').val());
                superior = parseInt($('#superiorNoConformidadNoAprobadas').val());
                inferior = parseInt($('#inferiorNoConformidadNoAprobadas').val());
                registros = parseInt($('#registrosNoConformidadNoAprobadas').val());
                s = new Seguridad();
                s.cargaTareasNoConformidadRechazadas(pagina, registros, inferior, superior);
                $('#descripcionTareaNoConformidad').val('');
                abreAlerta("Tarea actualizada correctamente");

            }
            else{
                abreAlerta("error al actualizar una tarea de no conformidad");
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}

$(document).on('click', '.editarTareaNoConformidadCuestionario', function() {

    var idTareaNoConformidad = $(this).data("id-tarea");
    var pregunta = $(this).data("pregunta");
    var idCuestionarioUsuario = $(this).data("id-cuestionario-usuario");

    $('#pregunta').text(pregunta);

    $('#idTarea').val(idTareaNoConformidad);


    $('#modal-actualiza-tarea_no_conformidad-cuestionario').modal('show');

});

