/**
 * SeguridadHigiene.js
 * Clase y funciones para el módulo Seguridad e higiene
 * @copyright (c) 2018 Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package inicio
 */


$(document).ready(function () {
    status = $('#status').val();
    indicador = $('#indicador').val();
    pagina = $('#pagina').val();
    registros = 10;
    inferior = $('#inferior').val();
    superior = $('#superior').val();
    grupo = $('#grupo').val();
    clave = $('#clave').val();
    cargarTareasDeNoConformidad(status, indicador,pagina, registros, inferior, superior, grupo, clave);
    cargarNormas();
});

$(document).on('change', '#status', function(){
    status = $('#status').val();
    indicador = $('#indicador').val();
    pagina = $('#pagina').val();
    registros = 10;
    inferior = $('#inferior').val();
    superior = $('#superior').val();
    grupo = $('#grupo').val();
    clave = $('#clave').val();
    cargarTareasDeNoConformidad(status, indicador,pagina, registros, inferior, superior, grupo, clave);
});

$(document).on('click', '.pagina', function(){
    status = $('#status').val();
    indicador = $('#indicador').val();
    pagina = $(this).attr('data-pagina');
    registros = 10;
    inferior = $('#inferior').val();
    superior = $('#superior').val();
    grupo = $('#grupo').val();
    clave = $('#clave').val();
    cargarTareasDeNoConformidad(status, indicador,pagina, registros, inferior, superior, grupo, clave);
});

function cargarTareasDeNoConformidad(status, indicador, pagina, registros, inferior, superior, grupo, clave) {
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'obtenerTareasNoConformidadDelSupervisor',
            status: status,
            pagina: pagina,
            registros: registros,
            inferior: inferior,
            superior: superior,
            grupo: grupo,
            clave:clave
        },
        success: function(response){
            if (response.status){
                renderTareas(response);
            }
            else{
                abreAlerta(response.mensaje);
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}

function renderTareas(response){
    tabla = $('#tareas-no-conformidad tbody');
    tabla.html('');
    tareas = response.tareas;
    console.log(response.pagina, "pagina");
    console.log(response.inferior, "inferior");
    console.log(response.superior, "superior");
    console.log(response.paginas, "paginas");
    if (tareas.length > 0){
        $.each(tareas, function(registro, item){

            if(item.frecuencia == "evento"){
                item.frecuencia = "solo una vez"
            }
        //    if( formatoStatus(item.status) == "Pendiente"){
                acciones = '<a title="eliminar tarea" style="margin: 5px" data-id-tarea="'+item.id_tarea_no_conformidad+'"><span class="fa fa-trash-o borrarTarea" data-id-tarea="'+item.id_tarea_no_conformidad+'"></span></a><a style="margin: 5px" href="' + url + 'inicio/editarNoConformidadSistemaCalidad/'+item.id_tarea_no_conformidad+'/" title="Editar tarea"><span class="fa fa-edit"></span></a>';
       //     }else{
           //     acciones = '<a style="margin: 5px" href="' + url + 'inicio/editarNoConformidad/'+item.id_tarea_no_conformidad+'/" title="Editar tarea"><span class="fa fa-edit"></span></a>';

         //   }

            var tr = $('<tr data-id ="'+item.id_tarea_no_conformidad+'" ></tr>');

            tr.append('<td id="fecha">' + new Date(item.created_at).toLocaleDateString() + '</td>');
            tr.append('<td id="">' + item.normaclave + '</td>');
            tr.append('<td id="actividad-principal">' + item.nombre_tarea_seguridad + '</td>');
            tr.append('<td id="descipcion">' + item.descripcion + '</td>');
            tr.append('<td id="status">' + formatoStatus(item.status) + '</td>');
            tr.append('<td >' + isNull(item.nombresubiosarea)  + '</td>');
            tr.append('<td >' + isNull(item.sucursal)  + '</td>');

            tr.append('<td >' + isNull(item.frecuencia)  + '</td>');
            tr.append('<td id="sub-tareas">'+item.sub_tareas+'</td>');
            tr.append('<td>' + acciones + ' </td>');
            tr.appendTo(tabla);
        });

        var ul = $('<ul class="pagination" />');
        pagina = parseInt(response.pagina);
        paginas = parseInt(response.paginas);
        if (pagina > 1) {
            $('<li />').html('<a class="pagina" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
        }
        else {
            $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
        }
        inferior = response.inferior;
        superior = response.superior;
        paginas = parseInt(response.paginas);
        if (paginas < superior) {
            limite = paginas;
        }
        else {
            limite = superior;
        }
        for (i = inferior; i <= limite; i++) {
            if (pagina == i) {
                $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
            }
            else {
                $('<li />').html('<a class="pagina" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
            }
        }
        if (pagina < paginas) {
            $('<li />').html('<a class="pagina" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
        }
        else {
            $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
        }
        $('#paginacion').html(ul);
    }
    else{
        var tr = $('<tr></tr>');
        tr.append('<td colspan="6">No se encontraron actividades</td>');
        tr.appendTo(tabla);
    }

}

function formatoStatus(status){
    if(status == "pendiente") {
        return "Pendiente";
    }
    if(status == "progreso") {
        return "En Ejecución";
    }
    if(status == "finalizado") {
        return "Terminada";
    }
}


function isNull(valor) {

    if(valor == null){
        valor = "";
    }
    return valor;

}

$(document).on('change', '#grupo', function(){
    status = $('#status').val();
    indicador = $('#indicador').val();
    pagina = $('#pagina').val();
    registros = 10;
    inferior = $('#inferior').val();
    superior = $('#superior').val();
    grupo = $('#grupo').val();
    clave = $('#clave').val();


    if(grupo == ""){
        $('#clave').val("");
        $('#clave').text("");
        $('#clave').prop('disabled', true);
    }else{
        obtenerClaves(grupo);
        $('#clave').prop('disabled', false);
    }

    cargarTareasDeNoConformidad(status, indicador,pagina, registros, inferior, superior, grupo, clave);

});

function cargarNormas() {
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'cargarNormas',

        },
        success: function(response){
            if (response.status){
                renderNormas(response);
            }
            else{
                abreAlerta("ocurrio un error al obtener las normas");
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}

function renderNormas(response){


    normas = response.normas;
    $('#grupo').html('');
    var addGrupo= '';
    addGrupo += '<option value="">todas</option>';
    $.each(normas, function (registro, item) {
        addGrupo += '<option value="' + item.id_codigo_calidad + '">' + item.nombre_norma + '</option>';

    });
    $('#grupo').append(addGrupo);

}

function obtenerClaves(grupo) {
    $.ajax({
        url: url + 'application/balance/controllers/AjaxSeguridadController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'obtenerClaves',
            grupo: grupo,
        },
        success: function(response){

            if (response.status){
                renderClaves(response);
            }
            else{
                abreAlerta("error al obtener las claves");
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });

}

function renderClaves(response){
    claves = response.claves;
    $('#clave').html('');
    var addClave = '';
    addClave += '<option value="">todas</option>';
    $.each(claves, function (registro, item) {
        addClave += '<option value="' + item.clave + '">' + item.clave + '</option>';

    });
    $('#clave').append(addClave);


}

$(document).on('change', '#clave', function(){
    status = $('#status').val();
    indicador = $('#indicador').val();
    pagina = $('#pagina').val();
    registros = 10;
    inferior = $('#inferior').val();
    superior = $('#superior').val();
    grupo = $('#grupo').val();
    clave = $('#clave').val();


    cargarTareasDeNoConformidad(status, indicador,pagina, registros, inferior, superior, grupo, clave);

});


$(document).on('click', '.borrarTarea', function () {
   let id = $(this).data("id-tarea");
    $('#modal-rechaza-actividad').modal('show');

    $('#idTarea').val(id);

});

function rechazarActividad(id, razon) {
    $('#modal-rechaza-actividad').modal('hide');
    $.ajax({
        url: url + 'application/inicio/controllers/AjaxSistemaCalidadController.php',
        type: 'GET',
        dataType: 'JSON',
        cache: false,
        data: {
            accion: 'rechazarActividad',
            id: id,
            razon: razon
        },
        success: function(response){

            if (response.status){
                status = $('#status').val();
                indicador = $('#indicador').val();
                pagina = $('#pagina').val();
                registros = 10;
                inferior = $('#inferior').val();
                superior = $('#superior').val();
                grupo = $('#grupo').val();
                clave = $('#clave').val();
                cargarTareasDeNoConformidad(status, indicador,pagina, registros, inferior, superior, grupo, clave);
                $('#razon').val("");
                abreAlerta("Tarea Rechazada correctamente");
            }
            else{
                abreAlerta("error al rechazar una actividad");
            }
        },
        error: function(xhr, responseText, thrownError){
            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });
}

$(document).on('click', '#btnRechazarActividad', function () {

    idTarea =  $('#idTarea').val();
    razon =  $('#razon').val();

    if (razon == '') {
        $('#modal-rechaza-actividad').modal('hide');
        abreAlerta('Por favor ingresa una descripcion');
        return false;
    }

      rechazarActividad(idTarea, razon);
});