<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class AccionDao extends Model {

    public function __construct() {
        parent::__construct();
    }

    public function obtenerAccionesEstrategia($id) {
        $sql = "SELECT * FROM acciones where Id_Estrategia = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['acciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las acciones. ' . TICKETS;
        }

        return $response;
    }

}
