<?php 

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
	
class ActividadDao extends Model
{
	public function __construct()
	{
		parent::__construct();
	}

	public function obtenerActividadesAccion($id)
	{
		$sql = "SELECT * FROM actividad where Id_Accion = ?";
		$stmt = $this->_dbh->prepare($sql);
		$stmt->bindValue(1, $id, PDO::PARAM_INT);
		try{
			$stmt->execute();
			$response['status'] = true;
			$response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
		}catch(PDOException $e){
			Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
			$response['status'] = false;
			$response['error'] = 'Lo siento, ocurrió un error al obtener las acciones. ' . TICKETS;
		}

		return $response;
	}
}