<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class ActividadesAgendaDao extends Model {

    public function __construct() {
        parent::__construct();
    }

    public function guardarActividadAgenda($fecha, $actividad, $idUsuario, $fechaCierre )
    {
        $sql = "INSERT INTO `actividades_agenda` (`Fecha`, `actividad`, `id_usuario`, fecha_final) "
            . "VALUES (?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $actividad, PDO::PARAM_STR);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(4, $fechaCierre, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al guardar la actividad de la agenda. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadAgenda( $idUsuario, $fecha )
    {
        $sql = "SELECT * FROM actividades_agenda where id_usuario = ? and Fecha >= ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al obtener la actividad de la agenda. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarFechaActividad( $fecha, $idActividad , $fechaCierre)
    {
        $sql = "update actividades_agenda set Fecha = ?, fecha_final = ? where id_actividades_agenda = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaCierre, PDO::PARAM_STR);
        $stmt->bindValue(3, $idActividad, PDO::PARAM_INT);


        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al actualizar la actividad de la agenda. ' . TICKETS;
        }

        return $response;
    }

    public function eliminarActividad(  $idActividad )
    {
        $sql = "delete from actividades_agenda where id_actividades_agenda = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al eliminar la actividad de la agenda. ' . TICKETS;
        }

        return $response;
    }

}
