<?php

/**
 * AgendaDao.php
 * Modelo para la persistencia de datos de la agenda
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package inicio
 */
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class AgendaDao extends Model {

    /**
     * Método constructor, obtiene la conexión a la base de datos
     * @access public
     */
    public function __construct() {
        parent::__construct();
    }

    /**
     * Método para obtener las actividades por usuario
     * @access public
     * @param int $idUsuario
     * @return mixed array con los datos de respuesta, o false si hay error
     */
    public function obtenerActividades($idUsuario) {
        $sql = "SELECT * FROM agenda INNER JOIN actividades ON "
                . "agenda.Id_Actividad = actividades.Id_Actividad WHERE "
                . "Id_Usuario = ? ORDER BY actividades.Frecuencia";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            return false;
        }
    }

    /**
     * Método para obtener el detalle de la agenda
     * @param int $idUsuario
     * @param int $idAgenda
     * @return mixed array con los datos de respuesta o false si hay un error
     */
    public function detalleAgenda($idUsuario, $idAgenda) {
        $sql = "SELECT * FROM actividades INNER JOIN agenda ON "
                . "actividades.Id_Actividad=agenda.Id_Actividad AND "
                . "agenda.Id_Usuario = ? WHERE "
                . "actividades.Id_Actividad = ? "
                . "ORDER BY actividades.Frecuencia";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idAgenda, PDO::PARAM_INT);
        try {
            $stmt->execute();
            return $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            return false;
        }
    }

    public function actualizarActividad($fecha, $idUsuario, $idActividad) {
        $sql = "UPDATE `agenda` SET `Fecha_Ultima_Aplicacion` = ? WHERE `Id_Usuario` = ? AND `Id_Actividad` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, date("Y-m-d"), PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(3, $idActividad, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la actividad. ' . TICKETS;
        }

        return $response;
    }

    /*     * * by Angel ** */


    /*
     * Metodo eliminaAgendaDAO
     * @param idUsuario
     */

    public function eliminaAgendaDAO($idUsuario) {
        $sql = "DELETE FROM agenda WHERE Id_Usuario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['mensaje'] = 'se elimino la agenda del usuario';
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al eliminar agenda de usuario . ' . TICKETS;
        }

        return $response;
    }

    /**
     * Método para obtener actividades por nivel
     * @param str $nivel
     * @return mixed array con los datos de respuesta o false si hay un error
     */
    public function obtenActividadNivelAgendaDao($nivel) {
        $sql = "SELECT * FROM actividades WHERE $nivel = 1 ";
        $stmt = $this->_dbh->prepare($sql);
        //$stmt->bindValue(1, $nivel, PDO::PARAM_STR);
        try {
            $stmt->execute();
            return $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            return false;
        }
    }

    /*
     * Metodo agregarActividadAgendaDAO
     * @param idUsuario
     */

    public function agregarActividadAgendaDAO($idUsuario, $idActividad, $obligacion) {
        $sql = "INSERT INTO agenda (Id_Agenda,Id_Usuario,Id_Actividad,Fecha_Ultima_Aplicacion, Obligatoria) VALUES(NULL,?,?,'0000-00-00 00:00:00',?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idActividad, PDO::PARAM_INT);
        $stmt->bindValue(3, $obligacion, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al eliminar agenda de usuario . ' . TICKETS;
        }

        return $response;
    }

}
