<?php
/**
 * ComentariosDao.php
 * Modelo para la persistencia de datos de comentarios
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package inicio
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . 
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Comentarios.php';

class ComentariosDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
     public function obtenerActividadesGenerales()
    {
        $sql = "SELECT * FROM `comentarios` WHERE `Status` < 2 AND (`Tipo` = 'alertas' OR "
                . "`Tipo` = 'alertas_calidad' OR `Tipo` = 'industrial' OR "
                . "`Tipo` = 'flota' OR `Tipo` = 'sugerencias' ) "
                . "ORDER BY `Tipo`";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['comentarios'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las actividades '
                    . 'generales. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerActividadesAlertas($idSucursal, $inicio, $registros)
    {
        $sql = "SELECT * FROM `comentarios` INNER JOIN `alertas` ON `comentarios`.Id_Sospechoso "
                . "= `alertas`.`Id_Alerta` WHERE `comentarios`.`Status` < 2 AND "
                . "`comentarios`.`Tipo` = 'alertas` AND `alertas`.`Id_Sucursal = ? "
                . "ORDER BY `comentarios`.`Cuando` DESC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento ocurrió un error al obtener las actividades de alertas. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function guardarActividadesSecuencia(Comentarios $c)
    {
        $sql = "INSERT INTO `comentarios` (`Quien`, `Cuando`, `Comentarios`, `Etapa`, `Id_Sospechoso`, `Tipo`, "
                . "`Status`, `Progreso`, `Avance`, `Id_Sucursal_Comentario`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_quien'), PDO::PARAM_STR);
        $stmt->bindValue(2, $c->__get('_cuando'), PDO::PARAM_STR);
        $stmt->bindValue(3, $c->__get('_comentarios'), PDO::PARAM_STR);
        $stmt->bindValue(4, $c->__get('_etapa'), PDO::PARAM_INT);
        $stmt->bindValue(5, $c->__get('_idSospechoso'), PDO::PARAM_INT);
        $stmt->bindValue(6, $c->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(7, $c->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(8, $c->__get('_progreso'), PDO::PARAM_STR);
        $stmt->bindValue(9, $c->__get('_avance'), PDO::PARAM_STR);
        $stmt->bindValue(10, $c->__get('_idSucursalComentario'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al agregar la actividad. ' . TICKETS;
        }
        
        return $response;
    }

    public function guardarActividades(Comentarios $c)
    {
        $sql = "INSERT INTO `comentarios` (`Quien`, `Cuando`, `Comentarios`, `Id_Sospechoso`, `Tipo`, "
                . "`Status`, `Progreso`, `Avance`, `Id_Sucursal_Comentario`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_quien'), PDO::PARAM_STR);
        $stmt->bindValue(2, $c->__get('_cuando'), PDO::PARAM_STR);
        $stmt->bindValue(3, $c->__get('_comentarios'), PDO::PARAM_STR);
        $stmt->bindValue(4, $c->__get('_idSospechoso'), PDO::PARAM_INT);
        $stmt->bindValue(5, $c->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(6, $c->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(7, $c->__get('_progreso'), PDO::PARAM_STR);
        $stmt->bindValue(8, $c->__get('_avance'), PDO::PARAM_STR);
        $stmt->bindValue(9, $c->__get('_idSucursalComentario'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al agregar la actividad. ' . TICKETS;
        }
        
        return $response;
    }

    public function guardarActividadesSpancop(Comentarios $c)
    {
        $sql = "INSERT INTO `comentarios` (`Quien`, `Cuando`, `Comentarios`, `Etapa`, `Id_Sospechoso`, `Tipo`, "
                . "`Status`, `Progreso`, `Avance`, `Id_Sucursal_Comentario`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_quien'), PDO::PARAM_STR);
        $stmt->bindValue(2, $c->__get('_cuando'), PDO::PARAM_STR);
        $stmt->bindValue(3, $c->__get('_comentarios'), PDO::PARAM_STR);
        $stmt->bindValue(4, $c->__get('_etapa'), PDO::PARAM_STR);
        $stmt->bindValue(5, $c->__get('_idSospechoso'), PDO::PARAM_INT);
        $stmt->bindValue(6, $c->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(7, $c->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(8, $c->__get('_progreso'), PDO::PARAM_STR);
        $stmt->bindValue(9, $c->__get('_avance'), PDO::PARAM_STR);
        $stmt->bindValue(10, $c->__get('_idSucursalComentario'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al agregar la actividad. ' . TICKETS;
        }
        
        return $response;
    }

    public function obtenerActividadesPorSecuencia($idSecuencia, $idCliente)
    {
        $sql = "SELECT * FROM `comentarios` WHERE `Id_Sospechoso` ? AND `Etapa` = ? AND `Tipo` = 'secuencia'";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCliente, PDO::PARAM_INT);
        $stmt->bindValue(2, $idSecuencia, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fectchAll();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al ';
        }

        return $response;
    }
    
    public function getActiPendUser($user, $inicio, $fin, $desde, $cuantos){
        $sql = "SELECT SQL_CALC_FOUND_ROWS *, DATE_FORMAT(Cuando, '%d/%m/%Y') AS fecha FROM comentarios WHERE Status < 2 AND Quien = ? AND Cuando BETWEEN ? AND ? AND Progreso < 100 ORDER BY Tipo, Cuando DESC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $user, PDO::PARAM_STR);
        $stmt->bindValue(2, $inicio, PDO::PARAM_STR);
        $stmt->bindValue(3, $fin, PDO::PARAM_STR);
        $stmt->bindValue(4, $desde, PDO::PARAM_INT);
        $stmt->bindValue(5, $cuantos, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las actividades';
        }

        return $response;
    }

    public function saveActProgress($comm, $progr){
        $sql = "UPDATE comentarios SET Progreso = ? WHERE Id_Comentario = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $progr, PDO::PARAM_STR);
        $stmt->bindValue(2, $comm, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el progreso de la activid';
        }

        return $response;
    }

    public function getActiByTipo($suc, $tipo, $tbl, $iden, $desde, $cuantos){
        $sql = "SELECT SQL_CALC_FOUND_ROWS *, DATE_FORMAT(Cuando, '%Y-%m-%d') AS fecha FROM comentarios INNER JOIN $tbl ON comentarios.Id_Sospechoso = $tbl.$iden 
                    WHERE comentarios.Status < 2 AND comentarios.Tipo = :tipo 
                        AND $tbl.Id_Sucursal = :suc 
                    ORDER BY comentarios.Quien ASC LIMIT :desde , :cuantos ";
        
        if($tipo == 'lpa2'){
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM comentarios where Status = 0 AND Quien = '' AND Tipo = :tipo AND Id_Sucursal_Comentario = :suc 
                        ORDER BY Cuando DESC LIMIT :desde , :cuantos ";
        }
        
        
        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindParam(':suc', $suc, PDO::PARAM_INT);
        $stmt->bindParam(':tipo', $tipo, PDO::PARAM_STR);
        $stmt->bindParam(':desde', $desde, PDO::PARAM_INT);
        $stmt->bindParam(':cuantos', $cuantos, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las actividades';
        }

        return $response;
    }
    
    public function getActiByUser($suc, $user, $tipo, $tbl, $iden, $desde, $cuantos){
        $sql = "SELECT SQL_CALC_FOUND_ROWS *, DATE_FORMAT(Cuando, '%Y-%m-%d') AS fecha FROM comentarios INNER JOIN $tbl ON comentarios.Id_Sospechoso = $tbl.$iden 
                    WHERE comentarios.Status < 2 AND comentarios.Tipo = :tipo 
                        AND $tbl.Id_Sucursal = :suc AND comentarios.Quien = :user
                    ORDER BY comentarios.Quien ASC LIMIT :desde , :cuantos ";

        if($tipo == 'lpa2'){
            $sql = "SELECT SQL_CALC_FOUND_ROWS * FROM comentarios where Status = 0 AND Quien = '' AND Tipo = :tipo AND Id_Sucursal_Comentario = :suc 
                        ORDER BY Cuando DESC LIMIT :desde , :cuantos ";
        }  
        
       $sql = "SELECT SQL_CALC_FOUND_ROWS *, DATE_FORMAT(Cuando, '%Y-%m-%d') AS fecha FROM comentarios INNER JOIN $tbl ON comentarios.Id_Sospechoso = $tbl.$iden 
                    WHERE comentarios.Status < 2 AND comentarios.Tipo = '$tipo' 
                        AND $tbl.Id_Sucursal = $suc AND comentarios.Quien = '$user'
                    ORDER BY comentarios.Quien ASC";
        
        if ($tipo == 'plan_2018'){
            $sql = "SELECT SQL_CALC_FOUND_ROWS *, DATE_FORMAT(Cuando, '%Y-%m-%d') AS fecha FROM comentarios where Status = 0 AND Quien = :user AND Tipo = :tipo AND Id_Sucursal_Comentario = :suc 
                        ORDER BY Cuando DESC LIMIT :desde , :cuantos ";
        }
        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindParam(':suc', $suc, PDO::PARAM_INT);
        $stmt->bindParam(':tipo', $tipo, PDO::PARAM_STR);
        $stmt->bindParam(':desde', $desde, PDO::PARAM_INT);
        $stmt->bindParam(':cuantos', $cuantos, PDO::PARAM_INT);
        $stmt->bindParam(':user', $user, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las actividades';
        }

        return $response;
    }

    public function asignaActividad(Comentarios $c)
    {
        $sql = "UPDATE comentarios SET Quien = ?, Cuando = ?, Avance = ?, Status = ?, Progreso = ?, Tipo = ? WHERE Id_Comentario = ? ";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_quien'), PDO::PARAM_STR);
        $stmt->bindValue(2, $c->__get('_cuando'), PDO::PARAM_STR);
        $stmt->bindValue(3, $c->__get('_avance'), PDO::PARAM_STR);
        $stmt->bindValue(4, $c->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(5, $c->__get('_progreso'), PDO::PARAM_STR);
        $stmt->bindValue(6, $c->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(7, $c->__get('_idComentario'), PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;

            if($c->__get('_tipo') == 'sugerencias'){
                $sqls = "UPDATE sugerencias SET Avance = ?, Status = ? WHERE Id_Sugerencia = ?";
                
                $stmts = $this->_dbh->prepare($sqls);
                $stmts->bindValue(1, $c->__get('_avance'), PDO::PARAM_STR);
                $stmts->bindValue(2, $c->__get('_status'), PDO::PARAM_INT);
                $stmts->bindValue(3, $c->__get('_idSospechoso'), PDO::PARAM_INT);
                $stmts->execute();
            }

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al asignar la actividad. ' . TICKETS;
        }
        
        return $response;
    }

    public function delActividad($comm){
        $sql = "DELETE FROM comentarios WHERE Id_Comentario = :comm ";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindParam(':comm', $comm, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al eliminar la actividad';
        }

        return $response;
    }

    public function obtenerActividadPlan($quien, $idActividad)
    {
        $sql = "SELECT * FROM comentarios WHERE Quien = ? AND Id_Sospechoso = ? AND `Tipo` = 'plan_2018'";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $quien, PDO::PARAM_STR);
        $stmt->bindValue(2, $idActividad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividad'] = $stmt->fetch(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function getActividadesSemanal($suc, $tipo, $tbl, $iden, $fecha, $finalizada){
        $arr = explode(',', $tipo); $tipo = '';
        foreach ($arr as $at) {
            $tipo .= "c.Tipo = '$at' OR ";
        }
        $tipo = substr($tipo, 0, -4);
        $status = '=';
        if(!$finalizada) $status = '<>';
        $sql = "SELECT SQL_CALC_FOUND_ROWS c.* FROM comentarios c INNER JOIN $tbl ON c.Id_Sospechoso = $tbl.Id_Junta_Cierre_Actividades
                    WHERE c.Status $status 2 AND ($tipo) AND DATE(c.Cuando) >= :fecha AND $tbl.Id_Sucursal = :suc ";
        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindParam(':suc', $suc, PDO::PARAM_INT);
        //$stmt->bindParam(':tipo', $tipo, PDO::PARAM_STR);
        $stmt->bindParam(':fecha', $fecha, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de las actividades';
        }

        return $response;
    }

    public function saveActStatus($comm, $stat){
        $sql = "UPDATE comentarios SET Status = ? WHERE Id_Comentario = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $stat, PDO::PARAM_STR);
        $stmt->bindValue(2, $comm, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar el status de la actividad';
        }

        return $response;
    }

    public function getComentarioSospechoso($tipo, $sospechoso){
        $sql = "SELECT * FROM comentarios WHERE Tipo = ?  AND Id_Sospechoso = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(2, $sospechoso, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['comentario'] = $stmt->fetch(PDO::FETCH_OBJ);;
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el comentario';
        }

        return $response;
    }
    
    public function getComentariosSospechoso($tipo, $sospechoso){
        $sql = "SELECT * FROM comentarios WHERE Tipo = ?  AND Id_Sospechoso = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(2, $sospechoso, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['comentarios'] = $stmt->fetchAll(PDO::FETCH_OBJ);;
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el comentario';
        }

        return $response;
    }

    public function saveBitacoraServicio(Comentarios $c){
        $sql = "INSERT INTO `comentarios` (`Quien`, `Cuando`, `Comentarios`, `Id_Sospechoso`, `Tipo`, "
                                        . "`Status`, `Progreso`, `Avance`, `Id_Sucursal_Comentario`, Que, Etapa) 
                                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_quien'), PDO::PARAM_STR);
        $stmt->bindValue(2, $c->__get('_cuando'), PDO::PARAM_STR);
        $stmt->bindValue(3, $c->__get('_comentarios'), PDO::PARAM_STR);
        $stmt->bindValue(4, $c->__get('_idSospechoso'), PDO::PARAM_INT);
        $stmt->bindValue(5, $c->__get('_tipo'), PDO::PARAM_STR);
        $stmt->bindValue(6, $c->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(7, $c->__get('_progreso'), PDO::PARAM_STR);
        $stmt->bindValue(8, $c->__get('_avance'), PDO::PARAM_STR);
        $stmt->bindValue(9, $c->__get('_idSucursalComentario'), PDO::PARAM_INT);
        $stmt->bindValue(10, $c->__get('_que'), PDO::PARAM_STR);
        $stmt->bindValue(11, $c->__get('_etapa'), PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al agregar la actividad. ' . TICKETS;
        }
        
        return $response;
    }

    public function getOrdenesServicio($vehiculo){
        $sql = "SELECT *, c.Status AS Estatus, 
                        IFNULL((SELECT Id_Documento FROM documentos WHERE Tipo_Documento = 30 AND Id_Cliente = v.Id_Vehiculo AND Id_Proveedor = r.Id_Rutina AND Condiciones_Pago = c.Etapa),0) AS documento 
                    FROM comentarios c INNER JOIN rutinas r ON r.Id_Rutina = c.Id_Sospechoso
                                INNER JOIN vehiculos v ON v.Id_Vehiculo = r.Id_Vehiculo
                    WHERE v.Id_Vehiculo = ? AND c.Tipo = 'rutina' 
                        ORDER BY c.Status ";
        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $vehiculo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['ordenes'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las ordenes de servicio';
        }

        return $response;
    }

    public function getOrdenServicio($id){
        $sql = "SELECT * FROM comentarios c INNER JOIN rutinas r ON r.Id_Rutina = c.Id_Sospechoso
                                INNER JOIN vehiculos v ON v.Id_Vehiculo = r.Id_Vehiculo
                    WHERE c.Id_Comentario = ? ";
        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['orden'] = $stmt->fetch(PDO::FETCH_OBJ);
        }
        catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las orden de servicio';
        }

        return $response;
    }

    public function actualizaActividades2018($id, $progreso, $status)
    {
        $sql = "UPDATE comentarios SET Progreso = ?, Status = ? WHERE Id_Comentario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $progreso, PDO::PARAM_STR);
        $stmt->bindValue(2, $status, PDO::PARAM_INT);
        $stmt->bindValue(3, $id, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesClienteSecuencia($idProspecto, $tipo, $idSecuencia)
    {
        $sql = "SELECT * FROM `comentarios` WHERE `Id_Sospechoso` = ? AND (`Tipo` = 'secuencia' OR `Tipo` = 'spancop') AND `Avance` = ? AND `Etapa` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProspecto, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $idSecuencia, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesSpancop($idSospechoso)
    {
        $sql = "SELECT * FROM `comentarios` WHERE `Id_Sospechoso` = ? AND (`Tipo` = 'spancop' OR `Tipo` = 'secuencia')";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSospechoso, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las actividades. ' . TICKETS;
        }

        return $response;
    }
    
    public function totalActividadesTelemarketing(){
        $sql = "SELECT * FROM comentarios WHERE Tipo = 'telemarketing' ORDER BY Id_Comentario";
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function totalActividadesTelemarketingIndicador($indicador){
        $sql = "SELECT * FROM comentarios WHERE Tipo = 'telemarketing' AND Id_Sospechoso = ? ORDER BY Id_Comentario";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $indicador, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesTelemarketing($inicio, $registros){
        $sql = "SELECT * FROM comentarios WHERE Tipo = 'telemarketing' ORDER BY Id_Comentario LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las actividades. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerActividadesTelemarketingIndicador($indicador, $inicio, $registros){
        $sql = "SELECT * FROM comentarios WHERE Tipo = 'telemarketing' AND id_Sospechoso = ? ORDER BY Id_Comentario LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $indicador, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['actividades'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las actividades. ' . TICKETS;
        }

        return $response;
    }
    
    public function actualizarProgresoMarketing($progreso, $idActividad){
        $sql = "UPDATE comentarios SET Progreso = ? WHERE Id_Comentario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $progreso, PDO::PARAM_INT);
        $stmt->bindValue(2, $idActividad, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar la actividad. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarFechaMarketing($fecha, $idActividad){
        $sql = "UPDATE comentarios SET Cuando = ? WHERE Id_Comentario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idActividad, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar la actividad. ' . TICKETS;
        }

        return $response;
    }
    
    public function actualizaComentario($comentario, $idComentario){
        $sql = "UPDATE comentarios SET Comentarios = ? WHERE Id_Comentario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $comentario, PDO::PARAM_STR);
        $stmt->bindValue(2, $idComentario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar los datos.';
        }

        return $response;
    }

    public function actualizaFecha($fecha, $idComentario){
        $sql = "UPDATE comentarios SET Cuando = ? WHERE Id_Comentario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idComentario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar los datos.';
        }

        return $response;
    }

    public function actualizaActividad($actividad, $idComentario){
        $sql = "UPDATE comentarios SET Avance = ? WHERE Id_Comentario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $actividad, PDO::PARAM_STR);
        $stmt->bindValue(2, $idComentario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar los datos.';
        }

        return $response;
    }
}