<?php

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class EstrategiaDao extends Model {

    public function __construct() {
        parent::__construct();
    }

    public function obtenerEstrategiasKeyIssue($idKey) {
        $sql = "SELECT * FROM estrategia where Id_Key_Issue = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idKey, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['estrategias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los key issues. ' . TICKETS;
        }

        return $response;
    }

}
