<?php
/**
 * JuntaCierreDao.php
 * Modelo para la persistencia de datos de juntas de cierre
 * @copyright (c) 2018, Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package inicio
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class JuntaCierreDao extends Model
{
    public function __construct() {
        parent::__construct();
    }

    public function getJuntaCierreSuc($suc, $fecha){
        $sql = "SELECT * FROM `junta_cierre` WHERE Id_Sucursal = ? AND Fecha = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $suc, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['junta'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la junta cierre ' . TICKETS;
        }
        
        return $response;
    }
    
    public function getJuntaCierreBalanceSuc($suc, $fecha){
        $sql = "SELECT * FROM `junta_cierre_balance` WHERE Id_Sucursal = ? AND Fecha = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $suc, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['balance'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la junta cierre balance' . TICKETS;
        }
        
        return $response;
    }

    public function getJuntaCierreBalanceDet($junta){
        $sql = "SELECT * FROM `junta_cierre_balance_detalle` WHERE Id_Junta_Cierre_Balance = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $junta, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['detalle'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la junta cierre balance detalle' . TICKETS;
        }
        
        return $response;
    }

    public function agregaActividadSecuencia($usuario, $tipo, $actividad){
        $SQL = "INSERT INTO secuencia_actividades (Id_Cliente, Tipo, Que, Avance, Status)
                        VALUES (?, ?, ?, 0, 2) ";
        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $usuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $actividad, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idActividad'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar la actividad ' . TICKETS;
        }
        
        return $response;
    }

    public function agregaActividadJunta($usuario, $tipo, $actividad, $suc){
        $SQL = "INSERT INTO junta_cierre_actividades (Id_Usuario, Tipo_Indicador, Actividad, Id_Sucursal)
                        VALUES (?, ?, ?, ?) ";
        $stmt = $this->_dbh->prepare($SQL);
        $stmt->bindValue(1, $usuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipo, PDO::PARAM_STR);
        $stmt->bindValue(3, $actividad, PDO::PARAM_STR);
        $stmt->bindValue(4, $suc, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idActividad'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar la actividad ' . TICKETS;
        }
        
        return $response;
    }
}