<?php
/**
 * JuntaCierreIndicadoresDao.php
 * Modelo para la persistencia de datos de juntas de cierre
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package inicio
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class JuntaCierreIndicadoresDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function obtenerIndicadores()
    {
        $sql = "SELECT * FROM `junta_cierre_indicadores` ORDER BY `Indicador`";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['indicadores'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la lista de '
                    . 'indicadores. ' . TICKETS;
        }
        
        return $response;
    }
}