<?php
/**
 * NotificacionesDao.php
 * Modelo para la persistencia de datos de notifiaciones
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package inicio
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Notificaciones.php';

class NotificacionesDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function obtenerListaNotificaciones($idUsuario)
    {
        $sql = "SELECT * FROM `notificaciones` WHERE `Id_Usuario` = ? AND (`Status` = 1 OR `Status` = 2) ORDER BY `Id_Notificacion` DESC";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['notificaciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener tus notificaciones. '
                    . TICKETS;
        }
        
        return $response;
    }

    public function obtenerListaNotificacionesActivas($idUsuario)
    {
        $sql = "SELECT * FROM `notificaciones` WHERE `Id_Usuario` = ? AND `Status` = 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['notificaciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener tus notificaciones. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function crearNotificacion(Notificaciones $n)
    {
        $sql = "INSERT INTO `notificaciones` (`Asunto`, `Descripcion`, `Fecha`, `Hora`, "
                . "`Url`, `Status`, `Id_Usuario`, `Id_Solicita`) "
                . "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $n->__get('_asunto'), PDO::PARAM_STR);
        $stmt->bindValue(2, $n->__get('_descripcion'), PDO::PARAM_STR);
        $stmt->bindValue(3, $n->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(4, $n->__get('_hora'), PDO::PARAM_STR);
        $stmt->bindValue(5, $n->__get('_url'), PDO::PARAM_STR);
        $stmt->bindValue(6, $n->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(7, $n->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(8, $n->__get('_idSolicita'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al generar la notificación. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerUltimaNotificacion($idUsuario)
    {
        $sql = "SELECT * FROM `notificaciones` WHERE `Id_Usuario` = ? AND"
                . " `Status` = 1 ORDER BY `Id_Notificacion` DESC LIMIT 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['notificacion'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la '
                    . 'notificación.' . TICKETS;
        }
        
        return $response;
    }
    
    public function cambiarStatus($idNotificacion, $status)
    {
        $sql = "UPDATE `notificaciones` SET `Status` = ? WHERE `Id_Notificacion` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_INT);
        $stmt->bindValue(2, $idNotificacion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al cambiar el estado '
                    . 'de la notificación. ' . TICKETS;
        }
        
        return $response;
    }
}