<?php
/**
 * AjaxController.php
 * Controlador para el manejo de ajax con el módulo de usuarios
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuario
 */

date_default_timezone_set("America/Chihuahua");
// date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdfParser' . DIRECTORY_SEPARATOR . 'alt_autoload.php-dist';


class AjaxController {

    private $_sesion;

    /**
     * Método constructor, crea la sesión
     * @access public
     */
    public function __construct() {
        $this->_sesion = new Sesion();
    }

    /**
     * Método para iniciar sesión
     * @access public
     */
    public function login() {
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Validador.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';

        //validamos los datos
        if (!Validador::validarDatos($_POST)) {
            $response['status'] = false;
            $response['mensaje'] = 'Debes ingresar tus datos de acceso';
        } else {
            //sanitizamos los datos
            $usuario = filter_input(INPUT_POST, 'usuario', FILTER_SANITIZE_STRING);
            $contrasena = md5(filter_input(INPUT_POST, 'contrasena', FILTER_SANITIZE_STRING));
            $u = new Usuario();
            $u->__set('_usuario', $usuario);
            $u->__set('_contrasena', $contrasena);
            $fecha = date("Y-m-d");
            $horaActua = date("H:i:s");
            // $horaActua = date("H:i:s", strtotime('-1 hour'));
            $us = new UsuarioDao();
            $existe = $us->existeUsuario($u);
            if ($existe['status']) {
                $valido = $existe['datos'];
                if ($valido > 0) {
                    $ub = $us->esUsuarioSinBloqueos($u);
                    if ($ub['status']) {
                        $activo = $ub['total'];
                        if ($activo == 0) {
                            $login = $us->login($u);
                            if ($login['status']) {
                                $datos = $login['login'];
                                if ($datos->Password == $contrasena) {
                                    //validamos que haya tomado asistencia
                                    $a = new AsistenciaDao();
                                    $hay = $a->validarAsistencia($fecha, $datos->Id_Usuario);
                                    $nomina = $us->obtenerUsuarioNomina($datos->Id_Usuario)['nomina'] ;
                                    if ($hay['total'] > 0 || ($nomina->tipo_nomina == null || $nomina->tipo_nomina == "")){
                                        //creamos las sesiones
                                        new Sesion();
                                        Sesion::crear('usuario', $datos->Usuario);
                                        Sesion::crear('idSucursal', $datos->Id_Sucursal);
                                        Sesion::crear('idUsuario', $datos->Id_Usuario);
                                        Sesion::crear('idRol', $datos->Tipo);
                                        $response['status'] = true;
                                        $response['mensaje'] = 'Login correcto. Redireccionando...';
                                        $response['user'] = $datos->Id_Usuario;
                                    }   
                                    else{

                                        if ($datos->Id_Usuario == 16 || $datos->Id_Usuario == 17  || $datos->Id_Usuario == 111 || $datos->Id_Usuario == 103){
                                            new Sesion();
                                            Sesion::crear('usuario', $datos->Usuario);
                                            Sesion::crear('idSucursal', $datos->Id_Sucursal);
                                            Sesion::crear('idUsuario', $datos->Id_Usuario);
                                            Sesion::crear('idRol', $datos->Tipo);
                                            $response['status'] = true;
                                            $response['mensaje'] = 'Login correcto. Redireccionando...';
                                            $response['user'] = $datos->Id_Usuario;
                                        }
                                        else{
                                            $response['status'] = false;
                                            $response['mensaje'] = 'Para ingresar al sistema por favor checa tu asistencia. ';
                                        }
                                    }
                                } else {
                                    $response['status'] = false;
                                    $response['mensaje'] = 'Tu contraseña es incorrecta';
                                }
                            } else {
                                $response['status'] = false;
                                $response['mensaje'] = $login['error'];
                            }
                        } else {
                            $response['status'] = false;
                            $mensaje = 'Lo siento, :( Lo siento, has sido bloqueado por :  '. '<br>';
                            foreach ($ub['datos'] as $datosBloqueo) {
                                 $mensaje = $mensaje . $datosBloqueo->tipo_bloqueo . '<br>';
                            }
                                $response['mensaje'] = $mensaje ;

                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $ub['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = 'Lo siento, no existe el usuario. Intenta otra vez';
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $existe['error'];
            }
        }

        echo json_encode($response);
    }

    public function validarPassword() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $password = filter_input(INPUT_POST, 'password', FILTER_SANITIZE_STRING);

        $password = md5($password);

        $u = new UsuarioDao();
        $valido = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
        if ($valido['status']) {
            $datosUsuario = $valido['usuarios'];
            if ($datosUsuario->Password == $password) {
                $response['status'] = true;
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'Contraseña no válida.';
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $valido['error'];
        }

        echo json_encode($response);
    }

    public function cambiarPassword() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $password = filter_input(INPUT_POST, 'passwordNueva', FILTER_SANITIZE_STRING);

        $password = md5($password);

        $u = new Usuario();
        $u->__set('_contrasena', $password);
        $u->__set('_fechaPassword', date("Y-m-d"));
        $u->__set('_idUsuario', Sesion::obtener('idUsuario'));

        $us = new UsuarioDao();
        $cambio = $us->actualizarContrasena($u);
        if ($cambio['status']) {
            $response['status'] = true;
            $response['mensaje'] = 'Contraseña cambiada correctamente.';
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambio['error'];
        }

        echo json_encode($response);
    }

    public function emailPassword() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);

        $u = new UsuarioDao();
        $valido = $u->validarEmailUsuario($email);
        if ($valido['status']) {
            if ($valido['valido'] > 0) {
                $response['status'] = true;
                $response['idUsuario'] = $valido['datosUsuario']->Id_Usuario;
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'Lo siento, el e-mail no corresponde a ningún usuario existente. ';
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $valido['error'];
        }

        echo json_encode($response);
    }

    public function generarContrasena() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $email = filter_input(INPUT_POST, 'email', FILTER_SANITIZE_EMAIL);

        //generamos la contraseña
        $cadena = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890";
        $longitudCadena = strlen($cadena);
        $pass = "";
        $longitudPass = 10;
        for ($i = 1; $i <= $longitudPass; $i++) {
            $pos = rand(0, $longitudCadena - 1);
            $pass .= substr($cadena, $pos, 1);
        }

        $passDb = md5(md5($pass));
        $u = new Usuario();
        $u->__set('_idUsuario', $idUsuario);
        $u->__set('_contrasena', $passDb);
        $u->__set('_fechaPassword', date("Y-m-d"));
        $us = new UsuarioDao();
        $actualizada = $us->actualizarContrasena($u);
        if ($actualizada['status']) {
            //enviamos el email
            $body = 'Estimado usuario tu contraseña temporal es ' . $pass . ' Favor de iniciar sesión y cambiarla en el menú cambiar Contraseña.';
            $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            $datos = array('contenido' => $body);
            $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

            $contexto = stream_context_create($opciones);
            $contenidoEmail = file_get_contents($url, false, $contexto);
            $enviado = Email::enviarEmail($email, '', 'Reestablecer Contraseña', $body);
            if ($enviado) {
                $response['status'] = true;
                $response['mensaje'] = 'Se ha enviado tu nueva contraseña a tu Email.';
            } else {
                $response['status'] = true;
                $response['mensaje'] = 'Tu contraseña ha sido cambiada, pero no se pudo enviar el Email ' . TICKETS;
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $actualizada['error'];
        }

        echo json_encode($response);
    }

    public function asistencia() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';
        $codigoBarras = filter_input(INPUT_POST, 'codigoBarras', FILTER_SANITIZE_STRING);
        //obtenemos los datos del usuario
        $fecha = date("Y-m-d");
        $horaActual = date("H:i:s");
        // $horaActual = date("H:i:s", strtotime('-1 hour'));
        $u = new UsuarioDao();
        $usuario = $u->obtenerUsuarioPorCodigoBarras($codigoBarras);
        if ($usuario['status']) {
            if ($usuario['total'] > 0) {
                $datos = $usuario['usuarios'];
                $status = $datos->Status;
                $usuario = new Usuario();
                $usuario->__set('_usuario', $datos->Usuario);
                $ub = $u->esUsuarioSinBloqueos($usuario);
                $as = new AsistenciaDao();
              //  if ($status == 1 and ) {
                    if ($datos->Id_Usuario != 109 || $datos->Id_Usuario != 111 || $datos->Id_Usuario != 103) {
                        $as = new AsistenciaDao();
                        $hayAsistencia = $as->validarAsistencia($fecha, $datos->Id_Usuario)['total'];
                        if ($hayAsistencia == 0) {

                            $horaSistema = new DateTime($fecha . ' ' . $horaActual);
                            $horaEntrada = new DateTime($fecha . ' 09:00:00');

                            $diferencia = $horaEntrada->diff($horaSistema);
                            if ($diferencia->h > 0 || $diferencia->i >= 30) {
                                $status = 3;
                            } elseif ($diferencia->i > 15 && $diferencia->i < 30 && $diferencia->h <= 0) {
                                $status = 2;
                            } elseif ($diferencia->i == 0 && $diferencia->i <= 15 && $diferencia->h <= 0) {
                                $status = 1;
                            }

                            if ($horaEntrada > $horaSistema) {
                                $status = 1;
                            }

                            //generamos la astencia
                            $a = new Asistencia();
                            $a->__set('_idUsuario', $datos->Id_Usuario);
                            $a->__set('_fecha', $fecha);
                            $a->__set('_horaEntrada', $horaActual);
                            $a->__set('_horaSalida', '00:00:00');
                            $a->__set('_idSucursal', $datos->Id_Sucursal);
                            $a->__set('_observaciones', '');
                            $a->__set('_asistencia', $status);
                            $asistencia = $as->registrarAsistencia($a);
                            if ($asistencia['status']) {
                                $response['status'] = true;
                                if (date("H") >= 12) {
                                    $response['mensaje'] = 'Buenos tardes ' . $datos->Nombre . ' has chedado tu asistencia correctamente.';
                                } else {
                                    $response['mensaje'] = 'Buenos días ' . $datos->Nombre . ' has chedado tu asistencia correctamente.';
                                }
                            } else {
                                $response['status'] = false;
                                $response['mensaje'] = $asistencia['error'];
                            }
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = 'Lo siento, solo puedes checar asistencia una vez por día, espera a mañana. -_-';
                        }
                    } else {
                        $horaActual = date("H:i:s");
                        // $horaActual = date("H:i:s", strtotime('-1 hour'));
                        $diferencia = $as->calcularTiempos("19:00:00", $horaActual);
                        $hraEntrada = new DateTime($fecha . $horaActual);
                        $horaSistema = new DateTime($fecha . " 19:00:00");
                        $intervalo = $horaSistema->diff($hraEntrada);
                        $decimal = $intervalo->format("%R%i");
                        $decimal = (int) $decimal;
                        if ($decimal <= 15) {
                            $status = 1;
                        }
                        if ($decimal > 15 && $decimal <= 30) {
                            $status = 2;
                        }
                        if ($decimal > 30) {
                            $status = 3;
                        }

                        $fecha = date("Y-m-d");
                        $diaFestivo = $u->obtenerDiaFestivo($fecha)['hay'];

                        $permisolaboral = $u->obtenerPermisoLaboralUsuario($datos->Id_Usuario, $fecha);
                        $permiso = $permisolaboral['hay'];
                        if($diaFestivo == 1 || $permiso == 1 ){
                            $status = 1;
                        }


                            //generamos la astencia
                        $a = new Asistencia();
                        $a->__set('_idUsuario', $datos->Id_Usuario);
                        $a->__set('_fecha', $fecha);
                        $a->__set('_horaEntrada', $horaActual);
                        $a->__set('_horaSalida', '00:00:00');
                        $a->__set('_idSucursal', $datos->Id_Sucursal);
                        $a->__set('_observaciones', '');
                        $a->__set('_asistencia', $status);
                        $asistencia = $as->registrarAsistencia($a);
                        if ($asistencia['status']) {
                            $response['status'] = true;
                            if (date("H") >= 12) {
                                $response['mensaje'] = 'Buenas tardes ' . $datos->Nombre . ' has chedado tu asistencia correctamente.';
                            } else {
                                $response['mensaje'] = 'Buenos días ' . $datos->Nombre . ' has chedado tu asistencia correctamente.';
                            }
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $asistencia['error'];
                        }
                    }
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'No se encontró usuario asociado a ese código de barras.';
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $usuario['error'];
        }

        echo json_encode($response);
    }

    public function salida() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';

        $codigoBarras = filter_input(INPUT_POST, 'codigoBarras', FILTER_SANITIZE_STRING);
        //obtenemos los datos del usuario
        $fecha = date("Y-m-d");
        $hora = date("H:i:s");
        // $hora = date("H:i:s", strtotime('-1 hour'));
        
        Utils::logInfo('Hora de salida: '.$hora,__FUNCTION__,__FILE__);

        $u = new UsuarioDao();
        $usuario = $u->obtenerUsuarioPorCodigoBarras($codigoBarras);
        if ($usuario['status']) {
            if ($usuario['total'] > 0) {
                $datos = $usuario['usuarios'];
                $as = new AsistenciaDao();
                $hayAsistencia = $as->validarAsistencia($fecha, $datos->Id_Usuario);
                if ($hayAsistencia['status']) {
                    $datosAsistencia = $hayAsistencia['asistencia'];
                    $salida = $as->registrarSalida($hora, $datos->Id_Usuario, $datosAsistencia->Id_Asistencia);
                    if ($salida['status']) {
                        $response['status'] = true;
                        if (date("N") == 6) {
                            $response['mensaje'] = 'Tu hora de salida se registró correctamente ' . $datos->Nombre . '. Hasta el lunes, feliz fin de semana!!!!';
                        } else {
                            $response['mensaje'] = 'Tu hora de salida se registró correctamente ' . $datos->Nombre . ' Hasta Mañana!!';
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $salida['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $hayAsistencia['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = 'No se encontró usuario asociado a ese código de barras.';
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $usuario['error'];
        }

        echo json_encode($response);
    }

    /** USUARIOS CRUD * */
    public function cargarUsuariosSucursal() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $u = new UsuarioDao();
        $t = $u->totalUsuariosSucursal(Sesion::obtener('idSucursal'));
        if ($t['status']) {
            $total = (int) $t['total'];
            $paginas = ceil($total / $registros);
            $usuarios = $u->obtenerUsuariosSucursal(Sesion::obtener('idSucursal'), $inicio, $registros);
            if ($usuarios['status']) {
                $response['status'] = true;
                $response['usuarios'] = $usuarios['usuarios'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $usuarios['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'] . 'TOTAAAAL';
        }

        echo json_encode($response);
    }

    /*     * ************************************
     * Metodo: completar_usuarioControler()
     * Param: usuario(texto que se escribe), inicio, registros(cuantos va a traer)
     * Desarrollo: AGRA
     * Descripción: devuelve el total de registros encontrados y los registros encontrados
     */

    public function totalCompletarUsuarioController() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $cadena = filter_input(INPUT_GET, 'cadena', FILTER_SANITIZE_STRING);

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $u = new UsuarioDao();
        $t = $u->totalCompletarUsuarioDAO($cadena, $inicio, $registros);
        if ($t['status']) {
            $total = (int) $t['total'];
            $paginas = ceil($total / $registros);
            //$usuarios = $u->obtenerUsuariosSucursal(Sesion::obtener('idSucursal'), $inicio, $registros);
            //if ($usuarios['status']){
            //    $response['status'] = true;
            $response['status'] = true;
            $response['usuarios'] = $t['usuarios'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
            //}
            //else{
            //    $response['status'] = false;
            //    $response['mensaje'] = $usuarios['error'].'SUCURSAAAAL';
            //}
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    /*     * *
     *
     */

    /*     * ********
     * Metodo validaUsuarioControler();
     */

    public function validaUsuarioController() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $usuario = filter_input(INPUT_POST, 'usuario', FILTER_SANITIZE_STRING);
        $idUsuario = (int) filter_input(INPUT_POST, 'id_usuario', FILTER_SANITIZE_NUMBER_INT);
        $response = array();

        $valida = new UsuarioDao();

        $val = $valida->validaUsuarioDAO($usuario, $idUsuario);

        if ($val['status']) {
            $response['status'] = true;
            $response['existe'] = $val['existe'];
        } else {
            $response['status'] = false;
            $response['mensaje'] = $val['error'];
        }

        echo json_encode($response);
    }

    /*     * ******* */
    
    public function regresaUsuarioController() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'Direccion.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DireccionDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Nomina.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuentasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'NominaDao.php';
        $nominaDao = new NominaDao();

        $idUsuario = (int) filter_input(INPUT_GET, 'id_usuario', FILTER_SANITIZE_NUMBER_INT);
        $response = array();

        $user = new UsuarioDao();

        $us = $user->obtenerUsuario($idUsuario);


        // DOCUMENTOS
        $files = array(
            'rfc' => '',
            'ine' => '',
            'imss' => '',
            'domicilio' => '',
            'licencia' => '',
            'curp' => '',
            'solicitudEmpleo' => '',
            'carta1' => '',
            'contrato' => '',
            'altaImss' => '',
            'bajaImss' => '',
            'constancia' => '',
            'renuncia' => '',
            'finiquito' => ''
        );        
        $ruta = '../documentos/' . $idUsuario . '/';
        $rutaFinal = BASEURL . 'application/usuarios/documentos/' . $idUsuario . '/';
        foreach ($files as $key => $value) {
            if (file_exists($ruta . $key . '.pdf'))
                $files[$key] = $rutaFinal . $key . '.pdf';
        }
        $response['files'] = $files;


        if ($us['status']) {
            $response['status'] = true;
            $response['usuario'] = $us['usuarios'];

            $regimenF = $user->getRegimenesFiscales($idUsuario);

            if($regimenF['total'] > 0) {
                for ($i = 0; $i < $regimenF['total']; $i++) {
                    $response['regimenF'][$i] = $regimenF['regimenFiscal'][$i];
                }
            }else{
                $response['regimenF'][0] = $us['usuarios']->regimen_fiscal;
            }

            $response['tRegimen'] = $regimenF['total'];

            $d = new Direccion();
            $dir = new DireccionDao();
            $idDireccion = $us['usuarios']->Id_Direccion;
            $d->__set('_idDireccion', $idDireccion);
            $direccion = $dir->obtenerDireccion($d);
            if ($direccion['status']) {
                $response['direccion'] = $direccion['direccion'];
                $n = new Nomina();
                $nomina = $user->obtenerUsuarioNomina($idUsuario);
                if ($nomina['status']) {
                    $response['nomina'] = $nomina['nomina'];

                    if(isset($nomina['nomina'])){
                        $idNominaUsuario = $nomina['nomina']->Id_Nomina;
                    } else {
                        $idNominaUsuario = 0;
                    }

                    $vinculosNominaProveedoresExternos = $nominaDao->obtenerProveedoresExternosDeLaNominaPorIdNomina($idNominaUsuario)['proveedoresExternosDeNomina'];
                    $response['nominaProveedoresExternos'] = $vinculosNominaProveedoresExternos;

                    $cd = new CuentasDao();
                    $cn = $cd->obtenerCuentaPersona($idUsuario, 'UsuarioNomina');
                    if ($cn['status']) {
                        $usuario_nomina = $cn['cuenta']->Id_Cuenta;
                        $cn = $cd->obtenerCuentaPersona($idUsuario, 'UsuarioDespensa');
                        if ($cn['status']) {
                            $usuario_despensa = $cn['cuenta']->Id_Cuenta;
                            $cn = $cd->obtenerCuentaPersona($idUsuario, 'UsuarioAsistencia');
                            if ($cn['status']) {
                                $usuario_asistencia = $cn['cuenta']->Id_Cuenta;
                                $cn = $cd->obtenerCuentaPersona($idUsuario, 'UsuarioPuntualidad');
                                if ($cn['status']) {
                                    $usuario_puntualidad = $cn['cuenta']->Id_Cuenta;
                                    $cn = $cd->obtenerCuentaPersona($idUsuario, 'UsuarioSubsidio');
                                    if ($cn['status']) {
                                        $usuario_subsidio = $cn['cuenta']->Id_Cuenta;
                                        $cn = $cd->obtenerCuentaPersona($idUsuario, 'AcreedoresDiversos');
                                        if ($cn['status']) {
                                            $acredores_diversos = $cn['cuenta']->Id_Cuenta;
                                            $cn = $cd->obtenerCuentaPersona($idUsuario, 'Deudores');
                                            if ($cn['status']) {
                                                $deudores = $cn['cuenta']->Id_Cuenta;
                                                $cn = $cd->obtenerCuentaPersona($idUsuario, 'GastosComprobar');
                                                if ($cn['status']) {
                                                    $gastos_comprobar = $cn['cuenta']->Id_Cuenta;
                                                    $obj = new stdClass();
                                                    $obj->nomina = $usuario_nomina;
                                                    $obj->despensa = $usuario_despensa;
                                                    $obj->asistencia = $usuario_asistencia;
                                                    $obj->puntualidad = $usuario_puntualidad;
                                                    $obj->subsidio = $usuario_subsidio;
                                                    $obj->gastos = $acredores_diversos;
                                                    $obj->deudor = $deudores;
                                                    $obj->gastos_comprobar = $gastos_comprobar;
                                                    $response['cuentas'] = $obj;
                                                } else {
                                                    $response['status'] = false;
                                                    $response['mensaje'] = $cd['error'];
                                                }
                                            } else {
                                                $response['status'] = false;
                                                $response['mensaje'] = $cd['error'];
                                            }
                                        } else {
                                            $response['status'] = false;
                                            $response['mensaje'] = $cd['error'];
                                        }
                                    } else {
                                        $response['status'] = false;
                                        $response['mensaje'] = $cd['error'];
                                    }
                                } else {
                                    $response['status'] = false;
                                    $response['mensaje'] = $cd['error'];
                                }
                            } else {
                                $response['status'] = false;
                                $response['mensaje'] = $cd['error'];
                            }
                        } else {
                            $response['status'] = false;
                            $response['mensaje'] = $cd['error'];
                        }
                    } else {
                        $response['status'] = false;
                        $response['mensaje'] = $cd['error'];
                    }
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $nomina['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $direccion['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $us['error'];
        }

        echo json_encode($response);
    }

    /*     * ************************************
     * Metodo: altaUsuarioControler()
     * Param: Objeto Ajax-> direccion, usuario, nomina, cuentas, perfil, modulo, subtareas
     * Desarrollo: AGRA
     * Descripción: Alta de usuario
     * Observación: podriamos dividir la pantalla para que los permisos se den de alta por ajax, sin confirmación
     */

    public function altaUsuarioController() {
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Validador.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'Direccion.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DireccionDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'TareasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuentasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Nomina.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PreguntaCursoInternoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInduccionDao.php';

        $perfil = filter_input(INPUT_POST, 'perfil', FILTER_SANITIZE_STRING);
        $premioAsistencia = filter_input(INPUT_POST, 'premioAsistencia', FILTER_SANITIZE_STRING);
        $premioPuntualidad = filter_input(INPUT_POST, 'premioPuntualidad', FILTER_SANITIZE_STRING);
        $premioDespensa = filter_input(INPUT_POST, 'premioDespensa', FILTER_SANITIZE_STRING);
        $Jdireccion = $_POST['direccion'];
        $Jusuario = $_POST['usuario'];
        $Jnomina = $_POST['nomina'];

        $tipo = 1;
        $response = array();

        $direccion = json_decode($Jdireccion);
        $usuario = json_decode($Jusuario);
        $nomina = json_decode($Jnomina);
        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'licencia' . DIRECTORY_SEPARATOR;

        if (isset($_FILES['pdfLicencia']['name'])) {
           if (move_uploaded_file($_FILES['pdfLicencia']['tmp_name'], $ruta . "Verificacion.pdf")) {

                //Obtenemos datos de la dirección y encapsulamos
                $d = new Direccion();

                $d->__set('_calle', filter_var($direccion->calle, FILTER_SANITIZE_STRING));
                $d->__set('_interior', filter_var($direccion->interior, FILTER_SANITIZE_STRING));
                $d->__set('_exterior', filter_var($direccion->exterior, FILTER_SANITIZE_STRING));
                $d->__set('_colonia', filter_var($direccion->colonia, FILTER_SANITIZE_STRING));
                $d->__set('_ciudad', filter_var($direccion->ciudad, FILTER_SANITIZE_STRING));
                $d->__set('_estado', filter_var($direccion->estado, FILTER_SANITIZE_STRING));
                $d->__set('_cp', (int)filter_var($direccion->codigo, FILTER_SANITIZE_NUMBER_INT));
                $d->__set('_telefono', filter_var($direccion->telefono, FILTER_SANITIZE_STRING));
                $d->__set('_celular', filter_var($direccion->celular, FILTER_SANITIZE_STRING));

                $dir = new DireccionDao();
                $direccion = $dir->guardarDireccion($d, $tipo);

                if ($direccion['status']) {
                    $idDireccion = $direccion['idDireccion'];
                    $d->__set('_idDireccion', $idDireccion);
                    $fecha_ingreso = filter_var($usuario->fecha_ingreso, FILTER_SANITIZE_STRING);
                    list($ano, $mes, $dia) = explode("-", $fecha_ingreso);
                    $user = new UsuarioDao();
                    $dataUser = $user->generaNoEmpleadoDAO($ano, $mes, $dia);

                    if ($dataUser['status']) {
                        $no_empleado = $dataUser['no_empleado'];

                        $u = new Usuario();

                        $u->__set('_nombre', filter_var($usuario->nombre, FILTER_SANITIZE_STRING));
                        $u->__set('_paterno', filter_var($usuario->paterno, FILTER_SANITIZE_STRING));
                        $u->__set('_materno', filter_var($usuario->materno, FILTER_SANITIZE_STRING));
                        $u->__set('_usuario', filter_var($usuario->usuario, FILTER_SANITIZE_STRING));
                        $pass = filter_var($usuario->contrasena, FILTER_SANITIZE_STRING);
                        $pass = md5(md5($pass));
                        $u->__set('_contrasena', $pass);
                        $u->__set('_tipo', $perfil);
                        $u->__set('_email', filter_var($usuario->email, FILTER_SANITIZE_STRING));
                        $u->__set('_status', 1);
                        $u->__set('_fechaRegistro', $fecha_ingreso);
                        $u->__set('_rfc', filter_var($usuario->rfc, FILTER_SANITIZE_STRING));
                        $u->__set('_nss', filter_var($usuario->nss, FILTER_SANITIZE_STRING));
                        $u->__set('_curp', filter_var($usuario->curp, FILTER_SANITIZE_STRING));
                        $u->__set('_idDireccion', $d->__get('_idDireccion'));
                        $u->__set('_idSucursal', Sesion::obtener('idSucursal'));
                        $u->__set('_idRegimenContratacion', filter_var($usuario->regimen_contratacion, FILTER_SANITIZE_NUMBER_INT));
                        $u->__set('_idBancoPagoNomina', filter_var($usuario->banco_pago_nomina, FILTER_SANITIZE_NUMBER_INT));
                        $u->__set('_idRiesgoPuesto', filter_var($usuario->riesgo_puesto, FILTER_SANITIZE_NUMBER_INT));
                        $u->__set('_tipoContratacion', filter_var($usuario->tipo_contratacion, FILTER_SANITIZE_STRING));
                        $u->__set('_departamento', filter_var($usuario->departamento, FILTER_SANITIZE_STRING));
                        $u->__set('_tipoJornada', filter_var($usuario->tipo_jornada, FILTER_SANITIZE_STRING));
                        $u->__set('_periodicidadPago', filter_var($usuario->periodicidad_pago, FILTER_SANITIZE_STRING));
                        $u->__set('_noEmpleado', $no_empleado);
                        $u->__set('_clabe', filter_var($usuario->clabe, FILTER_SANITIZE_STRING));
                        $u->__set('_idGerente', 0);
                        $u->__set('_mando', 0);
                        $u->__set('_idSesion', '');
                        $u->__set('_marketing', 0);
                        $u->__set('_codigoBarras', '');
                        $u->__set('_fechaBaja', null);

                        $dataUserAlta = $user->altaUsuarioDAO($u, $tipo);
                        if ($dataUserAlta['status']) {
                            $idUsuario = $dataUserAlta['id_usuario'];
                            $u->__set('_idUsuario', $idUsuario);

                            $n = new Nomina();
                            $n->__set('_idUsuario', $idUsuario);
                            $n->__set('_sueldo', filter_var($nomina->sueldo, FILTER_SANITIZE_STRING));
                            $n->__set('_diasAguinaldo', filter_var($nomina->dias_aguinaldo, FILTER_SANITIZE_NUMBER_INT));
                            $n->__set('_diasVacaciones', filter_var($nomina->dias_vacaciones, FILTER_SANITIZE_NUMBER_INT));
                            $n->__set('_primaVacacional', filter_var($nomina->prima_vacacional, FILTER_SANITIZE_STRING));
                            $n->__set('_pensionAlimenticia', filter_var($nomina->pension_alimenticia, FILTER_SANITIZE_STRING));
                            $n->__set('_prestamoInfonavit', filter_var($nomina->prestamo_infonavit, FILTER_SANITIZE_STRING));
                            $n->__set('_asistencia', filter_var($nomina->asistencia, FILTER_SANITIZE_STRING));
                            $n->__set('_puntualidad', filter_var($nomina->asistencia, FILTER_SANITIZE_STRING));
                            $n->__set('_despensa', filter_var($nomina->despensa, FILTER_SANITIZE_STRING));
                            $n->__set('_forma_de_pago', filter_var($nomina->forma_de_pago, FILTER_SANITIZE_STRING));
                            $n->__set('_servicio_fronterizo', filter_var($nomina->servicio_fronterizo, FILTER_SANITIZE_STRING));
                            $n->__set('_entidad_de_servicio', filter_var($nomina->estado, FILTER_SANITIZE_STRING));
                            $n->__set('_tipo_prestamo_infonavit', filter_var($nomina->tipo_infonavit, FILTER_SANITIZE_STRING));
                            $n->__set('_tipo_nomina', filter_var($nomina->tipo_nomina, FILTER_SANITIZE_STRING));
                            //                    $n->__set('_proveedor', filter_var($nomina->proveedor, FILTER_SANITIZE_NUMBER_INT));
                            $n->__set('_porcentaje_interno', filter_var($nomina->porcentaje_interna, FILTER_SANITIZE_STRING));
                            $n->__set('_porcentaje_externo', filter_var($nomina->porcentaje_externa, FILTER_SANITIZE_STRING));
                            $n->__set('_banderaAsistencia', filter_var($premioAsistencia, FILTER_SANITIZE_STRING));
                            $n->__set('_banderaPuntualidad', filter_var($premioPuntualidad, FILTER_SANITIZE_STRING));
                            $n->__set('_banderaDespensa', filter_var($premioDespensa, FILTER_SANITIZE_STRING));
                            //                    $n->__set('_isr', filter_var($nomina->isr, FILTER_SANITIZE_STRING));
                            //                    $n->__set('_comisiones', filter_var($nomina->comisiones, FILTER_SANITIZE_NUMBER_INT));


                            $cuenta_nomina = filter_var($nomina->cuenta_nomina, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_despensa = filter_var($nomina->cuenta_despensa, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_asistencia = filter_var($nomina->cuenta_asistencia, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_puntualidad = filter_var($nomina->cuenta_puntualidad, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_subsidio = filter_var($nomina->cuenta_subsidio, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_gastos = filter_var($nomina->cuenta_gastos, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_deudor = filter_var($nomina->cuenta_deudor, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_gastos_comprobar = filter_var($nomina->cuenta_gastos_comprobar, FILTER_SANITIZE_NUMBER_INT);

                            $idNomina = $user->altaNominaUsuarioDAO($n, $tipo);
                            if ($idNomina['status']) {
                                $n->__set('_idNomina', $idNomina['id_nomina']);

                                // VINCULAR PROVEEDORES
                                $this->vincularProveedoresExternosANomina($idNomina['id_nomina'], $idUsuario, $nomina->vinculosConProveedor);


                                $cd = new CuentasDao();
                                $respA = $cd->asignarCuenta($cuenta_nomina, $u->__get('_idUsuario'), 'UsuarioNomina', 1);
                                if ($respA['status']) {
                                    $respD = $cd->asignarCuenta($cuenta_despensa, $u->__get('_idUsuario'), 'UsuarioDespensa', 1);
                                    if ($respD['status']) {
                                        $respAs = $cd->asignarCuenta($cuenta_asistencia, $u->__get('_idUsuario'), 'UsuarioAsistencia', 1);
                                        if ($respAs['status']) {
                                            $respP = $cd->asignarCuenta($cuenta_puntualidad, $u->__get('_idUsuario'), 'UsuarioPuntualidad', 1);
                                            if ($respP['status']) {
                                                $respS = $cd->asignarCuenta($cuenta_subsidio, $u->__get('_idUsuario'), 'UsuarioSubsidio', 1);
                                                if ($respS['status']) {
                                                    $respAd = $cd->asignarCuenta($cuenta_gastos, $u->__get('_idUsuario'), 'AcreedoresDiversos', 1);
                                                    if ($respAd['status']) {
                                                        $respD = $cd->asignarCuenta($cuenta_deudor, $u->__get('_idUsuario'), 'Deudores', 1);
                                                        if ($respD['status']) {
                                                            $respGc = $cd->asignarCuenta($cuenta_gastos_comprobar, $u->__get('_idUsuario'), 'GastosComprobar', 1);
                                                            if ($respGc['status']) {

                                                                $cursoInduccionDao = new CursoInduccionDao();
                                                                $hoy = date("Y-m-d");
                                                                $fechafinal = date("Y-m-d", strtotime($hoy . "+ 1 month"));

                                                                $cursoInduccionDao->asignarCursosInduccion($u->__get('_idUsuario'), $fechafinal, $perfil);


                                                                $response['status'] = true;
                                                                $response['id_direccion'] = $d->__get('_idDireccion');
                                                                $response['id_usuario'] = $u->__get('_idUsuario');
                                                                $response['id_nomina'] = $n->__get('_idNomina');
                                                                $response['mensaje'] = 'Se guardó el usuario correctamente';

                                                                $ta = new TareasDao();
                                                                $tareas = $ta->agregaPermisoDao($idUsuario);
                                                                $subTareas = $ta->agregaSubPermisoDao($idUsuario);

                                                                if ($tareas['status'] && $subTareas['status']) {
                                                                    $response['permiso'] = 'tareas y subtareas correcto';
                                                                } else {
                                                                    $response['permiso'] = 'problemas al insertar tareas y subtareas';
                                                                }
                                                            } else {
                                                                //eliminar nomina user
                                                                //eliminar usuario
                                                                //eliminar direccion
                                                                $response['status'] = false;
                                                                $response['mensaje'] = 'No se pudo asignar la cuenta tipo GastosComprobar';
                                                            }
                                                        } else {
                                                            //eliminar nomina user
                                                            //eliminar usuario
                                                            //eliminar direccion
                                                            $response['status'] = false;
                                                            $response['mensaje'] = 'No se pudo asignar la cuenta tipo Deudores';
                                                        }
                                                    } else {
                                                        //eliminar nomina user
                                                        //eliminar usuario
                                                        //eliminar direccion
                                                        $response['status'] = false;
                                                        $response['mensaje'] = 'No se pudo asignar la cuenta tipo AcreedoresDiversos';
                                                    }
                                                } else {
                                                    //eliminar nomina user
                                                    //eliminar usuario
                                                    //eliminar direccion
                                                    $response['status'] = false;
                                                    $response['mensaje'] = 'No se pudo asignar la cuenta tipo UsuarioSubsidio';
                                                }
                                            } else {
                                                //eliminar nomina user
                                                //eliminar usuario
                                                //eliminar direccion
                                                $response['status'] = false;
                                                $response['mensaje'] = 'No se pudo asignar la cuenta tipo UsuarioPuntualidad';
                                            }
                                        } else {
                                            //eliminar nomina user
                                            //eliminar usuario
                                            //eliminar direccion
                                            $response['status'] = false;
                                            $response['mensaje'] = 'No se pudo asignar la cuenta tipo UsuarioAsistencia';
                                        }
                                    } else {
                                        //eliminar nomina user
                                        //eliminar usuario
                                        //eliminar direccion
                                        $response['status'] = false;
                                        $response['mensaje'] = 'No se pudo asignar la cuenta tipo UsuarioDespensa';
                                    }
                                } else {
                                    //eliminar nomina user
                                    //eliminar usuario
                                    //eliminar direccion
                                    $response['status'] = false;
                                    $response['mensaje'] = 'No se pudo asignar la cuenta tipo UsuarioNomina';
                                }
                            }// truena alta de nomina usuario
                            else {
                                //$cont->eliminar($p);
                                $response['status'] = false;
                                $response['mensaje'] = $idNomina['error'];
                            }
                        }// truena alta de usuario
                        else {
                            //$dir->eliminar($d);
                            $response['status'] = false;
                            $response['mensaje'] = $dataUserAlta['error'];
                        }
                    }// truena generación de numero de empleado
                    else {
                        //$dir->eliminar($d);
                        $response['status'] = false;
                        $response['mensaje'] = $dataUser['error'];
                    }
                }// truena el insert de la dirección
                else {
                    $response['status'] = false;
                    $response['mensaje'] = $direccion['error'];

                }
            }
        }


        echo json_encode($response);
    }

    /*     * ************************************
     * Metodo: actualizaUsuarioControler()
     * Param: Objeto Ajax-> direccion, usuario, nomina, perfil
     * Desarrollo: AGRA
     * Descripción: Actualiza Usuario
     * Observación: podriamos dividir la pantalla para que los permisos se den de alta por ajax, sin confirmación
     */

    public function actualizaUsuarioController() {
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Validador.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'Direccion.php';
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'DireccionDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuentasDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Nomina.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AgendaDao.php';

//        subirDocumentosController actualizaUsuarioController

        $perfil = filter_input(INPUT_POST, 'perfil', FILTER_SANITIZE_STRING);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_STRING);
        $premioAsistencia = filter_input(INPUT_POST, 'premioAsistencia', FILTER_SANITIZE_STRING);
        $premioPuntualidad = filter_input(INPUT_POST, 'premioPuntualidad', FILTER_SANITIZE_STRING);
        $premioDespensa = filter_input(INPUT_POST, 'premioDespensa', FILTER_SANITIZE_STRING);
        $regimen = filter_input(INPUT_POST, 'regimen', FILTER_SANITIZE_STRING);

        $licencia = filter_input(INPUT_POST, 'numLicencia', FILTER_SANITIZE_STRING);
        $vigenciaLicencia = filter_input(INPUT_POST, 'vigenciaLicencia', FILTER_SANITIZE_STRING);

        Utils::logInfo('','Vigencia: '.$vigenciaLicencia,'Licencia: '.$licencia);

        $Jdireccion = $_POST['direccion'];
        $Jusuario = $_POST['usuario'];

        if(isset($_POST['nomina'])){
            $Jnomina = $_POST['nomina'];
            $nomina = json_decode($Jnomina);
            $actualizaNomina = true;
        } else {
            $actualizaNomina = false;
        }

        $tipo = 2;
        $response = array();
        $direccion = json_decode($Jdireccion);
        $usuario = json_decode($Jusuario);


        //Obtenemos datos de la dirección y encapsulamos
                $d = new Direccion();

                $d->__set('_idDireccion', filter_var($direccion->id_direccion, FILTER_SANITIZE_NUMBER_INT));
                $d->__set('_calle', filter_var($direccion->calle, FILTER_SANITIZE_STRING));
                $d->__set('_interior', filter_var($direccion->interior, FILTER_SANITIZE_STRING));
                $d->__set('_exterior', filter_var($direccion->exterior, FILTER_SANITIZE_STRING));
                $d->__set('_colonia', filter_var($direccion->colonia, FILTER_SANITIZE_STRING));
                $d->__set('_ciudad', filter_var($direccion->ciudad, FILTER_SANITIZE_STRING));
                $d->__set('_estado', filter_var($direccion->estado, FILTER_SANITIZE_STRING));
                $d->__set('_cp', (int)filter_var($direccion->codigo, FILTER_SANITIZE_NUMBER_INT));
                $d->__set('_telefono', filter_var($direccion->telefono, FILTER_SANITIZE_STRING));
                $d->__set('_celular', filter_var($direccion->celular, FILTER_SANITIZE_STRING));

                $dir = new DireccionDao();
                $direccion = $dir->guardarDireccion($d, $tipo);

                if ($direccion['status']) {
                    $idDireccion = $direccion['idDireccion'];
                    $d->__set('_idDireccion', $idDireccion);
                    //$fecha_ingreso = filter_var($usuario->fecha_ingreso, FILTER_SANITIZE_STRING);
                    //list($ano, $mes, $dia) = explode("-", $fecha_ingreso);
                    $user = new UsuarioDao();
                    //$dataUser = $user->generaNoEmpleadoDAO($ano,$mes,$dia);
                    //   if ($dataUser['status']){
                    //       $no_empleado = $dataUser['no_empleado'];

                    $u = new Usuario();
                    $u->__set('_idUsuario', filter_var($usuario->id_usuario, FILTER_SANITIZE_NUMBER_INT));
                    $u->__set('_nombre', filter_var($usuario->nombre, FILTER_SANITIZE_STRING));
                    $u->__set('_paterno', filter_var($usuario->paterno, FILTER_SANITIZE_STRING));
                    $u->__set('_materno', filter_var($usuario->materno, FILTER_SANITIZE_STRING));
                    $u->__set('_usuario', filter_var($usuario->usuario, FILTER_SANITIZE_STRING));
                    $pass = filter_var($usuario->contrasena, FILTER_SANITIZE_STRING);
                    $u->__set('_tipo', $perfil);
                    $u->__set('_email', filter_var($usuario->email, FILTER_SANITIZE_STRING));
                    $u->__set('_fechaRegistro', filter_var($usuario->fecha_ingreso, FILTER_SANITIZE_STRING));
                    $u->__set('_rfc', filter_var($usuario->rfc, FILTER_SANITIZE_STRING));
                    $u->__set('_nss', filter_var($usuario->nss, FILTER_SANITIZE_STRING));
                    $u->__set('_curp', filter_var($usuario->curp, FILTER_SANITIZE_STRING));
                    $u->__set('_idDireccion', $d->__get('_idDireccion'));
                    $u->__set('_idSucursal', Sesion::obtener('idSucursal'));
                    $u->__set('_idRegimenContratacion', filter_var($usuario->regimen_contratacion, FILTER_SANITIZE_NUMBER_INT));
                    $u->__set('_idBancoPagoNomina', filter_var($usuario->banco_pago_nomina, FILTER_SANITIZE_NUMBER_INT));
                    $u->__set('_idRiesgoPuesto', filter_var($usuario->riesgo_puesto, FILTER_SANITIZE_NUMBER_INT));
                    $u->__set('_tipoContratacion', filter_var($usuario->tipo_contratacion, FILTER_SANITIZE_STRING));
                    $u->__set('_departamento', filter_var($usuario->departamento, FILTER_SANITIZE_STRING));
                    $u->__set('_tipoJornada', filter_var($usuario->tipo_jornada, FILTER_SANITIZE_STRING));
                    $u->__set('_periodicidadPago', filter_var($usuario->periodicidad_pago, FILTER_SANITIZE_STRING));
                    $u->__set('_regimen', filter_var($regimen));
                    $u->__set('_licencia', filter_var($licencia));
                    $u->__set('_vigenciaLicencia', filter_var($vigenciaLicencia));

                    //$u->__set('_noEmpleado',            filter_var($usuario->no_empleado, FILTER_SANITIZE_NUMBER_INT));
                    $u->__set('_clabe', filter_var($usuario->clabe, FILTER_SANITIZE_STRING));
                    $u->__set('_status', filter_var($status, FILTER_SANITIZE_NUMBER_INT));
                    if ($status == -1) {
                        $u->__set('_fechaBaja', filter_var($usuario->fecha_baja, FILTER_SANITIZE_STRING));
                        $u->__set('_razonBaja', filter_var($usuario->razon_baja, FILTER_SANITIZE_STRING));
                    } else {
                        $u->__set('_fechaBaja', null);
                        $u->__set('_razonBaja', null);
                    }

                    $old_perfil = $user->obtenerRol($u->__get('_idUsuario'));
                    if ($old_perfil['status']) {
                        if ($perfil != $old_perfil['rol']->Tipo) {
                            $agenda = new AgendaDao();
                            $eliminia = $agenda->eliminaAgendaDAO($u->__get('_idUsuario'));
                            switch ($perfil) {
                                case 1:
                                    $nivel = "Direccion";
                                    break;
                                case 2:
                                    $nivel = "Gerencia";
                                    break;
                                case 3:
                                    $nivel = "Administrador";
                                    break;
                                case 4:
                                    $nivel = "Vendedor";
                                    break;
                                case 5:
                                    $nivel = "Repartidor";
                                    break;
                            }
                            $actividades = $agenda->obtenActividadNivelAgendaDao($nivel);
                            foreach ($actividades as $act) {
                                $id_actividad = $act->Id_Actividad;
                                $obligacion = $act->Obligatoria;
                                $agregado = $agenda->agregarActividadAgendaDAO($u->__get('_idUsuario'), $id_actividad, $obligacion);
                            }
                        }
                    }

                    $dataUserActualiza = $user->altaUsuarioDAO($u, $tipo);
                    if ($dataUserActualiza['status']) {
                        $idUsuario = $dataUserActualiza['id_usuario'];
                        $u->__set('_idUsuario', $idUsuario);

                        if ($pass != '') {
                            $password = md5($pass);
                            $u->__set('_contrasena', $password);
                            $u->__set('_fechaPassword', date("Y-m-d"));

                            $cambio = $user->actualizarContrasena($u);
                            if ($cambio['status']) {
                                $response['status'] = true;
                                $response['mensaje'] = 'Contraseña cambiada correctamente.';
                            } else {
                                $response['status'] = false;
                                $response['mensaje'] = $cambio['error'];
                            }
                        }

                        if($actualizaNomina){
                            $n = new Nomina();
                            $n->__set('_idUsuario', $idUsuario);
                            $n->__set('_idNomina', filter_var($nomina->id_nomina, FILTER_SANITIZE_NUMBER_INT));
                            $n->__set('_sueldo', filter_var($nomina->sueldo, FILTER_SANITIZE_STRING));
                            $n->__set('_diasAguinaldo', filter_var($nomina->dias_aguinaldo, FILTER_SANITIZE_NUMBER_INT));
                            $n->__set('_diasVacaciones', filter_var($nomina->dias_vacaciones, FILTER_SANITIZE_NUMBER_INT));
                            $n->__set('_primaVacacional', filter_var($nomina->prima_vacacional, FILTER_SANITIZE_STRING));
                            $n->__set('_pensionAlimenticia', filter_var($nomina->pension_alimenticia, FILTER_SANITIZE_STRING));
                            $n->__set('_prestamoInfonavit', filter_var($nomina->prestamo_infonavit, FILTER_SANITIZE_STRING));
                            $n->__set('_asistencia', filter_var($nomina->asistencia, FILTER_SANITIZE_STRING));
                            $n->__set('_puntualidad', filter_var($nomina->asistencia, FILTER_SANITIZE_STRING));
                            $n->__set('_despensa', filter_var($nomina->despensa, FILTER_SANITIZE_STRING));
                            $n->__set('_forma_de_pago', filter_var($nomina->forma_de_pago, FILTER_SANITIZE_STRING));
                            $n->__set('_servicio_fronterizo', filter_var($nomina->servicio_fronterizo, FILTER_SANITIZE_STRING));
                            $n->__set('_entidad_de_servicio', filter_var($nomina->estado, FILTER_SANITIZE_STRING));
                            $n->__set('_tipo_prestamo_infonavit', filter_var($nomina->tipo_infonavit, FILTER_SANITIZE_STRING));
                            $n->__set('_tipo_nomina', filter_var($nomina->tipo_nomina, FILTER_SANITIZE_STRING));
                            //                $n->__set('_proveedor', filter_var($nomina->proveedor, FILTER_SANITIZE_NUMBER_INT));
                            $n->__set('_porcentaje_interno', filter_var($nomina->porcentaje_interna, FILTER_SANITIZE_STRING));
                            $n->__set('_porcentaje_externo', filter_var($nomina->porcentaje_externa, FILTER_SANITIZE_STRING));
                            $n->__set('_isr', filter_var($nomina->isr, FILTER_SANITIZE_STRING));
                            $n->__set('_banderaAsistencia', filter_var($premioAsistencia, FILTER_SANITIZE_STRING));
                            $n->__set('_banderaPuntualidad', filter_var($premioPuntualidad, FILTER_SANITIZE_STRING));
                            $n->__set('_banderaDespensa', filter_var($premioDespensa, FILTER_SANITIZE_STRING));

                            //                $n->__set('_comisiones', filter_var($nomina->comisiones, FILTER_SANITIZE_NUMBER_INT));
                            //                $n->__set('_imms_patronal', filter_var($nomina->imms_patronal, FILTER_SANITIZE_NUMBER_INT));

                            $cuenta_nomina = filter_var($nomina->cuenta_nomina, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_despensa = filter_var($nomina->cuenta_despensa, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_asistencia = filter_var($nomina->cuenta_asistencia, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_puntualidad = filter_var($nomina->cuenta_puntualidad, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_subsidio = filter_var($nomina->cuenta_subsidio, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_gastos = filter_var($nomina->cuenta_gastos, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_deudor = filter_var($nomina->cuenta_deudor, FILTER_SANITIZE_NUMBER_INT);
                            $cuenta_gastos_comprobar = filter_var($nomina->cuenta_gastos_comprobar, FILTER_SANITIZE_NUMBER_INT);

                            $idNomina = $user->altaNominaUsuarioDAO($n, $tipo);
                            if ($idNomina['status']) {
                                $n->__set('_idNomina', $idNomina['id_nomina']);

                                // VINCULAR PROVEEDORES
                                $this->vincularProveedoresExternosANomina($idNomina['id_nomina'], $idUsuario, $nomina->vinculosConProveedor);


                                $cd = new CuentasDao();
                                $tipoCuenta = $this->validarCuenta($u->__get('_idUsuario'), 'UsuarioNomina');
                                $respA = $cd->asignarCuenta($cuenta_nomina, $u->__get('_idUsuario'), 'UsuarioNomina', $tipoCuenta);
                                if ($respA['status']) {
                                    $tipoCuenta = $this->validarCuenta($u->__get('_idUsuario'), 'UsuarioDespensa');
                                    $respD = $cd->asignarCuenta($cuenta_despensa, $u->__get('_idUsuario'), 'UsuarioDespensa', $tipoCuenta);
                                    if ($respD['status']) {
                                        $tipoCuenta = $this->validarCuenta($u->__get('_idUsuario'), 'UsuarioAsistencia');
                                        $respAs = $cd->asignarCuenta($cuenta_asistencia, $u->__get('_idUsuario'), 'UsuarioAsistencia', $tipoCuenta);
                                        if ($respAs['status']) {
                                            $tipoCuenta = $this->validarCuenta($u->__get('_idUsuario'), 'UsuarioPuntualidad');
                                            $respP = $cd->asignarCuenta($cuenta_puntualidad, $u->__get('_idUsuario'), 'UsuarioPuntualidad', $tipoCuenta);
                                            if ($respP['status']) {
                                                $tipoCuenta = $this->validarCuenta($u->__get('_idUsuario'), 'UsuarioSubsidio');
                                                $respS = $cd->asignarCuenta($cuenta_subsidio, $u->__get('_idUsuario'), 'UsuarioSubsidio', $tipoCuenta);
                                                if ($respS['status']) {
                                                    $tipoCuenta = $this->validarCuenta($u->__get('_idUsuario'), 'AcreedoresDiversos');
                                                    $respAd = $cd->asignarCuenta($cuenta_gastos, $u->__get('_idUsuario'), 'AcreedoresDiversos', $tipoCuenta);
                                                    if ($respAd['status']) {
                                                        $tipoCuenta = $this->validarCuenta($u->__get('_idUsuario'), 'Deudores');
                                                        $respD = $cd->asignarCuenta($cuenta_deudor, $u->__get('_idUsuario'), 'Deudores', $tipoCuenta);
                                                        if ($respD['status']) {
                                                            $tipoCuenta = $this->validarCuenta($u->__get('_idUsuario'), 'GastosComprobar');
                                                            $respGc = $cd->asignarCuenta($cuenta_gastos_comprobar, $u->__get('_idUsuario'), 'GastosComprobar', $tipoCuenta);
                                                            if ($respGc['status']) {
                                                                $response['status'] = true;
                                                                $response['id_direccion'] = $d->__get('_idDireccion');
                                                                $response['id_usuario'] = $u->__get('_idUsuario');
                                                                $response['id_nomina'] = $n->__get('_idNomina');
                                                                $response['mensaje'] = 'Se actualizaron los datos del usuario correctamente';
                                                            } else {
                                                                //eliminar nomina user
                                                                //eliminar usuario
                                                                //eliminar direccion
                                                                $response['status'] = false;
                                                                $response['mensaje'] = 'No se pudo Actualizar la cuenta tipo GastosComprobar';
                                                            }
                                                        } else {
                                                            //eliminar nomina user
                                                            //eliminar usuario
                                                            //eliminar direccion
                                                            $response['status'] = false;
                                                            $response['mensaje'] = 'No se pudo Actualizar la cuenta tipo Deudores';
                                                        }
                                                    } else {
                                                        //eliminar nomina user
                                                        //eliminar usuario
                                                        //eliminar direccion
                                                        $response['status'] = false;
                                                        $response['mensaje'] = 'No se pudo Actualizar la cuenta tipo AcreedoresDiversos';
                                                    }
                                                } else {
                                                    //eliminar nomina user
                                                    //eliminar usuario
                                                    //eliminar direccion
                                                    $response['status'] = false;
                                                    $response['mensaje'] = 'No se pudo Actualizar la cuenta tipo UsuarioSubsidio';
                                                }
                                            } else {
                                                //eliminar nomina user
                                                //eliminar usuario
                                                //eliminar direccion
                                                $response['status'] = false;
                                                $response['mensaje'] = 'No se pudo Actualizar la cuenta tipo UsuarioPuntualidad';
                                            }
                                        } else {
                                            //eliminar nomina user
                                            //eliminar usuario
                                            //eliminar direccion
                                            $response['status'] = false;
                                            $response['mensaje'] = 'No se pudo Actualizar la cuenta tipo UsuarioAsistencia';
                                        }
                                    } else {
                                        //eliminar nomina user
                                        //eliminar usuario
                                        //eliminar direccion
                                        $response['status'] = false;
                                        $response['mensaje'] = 'No se pudo Actualizar la cuenta tipo UsuarioDespensa';
                                    }
                                } else {
                                    //eliminar nomina user
                                    //eliminar usuario
                                    //eliminar direccion
                                    $response['status'] = false;
                                    $response['mensaje'] = 'No se pudo Actualizar la cuenta tipo UsuarioNomina';
                                }
                            }// truena alta de nomina usuario
                            else {
                                //$cont->eliminar($p);
                                $response['status'] = false;
                                $response['mensaje'] = $idNomina['error'];
                            }
                        } else {
                            $response['status'] = true;
                            $response['id_direccion'] = $d->__get('_idDireccion');
                            $response['id_usuario'] = $u->__get('_idUsuario');
                            $response['id_nomina'] = 0;
                            $response['mensaje'] = 'Se actualizaron los datos del usuario correctamente';
                        }
                    }// truena alta de usuario
                    else {
                        //$dir->eliminar($d);
                        $response['status'] = false;
                        $response['mensaje'] = $dataUserActualiza['error'];
                    }
                    /*     }// truena generación de numero de empleado
                      else{
                      //$dir->eliminar($d);
                      $response['status'] = false;
                      $response['mensaje'] = $dataUser['error'];
                      } */
                }// truena el insert de la dirección
                else {
                    $response['status'] = false;
                    $response['mensaje'] = $direccion['error'];
                }

        echo json_encode($response);
    }
    
    function vincularProveedoresExternosANomina($idNomina, $idUsuario, $listaProveedores){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'NominaDao.php';
        $nominaDao = new NominaDao();

        $borrarProveedores =  $nominaDao->borrarProveedoresExternosDeLaNominaPorIdNomina($idNomina);
        if($borrarProveedores['status']){
            foreach ($listaProveedores as $proveedor){
                $nominaDao->insertarProveedorExternoDeLaNomina($proveedor->idProveedor, $idUsuario, $proveedor->banderaComisiones, $proveedor->banderaImms, $proveedor->porcentaje, $idNomina, $proveedor->porcentajeComisionProveedor);
            }
        }else {
            $response['status'] = false;
            $response['mensaje'] = $borrarProveedores['error'];
        }



       /* $consultaProveedoresExternosDeNomina = $nominaDao->obtenerProveedoresExternosDeLaNominaPorIdNomina($idNomina);
        if($consultaProveedoresExternosDeNomina['status']){
            $listaProveedoresBD = $consultaProveedoresExternosDeNomina['proveedoresExternosDeNomina'];
            foreach ($listaProveedores as $proveedor){
                $insidencia = false;
                $idNominaProveedoresExternos = '';
                foreach ($listaProveedoresBD as $proveedorBD){
                    if($proveedorBD->id_proveedor == $proveedor->idProveedor){
                        $insidencia = true;
                        $idNominaProveedoresExternos = $proveedorBD->id_nomina_proveedores_externos;
                    }
                }
                if($insidencia == false){
                    // Insertar proveedor
//                    Utils::log('Insertar en nomina el proveedor: '.$proveedor->idProveedor, 'vincularProveedoresExternosANomina', '1239');
                    $nominaDao->insertarProveedorExternoDeLaNomina($proveedor->idProveedor, $idUsuario, $proveedor->banderaComisiones, $proveedor->banderaImms, $proveedor->porcentaje, $idNomina);
                } else {
                    // Actualizar proveedor
//                    Utils::log('Actualizar en nomina el proveedor: '.$proveedor->idProveedor.' - idtabla:'.$idNominaProveedoresExternos, 'vincularProveedoresExternosANomina', '1242');
                    $nominaDao->actualizarProveedorExternoDeLaNomina($idNominaProveedoresExternos, $proveedor->banderaComisiones, $proveedor->banderaImms, $proveedor->porcentaje);
                }
            }
            foreach($listaProveedoresBD as$proveedorBD){
                $insidencia = false;
                foreach ($listaProveedores as $proveedor){
                    if($proveedor->idProveedor == $proveedorBD->id_proveedor){
                        $insidencia = true;
                    }
                }
                if($insidencia == false){
                    // Eliminar proveedor
//                    Utils::log('Eliminar en nomina el proveedor: '.$proveedorBD->id_proveedor.' - idtabla:'.$proveedorBD->id_nomina_proveedores_externos, 'vincularProveedoresExternosANomina', '1249');
                    $nominaDao->eliminarProveedorExternoDeLaNomina($proveedorBD->id_nomina_proveedores_externos);
                }
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $consultaProveedoresExternosDeNomina['error'];
        }
//        return $response; */
    }

    /*
     * método subirDocumentosController($idUsuario)
     */

    public function subirDocumentosController() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idUsuario = (int) filter_input(INPUT_POST, 'id_usuario', FILTER_SANITIZE_NUMBER_INT);
        $numLicencia = filter_input(INPUT_POST, 'user-licencia', FILTER_SANITIZE_STRING);
        $vigenciaLicencia = filter_input(INPUT_POST, 'user-vigencialicencia', FILTER_SANITIZE_STRING);

        $response['status'] = true;
        $response['mensaje'] = 'Los documentos se guardaron exitosamente';

        if (!is_dir(BASEPATH . 'application/usuarios/documentos/')) {
            mkdir(BASEPATH . 'application/usuarios/documentos', 0777);
        }
        $ruta = BASEPATH . 'application/usuarios/documentos/';
        $carpeta = $idUsuario;
        $carpeta = $ruta . $carpeta . '/';
        if (!file_exists($carpeta))
            mkdir($carpeta);

        if ($_FILES['doc-rfc']['name'] != '') {
            $inicio = strpos($_FILES['doc-rfc']['name'], '.');
            // $extension = substr($_FILES['doc-rfc']['name'], $inicio + 1, 3);
            $extension = 'pdf';
            $nombre = 'rfc.' . $extension;
            if (!move_uploaded_file($_FILES['doc-rfc']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-rfc';
            }
        }

        if ($_FILES['doc-ine']['name'] != '') {
            $inicio = strpos($_FILES['doc-ine']['name'], '.');
            $extension = 'pdf';
            $nombre = 'ine.' . $extension;
            if (!move_uploaded_file($_FILES['doc-ine']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-ine';
            }
        }

        if ($_FILES['doc-imss']['name'] != '') {
            $inicio = strpos($_FILES['doc-imss']['name'], '.');
            $extension = 'pdf';
            $nombre = 'imss.' . $extension;
            if (!move_uploaded_file($_FILES['doc-imss']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-imss';
            }
        }

        if ($_FILES['doc-domi']['name'] != '') {
            $inicio = strpos($_FILES['doc-domi']['name'], '.');
            $extension = 'pdf';
            $nombre = 'domicilio.' . $extension;
            if (!move_uploaded_file($_FILES['doc-domi']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-domi';
            }
        }

        if ($_FILES['doc-licencia']['name'] != '') {
            $inicio = strpos($_FILES['doc-licencia']['name'], '.');
            $extension = 'pdf';
            $nombre = 'licencia.' . $extension;

            $u = new Usuario();
            $u->__set('_numLicencia', filter_var($numLicencia, FILTER_SANITIZE_STRING));
            $u->__set('_vigenciaLicencia', filter_var($vigenciaLicencia, FILTER_SANITIZE_STRING));
            $u->__set('_idUsuario', filter_var($idUsuario, FILTER_SANITIZE_NUMBER_INT));

            $user = new UsuarioDao();
            $user->guardarLicencia($u);


            if (!move_uploaded_file($_FILES['doc-licencia']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-licencia';
            }
        }

        if ($_FILES['doc-curp']['name'] != '') {
            $inicio = strpos($_FILES['doc-curp']['name'], '.');
            $extension = 'pdf';
            $nombre = 'curp.' . $extension;
            if (!move_uploaded_file($_FILES['doc-curp']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-curp';
            }
        }

        if ($_FILES['doc-solicitudEmpleo']['name'] != '') {
            $inicio = strpos($_FILES['doc-solicitudEmpleo']['name'], '.');
            $extension = 'pdf';
            $nombre = 'solicitudEmpleo.' . $extension;
            if (!move_uploaded_file($_FILES['doc-solicitudEmpleo']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-solicitudEmpleo';
            }
        }

        if ($_FILES['doc-reco']['name'] != '') {
            $inicio = strpos($_FILES['doc-reco']['name'], '.');
            $extension = 'pdf';
            $nombre = 'carta1.' . $extension;
            if (!move_uploaded_file($_FILES['doc-reco']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-reco';
            }
        }

        if ($_FILES['doc-contrato']['name'] != '') {
            $inicio = strpos($_FILES['doc-contrato']['name'], '.');
            $extension = 'pdf';
            $nombre = 'contrato.' . $extension;
            if (!move_uploaded_file($_FILES['doc-contrato']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-contrato';
            }
        }

        if ($_FILES['doc-altaImss']['name'] != '') {
            $inicio = strpos($_FILES['doc-altaImss']['name'], '.');
            $extension = 'pdf';
            $nombre = 'altaImss.' . $extension;
            if (!move_uploaded_file($_FILES['doc-altaImss']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-altaImss';
            }
        }

        if ($_FILES['doc-bajaImss']['name'] != '') {
            $inicio = strpos($_FILES['doc-bajaImss']['name'], '.');
            $extension = 'pdf';
            $nombre = 'bajaImss.' . $extension;
            if (!move_uploaded_file($_FILES['doc-bajaImss']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-bajaImss';
            }
        }

        if ($_FILES['doc-renuncia']['name'] != '') {
            $inicio = strpos($_FILES['doc-renuncia']['name'], '.');
            $extension = 'pdf';
            $nombre = 'renuncia.' . $extension;
            if (!move_uploaded_file($_FILES['doc-renuncia']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-renuncia';
            }
        }

        if ($_FILES['doc-finiquito']['name'] != '') {
            $inicio = strpos($_FILES['doc-finiquito']['name'], '.');
            $extension = 'pdf';
            $nombre = 'finiquito.' . $extension;
            if (!move_uploaded_file($_FILES['doc-finiquito']['tmp_name'], $carpeta . $nombre)) {
                $response['status'] = false;
                $response['mensaje'] = 'error al subir doc-finiquito';
            }
        }

        echo json_encode($response);
    }

    /*
     * método obtenPermisosUsuarioController($idUsuario)
     */

    public function obtenPermisosUsuarioController() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'TareasDao.php';

        $idUsuario = (int) filter_input(INPUT_GET, 'id_usuario', FILTER_SANITIZE_NUMBER_INT);

        $ta = new TareasDao();
        $response = array();
        $tareas = $ta->obtenPermisoDao($idUsuario);
        if ($tareas['status']) {
            $subtareas = $ta->obtenSubPermisoDao($idUsuario);
            if ($subtareas['status']) {
                $response['status'] = true;
                $response['tareas'] = $tareas['tareas'];
                $response['subtareas'] = $subtareas['subtareas'];
            } else {
                $response['status'] = false;
                $response['mensaje'] = $subtareas['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $tareas['error'];
        }

        echo json_encode($response);
    }

    /*
     * Método modificaTareaController($idUsuario, $id, $tabla, $estado)
     */

    public function modificaTareaController() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'TareasDao.php';

        $idUsuario = (int) filter_input(INPUT_POST, 'id_usuario', FILTER_SANITIZE_NUMBER_INT);
        $id = (int) filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
        $tabla = filter_input(INPUT_POST, 'tabla', FILTER_SANITIZE_STRING);
        $estado = (int) filter_input(INPUT_POST, 'estado', FILTER_SANITIZE_NUMBER_INT);

        $ta = new TareasDao();
        $response = array();
        $actualizado = $ta->modificaTareaDAO($idUsuario, $id, $tabla, $estado);
        if ($actualizado['status']) {
            $response['status'] = true;
            $response['mensaje'] = 'actualizado';
        } else {
            $response['status'] = false;
            $response['mensaje'] = $actualizado['error'];
        }


        echo json_encode($response);
    }

    /** by isantosp * */
    public function getCuentasContables() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'contabilidad' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CuentasDao.php';

        $c = new Cuentas();
        $c->__set('_clave', '');
        $cu = new CuentasDao();
        $cuentas = $cu->obtenerCuentasPorClave($c);
        if ($cuentas['status']) {
            $response['cuentas'] = $cuentas['cuentas'];
            $response['status'] = true;
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cuentas['error'];
        }

        echo json_encode($response);
    }

    public function guardaPermiso() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        $data = $_POST['data'];
        $datosPermiso = json_decode($data);
        $u = new UsuarioDao();

        $perm = $u->guardaPermisoDAO(Sesion::obtener('idUsuario'), Sesion::obtener('idSucursal'), json_decode($data));

        if ($perm['status']) {
            $usuario = $u->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];
            $idGerente = $usuario->Id_Gerente;
            $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            $datos = array("contenido" => $usuario->Nombre . " " . $usuario->Apellido_Paterno . " " . $usuario->Apellido_Materno . " solicita un permiso laboral desde el día " . date("d/m/Y", strtotime($datosPermiso->desde)) . " a las " . date("H:i:s", strtotime($datosPermiso->horaInicio)) . " hasta el día " . date("d/m/Y", strtotime($datosPermiso->hasta)) . " a las " . date("H:i:s", strtotime($datosPermiso->horaFin)) . " por el siguiente motivo: " . $datosPermiso->motivo . "<p>Para autorizarlo vaya a <a href='" . BASEURL . "'>" . BASEURL . "</a>.");
            $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );
            $contexto = stream_context_create($opciones);
            $contenidoEmail = file_get_contents($url, false, $contexto);
            //obtenemos el mail del gerente
            $gerente = $u->obtenerUsuario($idGerente)['usuario'];
            Email::enviarEmail('sistemas@merdizshell.com', '', 'Permiso Laboral', $contenidoEmail);
            Email::enviarEmail('arturomercado.merdiz@gmail.com', '', 'Permiso Laboral', $contenidoEmail);
            Email::enviarEmail('porfiriomercado.merdiz@gmail.com', '', 'Permiso Laboral', $contenidoEmail);
            Email::enviarEmail($gerente->Mail, '', 'Permiso Laboral', $contenidoEmail);
            $response['status'] = true;
            $response['permiso'] = $perm['permiso'];
            $response['mensaje'] = 'Se guardó correctamente el permiso';
        } else {
            $response['status'] = false;
            $response['mensaje'] = $perm['error'];
        }

        echo json_encode($response);
    }

    public function buscarVendedoresActivos() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $termino = filter_input(INPUT_GET, 'term', FILTER_SANITIZE_STRING);

        $u = new UsuarioDao();
        $vendedores = $u->buscaarVendedoresActivos($termino);
        if ($vendedores['status']) {
            $arrayVendedores = new ArrayObject($vendedores['vendedores']);
            $iteradorVendedores = $arrayVendedores->getIterator();
            $vendedoresArray = array();
            while ($iteradorVendedores->valid()) {
                $vendedoresArray[] = array('label' => $iteradorVendedores->current()->Nombre . ' ' . $iteradorVendedores->current()->Apellido_Paterno . ' ' . $iteradorVendedores->current()->Apellido_Materno, 'value' => $iteradorVendedores->current()->Id_Usuario);
                $iteradorVendedores->next();
            }

            $response['status'] = true;
            $response['vendedores'] = $vendedoresArray;
        } else {
            $response['status'] = false;
            $response['mensaje'] = $vendedores['error'];
        }

        echo json_encode($response);
    }

    public function justificaAsistencia() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';

        $idAsistencia = filter_input(INPUT_POST, 'idAsistencia', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);
        $observaciones = filter_input(INPUT_POST, 'observaciones', FILTER_SANITIZE_STRING);
    }

    public function obtenerSolicitudesPermisos() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $u = new UsuarioDao();

        if (Sesion::obtener('idRol') == 1) {
            $permisos = $u->obtenerPermisosLaboralesDirector(Sesion::obtener('idSucursal'));
        } else {
            $permisos = $u->obtenerPermisosLaboralesGerente(Sesion::obtener('idSucursal'), Sesion::obtener('idUsuario'));
        }

        if ($permisos['status']) {
            $response['status'] = true;
            $response['permisos'] = $permisos['permisos'];
        } else {
            $response['status'] = false;
            $response['mensaje'] = $permisos['error'];
        }

        echo json_encode($response);
    }

    public function autorizarRechazarPermiso() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

        $idSolicitud = filter_input(INPUT_POST, 'idSolicitud', FILTER_SANITIZE_NUMBER_INT);
        $status = filter_input(INPUT_POST, 'status', FILTER_SANITIZE_NUMBER_INT);

        $u = new UsuarioDao();
        $cambia = $u->cambiaStatusPermiso($status, $idSolicitud);
        if ($cambia['status']) {
            if (Sesion::obtener('idRol') == 1) {
                $u->actualizaAutorizacionDirector(Sesion::obtener('idUsuario'), $idSolicitud);
            } else {
                $u->actualizaAutorizacionGerente(Sesion::obtener('idUsuario'), $idSolicitud);
            }
            $permiso = $u->obtenerPermisoLaboralPorId($idSolicitud)['permiso'];
            $usuario = $u->obtenerUsuario($permiso->Id_Usuario)['usuarios'];
            $url = BASEURL . 'application/inicio/views/emailNotificaciones.phtml';
            if ($status == 1) {
                $contenido = 'Tu permiso laboral ha sido autorizado por la dirección.';
            } else {
                $contenido = 'Tu permiso laboral ha sido rechazado por la dirección.';
            }
            $datos = array("contenido" => $contenido);
            $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );
            $contexto = stream_context_create($opciones);
            $contenidoEmail = file_get_contents($url, false, $contexto);
            Email::enviarEmail($usuario->Mail, '', 'Permiso Laboral', $contenidoEmail);

            $response['status'] = true;
            if ($status == 1) {
                $response['mensaje'] = 'Permiso autorizado correctamente.';
            } else {
                $response['mensaje'] = 'Permiso rechazado correctamente.';
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $cambia['error'];
        }

        echo json_encode($response);
    }

    public function obtenerUsuariosBloqueados(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR .
            DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $u = new UsuarioDao();
        $usuario = $u->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];

        if($usuario->Usuario == 'jMartinez'){
            $usuarios = $u->obtenerIdUsuariosBloqueadosPorSucursal(5);
        }else{
            $usuarios = $u->obtenerIdUsuariosBloqueados();
        }

        if ($usuarios['status']){


            foreach ($usuarios['usuarios'] as $usu) {
                $idUsuario = $usu->Id_Usuario;

                if($usuario->Usuario == 'jMartinez'){
                    $motivos = $u->obtenermotivosUsuarioBloqueadoGerente($idUsuario);
                }else{
                    $motivos = $u->obtenermotivosUsuarioBloqueado($idUsuario);
                }


               $cadenaMotivos = '';
                foreach ($motivos['usuarios'] as $mot) {

                    $cadenaMotivos = $cadenaMotivos . $mot->tipo_bloqueo . ', ';

                }
                $bloqueos[] = array(
                    'idCliente' => $usu->Id_Usuario,
                    'Nombre' => $usu->Nombre,
                    'Paterno' => $usu->Apellido_Paterno,
                    'Materno' => $usu->Apellido_Materno,
                    'motivos' => $cadenaMotivos
                );

            }


            $response['status'] = true;
            $response['usuarios'] = $usuarios['usuarios'];
            $response['bloqueos'] = $bloqueos;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $usuarios['error'];
        }

        echo json_encode($response);
    }

    public function desbloqueaUsuario(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 
             DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idBloqueoUsuario = filter_input(INPUT_POST, 'idBloqueoUsuario', FILTER_SANITIZE_NUMBER_INT);

        $u = new UsuarioDao();
        $usuario = $u->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];

        if($usuario->Usuario == 'jMartinez'){
            $desbloquea = $u->desbloqueaUsuarioGerente($idBloqueoUsuario);
        }else{
            $desbloquea = $u->desbloqueaUsuario($idBloqueoUsuario);
        }


        if ($desbloquea['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Usuario desbloqueado correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $desbloquea['error'];
        }

        echo json_encode($response);
    }

    public function cargarUsuariosActivos() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $u = new UsuarioDao();
        $t = $u->totalUsuariosActivos();
        if ($t['status']) {
            $total = (int) $t['total'];
            Utils::logInfo('$total : ' .$total .'$registros : ' .$registros, __FILE__, __LINE__);
            $paginas = ceil($total / $registros);
            $usuarios = $u->obtenerUsuariosActivosListado( $inicio, $registros);
            if ($usuarios['status']) {
                $response['status'] = true;
                $response['usuarios'] = $usuarios['usuarios'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $usuarios['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'] . 'TOTAAAAL';
        }

        echo json_encode($response);
    }

    public function totalCompletarUsuarioActivo() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $cadena = filter_input(INPUT_GET, 'cadena', FILTER_SANITIZE_STRING);

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $u = new UsuarioDao();
        $t = $u->totalCompletarUsuarioActivo($cadena, $inicio, $registros);
        if ($t['status']) {
            $total = (int) $t['total'];
            $paginas = ceil($total / $registros);
            $response['status'] = true;
            $response['usuarios'] = $t['usuarios'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;
            //}
            //else{
            //    $response['status'] = false;
            //    $response['mensaje'] = $usuarios['error'].'SUCURSAAAAL';
            //}
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'];
        }

        echo json_encode($response);
    }

    public function obtenerUsuariosNominaIndividual() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $u = new UsuarioDao();
        $t = $u->totalUsuariosActivos();
        if ($t['status']) {
            $total = (int) $t['total'];
            $paginas = ceil($total / $registros);
            $usuarios = $u->obtenerUsuariosActivosParaNominaListado( $inicio, $registros);
            if ($usuarios['status']) {
                $response['status'] = true;
                $response['usuarios'] = $usuarios['usuarios'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $usuarios['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $t['error'] . 'TOTAAAAL';
        }

        echo json_encode($response);
    }

    public function obtenerUsuariosNominaMasiva() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $fechaInicial = filter_input(INPUT_GET, 'fechaInicial', FILTER_SANITIZE_STRING);
        $fechaFinal = filter_input(INPUT_GET, 'fechaFinal', FILTER_SANITIZE_STRING);

        $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosParaNominaMasiva($fechaInicial, $fechaFinal);
            if ($usuarios['status']) {
                $response['status'] = true;
                $response['usuarios'] = $usuarios['usuarios'];
            } else {
                $response['status'] = false;
                $response['mensaje'] = $usuarios['error'];
            }

        echo json_encode($response);
    }

    public function obtenerHistorialDeVacaciones() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idUsuario = filter_input(INPUT_GET, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $fechaInicio = filter_input(INPUT_GET, 'fechaInicio', FILTER_SANITIZE_STRING);
        $fechaFin = filter_input(INPUT_GET, 'fechaFinal', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;
        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $usuarioDao = new UsuarioDao();
        $consultaTotal= $usuarioDao->obtenerTotalDeVacacionesPorUsuarioYFechas($idUsuario, $fechaInicio, $fechaFin);
        if($consultaTotal['status']) {
            $total = (int)$consultaTotal['total'];
            $paginas = ceil($total / $registros);
            $vacaciones = $usuarioDao->obtenerHistorialDeVacacionesPorUsuarioYFechas($idUsuario, $fechaInicio, $fechaFin, $inicio, $registros);
            if ($vacaciones['status']) {
                $response['status'] = true;
                $response['historial'] = $vacaciones['historial'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $vacaciones['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $consultaTotal['error'];
        }

        echo json_encode($response);
    }

    public function obtenerHistorialDeNominas() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idUsuario = filter_input(INPUT_GET, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $fechaInicio = filter_input(INPUT_GET, 'fechaInicio', FILTER_SANITIZE_STRING);
        $fechaFin = filter_input(INPUT_GET, 'fechaFinal', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;
        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $usuarioDao = new UsuarioDao();

        $consultaTotal= $usuarioDao->obtenerTotalDeNominasPorUsuarioYFechas($idUsuario, $fechaInicio, $fechaFin);
        if($consultaTotal['status']){
            $total = (int) $consultaTotal['total'];
            $paginas = ceil($total / $registros);
            $nominas = $usuarioDao->obtenerHistorialDeNominasPorUsuarioYFechas($idUsuario, $fechaInicio, $fechaFin, $inicio, $registros);
            if ($nominas['status']) {
                $response['status'] = true;
                $response['historial'] = $nominas['historial'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $nominas['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $consultaTotal['error'];
        }

        echo json_encode($response);
    }

    public function obtenerHistorialDeTarjetasFirmadas() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idUsuario = filter_input(INPUT_GET, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $fechaInicio = filter_input(INPUT_GET, 'fechaInicio', FILTER_SANITIZE_STRING);
        $fechaFin = filter_input(INPUT_GET, 'fechaFinal', FILTER_SANITIZE_STRING);
        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;
        if ($pagina > $superior) {
            $inferior = $pagina;
            $superior = $pagina + 9;
        }
        if ($inferior > $pagina) {
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $usuarioDao = new UsuarioDao();
        $consultaTotal= $usuarioDao->obtenerTotalDeTarjetasFirmadasPorFechasYUsuario($idUsuario, $fechaInicio, $fechaFin);
        if($consultaTotal['status']){
            $total = (int) $consultaTotal['total'];
            $paginas = ceil($total / $registros);
            $tarjetas = $usuarioDao->obtenerHistorialDeTarjetasFirmadasPorFechasYUsuario($idUsuario, $fechaInicio, $fechaFin, $inicio, $registros);
            if ($tarjetas['status']) {
                $response['status'] = true;
                $response['historial'] = $tarjetas['historial'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;
            } else {
                $response['status'] = false;
                $response['mensaje'] = $tarjetas['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $consultaTotal['error'];
        }

        echo json_encode($response);
    }

    public function sendMail(){
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'HistorialCorreoDao.php';
        $d = new DocumentoClienteDao();
        $c = new HistorialCorreoDao();

        $cliente = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $mail = filter_input(INPUT_POST, 'mail-mail', FILTER_SANITIZE_STRING);
        $asunto = filter_input(INPUT_POST, 'mail-asunto', FILTER_SANITIZE_STRING);
        $mensaje = filter_input(INPUT_POST, 'mail-msg', FILTER_SANITIZE_STRING);
        $archivos = filter_input(INPUT_POST, 'files', FILTER_SANITIZE_STRING);

        $adjuntos = array('file' => array(), 'name' => array());
        $arrFiles = array();

        $urlPagina = 'https://merdizshell.com/';
        $rutaPagina = realpath(BASEPATH.'/..').'/';
        $arrRuta = array(
            'examen-capacitacion' => BASEPATH.'usuarios/exportarReconocimientoCurso',
            'examen-induccion' => BASEPATH.'usuarios/exportarReconocimientoCurso',
        );

       /* if (!empty($_FILES['mail-file']['name']) && ($_FILES['mail-file']['type'] == "application/pdf")){
            $filename = str_replace(' ','_',$_FILES['mail-file']['name']);
            $ruta = '../doc_cliente/';
            $ext = '.pdf';
            copy($_FILES['mail-file']['tmp_name'],$ruta.$filename);

            $adjuntos['file'][] = $arrRuta['adicional'].$filename;
            $adjuntos['name'][] = $filename;
        }else{
            $response['status'] = false;
            $response['mensaje'] = 'El documento debe tener extención PDF.';
        }*/

        $archivos = json_decode($_POST['files']);
        foreach ($archivos as $archi) {
            //Utils::logInfo( $arrRuta[$archi->tipo].'/'.$archi->idUsuario.'/'. $archi->idCurso . '/', " file", "");
            $adjuntos['file'][] = $arrRuta[$archi->tipo].'/'.$archi->idUsuario.'/'. $archi->idCurso . '/';
            $adjuntos['name'][] = $archi->file.'.pdf';
        }


        $response['ids'] = $arrFiles;
        $response['files'] = $adjuntos;


            $response['status'] = true;
            $response['mensaje'] = 'Se enviaron los documentos correctamente.';

            $contenidoEmail = file_get_contents('https://merdishell.a2hosted.com/application/inicio/views/emailNotificaciones.phtml');
            $contenido = $mensaje."<br><br><small>Se anexan ".count($arrFiles)." archivos</small>";
            $contenidoFinal = str_replace("contenido",'>'.$contenido,$contenidoEmail);

            $mails = $_POST['mail-mail'];
            Email::enviarEmailNomina(trim($mails), '', $asunto, $contenidoFinal, $adjuntos);



        echo json_encode($response);
    }

    public function getSugerenciasYAlertasPorUsuario(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'SeguridadDao.php';



        $seguridadDao = new SeguridadDao();

        set_time_limit(120);

        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $pagina = filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);

        $tareas = $seguridadDao->getAllsugerenciasYAlertasPorUsuario($idUsuario,$pagina);
        $response['tareas'] = $tareas['tareas'];
        $response['total'] = $tareas['total'];

        echo json_encode($response);
    }

    public function validarCuenta($idUsuario, $tipo){
        $cd = new CuentasDao();
        $totalCuenta = $cd->obtenerCuentaPersona($idUsuario, $tipo)['total'];
        if($totalCuenta > 0){
            $tipoCuenta = 2;
        }else{
            $tipoCuenta = 1;
        }

        return $tipoCuenta;
    }

    public function cargarDatosPdf()
    {
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdfParser' . DIRECTORY_SEPARATOR . 'alt_autoload.php-dist';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $rfc = filter_input(INPUT_POST, 'enviarRFC', FILTER_SANITIZE_STRING);
        $idUser = filter_input(INPUT_POST, 'id_user', FILTER_SANITIZE_STRING);
        $pdfParser = new \Smalot\PdfParser\Parser();
        $fecha = date("Y-m-d");

        if (!is_dir(BASEPATH . 'application/usuarios/documentos/')) {
            mkdir(BASEPATH . 'application/usuarios/documentos', 0777);
        }
        $ruta = BASEPATH . 'application/usuarios/documentos/';
        $carpeta = $idUser;
        $carpeta = $ruta . $carpeta . '/';
        if (!file_exists($carpeta))
            mkdir($carpeta);

        if (isset($_FILES['pdfConstancia']['name'])) {
            if (move_uploaded_file($_FILES['pdfConstancia']['tmp_name'], $carpeta . "constancia.pdf")) {

                $file = $carpeta . "constancia.pdf";

                $pdf = $pdfParser->parseFile($file);

                $text = $pdf->getText();

                $pdfText = nl2br($text);

                $buscar_rfc = 'RFC';
                $posicion_rfc = strpos($pdfText, $buscar_rfc);

                if ($posicion_rfc === false) {
                } else {

                    $rfc = substr($pdfText, $posicion_rfc, 18);
                    $solo_rfc = explode(":", $rfc);
                    $response['rfc'] = trim($solo_rfc[1]);
                }

                $buscar_razon = 'Denominación';
                $posicion_razon = strpos($pdfText, $buscar_razon);

                if ($posicion_razon === false) {

                    $buscar_contribuyentes = '(s)';
                    $posicion_contribuyentes = strpos($pdfText, $buscar_contribuyentes);

                    if ($posicion_contribuyentes === false) {
                    } else {

                        $contribuyentes = substr($pdfText, $posicion_contribuyentes);
                        $buscar_primer = 'Primer';
                        $posicion_primer = strpos($contribuyentes, $buscar_primer);

                        if ($posicion_primer === false) {
                        } else {
                            $nombre = substr($contribuyentes, 0, $posicion_primer);
                            $buscarDosPuntosNombre = ':';
                            $posDosPuntosNombre = strpos($nombre, $buscarDosPuntosNombre);

                            if ($posDosPuntosNombre === false) {
                            } else {
                                $dosPuntosNombre = substr($nombre, $posDosPuntosNombre);
                                $soloNombre = substr($dosPuntosNombre, 1);

                                $response['nombre'] = Utils::quitar_Espacios($soloNombre);
                            }
                        }

                        $buscar_pa = "Primer";
                        $posicion_pa = strpos($pdfText, $buscar_pa);

                        if ($posicion_pa === false) {
                        } else {
                            $soloPrimer = substr($pdfText, $posicion_pa);
                            $buscar_segundo = "Segundo";
                            $posicion_segundo = strpos($soloPrimer, $buscar_segundo);

                            $primerApellido = substr($soloPrimer, 0, $posicion_segundo);
                            $buscarDosPuntosPApellido = ':';
                            $posDosPuntosPApellido = strpos($primerApellido, $buscarDosPuntosPApellido);

                            if ($posDosPuntosPApellido === false) {
                            } else {
                                $dosPuntosPApellido = substr($primerApellido, $posDosPuntosPApellido);
                                $soloPApellido = substr($dosPuntosPApellido, 1);

                                $response['apePaterno'] = Utils::quitar_Espacios($soloPApellido);
                            }

                            $buscar_fecha = "Fecha";
                            $posicion_fecha = strpos($soloPrimer, $buscar_fecha);

                            $segundoApellido = substr($soloPrimer, 0, $posicion_fecha);

                            $buscarDosPuntoSApellido = ':';
                            $posDosPuntoSApellido = strpos($segundoApellido, $buscarDosPuntoSApellido);

                            if ($posDosPuntoSApellido === false) {
                            } else {
                                $dosPuntoSApellido = substr($segundoApellido, $posDosPuntoSApellido);
                                $soloSApellido = substr($dosPuntoSApellido, 1);

                                $solo_rfcd = explode(":", $soloSApellido);
                                $response['apeMaterno'] = Utils::quitar_Espacios($solo_rfcd[1]);
                            }
                        }
                    }
                } else {

                    $razon = substr($pdfText, $posicion_razon);
                    $buscar_regimen = 'Régimen';
                    $posicion_regimen = strpos($razon, $buscar_regimen);

                    if ($posicion_regimen === false) {
                    } else {

                        $regimen = substr($razon, 0, $posicion_regimen - 3);
                        $solo_regimen = explode(":", $regimen);
                        $response['razon'] = trim($solo_regimen[1]);

                    }
                }
                $buscar_cp = 'Código';
                $posicion_cp = strpos($pdfText, $buscar_cp);

                if ($posicion_cp === false) {
                } else {

                    $cp = substr($pdfText, $posicion_cp, 21);
                    $solo_cp = explode(":", $cp);
                    $response['cp'] = trim($solo_cp[1]);
                }

                $buscar_regimenes = 'Regímenes';
                $posicion_regimenes = strpos($pdfText, $buscar_regimenes);

                if ($posicion_regimenes === false) {
                } else {

                    $regimenes = substr($pdfText, $posicion_regimenes);

                    $buscar_obligaciones = 'Obligaciones';
                    $posicion_obligaciones = strpos($regimenes, $buscar_obligaciones);

                    if ($posicion_obligaciones === false) {
                    } else {

                        $obligaciones = substr($regimenes, 0, $posicion_obligaciones);
                        $solo_regimenes = explode(":", $obligaciones);

                        $buscar_fin = 'Fin';
                        $posicion_fin = strpos($regimenes, $buscar_fin);

                        if ($posicion_fin === false) {
                        } else {

                            $fin = substr($regimenes, $posicion_fin);
                            $solo_fin = explode("F", $fin);

                            $buscar_regimen2 = 'Régimen';
                            $posicion_regimen2 = strpos($fin, $buscar_regimen2);

                            if ($posicion_regimen2 === false) {
                            } else {

                                $regimen2 = substr($fin, 0, 11);
                                $solo_regimen2 = explode("in", $regimen2);

                                $regimen3 = substr($fin, 11);

                                $buscar_obligaciones3 = 'Obligaciones';
                                $posicion_obligaciones3 = strpos($regimen3, $buscar_obligaciones3);

                                if ($posicion_obligaciones3 === false) {
                                } else {

                                    $regimen4 = substr($regimen3, 0, $posicion_obligaciones3);
                                    $numero = substr_count($regimen4, "Régimen");

                                    for ($i = 0; $i < $numero; $i++) {
                                        $regimen6 = preg_split('/>/', $regimen4);
                                        $regimenFinal[$i] = substr($regimen6[$i], 0, -16);
                                        $response['regimen'][$i] = trim($regimenFinal[$i]);

                                        $cRegimen = new UsuarioDao();
                                        $datosRegimen = $cRegimen->getRegimenFiscal($idUser, trim($regimenFinal[$i]));
                                        if ($datosRegimen['total'] == 0) {
                                            $regimenFiscal = new Usuario();
                                            $regimenFiscal->__set('_nombreRegi', trim($regimenFinal[$i]));
                                            $regimenFiscal->__set('_id_user', trim($idUser));
                                            $cRegimen->guardaRegimenFiscal($regimenFiscal, $idUser);
                                        }
                                        foreach ($datosRegimen['regimenF'] as $nombreRegimen) {
                                            if ($nombreRegimen->regimen_fiscal != trim($regimenFinal[$i])) {
                                                $regimenFiscal = new Usuario();
                                                $regimenFiscal->__set('_nombreRegi', trim($regimenFinal[$i]));
                                                $regimenFiscal->__set('_id_user', trim($idUser));
                                                $cRegimen->guardaRegimenFiscal($regimenFiscal, $idUser);
                                            } else {
                                            }
                                        }
                                    }
                                    $response['numero'] = $numero;
                                    $response['status'] = true;
                                    $response['mensaje'] = "Datos cargados satisfactoriamente";
                                }
                            }
                        }
                    }
                }
            }
        }
        echo json_encode($response);
    }

}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
    } else {
        $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
    }
    if (isset($accion)) {
        $obj = new AjaxController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento, no recibí todos los datos. Por favor '
                . 'intenta otra vez ó comunicate con el administrador del sistema.';
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}
