<?php
/**
 * AjaxEvaluacionController.php
 * Controlador para el manejo de datos con ajax
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxCursosController {

    public function obtenerCursosCapacitacion(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();

            $obtenerCursos = $cursoInternoParticipantesDao->obtenerCursosPorParticipante( "progreso", Sesion::obtener('idUsuario'), $inicio, $registros);
            if ($obtenerCursos['status']){

                $response['status'] = true;
                $paginas = ceil($obtenerCursos['total'] / $registros);
                $response['cursos'] = $obtenerCursos['cursos'];
                $response['pagina'] = $pagina;
                $response['inferior'] = $inferior;
                $response['superior'] = $superior;
                $response['paginas'] = $paginas;

            }else{
                $response['status'] = false;
                $response['mensaje'] = $obtenerCursos['error'];
            }


        echo json_encode($response);

    }


    public function guardarExamen(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';

        $totalPreguntas =  filter_input(INPUT_GET, 'totalPreguntas', FILTER_SANITIZE_NUMBER_INT);
        $contRespuestasCorrectas =  filter_input(INPUT_GET, 'contRespuestasCorrectas', FILTER_SANITIZE_NUMBER_INT);
        $idCursoInternoParticipantes=  filter_input(INPUT_GET, 'idCursoInternoParticipantes', FILTER_SANITIZE_NUMBER_INT);

        $preguntasContestadas = $_GET['preguntasContestadas'];
        $preguntasContestadas = json_decode($preguntasContestadas);

        $cursoInternoParticipantesDao = new  CursoInternoParticipantesDao();

        $calificacion = round(($contRespuestasCorrectas / $totalPreguntas) *100,2) ;

        $actualizarExamen =  $cursoInternoParticipantesDao->actualizarExamen( $calificacion,'finalizado',$idCursoInternoParticipantes);

        if($actualizarExamen['status']){

            $response['status'] = true;
            $response['calificacion'] = $calificacion;

             $infoCurso = $cursoInternoParticipantesDao->obtenerCursoPoiIdCursoInternoParticipantes($idCursoInternoParticipantes)['curso'];

            $adjuntos = $this->generarPdf(  $infoCurso->Nombre. ' ' . $infoCurso->Apellido_Paterno . ' ' .  $infoCurso->Apellido_Materno , $infoCurso->titulo, $infoCurso->Mail);
            $url ='https://merdishell.a2hosted.com/' . 'application/inicio/views/emailNotificaciones.phtml';
            $datos = array("contenido" => "reconocimiento");
            $opciones = array(
                'http' => array(
                    'method' => 'POST',
                    'header' => 'Content-type: application/x-www-form-urlencoded',
                    'content' => http_build_query($datos)
                )
            );

            $contexto = stream_context_create($opciones);
            $contenidoEmail = file_get_contents($url, false, $contexto);
            Email::enviarEmailNomina($infoCurso->Mail, '', "reconocimiento", $contenidoEmail, $adjuntos);
        }else{
            $response['status'] = false;
            $response['mensaje'] = $actualizarExamen['error'];
        }

        echo json_encode($response);

    }


    public function generarPdf($usuario, $nombreCurso, $correo){
        $rutaLogo = BASEPATH . 'public' . DIRECTORY_SEPARATOR . 'img' . DIRECTORY_SEPARATOR . 'logo.jpg';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdf' . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdf' . DIRECTORY_SEPARATOR . 'html2pdf.class.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

        $meses = ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'];
        $mes = date("m");
        $year = date("Y");
        $dia = date("d");
        $nombreMes = $meses[$mes] ;
        $formarFecha = $nombreMes . ' '. $dia . ', ' .  $year;

        $html = '
<style type="text/css">


h1{
    font-weight: 100;    
}
.size-font-h1{
font-size: 50px !important; 
}
</style>
<page backtop="35mm" backbottom="5mm" backleft="5mm" backright="8mm">
    <page_header>
        <table style="width: 100%; border: 1px solid black">
            <tr>
                <td>
                    <img src="' . $rutaLogo . '" style="height: 100px; width: 500px">
                </td>
            </tr>
        </table>
    </page_header>
    <br><br>
    <br>
    
    <div style="padding-left: 250px; line-height: normal">
    <h1 class="size-font-h1" >Otorga el presente reconocimiento a : </h1><br>
   
      <h1><b>' . $usuario . '</b></h1><br><br>
      
       
    </div>
    <div style="width: 100%; text-align: center; line-height: normal">
    <h1>Por su participación en <b>el taller en línea de  </b> </h1>
         <h1> <b>' . $nombreCurso  . ' </b></h1><br>
      <h3 style="font-weight: 100;">México ' . $formarFecha . ' </h3><br>
    </div>

</page>';

        ob_start();
        ob_get_clean();
        try {
            $html2pdf = new HTML2PDF('L', 'A4');
            $html2pdf->setDefaultFont('Arial');
            $html2pdf->writeHTML($html);

            $pdfdoc = $html2pdf->Output('', 'S');
            unset($adjuntos);
            $adjuntos['file'][] = $pdfdoc;
            $adjuntos['name'][] ="reconocimiento" . ".pdf";

           return $adjuntos;

        } catch (HTML2PDF_exception $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            die($e->getMessage());

        }

    }

    public function obtenerCursosresponsable(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();

        $obtenerCursos = $cursoInternoParticipantesDao->obtenerCursosPorResponsable( "progreso", Sesion::obtener('idUsuario'), $inicio, $registros);
        if ($obtenerCursos['status']){

            $response['status'] = true;
            $paginas = ceil($obtenerCursos['total'] / $registros);
            $response['cursos'] = $obtenerCursos['cursos'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;

        }else{
            $response['status'] = false;
            $response['mensaje'] = $obtenerCursos['error'];
        }


        echo json_encode($response);

    }

    public function subirListaAsistencias(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';

        $cursoInternoParticipantesDao = new  CursoInternoParticipantesDao();


        $ruta = BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'asistenciasCursos' . DIRECTORY_SEPARATOR;

        $idCursoInternoCapacitacion= filter_input(INPUT_POST, 'idCursoInternoCapacitacion', FILTER_SANITIZE_STRING);


        if (isset($_FILES['docListaAsistencia']['name'])) {

            list($base, $ext) = explode('.', $_FILES['docListaAsistencia']['name']);
            $array = explode('.', $_FILES['docListaAsistencia']['name']);

            foreach ($array as $iterador) {
                $extencion = $iterador;
            }
            $newname = "curso". $idCursoInternoCapacitacion. '.'  . $extencion;

            if (move_uploaded_file($_FILES['docListaAsistencia']['tmp_name'], $ruta . $newname)) {

                $actualizarStatusCurso = $cursoInternoParticipantesDao->actualizarStatusCurso("autorizacion", $newname, $idCursoInternoCapacitacion );

                if($actualizarStatusCurso['status']){
                    $response['status'] = true;
                }else{
                    $response['status'] = false;
                    $response['mensaje'] = $actualizarStatusCurso['error'];
                }

            }
        }

        echo json_encode($response);

    }

    public function obtenerProximosCursos(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();
        $usuarioDao = new UsuarioDao();
        $fechaHoy = date("Y-m-d") ;


        $usuario =  $usuarioDao->obtenerUsuario(Sesion::obtener('idUsuario'))['usuarios'];

        $obtenerCursos = $cursoInternoParticipantesDao->obtenerProximosCursos( $fechaHoy, $usuario->Tipo, $inicio, $registros);
        if ($obtenerCursos['status']){

            $response['status'] = true;
            $paginas = ceil($obtenerCursos['total'] / $registros);
            $response['cursos'] = $obtenerCursos['cursos'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;

        }else{
            $response['status'] = false;
            $response['mensaje'] = $obtenerCursos['error'];
        }


        echo json_encode($response);

    }

    public function obtenerListaAsistenciasEnAutorizacion(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();

        $obtenerCursos = $cursoInternoParticipantesDao->obtenerAsistenciasPorAutorizar( "autorizacion", $inicio, $registros);
        if ($obtenerCursos['status']){

            $response['status'] = true;
            $paginas = ceil($obtenerCursos['total'] / $registros);
            $response['cursos'] = $obtenerCursos['cursos'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;

        }else{
            $response['status'] = false;
            $response['mensaje'] = $obtenerCursos['error'];
        }


        echo json_encode($response);

    }


    public function autorizarListaAsistencia(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $idCursoInternoCapacitacion = (int) filter_input(INPUT_GET, 'idCursoInternoCapacitacion', FILTER_SANITIZE_NUMBER_INT);

        $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();

       $autorizarLista =  $cursoInternoParticipantesDao->autorizarListaAsistencia("autorizado",$idCursoInternoCapacitacion);

       if($autorizarLista['status']){
           $response['status'] = true;
           $response['mensaje'] = "lista de asistencias autorizada correctamente";
       }else{
           $response['status'] = false;
           $response['mensaje'] = $autorizarLista['error'];
       }

        echo json_encode($response);

    }

    public function rechazarListaAsistencia(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' .
            DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';


        $idCursoInternoCapacitacion = (int) filter_input(INPUT_GET, 'idCursoInternoCapacitacion', FILTER_SANITIZE_NUMBER_INT);
        $razon =  filter_input(INPUT_GET, 'razon', FILTER_SANITIZE_STRING);
        $fecha =  filter_input(INPUT_GET, 'fecha', FILTER_SANITIZE_STRING);

        $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();

        $autorizarLista =  $cursoInternoParticipantesDao->rechazarListaAsistencia("progreso", $fecha,$razon ,$idCursoInternoCapacitacion);

        $cursosInternosDao = new CursosInternosDao();

        $cursosInternosDao->guardarRazonHistorialRechazo($idCursoInternoCapacitacion, $razon );

        $cursoInfo = $cursosInternosDao->obtenerCursoCapacitacion($idCursoInternoCapacitacion)['cursos'];

        $contenido = 'La lista de asistencia del curso : '. $cursoInfo->titulo. ' fue rechazada por '. $cursoInfo->razon_rechazo .' ultimo dia para subirla '
                . $cursoInfo->fecha_limite_asistencia . ' en ' . BASEURL. '/usuarios/subirAsistenciasCursos/' ;
        $url = BASEURL.'application/inicio/views/emailNotificaciones.phtml';
        $datos = array('contenido' => $contenido);
        $opciones = array(
            'http' => array(
                'method' => 'POST',
                'header' => 'Content-type: application/x-www-form-urlencoded',
                'content' => http_build_query($datos)
            )
        );

        $contexto = stream_context_create($opciones);
        $contenidoEmail = file_get_contents($url, false, $contexto);
        // Email::enviarEmail('sistemas@merdizshell.com', '', 'lista de curso rechazada', $contenidoEmail);
        Email::enviarEmail($cursoInfo->Mail, '', 'lista de curso rechazada', $contenidoEmail);


        if($autorizarLista['status']){
            $response['status'] = true;
            $response['mensaje'] = "lista de asistencias rechazada correctamente";
        }else{
            $response['status'] = false;
            $response['mensaje'] = $autorizarLista['error'];
        }

        echo json_encode($response);

    }

    public function obtenerCursosInduccion(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInduccionDao.php';

        $pagina = (int) filter_input(INPUT_GET, 'pagina', FILTER_SANITIZE_NUMBER_INT);
        $registros = (int) filter_input(INPUT_GET, 'registros', FILTER_SANITIZE_NUMBER_INT);
        $superior = (int) filter_input(INPUT_GET, 'superior', FILTER_SANITIZE_NUMBER_INT);
        $inferior = (int) filter_input(INPUT_GET, 'inferior', FILTER_SANITIZE_NUMBER_INT);

        $inicio = ($pagina - 1) * $registros;

        if ($pagina > $superior){
            $inferior = $pagina;
            $superior = $pagina + 9;
        }

        if ($inferior > $pagina){
            $inferior = $pagina - 9;
            $superior = $pagina;
        }

        $cursoInduccionDao = new CursoInduccionDao();

        $obtenerCursos = $cursoInduccionDao->obtenerCursosPorUsuario( "progreso", Sesion::obtener('idUsuario'), $inicio, $registros);
        if ($obtenerCursos['status']){

            $response['status'] = true;
            $paginas = ceil($obtenerCursos['total'] / $registros);
            $response['cursos'] = $obtenerCursos['cursos'];
            $response['pagina'] = $pagina;
            $response['inferior'] = $inferior;
            $response['superior'] = $superior;
            $response['paginas'] = $paginas;

        }else{
            $response['status'] = false;
            $response['mensaje'] = $obtenerCursos['error'];
        }


        echo json_encode($response);

    }

    public function guardarExamenInduccion(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInduccionDao.php';

        $totalPreguntas =  filter_input(INPUT_GET, 'totalPreguntas', FILTER_SANITIZE_NUMBER_INT);
        $contRespuestasCorrectas =  filter_input(INPUT_GET, 'contRespuestasCorrectas', FILTER_SANITIZE_NUMBER_INT);
        $idCursoInduccion=  filter_input(INPUT_GET, 'idCursoInduccion', FILTER_SANITIZE_NUMBER_INT);

        $preguntasContestadas = $_GET['preguntasContestadas'];
        $preguntasContestadas = json_decode($preguntasContestadas);

        $cursoInduccionDao = new  CursoInduccionDao();

        $calificacion = round(($contRespuestasCorrectas / $totalPreguntas) *100,2) ;

        $actualizarExamen =  $cursoInduccionDao->actualizarCursoInduccion( $calificacion,'finalizado',$idCursoInduccion);

        if($actualizarExamen['status']){

            $response['status'] = true;
            $response['calificacion'] = $calificacion;

            $infoCurso = $cursoInduccionDao->obtenerCursoPorIdCursoInduccion($idCursoInduccion)['curso'];

            $this->generarPdf( $infoCurso->Nombre. ' ' . $infoCurso->Apellido_Paterno . ' ' .  $infoCurso->Apellido_Materno ,  $infoCurso->titulo, $infoCurso->Mail);

        }else{
            $response['status'] = false;
            $response['mensaje'] = $actualizarExamen['error'];
        }

        echo json_encode($response);

    }

    public function getHistorialCursosCapacitacion(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

        $cursosInternosDao = new CursosInternosDao();

        set_time_limit(120);

        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $pagina = filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);

        $cursos = $cursosInternosDao->getAllCursosCapacitacionPorUsuario($idUsuario,$pagina);

        $response['cursos'] = $cursos['cursos'];
        $response['total'] = $cursos['total'];

        echo json_encode($response);
    }

    public function getHistorialCursosInduccion(){

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';

        $cursosInternosDao = new CursosInternosDao();

        set_time_limit(120);

        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $pagina = filter_input(INPUT_POST, 'pagina', FILTER_SANITIZE_NUMBER_INT);

        $cursos = $cursosInternosDao->getAllCursosInduccionPorUsuario($idUsuario,$pagina);
        $response['cursos'] = $cursos['cursos'];
        $response['total'] = $cursos['total'];

        echo json_encode($response);
    }

    public function sendMail(){
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'DocumentoClienteDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'administracion' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'HistorialCorreoDao.php';
        $d = new DocumentoClienteDao();
        $c = new HistorialCorreoDao();

        $cliente = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $mail = filter_input(INPUT_POST, 'mail-mail', FILTER_SANITIZE_STRING);
        $asunto = filter_input(INPUT_POST, 'mail-asunto', FILTER_SANITIZE_STRING);
        $mensaje = filter_input(INPUT_POST, 'mail-msg', FILTER_SANITIZE_STRING);
        $archivos = filter_input(INPUT_POST, 'files', FILTER_SANITIZE_STRING);

        $adjuntos = array('file' => array(), 'name' => array());
        $arrFiles = array();

        $urlPagina = 'https://merdizshell.com/';
        $rutaPagina = realpath(BASEPATH.'/..').'/';
        $arrRuta = array(
            'examen-capacitacion' => BASEURL.'usuarios/exportarReconocimientoCurso',
            'examen-induccion' => BASEURL.'usuarios/exportarReconocimientoCurso',
        );

        /* if (!empty($_FILES['mail-file']['name']) && ($_FILES['mail-file']['type'] == "application/pdf")){
             $filename = str_replace(' ','_',$_FILES['mail-file']['name']);
             $ruta = '../doc_cliente/';
             $ext = '.pdf';
             copy($_FILES['mail-file']['tmp_name'],$ruta.$filename);

             $adjuntos['file'][] = $arrRuta['adicional'].$filename;
             $adjuntos['name'][] = $filename;
         }else{
             $response['status'] = false;
             $response['mensaje'] = 'El documento debe tener extención PDF.';
         }*/

        $archivos = json_decode($_POST['files']);
        foreach ($archivos as $archi) {
            $usuarioDao = new UsuarioDao();
            $usuario = $usuarioDao->obtenerUsuario( $archi->idUsuario)['usuarios'];


            $adjunto = $this->generarPdf($usuario->Nombre. ' ' . $usuario->Apellido_Paterno . ' ' .  $usuario->Apellido_Materno , $archi->file, '');
            $adjuntos['file'][] = $adjunto['file'][0];
            $adjuntos['name'][] = $adjunto['name'][0];
        }


        $response['status'] = true;
        $response['mensaje'] = 'Se enviaron los documentos correctamente.';

        $contenidoEmail = file_get_contents( BASEURL.'application/inicio/views/emailNotificaciones.phtml');
        $contenido = $mensaje."<br><br><small>Se anexan ".count($arrFiles)." archivos</small>";
        $contenidoFinal = str_replace("contenido",'>'.$contenido,$contenidoEmail);

        $mails = $_POST['mail-mail'];
        Email::enviarEmailNomina(trim($mails), '', $asunto, $contenidoFinal, $adjuntos);



        echo json_encode($response);
    }

}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        } else {
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxCursosController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}