<?php
/**
 * AjaxDriverController.php
 * Controlador para el manejo de ajax con drivers
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxDriverController 
{
    public function guardarDriver()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DriverDao.php';
        
        $idDriver = filter_input(INPUT_POST, 'driver', FILTER_SANITIZE_NUMBER_INT);
        $impacto = filter_input(INPUT_POST, 'impacto', FILTER_SANITIZE_STRING);
        
        $d = new Driver();
        $d->__set('_idDriver', $idDriver);
        $d->__set('_impacto', $impacto);
        
        $dr = new DriverDao();
        $dadri = $dr->obtenerDriver($idDriver);
        if ($dadri['status']){
            $datosDriver = $dadri['driver'];
            $driver = $datosDriver->Driver;
            $d->__set('_driver', $driver);
            $guardar = $dr->guardar($d, 2);
            if ($guardar['status']){
                $response['status'] = true;
                $response['mensaje'] = 'Los datos del driver se guardaron correctamente.';
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $guardar['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $dadri['error'];
        }
        
        echo json_encode($response);
    }
    
    public function obtenerDriver()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'DriverDao.php';
        
        $idDriver = filter_input(INPUT_GET, 'idDriver', FILTER_SANITIZE_NUMBER_INT);
        
        $d = new DriverDao();
        $obtener = $d->obtenerDriver($idDriver);
        if ($obtener['status']){
            $response['status'] = true;
            $response['driver'] = $obtener['driver'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $obtener['error'];
        }
        
        echo json_encode($response);
    }
    
    public function editarDriver()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'DriverDao.php';
        
        $idDriver = filter_input(INPUT_POST, 'idDriver', FILTER_SANITIZE_NUMBER_INT);
        $driver = filter_input(INPUT_POST, 'driver', FILTER_SANITIZE_STRING);
        $impacto = filter_input(INPUT_POST, 'impacto', FILTER_SANITIZE_STRING);
        
        $d = new Driver();
        $d->__set('_idDriver', $idDriver);
        $d->__set('_driver', $driver);
        $d->__set('_impacto', $impacto);
        
        $di = new DriverDao();
        
        $actualizar = $di->guardar($d, 2);
        if ($actualizar['status']){
            $drivers = $di->obtenerDrivers();
            if ($drivers['status']){
                $response['status'] = true;
                $response['mensaje'] = 'Datos guardados correctamente';
                $response['drivers'] = $drivers['drivers'];
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $drivers['error'];
            }
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $actualizar['error'];
        }
        
        echo json_encode($response);
    }
    
    public function obtenerDrivers()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'DriverDao.php';
        
        $d = new DriverDao();
        $drivers = $d->obtenerDrivers();
        
        if ($drivers['status']){
            $response['status'] = true;
            $response['drivers'] = $drivers['drivers'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $drivers['error'];
        }
        
        echo json_encode($response);
    }
    
    public function obtenerIndicadoresDriver()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'IndicadorDao.php';
        
        $idDriver = filter_input(INPUT_GET, 'driver', FILTER_SANITIZE_NUMBER_INT);
        $i = new Indicador();
        $i->__set('_idDriver', $idDriver);
        
        $in = new IndicadorDao();
        $indicadores = $in->obtenerIndicadores($i);
        if ($indicadores['status']){
            $response['status'] = true;
            $response['indicadores'] = $indicadores['indicadores'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $indicadores['error'];
        }
        
        echo json_encode($response);
    }
    
    public function agregarIndicador()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'IndicadorDao.php';
        
        $idDriver = filter_input(INPUT_POST, 'idDriver', FILTER_SANITIZE_NUMBER_INT);
        $indicador = filter_input(INPUT_POST, 'indicador', FILTER_SANITIZE_STRING);
        $impacto = filter_input(INPUT_POST, 'impacto', FILTER_SANITIZE_STRING);
        $objetivo = filter_input(INPUT_POST, 'objetivo', FILTER_SANITIZE_STRING);
        $i = new Indicador();
        
        $i->__set('_idDriver', $idDriver);
        $i->__set('_indicador', $indicador);
        $i->__set('_impacto', $impacto);
        $i->__set('_objetivo', $objetivo);
        
        $in = new IndicadorDao();
        $agregar = $in->guardar($i, 1);
        if ($agregar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Indicador agregado correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $agregar['error'];
        }
        
        echo json_encode($response);
    }
    
    public function obtenerIndicador()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'IndicadorDao.php';
        
        $idIndicador = filter_input(INPUT_GET, 'idIndicador', FILTER_SANITIZE_NUMBER_INT);
        $i = new IndicadorDao();
        $indicador = $i->obtenerIndicador($idIndicador);
        if ($indicador['status']){
            $response['status'] = true;
            $response['indicador'] = $indicador['indicador'];
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $indicador['error'];
        }
        
        echo json_encode($response);
    }
    
    public function editarIndicador()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'IndicadorDao.php';

        $idIndicador = filter_input(INPUT_POST, 'idIndicador', FILTER_SANITIZE_NUMBER_INT);
        $indicadorE = filter_input(INPUT_POST, 'indicador', FILTER_SANITIZE_STRING);
        $impacto = filter_input(INPUT_POST, 'impacto', FILTER_SANITIZE_STRING);
        $objetivo = filter_input(INPUT_POST, 'objetivo', FILTER_SANITIZE_STRING);
        $idDriver = filter_input(INPUT_POST, 'idDriver', FILTER_SANITIZE_NUMBER_INT);
        
        $i = new Indicador();
        $i->__set('_idIndicador', $idIndicador);
        $i->__set('_indicador', $indicadorE);
        $i->__set('_impacto', $impacto);
        $i->__set('_objetivo', $objetivo);
        $i->__set('_idDriver', $idDriver);
        
        $in = new IndicadorDao();
        $indicador = $in->guardar($i, 2);
        if ($indicador['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Datos guardados correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $indicador['error'];
        }
        
        echo json_encode($response);
    }
    
    public function eliminarIndicador()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'IndicadorDao.php';

        $idIndicador = filter_input(INPUT_POST, 'idIndicador', FILTER_SANITIZE_NUMBER_INT);
        
        $in = new IndicadorDao();
        $eliminar = $in->eliminar($idIndicador);
        if ($eliminar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Indicador eliminado correctamente.';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $eliminar['error'];
        }
        
        echo json_encode($response);
    }            
}


if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest'){
    new Sesion();
    if(Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')){
        if ($_SERVER['REQUEST_METHOD'] == 'POST'){
            $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        }
        else{
            $accion = filter_input(INPUT_GET, 'accion', FILTER_SANITIZE_STRING);
        }
        $obj = new AjaxDriverController();
        $obj->$accion();
    }
    else{
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
}
else{
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}