<?php
/**
 * AjaxEvaluacionController.php
 * Controlador para el manejo de datos con ajax
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

ini_set('display_errors', 1);

date_default_timezone_set('America/Mexico_City');
require_once '../../../config.inc.php';
require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Sesion.php';

class AjaxEvaluacionController {

    public function abrirPeriodo() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'PeriodoDao.php';

        $fechaInicio = filter_input(INPUT_POST, 'inicio', FILTER_SANITIZE_STRING);
        $fechaFin = filter_input(INPUT_POST, 'fin', FILTER_SANITIZE_STRING);
        $status = 1;
        $p = new Periodo();
        $p->__set('_fechaInicio', $fechaInicio);
        $p->__set('_fechaFin', $fechaFin);
        $p->__set('_status', $status);

        $pe = new PeriodoDao();
        $guardar = $pe->guardar($p);
        if ($guardar['status']) {
            $response['status'] = true;
            $response['mensaje'] = 'Datos guardados correctamente.';
        } else {
            $response['status'] = false;
            $response['mensaje'] = $guardar['error'];
        }

        echo json_encode($response);
    }

    public function guardarCompetenciaConMando() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompetenciaMandoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PeriodoDao.php';

        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $pregunta1 = filter_input(INPUT_POST, 'pregunta1', FILTER_SANITIZE_NUMBER_INT);
        $pregunta2 = filter_input(INPUT_POST, 'pregunta2', FILTER_SANITIZE_NUMBER_INT);
        $pregunta3 = filter_input(INPUT_POST, 'pregunta3', FILTER_SANITIZE_NUMBER_INT);
        $pregunta4 = filter_input(INPUT_POST, 'pregunta4', FILTER_SANITIZE_NUMBER_INT);
        $pregunta5 = filter_input(INPUT_POST, 'pregunta5', FILTER_SANITIZE_NUMBER_INT);
        $pregunta6 = filter_input(INPUT_POST, 'pregunta6', FILTER_SANITIZE_NUMBER_INT);
        $pregunta7 = filter_input(INPUT_POST, 'pregunta7', FILTER_SANITIZE_NUMBER_INT);
        $pregunta8 = filter_input(INPUT_POST, 'pregunta8', FILTER_SANITIZE_NUMBER_INT);
        $pregunta9 = filter_input(INPUT_POST, 'pregunta9', FILTER_SANITIZE_NUMBER_INT);
        $pregunta10 = filter_input(INPUT_POST, 'pregunta10', FILTER_SANITIZE_NUMBER_INT);
        $pregunta11 = filter_input(INPUT_POST, 'pregunta11', FILTER_SANITIZE_NUMBER_INT);
        $pregunta12 = filter_input(INPUT_POST, 'pregunta12', FILTER_SANITIZE_NUMBER_INT);
        $pregunta13 = filter_input(INPUT_POST, 'pregunta13', FILTER_SANITIZE_NUMBER_INT);
        $pregunta14 = filter_input(INPUT_POST, 'pregunta14', FILTER_SANITIZE_NUMBER_INT);
        $pregunta15 = filter_input(INPUT_POST, 'pregunta15', FILTER_SANITIZE_NUMBER_INT);
        $totalPuntos = filter_input(INPUT_POST, 'totalPuntos', FILTER_SANITIZE_STRING);
        $totalEvaluacion = filter_input(INPUT_POST, 'totalEvaluacion', FILTER_SANITIZE_STRING);

        $p = new PeriodoDao();
        $periodo = $p->obtenerUltimoPeriodo();
        if ($periodo['status']) {
            $datosPeriodo = $periodo['periodo'];
            $idPeriodo = $datosPeriodo->Id_Periodo;
            //validar si hay datos 
            $com = new CompetenciaMandoDao();
            $e = new CompetenciaMando();
            $e->__set('_idPeriodo', $idPeriodo);
            $e->__set('_idUsuario', $idUsuario);
            $e->__set('_pregunta1', $pregunta1);
            $e->__set('_pregunta2', $pregunta2);
            $e->__set('_pregunta3', $pregunta3);
            $e->__set('_pregunta4', $pregunta4);
            $e->__set('_pregunta5', $pregunta5);
            $e->__set('_pregunta6', $pregunta6);
            $e->__set('_pregunta7', $pregunta7);
            $e->__set('_pregunta8', $pregunta8);
            $e->__set('_pregunta9', $pregunta9);
            $e->__set('_pregunta10', $pregunta10);
            $e->__set('_pregunta11', $pregunta11);
            $e->__set('_pregunta12', $pregunta12);
            $e->__set('_pregunta13', $pregunta13);
            $e->__set('_pregunta14', $pregunta14);
            $e->__set('_pregunta15', $pregunta15);
            $e->__set('_totalPuntos', $totalPuntos);
            $e->__set('_totalEvaluacion', $totalEvaluacion);
            $hayCom = $com->obtenerCompetenciaMandoPorUsuario($idUsuario, $idPeriodo);
            if ($hayCom['status']){
                $hay = $hayCom['totalRegistros'];
                if ($hay > 0){
                    $competencia = $com->actualizar($e);
                }
                else{
                    $competencia = $com->guardar($e);
                }
                
                if ($competencia['status']) {
                    $response['status'] = true;
                    $response['mensaje'] = 'Datos guardados correctamente';
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $competencia['error'];
                }
            }
            else{
                $response['status'] = false;
                $response['mensaje'] = $hayCom['error'];
            }                        
        } else {
            $response['status'] = false;
            $response['mensaje'] = $periodo['error'];
        }

        echo json_encode($response);
    }

    public function guardarObjetivosMando() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PeriodoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ObjetivoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'CompromisosMejoraDao.php';
        
        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $p = new PeriodoDao();
        $periodo = $p->obtenerUltimoPeriodo();
        $bandera = true;
        if ($periodo['status']) {
            $datosPeriodo = $periodo['periodo'];
            $idPeriodo = $datosPeriodo->Id_Periodo;
            $totalRegistros = count($_POST['idDriver']);
            //comprobamos si existen datos 
            $o = new ObjetivoDao();
            $objs = $o->obtenerObjetivosPorUsuario($idUsuario, 2);
            if ($objs['status']) {
                $hayObjetivos = $objs['totalRegistros'];
                if ($hayObjetivos > 0) {
                    for ($i = 0; $i < $totalRegistros; $i++) {
                        $ob = new Objetivo();
                        $ob->__set('_idDriver', $_POST['idDriver'][$i]);
                        $ob->__set('_expectativa', $_POST['expectativa'][$i]);
                        $ob->__set('_idIndicador', $_POST['idIndicador'][$i]);
                        $ob->__set('_resultado', $_POST['resultado'][$i]);
                        $ob->__set('_cumplimiento', $_POST['cumplimiento'][$i]);
                        $ob->__set('_puntos', $_POST['puntos'][$i]);
                        $ob->__set('_idPeriodo', $idPeriodo);
                        $ob->__set('_idUsuario', $idUsuario);
                        $obj = new ObjetivoDao();
                        $objetivo = $obj->actualizarObjetivos($ob);
                        if (!$objetivo['status']) {
                            $bandera = false;
                            break;
                        }
                        
                        $cm = new CompromisosMejoraDao();
                        $cm->actualizarExpectativa($_POST['expectativa'][$i], $_POST['idIndicador'][$i], $idUsuario, $idPeriodo);
                        
                    }
                } else {
                    for ($i = 0; $i < $totalRegistros; $i++) {
                        $ob = new Objetivo();
                        $ob->__set('_idDriver', $_POST['idDriver'][$i]);
                        $ob->__set('_expectativa', $_POST['expectativa'][$i]);
                        $ob->__set('_idIndicador', $_POST['idIndicador'][$i]);
                        $ob->__set('_resultado', $_POST['resultado'][$i]);
                        $ob->__set('_cumplimiento', $_POST['cumplimiento'][$i]);
                        $ob->__set('_puntos', $_POST['puntos'][$i]);
                        $ob->__set('_idPeriodo', $idPeriodo);
                        $ob->__set('_idUsuario', $idUsuario);
                        $obj = new ObjetivoDao();
                        $objetivo = $obj->guardarObjetivo($ob);
                        if (!$objetivo['status']) {
                            $bandera = false;
                            break;
                        }
                    }
                }
                if ($bandera) {
                    $response['status'] = true;
                    $response['mensaje'] = 'Datos guardados correctamente.';
                } else {
                    $response['status'] = false;
                    $response['mensaje'] = $objetivo['error'];
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $objs['error'];
            }
        } else {
            $response['status'] = false;
            $response['mensaje'] = $periodo['error'];
        }

        echo json_encode($response);
    }
    
    public function agregarCompromisoObjetivo()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . 
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompromisosMejoraDao.php';        
        $idUsuario = Sesion::obtener('idUsuario');
        $idPeriodo = filter_input(INPUT_POST, 'idPeriodo', FILTER_SANITIZE_NUMBER_INT);
        $idCompromiso = filter_input(INPUT_POST, 'idCompromiso', FILTER_SANITIZE_NUMBER_INT);
        $idIndicador = filter_input(INPUT_POST, 'idIndicador', FILTER_SANITIZE_NUMBER_INT);
        $expectativa = filter_input(INPUT_POST, 'expectativa', FILTER_SANITIZE_STRING);
        $actividad = filter_input(INPUT_POST, 'actividad', FILTER_SANITIZE_STRING);
        $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
        
        $c = new CompromisosMejora();
        $c->__set('_idCompromiso', $idCompromiso);
        $c->__set('_idIndicador', $idIndicador);
        $c->__set('_expectativa', $expectativa);
        $c->__set('_actividad', $actividad);
        $c->__set('_fecha', $fecha);
        $c->__set('_status', 2);
        $c->__set('_idUsuario', $idUsuario);
        $c->__set('_idPeriodo', $idPeriodo);
        //guardamos los datos
        $com = new CompromisosMejoraDao();
        $guardar = $com->guardar($c);
        if ($guardar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Datos agregados correctamente.';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $guardar['error'];
        }
        
        echo json_encode($response);
        
    }
    
    public function actualizaActividad()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . 
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompromisosMejoraDao.php';        
        $idUsuario = Sesion::obtener('idUsuario');
        $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
        $actividad = filter_input(INPUT_POST, 'actividad', FILTER_SANITIZE_STRING);
        $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
        $com = new CompromisosMejoraDao();
        $actualizar = $com->actualizaActividad($id, $actividad, $fecha);
        if ($actualizar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Datos actualizados correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $actualizar['error'];
        }
        
        echo json_encode($response);
    }
    
    public function actualizarCompetencia()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . 
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompetenciaTemporalDao.php';
        
        $id = filter_input(INPUT_POST, 'id', FILTER_SANITIZE_NUMBER_INT);
        $actividad = filter_input(INPUT_POST, 'actividad', FILTER_SANITIZE_STRING);
        $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
        $com = new CompetenciaTemporalDao();
        $actualizar = $com->actualizarActividad($id, $actividad, $fecha);
        if ($actualizar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Datos actualizados correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $actualizar['error'];
        }
        
        echo json_encode($response);
    }
    
    public function agregarCompentencia()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . 
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompetenciaTemporalDao.php';
        
        $idPeriodo = filter_input(INPUT_POST, 'idPeriodo', FILTER_SANITIZE_NUMBER_INT);
        $competencia = filter_input(INPUT_POST, 'competencia', FILTER_SANITIZE_STRING);
        $accion = filter_input(INPUT_POST, 'accion1', FILTER_SANITIZE_STRING);
        $fecha = filter_input(INPUT_POST, 'fecha', FILTER_SANITIZE_STRING);
        $actividad = filter_input(INPUT_POST, 'actividad', FILTER_SANITIZE_STRING);
        
        $c = new CompetenciaTemporal();
        $c->__set('_idUsuario', Sesion::obtener('idUsuario'));
        $c->__set('_idPeriodo', $idPeriodo);
        $c->__set('_competencia', $competencia);
        $c->__set('_accion', $accion);
        $c->__set('_actividad', $actividad);
        $c->__set('_fecha', $fecha);
        
        $com = new CompetenciaTemporalDao();
        $guardar = $com->guardar($c);
        if ($guardar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Actividad agregada correctamente';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $guardar['error'];
        }
        
        echo json_encode($response);
    }
    
    public function actualizarLogros()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'EvaluacionDao.php';
        
        $idPeriodo = filter_input(INPUT_POST, 'idPeriodo', FILTER_SANITIZE_NUMBER_INT);
        $logros = filter_input(INPUT_POST, 'logros', FILTER_SANITIZE_STRING);
        
        $e = new Evaluacion();
        $e->__set('_logros', $logros);
        $e->__set('_idPeriodo', $idPeriodo);
        $e->__set('_idUsuario', Sesion::obtener('idUsuario'));
        
        $ev = new EvaluacionDao();
        
        $guardar = $ev->actualizarLogros($e);
        if ($guardar['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Datos actualizados';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $guardar['error'];
        }
        
        echo json_encode($response);
    }
    
    public function actualizarComentario()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'EvaluacionDao.php';
        
        $idPeriodo = filter_input(INPUT_POST, 'idPeriodo', FILTER_SANITIZE_NUMBER_INT);
        $comentarios = filter_input(INPUT_POST, 'comentario', FILTER_SANITIZE_STRING);
        
        $e = new Evaluacion();
        $e->__set('_idPeriodo', $idPeriodo);
        $e->__set('_comentarios', $comentarios);
        $e->__set('_idUsuario', Sesion::obtener('idUsuario'));
        
        $ac = new EvaluacionDao();
        $actualiza = $ac->actualizarComentario($e);
        if ($actualiza['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Datos actualizados';
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $actualiza['error'];
        }
        
        echo json_encode($response);
    }
    
    public function eliminarObjetivo()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'CompromisosMejoraDao.php';
        
        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $idObjetivo = filter_input(INPUT_POST, 'idObjetivo', FILTER_SANITIZE_NUMBER_INT);
        
        $ob = new CompromisosMejoraDao();
        
        $elimina = $ob->rechazarActividad($idObjetivo, $idUsuario);
        if ($elimina['status']){
            $response['status'] = true;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $elimina['error'];
        }
        
        echo json_encode($response);
    }
    
    public function finalizarProceso()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . 
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompromisosMejoraDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompetenciaTemporalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'inicio' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'ComentariosDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
                'models' . DIRECTORY_SEPARATOR . 'ActividadEvaluacionDao.php';
        
        $idUsuario = filter_input(INPUT_POST, 'idUsuario', FILTER_SANITIZE_NUMBER_INT);
        $idPeriodo = filter_input(INPUT_POST, 'idPeriodo', FILTER_SANITIZE_NUMBER_INT);
        //obtenemos los datos del usuario
        $u = new UsuarioDao();
        $us = $u->obtenerUsuario($idUsuario);
        $datosUsuario = $us['usuarios'];        
        
        //obtenemos los registros de los objetivos
        $com = new CompromisosMejoraDao();
        $compromisos = $com->obtenerCompromisosMejoraTemporal($idUsuario, $idPeriodo);
        
        $arrayCompromisos = new ArrayObject($compromisos['compromisos']);
        $iteradorCompromisos = $arrayCompromisos->getIterator();
        
        while($iteradorCompromisos->valid()){
            $c = new Comentarios();
            $c->__set('_quien', $datosUsuario->Nombre . ' ' . $datosUsuario->Apellido_Paterno . ' ' . $datosUsuario->Apellido_Materno);
            $c->__set('_cuando', $iteradorCompromisos->current()->Fecha);
            $c->__set('_comentarios', $iteradorCompromisos->current()->Expectativa);
            $c->__set('_etapa', '');
            $c->__set('_idSospechoso', $idUsuario);
            $c->__set('_tipo', 'evaluacion');
            $c->__set('_status', 1);
            $c->__set('_progreso', 0);
            $c->__set('_avance', $iteradorCompromisos->current()->Actividad);
            $c->__set('_idSucursalComentario', $datosUsuario->Id_Sucursal);
            $gcom = new ComentariosDao();
            $guardarCompromiso = $gcom->guardarActividades($c);
            if (!$guardarCompromiso['status']){
                $response['status'] = false;
                $response['mensaje'] = $guardarCompromiso['error'];
                break;
            }
            $iteradorCompromisos->next();
        }
        
        
        //obtenemos las competencias
        $comp = new CompetenciaTemporalDao();
        $competencias = $comp->obtenerCompentencias($idUsuario, $idPeriodo);
        $arrayCompetencias = new ArrayObject($competencias['competencias']);
        $iteradorCompetencias = $arrayCompetencias->getIterator();
        while($iteradorCompetencias->valid()){
            $c = new Comentarios();
            $c->__set('_quien', $datosUsuario->Nombre . ' ' . $datosUsuario->Apellido_Paterno . ' ' . $datosUsuario->Apellido_Materno);
            $c->__set('_cuando', $iteradorCompetencias->current()->Fecha);
            $c->__set('_comentarios', $iteradorCompetencias->current()->Accion);
            $c->__set('_etapa', '');
            $c->__set('_idSospechoso', $idUsuario);
            $c->__set('_tipo', 'evaluacion');
            $c->__set('_status', 1);
            $c->__set('_progreso', 0);
            $c->__set('_avance', $iteradorCompetencias->current()->Actividad);
            $c->__set('_idSucursalComentario', $datosUsuario->Id_Sucursal);
            $gcomp = new ComentariosDao();
            $guardarCompetencias = $gcomp->guardarActividades($c);
            if(!$guardarCompetencias['status']){
                $response['status'] = false;
                $response['mensaje'] = $guardarCompetencias['error'];
                break;
            }
            $iteradorCompetencias->next();
        }
        
        
        $a = new ActividadEvaluacion();
        $a->__set('_idSucursal', $datosUsuario->Id_Sucursal);
        $a->__set('_idUsuario', $idUsuario);
        $a->__set('_status', 1);
        $act = new ActividadEvaluacionDao();
        $actividad = $act->guardarActividad($a);
        
        if ($actividad['status']){
            $response['status'] = true;
            $response['mensaje'] = 'Actividades generadas correctamente.';
        }
        else
        {
            $response['status'] = false;
            $response['mensaje'] = $actividad['error'];
        }
        echo json_encode($response);
    }
    
    public function eliminaCompetencia()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . 
                DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompetenciaTemporalDao.php';
        
        $idCompetencia = filter_input(INPUT_POST, 'idCompetencia', FILTER_SANITIZE_NUMBER_INT);
        
        $com = new CompetenciaTemporalDao();
        $elimina = $com->eliminaCompetencia($idCompetencia);
        if ($elimina['status']){
            $response['status'] = true;
        }
        else{
            $response['status'] = false;
            $response['mensaje'] = $elimina['error'];
        }
        
        echo json_encode($response);
    }
}

if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    new Sesion();
    if (Sesion::existeSesion('idUsuario') && Sesion::existeSesion('idSucursal')) {
        $accion = filter_input(INPUT_POST, 'accion', FILTER_SANITIZE_STRING);
        $obj = new AjaxEvaluacionController();
        $obj->$accion();
    } else {
        $response['status'] = false;
        $response['mensaje'] = 'Lo siento tu sesión ha caducado. Por favor vuelve a iniciar sesión.';
        echo json_encode($response);
    }
} else {
    $response['status'] = false;
    $response['mensaje'] = 'Acceso denegado';
    echo json_encode($response);
}