<?php
/**
 * UsuariosController.php
 * Controlador principal del módulo de usuarios
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

class UsuariosController extends Controller {

    private $_module = 2;
    private $_tarea;

    public function __construct() {
        require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'TareasDao.php';
        $this->_modulo = 'usuarios';

        $t = new TareasDao();
        $tareas = $t->obtenerTareasModuloUsuario($this->_module, Sesion::obtener('idUsuario'));
        if (!$tareas['status']) {
            ErrorController::mostrarError(1, $tareas['error']);
        }
        $tareasLista = $tareas['tareas'];
        $arrayTareas = new ArrayObject($tareasLista);
        $iteradorTareas = $arrayTareas->getIterator();
        $this->_datos['tareas'] = $iteradorTareas;
    }

    public function index() {
        $this->_vista = 'index';
        $this->_datos['accion'] = '';
        $this->existeVista();
        $this->cargarVista();
    }

    public function login() {
        $this->_vista = 'login';
        $this->existeVista();
        $this->cargarVista();
    }

    public function logout() {
        session_destroy();
        header('location: ' . BASEURL);
    }

    public function evaluacion() {
        //validar si tiene permisos
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $this->_vista = 'evaluacion';
            $this->existeVista();
            $this->_datos['accion'] = 'evaluación de personal';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function evaluacionMando() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $u = new UsuarioDao();
            $us = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
            if ($us['status']) {
                $datosUsuario = $us['usuarios'];
                $nombreUsuario = $datosUsuario->Nombre . ' ' .
                        $datosUsuario->Apellido_Paterno . ' ' . $datosUsuario->Apellido_Materno;
                $idValuador = $datosUsuario->Id_Usuario;
                $mando = $u->obtenerUsuariosConMando();
                if ($mando['status']) {
                    $datosUsuarios = $mando['usuarios'];
                    $arrayUsuarios = new ArrayObject($datosUsuarios);
                    $iteradorUsuarios = $arrayUsuarios->getIterator();
                    $this->_vista = 'evaluacionMando';
                    $this->existeVista();
                    $this->_datos['tipoEvaluacion'] = 1;
                    $this->_datos['accion'] = 'evaluación de personal';
                    $this->_datos['valuador'] = $nombreUsuario;
                    $this->_datos['idValuador'] = $idValuador;
                    $this->_datos['usuarios'] = $iteradorUsuarios;
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $mando['error']);
                }
            } else {
                ErrorController::mostrarError(1, $us['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function evaluacionSinMando() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $u = new UsuarioDao();
            $us = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
            if ($us['status']) {
                $datosUsuario = $us['usuarios'];
                $nombreUsuario = $datosUsuario->Nombre . ' ' .
                        $datosUsuario->Apellido_Paterno . ' ' . $datosUsuario->Apellido_Materno;
                $idValuador = $datosUsuario->Id_Usuario;
                $mando = $u->obtenerUsuariosSinMando();
                if ($mando['status']) {
                    $datosUsuarios = $mando['usuarios'];
                    $arrayUsuarios = new ArrayObject($datosUsuarios);
                    $iteradorUsuarios = $arrayUsuarios->getIterator();
                    $this->_vista = 'evaluacionSinMando';
                    $this->existeVista();
                    $this->_datos['tipoEvaluacion'] = 1;
                    $this->_datos['accion'] = 'evaluación de personal';
                    $this->_datos['valuador'] = $nombreUsuario;
                    $this->_datos['idValuador'] = $idValuador;
                    $this->_datos['usuarios'] = $iteradorUsuarios;
                    $this->cargarVista();
                } else {
                    ErrorController::mostrarError(1, $mando['error']);
                }
            } else {
                ErrorController::mostrarError(1, $us['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function competenciaSinMando() {
        //validar si tiene permisos
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $this->_vista = 'competenciaSInMando';
            $this->existeVista();
            $this->_datos['accion'] = 'evaluación de personal';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function competenciaMando() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' .
                DIRECTORY_SEPARATOR . 'CompetenciaMandoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'PeriodoDao.php';

        //validar si tiene permisos
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $this->_vista = 'competenciaMando';
            $idEvaluado = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            //obtenemos el periodo
            $p = new PeriodoDao();
            $up = $p->obtenerUltimoPeriodo();
            if ($up['status']) {
                $ultimo = $up['periodo'];
                $fechaInicio = $ultimo->Inicio;
                $fechaFin = date("Y-m-d", strtotime($fechaInicio . ' + 1 month'));
                $periodo = $p->periodoActivo($fechaInicio, $fechaFin);
                if ($periodo['status']) {
                    $hayPeriodo = $periodo['hayPeriodo'];
                    if ($hayPeriodo > 0) {
                        $datosPeriodo = $periodo['periodo'];
                        $idPeriodo = $datosPeriodo->Id_Periodo;
                        $this->_datos['idPeriodo'] = $idPeriodo;
                        //obtenemos las competencias
                        $co = new CompetenciaMandoDao();
                        $competencia = $co->obtenerCompetenciaMandoPorUsuario($idEvaluado, $idPeriodo);

                        if ($competencia['status']) {
                            $hayCompetencia = $competencia['totalRegistros'];
                            if ($hayCompetencia > 0) {
                                $datosCompetencia = $competencia['compentencia'];
                                $pregunta1 = $datosCompetencia->Pregunta1;
                                $pregunta2 = $datosCompetencia->Pregunta2;
                                $pregunta3 = $datosCompetencia->Pregunta3;
                                $pregunta4 = $datosCompetencia->Pregunta4;
                                $pregunta5 = $datosCompetencia->Pregunta5;
                                $pregunta6 = $datosCompetencia->Pregunta6;
                                $pregunta7 = $datosCompetencia->Pregunta7;
                                $pregunta8 = $datosCompetencia->Pregunta8;
                                $pregunta9 = $datosCompetencia->Pregunta9;
                                $pregunta10 = $datosCompetencia->Pregunta10;
                                $pregunta11 = $datosCompetencia->pregunta11;
                                $pregunta12 = $datosCompetencia->Pregunta12;
                                $pregunta13 = $datosCompetencia->Pregunta13;
                                $pregunta14 = $datosCompetencia->Pregunta14;
                                $pregunta15 = $datosCompetencia->Pregunta15;
                                $totalPuntos = $datosCompetencia->Total_Puntos;
                                $totalEvaluacion = $datosCompetencia->Total_Evaluacion;
                            } else {
                                $pregunta1 = 0;
                                $pregunta2 = 0;
                                $pregunta3 = 0;
                                $pregunta4 = 0;
                                $pregunta5 = 0;
                                $pregunta6 = 0;
                                $pregunta7 = 0;
                                $pregunta8 = 0;
                                $pregunta9 = 0;
                                $pregunta10 = 0;
                                $pregunta11 = 0;
                                $pregunta12 = 0;
                                $pregunta13 = 0;
                                $pregunta14 = 0;
                                $pregunta15 = 0;
                                $totalPuntos = 0;
                                $totalEvaluacion = 0;
                            }

                            $this->existeVista();
                            $this->_datos['accion'] = 'evaluación de personal';
                            $this->_datos['evaluado'] = $idEvaluado;
                            $this->_datos['pregunta1'] = $pregunta1;
                            $this->_datos['pregunta2'] = $pregunta2;
                            $this->_datos['pregunta3'] = $pregunta3;
                            $this->_datos['pregunta4'] = $pregunta4;
                            $this->_datos['pregunta5'] = $pregunta5;
                            $this->_datos['pregunta6'] = $pregunta6;
                            $this->_datos['pregunta7'] = $pregunta7;
                            $this->_datos['pregunta8'] = $pregunta8;
                            $this->_datos['pregunta9'] = $pregunta9;
                            $this->_datos['pregunta10'] = $pregunta10;
                            $this->_datos['pregunta11'] = $pregunta11;
                            $this->_datos['pregunta12'] = $pregunta12;
                            $this->_datos['pregunta13'] = $pregunta13;
                            $this->_datos['pregunta14'] = $pregunta14;
                            $this->_datos['pregunta15'] = $pregunta15;
                            $this->_datos['totalPuntos'] = $totalPuntos;
                            $this->_datos['totalEvaluacion'] = $totalEvaluacion;
                            $this->cargarVista();
                        } else {
                            ErrorController::mostrarError(1, $competencia['error']);
                        }
                    } else {
                        ErrorController::mostrarError(1, 'No existe periodo activo');
                    }
                } else {
                    ErrorController::mostrarError(1, $periodo['error']);
                }
            } else {
                
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function objetivosMando() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DriverDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'IndicadorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'PeriodoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'ObjetivoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'SugerenciaDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'LPA2Dao.php';

        //validar si tiene permisos
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            //comprobamos si existe periodo abierto y si no se ha capturado información
            $idEvaluado = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            //validamos que solo el jefe directo tenga acceso a la evaluación
            $u = new UsuarioDao();
            $gere = $u->obtenerGerenteUsuario($idEvaluado);
            $gerente = $gere['gerente'];
            $idGerente = $gerente->Id_Gerente;
            if ($idGerente != Sesion::obtener('idUsuario')) {
                ErrorController::mostrarError(403);
            }

            $p = new PeriodoDao();
            $ultimo = $p->obtenerUltimoPeriodo();
            if ($ultimo['status']) {
                $datosUltimo = $ultimo['periodo'];
                $fechaInicio = $datosUltimo->Inicio;
                $fechaFin = date("Y-m-d", strtotime($fechaInicio . ' + 1 month'));
                $fechaInicioSugerencia = date("Y-m-1 00:00:00");
                $fechaFinSugerencia = date("Y-m-t 23:59:59");

                $periodo = $p->periodoActivo($fechaInicio, $fechaFin);
                if ($periodo['status']) {
                    $hayPeriodo = $periodo['hayPeriodo'];
                    if ($hayPeriodo > 0) {
                        $datosPeriodo = $periodo['periodo'];
                        $idPeriodo = $datosPeriodo->Id_Periodo;
                        $this->_datos['idPeriodo'] = $idPeriodo;
                        //si hay periodo activo
                        $ob = new ObjetivoDao();
                        $objetivos = $ob->obtenerObjetivosPorUsuario($idEvaluado, 1);
                        if ($objetivos['status']) {
                            $hayObjetivos = $objetivos['totalRegistros'];
                            if ($hayObjetivos > 0) {
                                $d = new DriverDao();
                                $drivers = $d->obtenerDrivers();
                                if ($drivers['status']) {
                                    //cargamos los datos de los objetivos
                                    //sugerencias mejora
                                    $sug = new SugerenciaDao();
                                    $tSug = $sug->totalSugerenciasPorUsuario($idEvaluado, $fechaInicioSugerencia, $fechaFinSugerencia);
                                    $totalSugerencias = $tSug['totalSugerencias'];
                                    if ($totalSugerencias > 10) {
                                        $totalSugerencias = 10;
                                    }
                                    //lpa2
                                    $lp = new LPA2Dao();
                                    $lpa = $lp->cumplimientoLPAP2orUsuario($idEvaluado, $fechaInicioSugerencia, $fechaFinSugerencia);
                                    $lpa2 = $lpa['cumplimiento'];
                                    $cumplimientoLpa2 = $lpa2->Cumplimiento;
                                    $cumplimientoLpa2 = $lpa2->Cumplimiento;
                                    if ($cumplimientoLpa2 == NULL) {
                                        $cumplimientoLpa2 = 0;
                                    }
                                    $arrayDrivers = new ArrayObject($drivers['drivers']);
                                    $iteradorDriver = $arrayDrivers->getIterator();
                                    $this->_vista = 'objetivosMando';
                                    $this->existeVista();
                                    $this->_datos['edicion'] = 0;
                                    $this->_datos['evaluado'] = $idEvaluado;
                                    $this->_datos['accion'] = 'evaluación de personal';
                                    $this->_datos['totalSugerencias'] = $totalSugerencias;
                                    $this->_datos['cumplimientoLPA2'] = $cumplimientoLpa2;
                                    $this->_datos['drivers'] = $iteradorDriver;
                                    $this->cargarVista();
                                } else {
                                    ErrorController::mostrarError(1, $drivers['error']);
                                }
                            } else {
                                $d = new DriverDao();
                                $drivers = $d->obtenerDrivers();
                                if ($drivers['status']) {
                                    $arrayDrivers = new ArrayObject($drivers['drivers']);
                                    $iteradorDriver = $arrayDrivers->getIterator();
                                    //cargamos los datos de los objetivos
                                    //sugerencias mejora
                                    $sug = new SugerenciaDao();
                                    $tSug = $sug->totalSugerenciasPorUsuario($idEvaluado, $fechaInicioSugerencia, $fechaFinSugerencia);
                                    $totalSugerencias = $tSug['totalSugerencias'];
                                    if ($totalSugerencias > 10) {
                                        $totalSugerencias = 10;
                                    }
                                    //lpa2
                                    $lp = new LPA2Dao();
                                    $lpa = $lp->cumplimientoLPAP2orUsuario($idEvaluado, $fechaInicioSugerencia, $fechaFinSugerencia);
                                    $lpa2 = $lpa['cumplimiento'];
                                    $cumplimientoLpa2 = $lpa2->Cumplimiento;
                                    if ($cumplimientoLpa2 == NULL) {
                                        $cumplimientoLpa2 = 0;
                                    }

                                    $this->_vista = 'objetivosMando';
                                    $this->existeVista();
                                    $this->_datos['edicion'] = 1;
                                    $this->_datos['evaluado'] = $idEvaluado;
                                    $this->_datos['accion'] = 'evaluación de personal';
                                    $this->_datos['totalSugerencias'] = $totalSugerencias;
                                    $this->_datos['cumplimientoLPA2'] = $cumplimientoLpa2;
                                    $this->_datos['drivers'] = $iteradorDriver;
                                    $this->cargarVista();
                                } else {
                                    ErrorController::mostrarError(1, $drivers['error']);
                                }
                            }
                        } else {
                            ErrorController::mostrarError(1, $objetivos['error']);
                        }
                    } else {
                        //si no hay periodo activo, consultamos los datos del último periodo
                        $last = $p->obtenerUltimoPeriodo();
                        if ($last['status']) {
                            $hayPeriodo = $last['hayPeriodo'];
                            if ($hayPeriodo > 0) {
                                //aqui 

                                $d = new DriverDao();
                                $drivers = $d->obtenerDrivers();
                                $arrayDrivers = new ArrayObject($drivers['drivers']);
                                $iteradorDriver = $arrayDrivers->getIterator();

                                $datosPeriodo = $last['periodo'];
                                $idPeriodo = $datosPeriodo->Id_Periodo;
                                $this->_datos['idPeriodo'] = $idPeriodo;
                                $obj = new ObjetivoDao();
                                $objetivos = $obj->obtenerObjetivosPorUsuario($idEvaluado, $idPeriodo);
                                if ($objetivos['status']) {
                                    //cargamos los datos de los objetivos
                                    //sugerencia de mejora
                                    $sug = new SugerenciaDao();
                                    $tSug = $sug->totalSugerenciasPorUsuario($idEvaluado, $fechaInicioSugerencia, $fechaFinSugerencia);
                                    $totalSugerencias = $tSug['totalSugerencias'];
                                    if ($totalSugerencias > 10) {
                                        $totalSugerencias = 10;
                                    }
                                    //lpa2
                                    $lp = new LPA2Dao();
                                    $lpa = $lp->cumplimientoLPAP2orUsuario($idEvaluado, $fechaInicioSugerencia, $fechaFinSugerencia);
                                    $lpa2 = $lpa['cumplimiento'];
                                    $cumplimientoLpa2 = $lpa2->Cumplimiento;
                                    $cumplimientoLpa2 = $lpa2->Cumplimiento;
                                    if ($cumplimientoLpa2 == NULL) {
                                        $cumplimientoLpa2 = 0;
                                    }
                                    $datosObjetivos = $objetivos['objetivos'];
                                    $arrayObjetivos = new ArrayObject($datosObjetivos);
                                    $iteradorObjetivos = $arrayObjetivos->getIterator();
                                    $this->_vista = 'objetivosMando';
                                    $this->existeVista();
                                    $this->_datos['edicion'] = 1;
                                    $this->_datos['cumplimientoLPA2'] = $cumplimientoLpa2;
                                    $this->_datos['evaluado'] = $idEvaluado;
                                    $this->_datos['totalSugerencias'] = $totalSugerencias;
                                    $this->_datos['accion'] = 'evaluación de personal';
                                    $this->_datos['objetivos'] = $iteradorObjetivos;
                                    $this->_datos['drivers'] = $iteradorDriver;
                                    $this->cargarVista();
                                } else {
                                    ErrorController::mostrarError(1, $objetivos['error']);
                                }
                            } else {
                                ErrorController::mostrarError(1, 'Lo siento, no existen periodos registrados');
                            }
                        } else {
                            ErrorController::mostrarError(1, $last['error']);
                        }
                    }
                } else {
                    ErrorController::mostrarError(1, $periodo['error']);
                }
            } else {
                ErrorController::mostrarError(1, $ultimo['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function drivers() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DriverDao.php';

        //validar si tiene permisos
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $d = new DriverDao();
            $drivers = $d->obtenerDrivers();
            if ($drivers['status']) {
                $arrayDrivers = new ArrayObject($drivers['drivers']);
                $iteradorDrivers = $arrayDrivers->getIterator();
                $this->_vista = 'drivers';
                $this->existeVista();
                $this->_datos['drivers'] = $iteradorDrivers;
                $this->_datos['accion'] = 'evaluación de personal';
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $drivers['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function agregaIndicador() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
                'models' . DIRECTORY_SEPARATOR . 'DriverDao.php';
        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            $idDriver = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            $d = new DriverDao();
            $drivers = $d->obtenerDriver($idDriver);
            if ($drivers['status']) {
                $driver = $drivers['driver'];
                $this->_vista = 'agregaIndicador';
                $this->existeVista();
                $this->_datos['driver'] = $driver;
                $this->_datos['accion'] = 'evaluación de personal';
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $drivers['error']);
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function compromisosMejora() {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios'
                . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompetenciaMandoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios'
                . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'PeriodoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios'
                . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'ObjetivoDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios'
                . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'IndicadorDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios'
                . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompromisosMejoraDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios'
                . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'CompetenciaTemporalDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios'
                . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'EvaluacionDao.php';


        $this->_tarea = 75;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $idUsuario = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
            $p = new PeriodoDao();
            $periodo = $p->obtenerUltimoPeriodo();
            if ($periodo['status']) {
                $idPeriodo = $periodo['periodo']->Id_Periodo;
                $co = new CompetenciaMandoDao();
                $competencia = $co->obtenerCompetenciaMandoPorUsuario($idUsuario, 2);
                if ($competencia['status']) {
                    $hay2 = $competencia['totalRegistros'];
                    if ($hay2 > 0) {
                        $datosCompetencia = $competencia['compentencia'];
                        $competenciaDesarrollo = new ArrayObject();
                        if ($datosCompetencia->Pregunta1 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Innovador', 'accion' => 'Propone soluciones creativas, desarrolla maneras diferentes y novedosas para hacer frente a los retos'));
                        }
                        if ($datosCompetencia->Pregunta2 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Trabaja en Equipo', 'accion' => 'Trabaja eficazmente en grupos de trabajo y colabora con otras personas de la organización.'));
                        }
                        if ($datosCompetencia->Pregunta3 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Mejora Continua', 'accion' => 'Promueve la mejora de condiciones y procesos existentes; implementa soluciones y mide su impacto.'));
                        }
                        if ($datosCompetencia->Pregunta4 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Generar Confianza', 'accion' => 'Infunde confianza y seguridad a través de lo que hace y lo que dice; trata a los demás con dignidad justicia y respeto.'));
                        }
                        if ($datosCompetencia->Pregunta5 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Comunicador', 'accion' => 'Transmite información e ideas con claridad y de manera fácil de comprender y retener.'));
                        }
                        if ($datosCompetencia->Pregunta6 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Orientación al Cliente', 'accion' => 'Hace de los clientes el enfoque principal de sus acciones, buscando su satisfacción.'));
                        }
                        if ($datosCompetencia->Pregunta7 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Iniciativa', 'accion' => 'Toma medidas inmediatas y efectivas para lograr y/o exceder los objetivos; es proactivo'));
                        }
                        if ($datosCompetencia->Pregunta8 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Calidad', 'accion' => 'Realiza las tareas asegurando que estén libres de defecto y que satisfagan los requerimientos del cliente.'));
                        }
                        if ($datosCompetencia->Pregunta9 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Altos Estándares de trabajo', 'accion' => 'Se fija metas ambiciosas; asume la responsabilidad y compromiso para el logro exitoso de las tareas.'));
                        }
                        if ($datosCompetencia->Pregunta10 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Auto desarrollo', 'accion' => 'Actualiza sus conocimientos para el desempeño eficiente de su puesto; identifica nuevas áreas para el aprendizaje.'));
                        }
                        if ($datosCompetencia->pregunta11 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Visionario', 'accion' => 'La visión y los valores de la organización se ven reflejados en todas sus decisiones y acciones.'));
                        }
                        if ($datosCompetencia->Pregunta12 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Delega Autoridad', 'accion' => 'Asigna tareas a sus colaboradores con la autoridad para realizarlas y comparte la responsabilidad.'));
                        }
                        if ($datosCompetencia->Pregunta13 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Promueve el desarrollo de los demás', 'accion' => 'Orienta y guía el desarrollo del personal para el logro de los objetivos de trabajo.'));
                        }
                        if ($datosCompetencia->Pregunta14 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Planeación y Organización del trabajo', 'accion' => 'Establece planes de acción para sí mismo y para otros con objeto de asegurar que el trabajo se realice correctamente.'));
                        }
                        if ($datosCompetencia->Pregunta15 < 5) {
                            $competenciaDesarrollo->append(array('competencia' => 'Negociador', 'accion' => 'Establece acuerdos con el apoyo y aceptación de todas las partes, para el logro de los objetivos.'));
                        }

                        $iteradorCompetenciaDesarrollo = $competenciaDesarrollo->getIterator();
                        $cm = new CompromisosMejoraDao();

                        $totalEvaluacion = $datosCompetencia->Total_Evaluacion;
                        $o = new ObjetivoDao();
                        $objetivos = $o->obtenerTotalPuntosPorUsuario($idUsuario, 2);
                        if ($objetivos['status']) {
                            $mejoras = 0;
                            $datosObjetivos = $objetivos['puntos'];
                            $puntos = ($datosObjetivos->Total_Puntos * 60) / 100;
                            $aspectos = $o->obtenerAspectoAMejorar($idUsuario, $idPeriodo);
                            if ($aspectos['status']) {
                                $hay = $aspectos['total'];
                                if ($hay == 0) {
                                    ErrorController::mostrarError(1, 'Aún no te han evaluado');
                                } else {
                                    $arrayAspectos = new ArrayObject($aspectos['mejoras']);
                                    $iteradorAspectos = $arrayAspectos->getIterator();

                                    //validamos si hay registros para ese periodo
                                    $hayComp = $cm->obtenerCompromisosMejoraTemporal($idUsuario, 2);
                                    if ($hayComp['status']) {
                                        $hayCompromisos = $hayComp['hayCompromisos'];
                                        if ($hayCompromisos > 0) {
                                            $compromisos = $hayComp['compromisos'];
                                            $arrayCompromisos = new ArrayObject($compromisos);
                                            $iteradorCompromisos = $arrayCompromisos->getIterator();
                                        } else {
                                            while ($iteradorAspectos->valid()) {
                                                $com = new CompromisosMejora();
                                                $com->__set('_idIndicador', $iteradorAspectos->current()->Id_Indicador);
                                                $com->__set('_expectativa', $iteradorAspectos->current()->Expectativa);
                                                $com->__set('_actividad', '');
                                                $com->__set('_fecha', '');
                                                $com->__set('_status', 2);
                                                $com->__set('_idUsuario', $idUsuario);
                                                $com->__set('_idPeriodo', $idPeriodo);
                                                $guardaCompromiso = $cm->guardar($com);
                                                if (!$guardaCompromiso['status']) {
                                                    ErrorController::mostrarError(1, $guardaCompromiso['error']);
                                                    break;
                                                }

                                                $iteradorAspectos->next();
                                            }

                                            //obtenemos los datos
                                            $as = $cm->obtenerCompromisosMejoraTemporal($idUsuario, $idPeriodo);
                                            if ($as['status']) {
                                                $asp = $as['compromisos'];
                                                $arrayCompromisos = new ArrayObject($asp);
                                                $iteradorCompromisos = $arrayAspectos->getIterator();
                                            } else {
                                                ErrorController::mostrarError(1, $as['error']);
                                            }
                                        }
                                    } else {
                                        ErrorController::mostrarError(1, $hayComp['error']);
                                    }

                                    //cargar las competencias
                                    $comp = new CompetenciaTemporalDao();
                                    $comps = $comp->obtenerCompentencias($idUsuario, $idPeriodo);
                                    if ($comps['status']) {
                                        if ($comps['hayCompetencias'] > 0) {
                                            $arrayCompetencias = new ArrayObject($comps['competencias']);
                                            $iteradorCompetencias = $arrayCompetencias->getIterator();
                                        } else {

                                            $each = new RecursiveArrayIterator($iteradorCompetenciaDesarrollo);
                                            foreach ($each as $key => $val) {
                                                $cp = new CompetenciaTemporal();
                                                $cp->__set('_idUsuario', $idUsuario);
                                                $cp->__set('_idPeriodo', $idPeriodo);
                                                $cp->__set('_competencia', $val['competencia']);
                                                $cp->__set('_accion', $val['accion']);
                                                $cp->__set('_actividad', '');
                                                $cp->__set('_fecha', date("Y-m-d"));
                                                $inserta = $comp->guardar($cp);
                                                if (!$inserta['status']) {
                                                    $bandera = false;
                                                }
                                            }
                                        }

                                        $compe = $comp->obtenerCompentencias($idUsuario, $idPeriodo);
                                        if ($compe['status']) {
                                            $arrayCompetenciasTempora = new ArrayObject($compe['competencias']);
                                            $iteradorCompetencias = $arrayCompetenciasTempora->getIterator();
                                        } else {
                                            ErrorController::mostrarError(1, $compe['error']);
                                        }

                                        $ev = new EvaluacionDao();
                                        $eval = $ev->obtenerEvaluacion($idUsuario, $idPeriodo);
                                        if ($eval['status']) {
                                            $hay = $eval['hayDatos'];
                                            if ($hay > 0) {
                                                $datosEvaluacion = $eval['datosEvaluacion'];
                                            } else {
                                                $eval1 = new Evaluacion();
                                                $eval1->__set('_idUsuario', $idUsuario);
                                                $eval1->__set('_idPeriodo', $idPeriodo);
                                                $eval1->__set('_logros', '');
                                                $eval1->__set('_comentarios', '');
                                                $save = $ev->guardar($eval1);
                                                $dat = $ev->obtenerEvaluacion($idUsuario, $idPeriodo);
                                                $datosEvaluacion = $dat['datosEvaluacion'];
                                            }
                                        } else {
                                            ErrorController::mostrarError(1, $eval['error']);
                                        }


                                        $this->_vista = 'compromisoMejora';
                                        $this->_datos['aspectos'] = $iteradorCompromisos;
                                        $this->_datos['competencias'] = $iteradorCompetencias;
                                        $this->_datos['objetivos'] = $puntos;
                                        $this->_datos['totalDesempeno'] = $totalEvaluacion + $puntos;
                                        $this->_datos['Total_Evaluacion'] = $totalEvaluacion;
                                        $this->_datos['idEvaluado'] = $idUsuario;
                                        $this->_datos['periodo'] = $idPeriodo;
                                        $this->_datos['evaluacion'] = $datosEvaluacion;
                                        $this->existeVista();
                                        $this->_datos['accion'] = 'evaluación de personal';
                                        $this->cargarVista();
                                    } else {
                                        ErrorController::mostrarError(1, $comps['error']);
                                    }
                                }
                            } else {
                                ErrorController::mostrarError(1, $aspectos['error']);
                            }
                        } else {
                            ErrorController::mostrarError(1, $objetivos['error']);
                        }
                    } else {
                        ErrorController::mostrarError(1, 'Aún no te evaluan');
                    }
                } else {
                    ErrorController::mostrarError(1, $competencia['error']);
                }
            } else {
                $response['status'] = false;
                $response['mensaje'] = $periodo['error'];
            }
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function periodoEvaluacion() {
        $this->_tarea = 76;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }
            $this->_vista = 'periodoEvaluacion';
            $this->existeVista();
            $this->_datos['accion'] = 'evaluación de personal';
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function cambiarContrasena() {
        $this->_vista = 'cambiarContrasena';
        $this->existeVista();
        $this->_datos['accion'] = 'usuarios';
        $this->cargarVista();
    }

    public function password() {
        $this->_vista = 'password';
        $this->existeVista();
        $this->_datos['accion'] = 'usuarios';
        $this->cargarVista();
    }

    public function asistencia() {
        $this->_vista = 'asistencia';
        $this->existeVista();
        $this->_datos['accion'] = 'usuarios';
        $this->cargarVista();
    }


    public function salida() {
        $this->_vista = 'salida';
        $this->existeVista();
        $this->_datos['accion'] = 'usuarios';
        $this->cargarVista();
    }

    /** CRUD  USUARIOS * */
    public function usuarios() {
        //validar si tiene permisos
        $this->_tarea = 22;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'common' . DIRECTORY_SEPARATOR . 'TareasDao.php';
            $u = new UsuarioDao();
            $t = new TareasDao();

            $bancos = $u->getBancoNomina();
            $riesgos = $u->getRiesgoPuesto();
            $regimenes = $u->getRegimenContratacion();
            $proveedoresInternos = $u->getPrivedoresInternosActivos();

            /* $arrModulos = array(1 => 'Administración', 4 => 'Ventas', 6 => 'Balance Scorecard', 2 => 'Usuarios', 3 => 'Inventarios', 5 => 'Cobranza', 
              7 => 'Inicio', 8 => 'Contabilidad', 9 => 'Producción', 10 => 'Compras');
              $arrModulos = array(1 => 'Administración', 4 => 'Ventas', 2 => 'Usuarios', 6 => 'Balance Scorecard', 3 => 'Inventarios', 5 => 'Cobranza',
              8 => 'Contabilidad', 7 => 'Inicio', 9 => 'Producción', 10 => 'Compras'); */
            $arrModulos = array(1 => 'Administración', 4 => 'Ventas', 2 => 'Usuarios', 6 => 'Balance Scorecard', 3 => 'Inventarios',
                7 => 'Inicio', 8 => 'Contabilidad', 9 => 'Producción', 5 => 'Cobranza', 10 => 'Compras');
            $tareasTodas = array();
            foreach ($arrModulos as $key => $value) {
                $tareas = $t->getTareasModulo($key);
                foreach ($tareas['tareas'] as $tarea) {
                    $sub = $t->getSubtareas($tarea->Id_Tarea);
                    $tarea->subtareas = $sub['subtareas'];
                }
                $tareasTodas[] = array('title' => $value, 'tareas' => $tareas['tareas'], 'id' => $key);
            }

            $this->_vista = 'usuarios';
            $this->existeVista();
            $this->_datos['accion'] = 'usuarios';
            $this->_datos['bancos'] = $bancos['bancos'];
            $this->_datos['riesgos'] = $riesgos['riesgos'];
            $this->_datos['regimenes'] = $regimenes['regimenes'];
            $this->_datos['proveedores'] = $proveedoresInternos['proveedores'];
            $this->_datos['tareasTodas'] = $tareasTodas;
            $this->cargarVista();
        } else {
            ErrorController::mostrarError(1, $perm['error']);
        }
    }
    
    public function permisos()
    {
        $this->_tarea = 112;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoSubtareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']){
            if ($perm['acceso'] == 0){
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            $u = new UsuarioDao();
            $user = $u->obtenerUsuario(Sesion::obtener('idUsuario'));

            $dia = date('w', strtotime('tomorrow'));
            if($dia == 0){
                $fecha = date('Y-m-d', strtotime('+2 day'));
            }else if($dia == 6){
                $fecha = date('Y-m-d', strtotime('+3 day'));
            }else{
                $fecha = date('Y-m-d', strtotime('tomorrow'));
            }

            if ($user['status'])
            {
                $this->_vista = 'permisos';
                $this->existeVista();
                $this->_datos['accion'] = 'permisos';
                $this->_datos['user'] = $user['usuarios']->Nombre.' '.$user['usuarios']->Apellido_Paterno.' '.$user['usuarios']->Apellido_Materno;
                $this->_datos['fecha'] = $fecha;
                $this->_datos['fechaf'] = str_replace('-', '/', $fecha);
                $this->cargarVista();
            } else {
                ErrorController::mostrarError(1, $user['error']);
            }
        }
        else{
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function tarjetaAsistencia()
    {
        $this->_tarea = 81;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';

            $u = new UsuarioDao();
            $usuarios = $u->obtenerTodosUsuariosActivosSinDirectores();
            if ($usuarios['status']){
                $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                $iteradorUsuarios = $arrayUsuarios->getIterator();
                $this->_vista = 'tarjetaAsistencia';
                $this->existeVista();
                $this->_datos['usuarios'] = $iteradorUsuarios;
                $this->_datos['accion'] = 'tarjeta de asistencia';
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        }
        else{
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function generaTarjetaAsistencia()
    {
        $this->_tarea = 81;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';
            require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdf' . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';

            $idUsuario = filter_input(INPUT_POST, 'usuario', FILTER_SANITIZE_NUMBER_INT);
            $fechaInicial = filter_input(INPUT_POST, 'fechaInicial', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'fechaFinal', FILTER_SANITIZE_STRING);

            $u = new UsuarioDao();
            $tabla = array();
            if ($idUsuario > 0){
                
                $usuario = $u->obtenerUsuario($idUsuario);
                if ($usuario['status']){
                    $datosUsuario = $usuario['usuarios'];
                    $a = new AsistenciaDao();
                    $asistencias = $a->obtenerAsistencias($idUsuario, $fechaInicial, $fechaFinal);
                    
                    if ($asistencias['status']){
                        $arrayAsistencia = new ArrayObject($asistencias['asistencias']);
                        $iteradorAsistencias = $arrayAsistencia->getIterator();
                        while($iteradorAsistencias->valid()){
                            $fechaAsistencia = date("Y-m-d", strtotime($iteradorAsistencias->current()->Fecha));
                            $fechaAsistencia = $fechaAsistencia . ' 09:15:00';
                            $horaEntrada = new DateTime($fechaAsistencia);
                            $fecha = date("Y-m-d", strtotime($iteradorAsistencias->current()->Fecha));
                            $fechaEntrada = new DateTime($fecha . ' ' . $iteradorAsistencias->current()->Hora_Entrada);                        
                            switch($iteradorAsistencias->current()->Asistencia){
                                case "1": 
                                    $falta = 0;
                                    break;
                                case "3":
                                    $falta = 1;
                                    break;
                            }

                            $diferencia = $horaEntrada->diff($fechaEntrada, true);              
                            
                            if($horaEntrada < $fechaEntrada){
                                $retardo = $diferencia->i;
                            }
                            else{
                                $retardo = 0;
                            }

                            $tabla[] = array(
                                "fecha" => date("d/m/Y", strtotime($fecha)),
                                "entrada" => $iteradorAsistencias->current()->Hora_Entrada,
                                "salida" => $iteradorAsistencias->current()->Hora_Salida,
                                "falta" => $falta,
                                "retardo" => $retardo,
                                "observaciones" => $iteradorAsistencias->current()->Observaciones
                            );
                            $iteradorAsistencias->next();
                        }
                    
                        $this->_vista = 'generaTarjetaAsistencia';
                        $this->existeVista();
                        $this->_datos['asistencias'] = $tabla;
                        $this->_datos['fechaInicial'] = date("d/m/Y", strtotime($fechaInicial));
                        $this->_datos['fechaFinal'] = date("d/m/Y", strtotime($fechaFinal));
                        $this->_datos['usuario'] = $datosUsuario;
                        $this->_datos['accion'] = 'tarjeta de asistencia';
                        $this->cargarVista();

                    }
                    else{
                        ErrorController::mostrarError(1, $asistencias['error']);
                    }
                }
                else{
                    ErrorController::mostrarError(1, $usuario['error']);
                }
            }
            else{
                $usuarios = $u->obtenerTodosUsuariosActivosSinDirectores();                
                if ($usuarios['status']){
                    $arrayUsuarios = new ArrayObject($usuarios['usuarios']);
                    $iteradorUsuarios = $arrayUsuarios->getIterator();
                    

                    $this->_vista = 'generaTarjetaAsistenciaGlobal';
                    $this->existeVista();
                    $this->_datos['usuarios'] = $iteradorUsuarios;
                    $this->_datos['fechaInicialFormato'] = date("d/m/Y", strtotime($fechaInicial));
                    $this->_datos['fechaFinalFormato'] = date("d/m/Y", strtotime($fechaFinal));                    
                    $this->_datos['fechaInicial'] = $fechaInicial;
                    $this->_datos['fechaFinal'] = $fechaFinal;
                    $this->_datos['accion'] = 'tarjeta de asistencia';
                    $this->cargarVista();
                }
                else{
                    ErrorController::mostrarError(1, $usuarios['error']);
                }
            }
            
        }
        else{
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function asistencias()
    {
        $this->_tarea = 81;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            $u = new UsuarioDao();

            switch(Sesion::obtener('idRol'))
            {
                case '1':
                    $usuarios = $u->obtenerTodosUsuariosActivosSinDirectores();
                    break;
                case '2':
                    $usuarios = $u->obtenerUsuariosPorGerente(Sesion::obtener('idUsuario'));
                    break;
                default:
                    $usuarios = $u->obtenerUsuario(Sesion::obtener('idUsuario'));
                    break;
            }

            if ($usuarios['status']){
                $datosUsuarios = $usuarios['usuarios'];
                $this->_vista = 'asistencias';
                $this->existeVista();
                $this->_datos['usuarios'] = $datosUsuarios;
                $this->_datos['accion'] = 'asistencia';
                $this->cargarVista();
            }
            else{
                ErrorController::mostrarError(1, $usuarios['error']);
            }
        }
        else{
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteAsistencia()
    {
        $this->_tarea = 81;
        $t = new TareasDao();
        $perm = $t->obtenerPermisoTareaUsuario($this->_tarea, Sesion::obtener('idUsuario'));
        if ($perm['status']) {
            if ($perm['acceso'] == 0) {
                ErrorController::mostrarError(403);
            }

            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
            require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';

            $fechaInicial = filter_input(INPUT_POST, 'fechaInicial', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'fechaFinal', FILTER_SANITIZE_STRING);
            $idUsuario = isset($_POST['usuario']) ? filter_input(INPUT_POST, 'usuario', FILTER_SANITIZE_NUMBER_INT) : 0;
            $sucursal = isset($_POST['sucursal']) ? filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT) : 0; 

            $tabla = array();


            $a = new AsistenciaDao();
            if ($sucursal > 0){
                $asistencias = $a->obtenerAsistenciasReporteSucursal($sucursal, $fechaInicial, $fechaFinal)['asistencias'];
            }
            else{
                $asistencias = $a->obtenerAsistenciasReporteUsuario($idUsuario, $fechaInicial, $fechaFinal)['asistencias'];
            }

            $tabla = new ArrayObject();

            foreach($asistencias as $asistencia){
                $fechaAsistencia = date("Y-m-d", strtotime($asistencia->Fecha));
                $fechaAsistencia = $fechaAsistencia . ' 09:15:00';
                $horaEntrada = new DateTime($fechaAsistencia);
                $fecha = date("Y-m-d", strtotime($asistencia->Fecha));
                $fechaEntrada = new DateTime($fecha . ' ' . $asistencia->Hora_Entrada);                                       

                $diferencia = $horaEntrada->diff($fechaEntrada, true);              
                        
                if($horaEntrada < $fechaEntrada){
                    $retardo = $diferencia->format("%H:%i:%s");
                }
                else{
                    $retardo = 0;
                }

                switch($asistencia->Asistencia){
                    case "1":
                        $status = 'Asistencia';
                        break;
                    case "2":
                        $status = 'Retardo';
                        break;
                    case "3":
                        $status = 'Falta';
                        break;
                }

                $object = array(
                    "usuario" => $asistencia->Nombre . ' ' . $asistencia->Apellido_Paterno . ' ' . $asistencia->Apellido_Materno,
                    "fecha" => date("d/m/Y", strtotime($asistencia->Fecha)),
                    "horaEntrada" => $asistencia->Hora_Entrada,
                    "retraso" => $retardo,
                    "salida" => $asistencia->Hora_Salida,
                    "status" => $status,
                    "observaciones" => $asistencia->Observaciones,
                    "idAsistencia" => $asistencia->Id_Asistencia
                );
                $object = (object) $object;
                $tabla->append($object);
            }

            $iteradorTabla = $tabla->getIterator();

            $this->_vista = 'reporteAsistencia';
            $this->existeVista();
            $this->_datos['usuarios'] = $iteradorTabla;
            $this->_datos['accion'] = 'asistencia';
            $this->_datos['fechaInicial'] = $fechaInicial;
            $this->_datos['fechaFinal'] = $fechaFinal;
            $this->_datos['sucursal'] = $sucursal;
            $this->_datos['usuario'] = $idUsuario;
            $this->cargarVista();
            
        }
        else{
            ErrorController::mostrarError(1, $perm['error']);
        }
    }

    public function reporteAsistenciaPdf()
    {
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'AsistenciaDao.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdf' . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';

        $fechaInicial = filter_input(INPUT_POST, 'fechaInicial', FILTER_SANITIZE_STRING);
            $fechaFinal = filter_input(INPUT_POST, 'fechaFinal', FILTER_SANITIZE_STRING);
            $idUsuario = isset($_POST['usuario']) ? filter_input(INPUT_POST, 'usuario', FILTER_SANITIZE_NUMBER_INT) : 0;
            $sucursal = isset($_POST['sucursal']) ? filter_input(INPUT_POST, 'sucursal', FILTER_SANITIZE_NUMBER_INT) : 0; 

            $tabla = array();


            $a = new AsistenciaDao();
            if ($sucursal > 0){                
                $asistencias = $a->obtenerAsistenciasReporteSucursal($sucursal, $fechaInicial, $fechaFinal)['asistencias'];
            }
            else{
            
                $asistencias = $a->obtenerAsistenciasReporteUsuario($idUsuario, $fechaInicial, $fechaFinal)['asistencias'];
            }
            $tabla = new ArrayObject();        

            foreach($asistencias as $asistencia){                
                $fechaAsistencia = date("Y-m-d", strtotime($asistencia->Fecha));
                $fechaAsistencia = $fechaAsistencia . ' 09:15:00';
                $horaEntrada = new DateTime($fechaAsistencia);
                $fecha = date("Y-m-d", strtotime($asistencia->Fecha));
                $fechaEntrada = new DateTime($fecha . ' ' . $asistencia->Hora_Entrada);                                       

                $diferencia = $horaEntrada->diff($fechaEntrada, true);              
                        
                if($horaEntrada < $fechaEntrada){
                    $retardo = $diferencia->format("%H:%i:%s");
                }
                else{
                    $retardo = 0;
                }

                switch($asistencia->Asistencia){
                    case "1":
                        $status = 'Asistencia';
                        break;
                    case "2":
                        $status = 'Retardo';
                        break;
                    case "3":
                        $status = 'Falta';
                        break;
                }

                $object = array(
                    "usuario" => $asistencia->Nombre . ' ' . $asistencia->Apellido_Paterno . ' ' . $asistencia->Apellido_Materno,
                    "fecha" => date("d/m/Y", strtotime($asistencia->Fecha)),
                    "horaEntrada" => $asistencia->Hora_Entrada,
                    "retraso" => $retardo,
                    "salida" => $asistencia->Hora_Salida,
                    "status" => $status,
                    "observaciones" => $asistencia->Observaciones,
                    "idAsistencia" => $asistencia->Id_Asistencia
                );
                $object = (object) $object;
                $tabla->append($object);
            }
        

            $iteradorTabla = $tabla->getIterator();

            switch($sucursal){
                case 1:
                    $sucursal = 'Pachuca';
                    break;
                case 2: 
                    $sucursal = 'Puebla';
                    break;
                case 5: 
                    $sucursal = 'Querétaro';
                    break;
            }

            $this->_vista = 'reporteAsistenciaPdf';
            $this->existeVista();
            $this->_datos['usuarios'] = $iteradorTabla;
            $this->_datos['accion'] = 'asistencia';
            $this->_datos['fechaInicial'] = $fechaInicial;
            $this->_datos['fechaFinal'] = $fechaFinal;
            $this->_datos['sucursal'] = $sucursal;            
            $this->cargarVista();        
    }

    public function autorizaciones()
    {
        if (Sesion::obtener('idRol') == 1 || Sesion::obtener('idRol') == 2){
            $this->_vista = 'autorizaciones';
            $this->_datos['accion'] = 'autorizaciones';
            $this->existeVista();
            $this->cargarVista();        
        }
        else{
            ErrorController::mostrarError(403);
        }
    }
    
    
    public function cursosCapacitacion()
    {
            $this->_vista = 'cursosCapacitacion';
            $this->_datos['accion'] = 'cursosCapacitacion';
            $this->existeVista();
            $this->cargarVista();
    }

    public function contestarPreguntas()
    {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInternoParticipantesDao.php';

        $cursoInternoParticipantesDao = new CursoInternoParticipantesDao();

        $idCursoInternoParticipantes = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

        $preguntas = $cursoInternoParticipantesDao->obtenerPreguntasExamen($idCursoInternoParticipantes) ;

        $this->_vista = 'contestarPreguntas';
        $this->_datos['accion'] = 'contestarPreguntas';
        $this->_datos['preguntas'] = $preguntas['preguntas'];
        $this->_datos['totalPreguntas'] = $preguntas['total'];
        $this->_datos['idCursoInternoParticipantes'] = $idCursoInternoParticipantes;
        $this->existeVista();
        $this->cargarVista();
    }

    public function subirAsistenciasCursos()
    {
        $this->_vista = 'subirAsistenciasCursos';
        $this->_datos['accion'] = 'subirAsistenciasCursos';
        $this->existeVista();
        $this->cargarVista();
    }

    public function proximosCursos()
    {
        $this->_vista = 'proximosCursos';
        $this->_datos['accion'] = 'proximosCursos';
        $this->existeVista();
        $this->cargarVista();
    }

    public function autorizarListasAsistencias()
    {
        $this->_vista = 'autorizarListasAsistencias';
        $this->_datos['accion'] = 'autorizarListasAsistencias';
        $this->existeVista();
        $this->cargarVista();
    }

    public function cursosInduccion()
    {
        $this->_vista = 'cursosInduccion';
        $this->_datos['accion'] = 'cursosInduccion';
        $this->existeVista();
        $this->cargarVista();
    }

    public function contestarPreguntasInduccion()
    {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursoInduccionDao.php';

        $cursoInduccionDao = new CursoInduccionDao();

        $idCursoInduccion = filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);

        $preguntas = $cursoInduccionDao->obtenerPreguntasExamen($idCursoInduccion) ;

        $this->_vista = 'contestarPreguntasInduccion';
        $this->_datos['accion'] = 'contestarPreguntasInduccion';
        $this->_datos['preguntas'] = $preguntas['preguntas'];
        $this->_datos['totalPreguntas'] = $preguntas['total'];
        $this->_datos['idCursoInduccion'] = $idCursoInduccion;
        $this->existeVista();
        $this->cargarVista();
    }
    
   public function exportarReconocimientoCurso() {

        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'UsuarioDao.php';
        require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'balance' . DIRECTORY_SEPARATOR .
            'models' . DIRECTORY_SEPARATOR . 'CursosInternosDao.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdf' . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';
        require_once BASEPATH . 'libs' . DIRECTORY_SEPARATOR . 'pdf' . DIRECTORY_SEPARATOR . 'html2pdf.class.php';
        require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Email.php';

        $idUsuario= filter_input(INPUT_GET, 'opcion', FILTER_SANITIZE_NUMBER_INT);
        $idCurso = filter_input(INPUT_GET, 'id', FILTER_SANITIZE_NUMBER_INT);


        if (!is_numeric($idUsuario)) {
            ErrorController::mostrarError(1, 'Petición no válida');
        }

        $usuarioDao = new UsuarioDao();
        $cursosInternosDao = new CursosInternosDao();


        $usuario = $usuarioDao->obtenerUsuario($idUsuario)['usuarios'];
        $curso = $cursosInternosDao->obtenerCurso($idCurso)['curso'];

        $this->_vista = 'exportarReconocimientoCurso';
        $this->_datos['accion'] = 'exportarReconocimientoCurso';
        $this->_datos['nombreCurso'] = $curso->titulo;
        $this->_datos['nombreUsuario'] = $usuario->Nombre .' ' .   $usuario->Apellido_Paterno .' ' .   $usuario->Apellido_Materno ;
        $this->existeVista();
        $this->cargarVista();

    }
    
    public function subirNominaFirmada(){

        $this->_vista = 'subirNominaFirmada';
        $this->existeVista();
        $this->_datos['accion'] = 'subirNominaFirmada';
        $this->cargarVista();
    }

    public function historialNominas(){
        
        $idUsuario =  Sesion::obtener('idUsuario');
        $this->_vista = 'historialNominas';
        $this->existeVista();
        $this->_datos['accion'] = 'historialNominas';
        $this->_datos['user'] = $idUsuario;
        $this->cargarVista();
    }

}
