/**
 * Drivers.js
 * Clase y funciones para el manejo de drivers
 * @copyright (c) 2016 Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

var Driver = (function(){
    function Driver()
    {
        
    };
    
    Driver.prototype.guardarDriver = function(driver, impacto){
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'guardarDriver',
                driver: driver,
                impacto: impacto
            },
            beforeSend: function(){
                clase = $('#mensajeDriver').attr('class');
                $('#mensajeDriver').removeClass(clase).addClass('alert alert-info')
                        .text('Guardando datos, por favor espera...');
                
            },
            success: function(response){
                clase = $('#mensajeDriver').attr('class');
                if (response.status){
                    $('#mensajeDriver').removeClass(clase).addClass('alert alert-success')
                            .text(response.mensaje);
                }
                else{
                    $('#mensajeDriver').removeClass(clase).addClass('alert alert-danger')
                            .text(response.mensaje);
                }
            },
            error: function(){
                mensaje = 'Lo siento, ocurrió un error al guardar el Driver.';
                clase = $('#mensajeDriver').attr('class');
                $('#mensajeDriver').removeClass(clase).addClass('alert alert-danger')
                        .text(mensaje);
            }
        });
    };
    
    Driver.prototype.obtenerDrivers = function(){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'obtenerDrivers'
            },
            beforeSend: function(){
                $('.refresh-container-table').show();
            },
            success: function(response){
                $('.refresh-container-table').hide();
                if (response.status){
                    _this.renderDrivers(response);
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(){
                mensaje = 'Lo siento, ocurrió un error al obtener los datos de los drivers.';
                abreAlerta(mensaje);
            },
            timeout: 15000
        });
    };
    
    Driver.prototype.renderDrivers = function(response){
        var html = '';
        if (response.drivers.length > 0){
            $.each(response.drivers, function(registro, item){
                html += '<tr data="' + item.Id_Driver  + '">';
                html += '<td>' + item.Id_Driver + '</td>';
                html += '<td>' + item.Driver + '</td>';
                html += '<td>' + item.Impacto + '% </td>';
                html += '<td><a class="editar ayuda" href="javascript:void(0);" title="Editar Driver"><span class="fa fa-edit"></span></a> <a class="agregar ayuda" href="javascript:void(0)" title="Agregar Indicador"><span class="fa fa-plus"></span></a></td>';
                html += '</tr>';
            });
        }
        else{
            html += '<tr data="0">';
            html += '<td colspan="4">No se encontraron resultados</td>';
            html += '</tr>';
        }
        
        $('#listaDrivers tbody').html(html);
    };
    
    Driver.prototype.obtenerDriver = function(idDriver){
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'obtenerDriver',
                idDriver: idDriver
            },
            success: function(response){
                if (response.status){
                    $('#idDriverEdita').val(response.driver.Id_Driver);
                    $('#driverEditar').val(response.driver.Driver);
                    $('#impactoEditar').val(response.driver.Impacto);
                    $('#modalEdicionDriver').modal('show');
                }
                else{
                    abreAlerta(response.mensaje);
                }            
            },
            error: function(){
                mensaje = '';
                abreAlerta(mensaje);
            }
        });
    };
    
    Driver.prototype.editarDriver = function(idDriver, driver, impacto){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'editarDriver',
                idDriver: idDriver,
                driver: driver,
                impacto: impacto
            },
            success: function(response){
                $('#modalEdicionDriver').modal('hide');
                abreAlerta(response.mensaje);
                if (response.status){
                    _this.renderDrivers();
                }
            },
            error: function(){
                mensaje = 'Lo siento, ocurrió un error al guardar los datos';
                abreAlerta(mensaje);
            }
        });
    };
    
    Driver.prototype.obtenerIndicadoresDriver = function(driver){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'obtenerIndicadoresDriver',
                driver: driver
            },
            beforeSend: function(){
                $('.refresh-container-table').show();
            },
            success: function(response){
                if (response.status){
                    _this.renderIndicadores(response);
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(){
                mensaje = 'Lo siento, ocurrió un error al obtener los indicadores asociados al Driver';
                abreAlerta(mensaje);
            },
            timeout: 15000
        });
    };
    
    Driver.prototype.renderIndicadores = function(response){
        var html = '';
        if (response.indicadores.length > 0){
            $.each(response.indicadores, function(registro, item){
                html += '<tr data="' + item.Id_Indicador + '">';
                html += '<td>' + item.Id_Indicador + '</td>';
                html += '<td>' + item.Indicador  + '</td>';
                html += '<td>' + item.Impacto + '</td>';
                html += '<td>' +  item.Objetivo + '</td>';
                html += '<td><button type="button" class="btn btn-info editarIndicador">Editar</button> <button type="button" class="btn btn-danger eliminarIndicador">Eliminar</button>';
            });
        }
        else{
            html += '<tr data="0">';
            html += '<td colspan="4">No se encontraro resultados.</td>';
        }
        
        $('#listaIndicadores tbody').html(html);
    };
    
    Driver.prototype.agregarIndicador = function(idDriver, indicador, impacto, objetivo){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'agregarIndicador',
                idDriver: idDriver,
                indicador: indicador,
                impacto: impacto,
                objetivo: objetivo
            },
            beforeSend: function(){
                clase = $('#mensajeIndicador').attr('class');
                $('#mensajeIndicador').addClass('alert alert-info').html('Guardando datos por favor espera...');
            },
            success: function(response){
                _this.obtenerIndicadoresDriver(idDriver);
                clase = $('#mensajeIndicador').attr('class');
                if (response.status){
                    $('#mensajeIndicador').removeClass(clase).addClass('alert alert-success').html(response.mensaje).delay(8000).fadeOut();
                    $('#indicador').val('');
                    $('#porcentaje').val('');
                    $('#objetivo').val('');
                    $('#driverForm').trigger('reset');
                }
                else{
                    $('#mensajeIndicador').removeClass(clase).addClass('alert alert-danger').html(response.mensaje).delay(8000).fadeOut();
                }
            },
            error: function(){
                mensaje = 'Lo siento, ocurrió un error al agregar el Indicador';
                abreAlerta(mensaje);
            }
        });
    };
    
    Driver.prototype.obtenerIndicador = function(idIndicador){
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'obtenerIndicador',
                idIndicador: idIndicador
            },
            success: function(response){
                if (response.status){
                    $('#idIndicadorEditar').val(response.indicador.Id_Indicador);
                    $('#indicadorEditar').val(response.indicador.Indicador);
                    $('#impactoEditar').val(response.indicador.Impacto);
                    $('#objetivoEditar').val(response.indicador.Objetivo);
                    $('#idDriverEditar').val(response.indicador.Id_Driver);
                    $('#modalEditarIndicador').modal('show');
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(){
                mensaje = 'Lo siento, ocurrió un error al obtener los datos del Indicador';
                abreAlerta(mensaje);
            },
            timeout: 15000
        });
    };
    
    Driver.prototype.editarIndicador = function(idIndicador, indicador, impacto, objetivo, idDriver){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'editarIndicador',
                idIndicador: idIndicador,
                indicador: indicador,
                impacto: impacto,
                objetivo: objetivo,
                idDriver: idDriver
            },
            success: function(response){
                if (response.status){
                    $('#indicador').val('');
                    $('#porcentaje').val('');
                    $('#objetivo').val('');
                }
                abreAlerta(response.mensaje);
                _this.obtenerIndicadoresDriver(idDriver);
            },
            error: function(){
                abreAlerta('Lo siento, ocurrió un error al guardar los datos.');
            }
        });
    };
    
    Driver.prototype.eliminarIndicador = function(idIndicador, idDriver){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxDriverController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'eliminarIndicador',
                idIndicador: idIndicador,
            },
            beforeSend: function(){
                $('#modalEliminaIndicador').modal('hide');
            },
            success: function(response){
                abreAlerta(response.mensaje);
                _this.obtenerIndicadoresDriver(idDriver);
            },
            error: function(){
                abreAlerta('Lo siento, ocurrió un error al eliminar el driver.');
            }
        });
    };
    
    return Driver;
})();

$(function(){
    d = new Driver();
    d.obtenerDrivers();
});

$(document).on('submit', '#driverForm', function(e){
    e.preventDefault();
    driver = $('#driver').val();
    impacto = $('#impactoDriver').val();
    clase = $('#mensajeDriver').attr('class');
    
    if (driver == '' || driver == 0){
        $('#mensajeDriver').removeClass(clase).addClass('alert alert-danger')
                .text('Debes seleccionar un Driver');
        $('#driver').focus();
        return false;
    }
    
    if (impacto == '' || impacto == 0){
        $('#mensajeDriver').removeClass(clase).addClass('alert alert-danger')
                .text('Debes especificar el impacto del driver');
        $('#impacto').focus();
        return false;
    }
    
    m = new Driver();
    m.guardarDriver(driver, impacto);
    
});

$(document).on('click', '.agregar', function(){
    idDriver = $(this).parent().parent().attr('data');
    window.location = url + 'usuarios/agregaIndicador/' + idDriver + '/';
});

$(document).on('click', '#btnAgregar', function(){
    indicador = $('#indicador').val();
    impacto = $('#porcentaje').val();
    objetivo = $('#objetivo').val();
    idDriver = $('#idDriver').val();
    
    if (indicador == ''){
        abreAlerta('Debes ingresar el Indicador');
        $('#indicador').focus();
        return false;       
    }
    
    if (impacto == '' || impacto == 0){
        abreAlerta('Debes ingresar el impacto del indicador.');
        return false;
    }
    
    if (objetivo == '' || objetivo == 0){
        abreAlerta('Debes ingresar el objetivo');
        $('#objetivo').focus();
        return false;
    }
    
    d = new Driver();
    d.agregarIndicador(idDriver, indicador, impacto, objetivo);
});

$(document).on('click', '.editar', function(){
    idDriver = $(this).parent().parent().attr('data');
    console.log(idDriver);
    d = new Driver();
    d.obtenerDriver(idDriver);
});

$(document).on('click', '#btnEditarDriver', function(){
    idDriver = $('#idDriverEdita').val();
    driver = $('#driverEditar').val();
    impacto = $('#impactoEditar').val();
    
    d = new Driver();
    d.editarDriver(idDriver, driver, impacto);
});

$(document).on('click', '.editarIndicador', function(){
    idIndicador = $(this).parent().parent().attr('data');
    
    d = new Driver();
    d.obtenerIndicador(idIndicador);
});

$(document).on('click', '#btnEditarIndicador', function(){
    $('#modalEditarIndicador').modal('hide');
    idIndicador = $('#idIndicadorEditar').val();
    indicador = $('#indicadorEditar').val();
    impacto = $('#impactoEditar').val();
    objetivo = $('#objetivoEditar').val();
    idDriver = $('#idDriverEditar').val();
    d = new Driver();
    d.editarIndicador(idIndicador, indicador, impacto, objetivo, idDriver);
});

$(document).on('click', '.eliminarIndicador', function(){
    idIndicador = $(this).parent().parent().attr('data');
    idDriver = $('#idDriver').val();
    $('#idIndicadorEliminar').val(idIndicador);
    $('#modalEliminaIndicador').modal('show');    
});

$(document).on('click', '#btnEliminaIndicador', function(){
    idIndicador = $('#idIndicadorEliminar').val();
    idDriver = $('#idDriver').val();
    d = new Driver();
    d.eliminarIndicador(idIndicador, idDriver);
});