/**
 * Evaluacion.js
 * Clase y funciones para evaluación de personal
 * @copyright (c) 2016 Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

totalCompetencia = 0;

var Evaluacion = (function(){
    function Evaluacion()
    {
        
    };
    
    
    Evaluacion.prototype.guardarCompetenciaMando = function(){
        formulario = new FormData($('#competenciaMandoForm')[0]);
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: formulario,
            processData: false,
            contentType: false,
            beforeSend: function(){
                $('#guardarCompetenciaMando').button('loading');
            },
            success: function(response){
                $('#guardarCompetenciaMando').button('reset');
                abreAlerta(response.mensaje);
                if (response.status){
                    $('#guardarCompetenciaMando').prop('disabled', true);
                    $('#btnSiguiente').prop('disabled', false);
                }
            },
            error: function(){
                $('#guardarCompetenciaMando').button('reset');
                $('#guardarCompetenciaMando').button('reset');
                abreAlerta('Lo siento, ocurrió un error al guardar los datos.');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.guardarObjetivos = function(){
        formulario = new FormData($('#objetivosMandoForm')[0]);
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: formulario,
            processData: false,
            contentType: false,
            beforeSend: function(){
                $('#btnObjetivos').button('loading');
            },
            success: function(response){
                $('#btnObjetivos').button('reset');
                abreAlerta(response.mensaje);
                if (response.status){
                    $('#btnObjetivos').prop('disabled', false);
                    $('#siguiente').prop('disabled', false);
                }
            },
            error: function(){
                $('#btnObjetivos').button('reset');
                abreAlerta('Lo siento, ocurrió un error al guardar los datos.');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.agregarCompromisoObjetivo = function(idFila, idIndicador, indicador, expectativa, actividad, fecha, idPeriodo){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'agregarCompromisoObjetivo',
                idCompromiso: idFila,
                idIndicador: idIndicador,
                expectativa: expectativa,
                actividad: actividad,
                fecha: fecha,
                idPeriodo: idPeriodo
            },
            beforeSend: function(){
                
            },
            success: function(response){
                if (response.status){
                    var html = '';
                    html += '<tr id="objetivos_' + idFila + '">';
                    html += '<td><input type="hidden" id="indicador_' + idFila + '" name="idIndicador[]" value="' + idIndicador + '">\n\
                            <input type="text" id="nombreIndicador_' + idFila + '" name="indicador[]" class="form-control" value="' + indicador + '" readonly="true"></td>';
                    html += '<td><textarea name="mejora[]" class="form-control">' + expectativa + '</textarea></td>';
                    html += '<td><textarea name="actividades[]" class="form-control">' + actividad + '</textarea></td>';
                    html += '<td><input type="text" name="fecha[]" class="form-control calendario" value="' + fecha + '"></td>';
                    html += '<td><a href="javascript:void(0);" title="Agregar" class="agregarActividadCompromiso ayuda"><span class="fa fa-plus"></span></a></td>';
                    html += '</tr>';
                    id = '#objetivos_' + idFila;
                    $(html).insertAfter(id);
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(){
                abreAlerta('Lo siento, ocurrió un error al agregar la actividad');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.actualizaActividad = function(idFila, actividad, fecha){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'actualizaActividad',
                id: idFila,
                actividad: actividad,
                fecha: fecha
            },
            success: function(response){
                abreAlerta(response.mensaje);
            },
            error: function(){
                abreAlerta('Lo siento, ocurrió un error al actualizar la información');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.actualizarCompromiso = function(idFila, actividad, fecha){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'actualizarCompetencia',
                id: idFila,
                actividad: actividad,
                fecha: fecha
            },
            success: function(response){
                abreAlerta(response.mensaje);
            },
            error: function(){
                abreAlerta('Ocurrió un error al actualizar tu actividad');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.agregarCompetencia = function(competencia, accion, actividad, fecha, idPeriodo, idFila){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'agregarCompentencia',
                competencia: competencia,
                accion1: accion,
                actividad: actividad,
                fecha: fecha,
                idPeriodo: idPeriodo
            },
            beforeSend: function(){
                $('#modalCompetencias').modal('hide');
            },
            success: function(response){
                if (response.status){
                    var html = '';
                    html += '<tr id="competencias_' + idFila + '">';
                    html += '<td><input type="text" name="competencias[]" id="competencia_' + idFila +'" class="form-control" value="' + competencia + '" readonly="true"></td>';
                    html += '<td><textarea name="accionesDesarrollo[]" class="form-control" readonly="true">' + accion + '</textarea></td>';
                    html += '<td><textarea name="actividadesDesarrollo[]" id="competenciaActividad_' + idFila + '" class="form-control competencia">' + actividad +'</textarea></td>';
                    html += '<td><input type="text" name="fechaDesarrollo[]" id="fechaCompromiso_' + idFila + '" class="form-control" value="' + fecha + '"></td>';
                    html + '<td><a href="javascript:void(0);" class="agregarActividadCompetencia ayuda" title="Agregar"><span class="fa fa-plus"></span></a></td>';
                    id = '#competencias_' + idFila;
                    $(html).insertAfter(id);
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(){
                abreAlerta('Lo siento, ocurrió un error al agregar la actividad');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.actualizaComentario = function(idPeriodo, comentario){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'actualizarComentario',
                idPeriodo: idPeriodo,
                comentario: comentario
            },
            success: function(response){
                abreAlerta(response.mensaje);
            },
            error: function(){
                abreAlerta('Ocurrió un error al actualizar tus datos');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.actualizaLogros = function(idPeriodo, logros){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'actualizarLogros',
                idPeriodo: idPeriodo,
                logros: logros
            },
            success: function(response){
                abreAlerta(response.mensaje);
            },
            error: function(){
                abreAlerta('Ocurrió un error al actualizar tus datos');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.eliminarObjetivo = function(idObjetivo, idUsuario){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'eliminarObjetivo',
                idObjetivo: idObjetivo,
                idUsuario: idUsuario
            },
            success: function(response){
                if (response.status)
                {
                    location.reload();
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(){
                abreAlerta('Ocurrió un error al rechazar la actividad');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.finalizarProceso = function(idUsuario, idPeriodo){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'finalizarProceso',
                idUsuario: idUsuario,
                idPeriodo: idPeriodo
            },
            success: function(response){
                if (response.status){
                    abreAlerta('Proceso Finalizado correctamente');
                    window.location = url + 'usuarios/evaluacion/';
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(){
                abreAlerta('Ocurrió un error al finalizar el proceso.');
            },
            timeout: 15000
        });
    };
    
    Evaluacion.prototype.eliminaCompetencia = function(idCompetencia){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxEvaluacionController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'eliminaCompetencia',
                idCompetencia: idCompetencia
            },
            success: function(response){
                if (response.status){
                    location.reload();
                }
                else{
                    abreAlerta(response.mensaje);
                }
            },
            error: function(){
                abreAlerta('Ocurrió un error al borrar la actividad.');
            },
            timeout: 15000
        });
    };
    
    return Evaluacion;
})();


$(function(){
    
});

$(document).on('click', '.pregunta', function(){
    valor = parseInt($(this).val());   
    totalCompetencia += valor;
    pregunta = $(this).attr('name');
    $('input[name="' + pregunta + '"]').prop('readonly', true);
    $('#totalPuntos').val(totalCompetencia);    
    entre = $('#entre').val();    
    totalEvaluacion = ((totalCompetencia * 0.1) / entre) * 100;
    $('#totalEvaluacion').val(totalEvaluacion);
});

$(document).on('submit', '#competenciaMandoForm', function(e){
    e.preventDefault();
    ev = new Evaluacion();
    ev.guardarCompetenciaMando();
});

$(document).on('submit', '#objetivosMandoForm', function(e){
    e.preventDefault();
    ev = new Evaluacion();
    ev.guardarObjetivos();
});

$(document).on('blur', '.resultado', function(){   
    valor = $(this).attr('data');
    resultado = parseInt($(this).val());
    objetivo = $('#objetivo_' + valor).val();
    cumplimiento = ((resultado * 100) / objetivo);
    cumplimiento = Math.round(cumplimiento);
    if (cumplimiento > 100){
        cumplimiento = 100;
    }
    ponderacion = $('#ponderacion_' + valor).val();
    $('#cumplimiento_' + valor).val(cumplimiento);
    puntos = (ponderacion * cumplimiento) / 100;
    $('#puntos_' + valor).val(puntos);
    calcularTotalPuntos();
});

function calcularTotalPuntos()
{
    totalPuntos = 0;
    t = $('#totalRegistros').val();
    for (i = 1; i <= t; i++){
        totalPuntos += parseFloat($('#puntos_' + i).val());
    }
    
    $('#totalPuntos').val(totalPuntos);
    calcularTotalObjetivos();
}

function calcularTotalObjetivos()
{
    totalPuntos = $('#totalPuntos').val();
    porcentaje = $('#x').val();
    porcentaje = parseInt(porcentaje.substr(0,2));
    porcentaje = Math.round(porcentaje, 2);
    total = (totalPuntos * porcentaje) / 100;
    total = Math.round(total, 2);
    $('#totalPorcentaje').val(total);
}

$(document).on('click', '.agregarActividadCompromiso', function(){
    id = $(this).parent().parent().attr('id');
    idFila = id.substring(10);
    idFila = parseInt(idFila);
    idIndicador = $('#indicador_' + idFila).val();
    indicador = $('#nombreIndicador_' + idFila).val();
    $('#aspectoMejoraAgregar').val(indicador);
    $('#idIndicadorAgregar').val(idIndicador);
    $('#idFilaInsertar').val(idFila);
    $('#expectativaMejoraAgregar').val('');
    $('#actividadMejoraAgregar').val('');
    $('#fechaActividadAgregar').val('');
    $('#modalActividad').modal('show');
});

$(document).on('click', '#btnGuardarActividad', function(){
    $('#modalActividad').modal('hide');
    idFila = $('#idFilaInsertar').val();
    idIndicador = $('#idIndicadorAgregar').val();
    indicador = $('#nombreIndicador_' + idFila).val();
    expectativa = $('#expectativaMejoraAgregar').val();
    actividad = $('#actividadMejoraAgregar').val();
    fecha = $('#fechaActividadAgregar').val();
    idPeriodo = $('#periodo').val();
    
    //guardamos la información
    e = new Evaluacion();
    e.agregarCompromisoObjetivo(idFila, idIndicador, indicador, expectativa, actividad, fecha, idPeriodo);    
});

$(document).on('submit', '#compromisosMejoraForm', function(e){
    e.preventDefault();
    ev = new Evaluacion();
    ev.guardarCompromisos();
});

$(document).on('blur', '.actividadObjetivos', function(){
    id = $(this).parent().parent().attr('id');
    idFila = id.substring(10);
    idFila = parseInt(idFila);
    actividad = $(this).val();
    fecha = $('#fechaObjetivos_' + idFila).val();
    e = new Evaluacion();
    e.actualizaActividad(idFila, actividad, fecha);
});

$(document).on('click', '.agregarActividadCompetencia', function(){
    id = $(this).parent().parent().attr('id');
    idFila = id.substring(13);
    competencia = $('#competencia_' + idFila).val();
    $('#competenciaDesarrollo').val(competencia);
    $('#idFilaCompetencia').val(idFila);
    $('#modalCompetencias').modal('show');
});

$(document).on('blur', '.competencia', function(){
    id = $(this).parent().parent().attr('id');
    idFila = id.substring(13);
    actividad = $('#competenciaActividad_' + idFila).val();
    fecha = $('#fechaCompromiso_' + idFila).val();
    e = new Evaluacion();
    e.actualizarCompromiso(idFila, actividad, fecha);
});

$(document).on('blur', '.fechaCompromiso', function(){
    id = $(this).parent().parent().attr('id');
    idFila = id.substring(13);
    actividad = $('#competenciaActividad_' + idFila).val();
    fecha = $('#fechaCompromiso_' + idFila).val();
    e = new Evaluacion();
    e.actualizarCompromiso(idFila, actividad, fecha);
});

$(document).on('change', '.fechaObjetivos', function(){
    id = $(this).parent().parent().attr('id');
    idFila = id.substring(10);
    idFila = parseInt(idFila);
    actividad = $('#actividadObjetivos_' + idFila).val();
    fecha = $(this).val();
    e = new Evaluacion();
    e.actualizaActividad(idFila, actividad, fecha);
});

$(document).on('click', '#btnGuardarCompetencia', function(){
    competencia = $('#competenciaDesarrollo').val();
    expectativa =$('#expectativaCompetenciaMejoraAgregar').val();
    actividad = $('#actividaCompetenciadMejoraAgregar').val();
    idFila = $('#idFilaCompetencia').val();
    fecha = $('#fechaActividadCompentenciaAgregar').val();
    idPeriodo = $('#periodo').val();
    
    e = new Evaluacion();
    e.agregarCompetencia(competencia, expectativa, actividad, fecha, idPeriodo, idFila);
});

$(document).on('blur', '#logros', function(){
    idPeriodo = $('#periodo').val();
    logros = $(this).val();
    
    e = new Evaluacion();
    e.actualizaLogros(idPeriodo, logros);
});

$(document).on('blur', '#comentarios', function(){
    idPeriodo = $('#periodo').val();
    comentarios = $(this).val();
    
    e = new Evaluacion();
    e.actualizaComentario(idPeriodo, comentarios);
});

$(document).on('click', '.rechazar', function(){
    idCompleto = $(this).parent().parent().attr('id');
    id = idCompleto.substring(10);
    $('#idActividadElimina').val(id);
    $('#eliminarActividad').modal('show');
});

$(document).on('click', '#btnEliminaActividad', function(){
    $('#eliminarActividad').modal('hide');
    id = $('#idActividadElimina').val();
    idUsuario = $('#idUsuario').val();
    
    m = new Evaluacion();
    m.eliminarObjetivo(id, idUsuario);
});

$(document).on('click', '#finalizarProceso', function(){
    ev = new Evaluacion();
    idUsuario = $('#idUsuario').val();
    idPeriodo = $('#periodo').val();
    ev.finalizarProceso(idUsuario, idPeriodo);
});

$(document).on('click', '.rechazarCompetencia', function(){
    idC = $(this).parent().parent().attr('id');
    id = idC.substring(13);
    
    $('#idCompetenciaElimina').val(id);
    $('#eliminaCompetencia').modal('show');
});

$(document).on('click', '#btnEliminaCompetencia', function(){
    $('#eliminaCompetencia').modal('hide');
    id = $('#idCompetenciaElimina').val();
    
    ev = new Evaluacion();
    ev.eliminaCompetencia(id);
});