/**
 * HistorialVacaciones.js
 * Clase y funciones para el módulo de historial de vacaciones
 * @copyright (c) 2015 Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package historialVacaciones
 */

$(document).on('click','#generarHistorial',function () {
    if(validarParametrosHistorial($('#usuario'), $('#fechaInicial'), $('#fechaFinal'))){
        usuario = $('#usuario').val();
        fechaInicio = $('#fechaInicial').val();
        fechaFin = $('#fechaFinal').val();
        consultarHistorialDeVacaciones(usuario, fechaInicio, fechaFin);
    }
});

function consultarHistorialDeVacaciones(idUsuario, fechaInicio, fechaFinal) {
    $.ajax({
        url: url + 'application/usuarios/controllers/AjaxController.php',
        type: 'get',
        dataType: 'json',
        data: {
            accion: 'obtenerHistorialDeVacaciones',
            idUsuario: idUsuario,
            fechaInicio: fechaInicio,
            fechaFinal: fechaFinal
        },
        success: function (response) {
            // console.log(response);
            renderHistorialDeVacaciones(response);
        },
        error: function (response) {
            console.log(response);
            abreAlerta(response);
        },
        timeout: 15000
    });
}

function renderHistorialDeVacaciones(response) {
    var html = '';
    if (response.historial.length > 0) {
        $.each(response.historial, function (registro, item) {
            html += '<tr>';
            html += '<td>' + item.nombre_usuario + '</td>';
            html += '<td>' + item.Fecha_Inicio + ' a las '+ item.Hora_Inicial+ '</td>';
            html += '<td>' + item.Fecha_Fin + ' a las '+ item.Hora_Final+'</td>';
            html += '<td>' + item.Dias_Solicitados + '</td>';
            html += '<td>' + item.Motivo + '</td>';
            html += '</tr>';
        });

        // var ul = $('<ul class="pagination" />');
        // pagina = parseInt(response.pagina);
        // paginas = parseInt(response.paginas);
        // if (pagina > 1) {
        //     $('<li />').html('<a class="paginaAltaSeguridad" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
        // } else {
        //     $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
        // }
        // inferior = response.inferior;
        // superior = response.superior;
        // paginas = parseInt(response.paginas);
        // if (paginas < superior) {
        //     limite = paginas;
        // } else {
        //     limite = superior;
        // }
        // for (i = inferior; i <= limite; i++) {
        //     if (pagina == i) {
        //         $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
        //     } else {
        //         $('<li />').html('<a class="paginaAltaSeguridad" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
        //     }
        // }
        // if (pagina < paginas) {
        //     $('<li />').html('<a class="paginaAltaSeguridad" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
        // } else {
        //     $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
        // }
        // $('#paginacion').html(ul);
    } else {
        html += '<tr>';
        html += '<td colspan="5">No se encontraron resultados</td>';
        html += '</tr>';
    }

    $('#historialVacaciones tbody').html(html);
}

function validarParametrosHistorial(jqueryUsuario, jqueryFechaInicial, jqueryFechaFinal) {
    if(validarNoEmptyString(jqueryUsuario) &&
        validarNoEmptyString(jqueryFechaInicial) &&
        validarNoEmptyString(jqueryFechaFinal) &&
        validarRangoFechas(jqueryFechaInicial, jqueryFechaFinal)){
        return true;
    } else {
        return false
    }
}

function validarRangoFechas(jqueryElemFechaInicio, jqueryElemFechaFin){
    fechaInicio = jqueryElemFechaInicio.val();
    fechaInicio = new Date(fechaInicio);
    fechaInicio.setHours(0,0,1,0);
    fechaFin = jqueryElemFechaFin.val();
    fechaFin = new Date(fechaFin);
    fechaFin.setHours(0,0, 2,0);
    if (fechaFin > fechaInicio){
        removeBlockError(jqueryElemFechaFin);
        return true;
    } else{
        addBlockError(jqueryElemFechaFin, 'La fecha final debe ser mayor o igual a la fecha inicial');
        return false;
    }
}

function validarNoEmptyString(jqueryElem) {
    valor= jqueryElem.val();
    if (valor != ""){
        removeBlockError(jqueryElem);
        return true;
    } else{
        addBlockError(jqueryElem, 'El campo no puede estar vacío');
        return false;
    }
}

function addBlockError(jqueryElem, msg){
    divp = jqueryElem.parents('.form-group');
    divp.addClass('has-error');
    divp.find('span.error').remove();
    divp.append('<span class="help-block error">'+msg+'</span>');
}

function removeBlockError(jqueryElem){
    divp = jqueryElem.parents('.form-group');
    divp.removeClass('has-error');
    divp.find('span.error').remove();
}




