/**
 * Usuarios.js
 * Clase y funciones para el módulo de usuarios
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

var Usuario = (function(){
    function Usuario(){
        
    };
    
    Usuario.prototype.login = function(usuario, contrasena){
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'login',
                usuario: usuario,
                contrasena: contrasena
            },
            beforeSend: function(){
                var clase = $('#msjLogin').attr('class');
                $('#msjLogin').removeClass(clase).addClass('alert alert-info')
                        .text('Procesando por favor espera...');
            },
            success: function(response){
                var clase = $('#msjLogin').attr('class');
                if (response.status){
                    $('#msjLogin').removeClass(clase).addClass('alert alert-success')
                            .text(response.mensaje);
                    if (response.user == 16 || response.user == 17 || response.user == 9 || response.user == 44){
                        window.location = url + 'inicio/sucursales/';
                    }else if (response.user == 122){
                        window.location = url + 'ayuda/todos/';
                    }
                    else{
                        window.location = url;
                    }
                }
                else{
                    $('.modal-dialog').effect('shake', 'slow');
                    $('#msjLogin').removeClass(clase).addClass('alert alert-danger')
                            .html(response.mensaje);
                }
            },
            error: function(){
                var clase = $('#msjLogin').attr('class');
                $('#msjLogin').removeClass(clase).addClass('alert alert-danger')
                        .html('Lo siento ocurrió un error al iniciar sesión. Contacta al \n\
                        administrador del sistema o levanta un <a class="alert-link" href="'+ url +'tickets/">ticket</a>.');
            },
            timeout: 15000
        });
    };
    
    Usuario.prototype.validarPassword = function(password, passwordNueva){
        _this = this;
        var retorno;
        retorno = $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'validarPassword',
                password: password
            },
            success: function(response){
                if (response.status){
                    _this.cambiarPassword(password, passwordNueva);
                }
                else{
                    $('#msjPassword').removeClass().addClass('alert alert-danger').text(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                $('#msjPassword').removeClass().addClass('alert alert-danger').html(error);
            },
            timeout: 15000
        });
    };
    
    Usuario.prototype.cambiarPassword = function(password, passwordNueva){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            cache: false,
            data: {
                accion: 'cambiarPassword',
                password: password,
                passwordNueva: passwordNueva
            },
            beforeSend: function(){
                $('#msjPassword').removeClass().addClass('alert alert-info').text('Cambiando datos...');
            },
            success: function(response){
                if (response.status){
                    console.log('entra');
                    $('#msjPassword').removeClass().addClass('alert alert-success').text(response.mensaje);
                    $('#contrasenaForm').trigger('reset');
                }
                else{
                    $('#msjPassword').removeClass().addClass('alert alert-danger').text(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                $('#msjPassword').removeClass().addClass('alert alert-danger').html(error);
            }
        });
    };
    
    Usuario.prototype.emailPassword = function(email){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'emailPassword',
                email: email
            },
            beforeSend: function(){
                $('#msjPassword').removeClass().addClass('alert alert-info').text('Validando datos....');
            },
            success: function(response){
                if (response.status){
                    _this.passwordChange(response.idUsuario, email);
                }else{
                    $('#msjPassword').removeClass().addClass('alert alert-danger').html(response.mensaje);
                }
            },
            error: function(xhr, responseText, throwError){
                error = mostrarMensajeError(xhr, responseText, throwError);
                $('#msjPassword').removeClass().addClass('alert alert-danger').html(error);
            },
            timeout: 15000
        });
    };
    
    Usuario.prototype.passwordChange = function(idUsuario, email){
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'generarContrasena',
                idUsuario: idUsuario,
                email: email
            },
            beforeSend: function(){
                $('#msjPassword').removeClass().addClass('alert alert-info').text('Generando Contraseña...');
            },
            success: function(response){
                if (response.status){
                    $('#msjPassword').removeClass().addClass('alert alert-success').html(response.mensaje);
                    $('#resetPassword').trigger('reset');
                }
                else{
                    $('#msjPassword').removeClass().addClass('alert alert-danger').html(response.mensaje);
                }
            },
            error: function(xhr, responseText, thrownError){
                error = mostrarMensajeError(xhr, responseText, thrownError);
                $('#msjPassword').removeClass().addClass('alert alert-danger').html(error);
            },
            timeout: 40000
        });
    };

    Usuario.prototype.asistencia = function(codigoBarras) {
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'asistencia',
                codigoBarras: codigoBarras,                
            },
            beforeSend: function(){
                var clase = $('#msjAsistencia').attr('class');
                $('#msjAsistencia').removeClass(clase).addClass('alert alert-info')
                        .text('Procesando por favor espera...');
            },
            success: function(response){
                var clase = $('#msjAsistencia').attr('class');
                if (response.status){
                    $('#msjAsistencia').removeClass(clase).addClass('alert alert-success')
                            .text(response.mensaje);
                    $('#codigoBarras').val('');
                }
                else{
                    $('.modal-dialog').effect('shake', 'slow');
                    $('#msjAsistencia').removeClass(clase).addClass('alert alert-danger')
                            .html(response.mensaje);
                }
            },
            error: function(){
                var clase = $('#msjAsistencia').attr('class');
                $('#msjAsistencia').removeClass(clase).addClass('alert alert-danger')
                        .html('Lo siento ocurrió un error al checar tu asistencia. Contacta al \n\
                        administrador del sistema o levanta un <a class="alert-link" href="'+ url +'tickets/">ticket</a>.');
            },
            timeout: 15000
        });
    };

    Usuario.prototype.salida = function(codigoBarras) {
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'salida',
                codigoBarras: codigoBarras,                
            },
            beforeSend: function(){
                var clase = $('#msjAsistencia').attr('class');
                $('#msjAsistencia').removeClass(clase).addClass('alert alert-info')
                        .text('Procesando por favor espera...');
            },
            success: function(response){
                var clase = $('#msjAsistencia').attr('class');
                if (response.status){
                    $('#msjAsistencia').removeClass(clase).addClass('alert alert-success')
                            .text(response.mensaje);
                    $('#codigoBarras').val('');
                }
                else{
                    $('.modal-dialog').effect('shake', 'slow');
                    $('#msjAsistencia').removeClass(clase).addClass('alert alert-danger')
                            .html(response.mensaje);
                }
            },
            error: function(){
                var clase = $('#msjAsistencia').attr('class');
                $('#msjAsistencia').removeClass(clase).addClass('alert alert-danger')
                        .html('Lo siento ocurrió un error al checar tu asistencia. Contacta al \n\
                        administrador del sistema o levanta un <a class="alert-link" href="'+ url +'tickets/">ticket</a>.');
            },
            timeout: 15000
        });
    };
    
    return Usuario;
})();

$('#loginForm').on('submit',function(e){
    e.preventDefault();
    var usuario = $('#usuario').val();
    var contrasena = $('#contrasena').val();
    var clase = $('#msjLogin').attr('class');
    
    //validamos los datos
    if (usuario == '' || usuario == undefined){
        $('#msjLogin').removeClass(clase).addClass('alert alert-danger')
                .text('Debes igresar tu usuario');
        $('#usuario').val('');
        $('#usuario').focus();
        return false;
    }
    
    if (contrasena == '' || contrasena == undefined){
        $('#msjLogin').removeClass(clase).addClass('alert alert-danger')
                .text('Debes igresar tu contraseña');
        $('#contrasena').val('');
        $('#contrasena').focus();
        return false;
    }
    
    
    contrasena = md5(contrasena);
    
    var u = new Usuario();
    u.login(usuario, contrasena);
});

$(document).on('submit', '#contrasenaForm', function(e){
    e.preventDefault();
    passwordActual = $('#passwordActual').val();
    passwordNueva = $('#nuevoPassword').val();
    confirmar = $('#confirmar').val();    
    
    if (passwordActual == ''){
        $('#msjPassword').removeClass().addClass('alert alert-danger').text('Por favor ingresa tu contraseña actual');
        return false;
    }
    
    if (passwordNueva == ''){
        $('#msjPassword').removeClass().addClass('alert alert-danger').text('Por favor ingresa tu nueva contraseña');
        return false;
    }
    
    if (confirmar == ''){
        $('#msjPassword').removeClass().addClass('alert alert-danger').text('Por favor confirma tu contraseña');
        return false;
    }
    
    if (passwordNueva != confirmar){
        $('#msjPassword').removeClass().addClass('alert alert-danger').text('Las contraseñas no coinciden');
        return false;
    }
    
    passwordActual = md5(passwordActual);
    passwordNueva = md5(passwordNueva);
    
    u = new Usuario();
    u.validarPassword(passwordActual, passwordNueva);
});

$(document).on('submit', '#resetPassword', function(e){
    e.preventDefault();
    email = $('#email').val();
    
    if (email == ''){
        $('#msjPassword').removeClass().addClass('alert alert-danger').text('Por favor ingresa tu Email');
        return false;
    }
    
    valido = validarEmail(email);
    if (!valido){
        $('#msjPassword').removeClass().addClass('alert alert-danger').text('Por favor ingresa un Email válido');
        return false;
    }
    
    hayConexion = pruebaConexion();
    if (hayConexion){
        u = new Usuario();
        u.emailPassword(email);
    }
    else{
        $('#msjPassword').removeClass().addClass('alert alert-danger').html(msjConexion);
        return false;
    }
    
});

$('#asistenciaForm').on('submit', function(e){
     e.preventDefault();
    console.log('entra');    

    codigoBarras = $('#codigoBarras').val();

    if (codigoBarras == ''){
        $('#msjAsistencia').removeClass().addClass('alert alert-danger').text('Por favor scanea tu código de barras.');
        return false;
    }

    u = new Usuario();
    u.asistencia(codigoBarras);
});

$('#salidaForm').on('submit', function(e){
     e.preventDefault();
    console.log('entra');    

    codigoBarras = $('#codigoBarras').val();

    if (codigoBarras == ''){
        $('#msjAsistencia').removeClass().addClass('alert alert-danger').text('Por favor scanea tu código de barras.');
        return false;
    }

    u = new Usuario();
    u.salida(codigoBarras);
});