/**
 * UsuariosCRUD.js
 * Clase y funciones para el módulo de usuarios
 * @copyright (c) 2015 Merdiz
 * @author Ivan Santos Pérez
 * @version 1.0 Beta
 * @package usuarios
 */

//clase Usuarios
var Usuarios = (function () {
    function Usuarios() {

    };

    Usuarios.prototype.cargaUsuarios = function (pagina, registros, inferior, superior) {
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'cargarUsuariosSucursal',
                pagina: pagina,
                registros: registros,
                inferior: inferior,
                superior: superior
            },
            beforeSend: function () {
                $('.refresh-container-table').show();
            },
            success: function (response) {
                $('.refresh-container-table').hide();
                if (response.status) {
                    _this.renderUsuarios(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function () {
                $('.refresh-container-table').hide();
                mensaje = 'Lo siento ocurrió un error inesperado al cargar la lista de usuarios. ' + msjTicket;
                abreAlerta(mensaje);
            },
            timeout: 15000
        });
    };

    Usuarios.prototype.getCuentasContables = function () {
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'getCuentasContables'
            },
            beforeSend: function () {
                $('.refresh-container').show();
            },
            success: function (response) {
                $('.refresh-container').hide();
                if (response.status) {
                    cuentas = response.cuentas;
                    $.each(cuentas, function (index, item) {
                        $('[id*="cta-"]').append('<option value="' + item.Id_Cuenta + '">' + item.Nombre + ' [' + item.Clave + ']</option>')
                    });
                    $('[id="cta-*"]').selectpicker('refresh');
                    $('[id="cta-*"]').selectpicker('render');
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function () {
                abreAlerta('Lo siento, ocurrió un error al obtener las cuentas contables. ' + msjTicket);
            }
        });
    };

    Usuarios.prototype.getUsuario = function (idUsuario) {
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'regresaUsuarioController',
                id_usuario: idUsuario
            },
            beforeSend: function () {
                $('.refresh-container').show();
            },
            success: function (response) {
                $('.refresh-container').hide();
                if (response.status) {
                    limpiarExpediente();
                    // USUARIO
                    user = response.usuario;
                    $('#user-id_usuario').val(user.Id_Usuario);
                    $('#id_usuario').val(user.Id_Usuario);
                    $('#id_user').val(user.Id_Usuario);

                    renderStatusUsuario(user.Status);
                    // if (user.Status == 1){
                    //     $('#activo').attr('checked', 'checked').parent().addClass('active');
                    //     $('#inactivo').parent().removeClass('active');
                    // }
                    // else{
                    //     $('#inactivo').attr('checked', 'checked').parent().addClass('active');
                    //     $('#activo').parent().removeClass('active');
                    // }

                    if (user.Status == -1) {
                        showFormularioBaja();
                        $('#user-fecha_baja').val(user.fecha_baja);
                        $('#user-razon_baja').val(user.razon_baja);
                    } else {
                        hideFormularioBaja();
                        clearFormularioBaja();
                    }

                    // if(user.Status == -1){
                    //     $('#user-fecha_baja').val(user.fecha_baja);
                    //     document.getElementById("fecha_baja").style.display = "block";
                    //     document.getElementById("razon_baja").style.display = "block";
                    //     $("input[name=status][value=" + user.Status + "]").attr('checked', 'checked');
                    // } else {
                    //     document.getElementById("fecha_baja").style.display = "none";
                    //     document.getElementById("razon_baja").style.display = "none";
                    // }

                    // $("input[name=perfil][value=" + user.Tipo + "]").attr('checked', 'checked');
                    if (user.Tipo == 1 || user.Tipo == '1') {
                        $('#director').prop('checked', true).parent().addClass('active');
                    } else if (user.Tipo == 2 || user.Tipo == '2') {
                        $('#gerente').prop('checked', true).parent().addClass('active');
                    } else if (user.Tipo == 3 || user.Tipo == '3') {
                        $('#administrador').prop('checked', true).parent().addClass('active');
                    } else if (user.Tipo == 4 || user.Tipo == '4') {
                        $('#vendedor').prop('checked', true).parent().addClass('active');
                    } else if (user.Tipo == 5 || user.Tipo == '5') {
                        $('#repartidor').prop('checked', true).parent().addClass('active');
                    }


                    $('#user-nombre').val(user.Nombre);
                    $('#user-paterno').val(user.Apellido_Paterno);
                    $('#user-materno').val(user.Apellido_Materno);
                    $('#user-usuario').val(user.Usuario);
                    $('#user-contrasena').attr('placeholder', 'Dejar en blanco para no modificar');
                    $('#user-fecha_ingreso').val(user.Fecha_Ingreso);
                    $('#user-numero').val(user.No_Empleado);
                    $('#user-clabe').val(user.Clabe);
                    $('#user-email').val(user.Mail);
                    $('#user-rfc').val(user.RFC);
                    $('#user-nss').val(user.NSS);
                    $('#user-curp').val(user.CURP);
                    $('#user-banco_pago_nomina').val(user.Id_Banco_Pago_Nomina);
                    $('#user-periodicidad_pago').val(user.Periodicidad_Pago);
                    $('#user-tipo_contratacion').val(user.Tipo_Contratacion);
                    $('#user-tipo_jornada').val(user.Tipo_Jornada);
                    $('#user-departamento').val(user.Departamento);
                    $('#user-riesgo_puesto').val(user.Id_Riesgo_Puesto);
                    $('#user-regimen_contratacion').val(user.Id_Regimen_Contratacion);
                    $('#user-licencia').val(user.Licencia);
                    $('#user-vigencialicencia').val(user.Vigencia_Licencia);

                    if(response.tRegimen > 0) {
                        for (i = 0; i < response.tRegimen; i++) {
                            $('#regimen').append('<option value="' + response.regimenF[i].regimen_fiscal + '">' + response.regimenF[i].regimen_fiscal + '</option>');
                            $("#regimen").selectpicker("refresh");
                            $('#regimen').selectpicker('render');

                            if (response.regimenF[i].regimen_fiscal == user.regimen_fiscal) {
                                $('#regimen').selectpicker('val', response.regimenF[i].regimen_fiscal);
                            }
                        }
                    }else{
                        $('#regimen').append('<option value="' + user.regimen_fiscal + '">' + user.regimen_fiscal + '</option>');
                        $("#regimen").selectpicker("refresh");
                        $('#regimen').selectpicker('render');
                        $('#regimen').selectpicker('val', user.regimen_fiscal);
                    }

                    // DIRECCION
                    dir = response.direccion;
                    $('#dir-id_direccion').val(user.Id_Direccion);
                    $('#dir-calle').val(dir.Calle);
                    $('#dir-interior').val(dir.Numero_Interior);
                    $('#dir-exterior').val(dir.Numero_Exterior);
                    $('#dir-colonia').val(dir.Colonia);
                    $('#dir-ciudad').val(dir.Ciudad);
                    $('#dir-estado').val(dir.Estado);
                    $('#dir-codigo').val(dir.CP);
                    $('#dir-telefono').val(dir.Telefono);
                    $('#dir-celular').val(dir.Celular);

                    // NOMINA
                    nomi = response.nomina;
                    $('#nomi-id_nomina').val(nomi.Id_Nomina);
                    $('#nomi-sueldo').val(nomi.Sueldo);
                    $('#nomi-dias_aguinaldo').val(nomi.Dias_Aguinaldo);
                    $('#nomi-dias_vacaciones').val(nomi.Dias_Vacaciones);
                    $('#nomi-prima_vacacional').val(nomi.Prima_Vacacional);
                    $('#nomi-asistencia').val(nomi.Asistencia);
                    $('#nomi-puntualidad').val(nomi.Puntualidad);
                    $('#nomi-despensa').val(nomi.Despensa);
                    $('#nomi-prestamo_infonavit').val(nomi.Prestamo_Infonavit);
                    $('#nomi-pension_alimenticia').val(nomi.Pension_Alimenticia);
                    $('#nomi-servicio_fronterizo').val(nomi.servicio_region_fronteriza);
                    $('#nomi-forma_de_pago').val(nomi.forma_pago);
                    $('#nomi-estado').val(nomi.entidad_de_servicio);
                    renderPremiospuntualidad(nomi.Bandera_Puntualidad);
                    renderPremioAsistencia(nomi.Bandera_Asistencia)
                    renderPremioDespensa(nomi.Bandera_Despensa)

                    $('#nomi-tipo_nomina').val(nomi.tipo_nomina);
                    if (nomi.tipo_nomina == 'externa') {
                        $(".proveedores").css("display", "block");
                        $(".porcentajenominas").css("display", "none");
                        $(".premios").css("display", "none");
                        // $('#nomi-proveedor').val(nomi.proveedor);
                        $('#nomi-porcentaje_interna').val(0);
                        $('#nomi-porcentaje_externa').val(0);
                        // if(nomi.comisiones == '1'){
                        //     $("#nomi-comisiones").prop("checked", true);
                        // } else {
                        //     $("#nomi-comisiones").prop("checked", false);
                        // }
                        // if(nomi.imms_patronal == '1'){
                        //     $("#nomi-imms_patronal").prop("checked", true);
                        // } else {
                        //     $("#nomi-imms_patronal").prop("checked", false);
                        // }
                        $("#tablaVincularProveedores").css("display", "block");


                    } else if (nomi.tipo_nomina == 'mixta') {
                        $(".proveedores").css("display", "block");
                        $(".porcentajenominas").css("display", "block");
                        $(".premios").css("display", "block");
                        $('#nomi-porcentaje_interna').val(nomi.porcentaje_interna);
                        $('#nomi-porcentaje_externa').val(nomi.porcentaje_externa);
                        $("#tablaVincularProveedores").css("display", "block");
                    } else if (nomi.tipo_nomina == 'interna'){
                        $(".proveedores").css("display", "none");
                        $(".porcentajenominas").css("display", "none");
                        $('#nomi-porcentaje_interna').val(0);
                        $('#nomi-porcentaje_externa').val(0);
                        $(".premios").css("display", "block");
                        $("#tablaProveedores").css("display", "none");
                    }else {
                        $(".proveedores").css("display", "none");
                        $(".porcentajenominas").css("display", "none");
                        $(".premios").css("display", "none");
                        $('#nomi-porcentaje_interna').val(0);
                        $('#nomi-porcentaje_externa').val(0);
                        $("#tablaProveedores").css("display", "none");
                    }

                    $('#nomi-tipo_infonavit').val(nomi.tipo_prestamo_infonavit);
                    $('#nomi-isr').val(nomi.isr);
                    $('#nomi-sueldo_integrado').val(nomi.sueldo_integrado);

                    // CUENTAS
                    ctas = response.cuentas;
                    $('#nomi-cuenta_nomina').val(ctas.nomina);
                    $('#nomi-cuenta_despensa').val(ctas.despensa);
                    $('#nomi-cuenta_asistencia').val(ctas.asistencia);
                    $('#nomi-cuenta_puntualidad').val(ctas.puntualidad);
                    $('#nomi-cuenta_subsidio').val(ctas.subsidio);
                    $('#nomi-cuenta_gastos').val(ctas.gastos);
                    $('#nomi-cuenta_deudor').val(ctas.deudor);
                    $('#nomi-cuenta_gastos_comprobar').val(ctas.gastos_comprobar);
                    $('#cta-sueldos').val(ctas.nomina).selectpicker('refresh').selectpicker('render');
                    $('#cta-desp').val(ctas.despensa).selectpicker('refresh').selectpicker('render');
                    $('#cta-asist').val(ctas.asistencia).selectpicker('refresh').selectpicker('render');
                    $('#cta-punt').val(ctas.puntualidad).selectpicker('refresh').selectpicker('render');
                    $('#cta-subs').val(ctas.subsidio).selectpicker('refresh').selectpicker('render');
                    $('#cta-tarje').val(ctas.gastos).selectpicker('refresh').selectpicker('render');
                    $('#cta-deudor').val(ctas.deudor).selectpicker('refresh').selectpicker('render');
                    $('#cta-anti').val(ctas.gastos_comprobar).selectpicker('refresh').selectpicker('render');

                    // ARCHIVOS
                    $.each(response.files, function (key, val) {
                        if (val == '')
                            $('.doc-url-' + key).html('');
                        else
                            $('.doc-url-' + key).html('<small><span class="label label-success">Ya existe un documento en el expediente</span></small>');
                    });

                    $('#enviarRFC').val($('#user-rfc').val());

                    renderExpedienteCompleto(response.files);

                    renderProveedoresExternosDeNomina(response.nominaProveedoresExternos);

                    // renderExpedienteListadoDocumentos(response.files);

                    $('.tarea-mod').jstree('open_all');
                    $('.tarea-mod').jstree('uncheck_all');
                    _this.getPermisos(user.Id_Usuario);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function () {
                $('.refresh-container').hide();
                mensaje = 'Lo siento, ocurrió un error al obtener los datos del usuario. '.msjTicket;
                abreAlerta(mensaje);
            },
            timeout: 15000
        });
    };

    Usuarios.prototype.getPermisos = function (idUsuario) {
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'obtenPermisosUsuarioController',
                id_usuario: idUsuario
            },
            beforeSend: function () {
                $('.refresh-container').show();
            },
            success: function (response) {
                $('.refresh-container').hide();
                if (response.status) {
                    $.each(response.tareas, function (index, item) {
                        idt = 'tarea-' + item.Id_Tarea;
                        mod = $('[id="' + idt + '"]').parents('.tarea-mod');
                        $(mod).jstree('select_node', idt, true);
                    });

                    $.each(response.subtareas, function (index, item) {
                        idt = 'subtarea-' + item.Id_Subtarea;
                        mod = $('[id="' + idt + '"]').parents('.tarea-mod');
                        $(mod).jstree('select_node', idt, true);
                    });
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function () {
                $('.refresh-container').hide();
                mensaje = 'Lo siento, ocurrió un error al obtener los datos del usuario. '.msjTicket;
                abreAlerta(mensaje);
            },
            timeout: 15000
        });
    };

    Usuarios.prototype.sendFiles = function () {
        var formData = new FormData($('#frm-doc')[0]);
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            contentType: false,
            processData: false,
            data: formData,
            beforeSend: function () {
                $('#btnSendDoc').button('loading').prop('disabled', true);
                abreAlerta('Enviando archivos. Por favor espere..');
                $('#btnCerrarModalAlerta').addClass('hide');
            },
            success: function (resp) {
                $('#btnCerrarModalAlerta').removeClass('hide');
                if (resp.status) {
                    abreAlerta(resp.mensaje);
                    $('#tabs-user a[href="#datosTareas"]').tab('show');
                } else {
                    $('#btnSendDoc').button('reset').prop('disabled', false);
                    abreAlerta(resp.mensaje);
                }
            },
            error: function () {
                $('#btnSendDoc').button('reset').prop('disabled', false);
                abreAlerta('Lo siento, ocurrió un error al guardar tus datos. ' + msjTicket);
            }
        });
    };

    Usuarios.prototype.validarUsuario = function (usuario, id_usuario) {
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            data: {
                accion: 'validaUsuarioController',
                usuario: usuario,
                id_usuario: id_usuario
            },
            beforeSend: function () {

            },
            success: function (response) {
                $('span.error').remove();
                $('.has-error').removeClass('has-error');
                if (response.existe) {
                    setError($('#user-usuario'), 'Ya existe este nombre de usuario');
                }
            },
            error: function () {
                $('span.error').remove();
                $('.has-error').removeClass('has-error');
                mensaje = 'Lo siento no pude validar el usuario';
                setError($('#user-usuario'), mensaje);
            }
        });
    };

    Usuarios.prototype.guardar = function (tipo, status, perfil, data, premioAsistencia, premioPuntualidad, premioDespensa, numLicencia, vigenciaLicencia) {
        accion = '';
        if (tipo == 1) accion = 'altaUsuarioController';
        else if (tipo == 2) accion = 'actualizaUsuarioController';

        $('#guardar').button('loading').prop('disabled', true);
        $.post(url + 'application/usuarios/controllers/AjaxController.php',
            {
                accion: accion,
                status: status,
                perfil: perfil,
                usuario: JSON.stringify(data.user),
                direccion: JSON.stringify(data.dir),
                nomina: JSON.stringify(data.nomi),
                regimen: $('#regimen').val(),
                premioAsistencia: premioAsistencia,
                premioPuntualidad: premioPuntualidad,
                premioDespensa: premioDespensa,
                numLicencia: numLicencia,
                vigenciaLicencia: vigenciaLicencia
            },
            function (response) {
                $('#guardar').button('reset');
                if (response.status) {
                    desactivarFormulario();
                    abreAlerta(response.mensaje);
                    if (tipo == 1) {
                        $('#user-id_usuario').val(response.id_usuario);
                        $('#id_usuario').val(response.id_usuario);
                        $('#dir-id_direccion').val(response.id_direccion);
                        $('#nomi-id_nomina').val(response.id_nomina);
                        $('#tabs-user a[href="#userDocumentos"]').tab('show');
                        $('#tabs-user li:last').removeClass('hide');
                        $('#tabs-user li').slice(3).removeClass('hide');
                        $('#btnSendDoc').trigger('click');
                    } else {
                        //limpiar();
                        $('#tabs-user a[href="#datosTareas"]').tab('show');
                        $('#tabs-user li:last').removeClass('hide');
                    }
                    $('#nuevo').prop('disabled', false);
                    $('#guardar').prop('disabled', true).button('reset');
                    $('#editar').prop('disabled', false);
                    $('#cancelar').prop('disabled', true);
                    $('#buscar').trigger('keyup');
                } else {
                    abreAlerta(response.mensaje);
                }
            }, 'json');

        mypth = url + 'application/usuarios/controllers/AjaxController.php';

        photo = document.getElementById("pdfLicencia").files[0];
        formData = new FormData();

        formData.append("file", photo);
        fetch(mypth, {method: "POST", body: formData});

    };

    Usuarios.prototype.buscarUsuario = function (termino, pagina, registros, inferior, superior) {
        _this = this;
        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'get',
            dataType: 'json',
            data: {
                accion: 'totalCompletarUsuarioController',
                cadena: termino,
                pagina: pagina,
                registros: registros,
                inferior: inferior,
                superior: superior
            },
            beforeSend: function () {
                $('.refresh-container-table').show();
            },
            success: function (response) {
                $('.refresh-container-table').hide();
                if (response.status) {
                    _this.renderUsuarios(response);
                } else {
                    abreAlerta(response.mensaje);
                }
            },
            error: function () {
                $('.refresh-container-table').hide();
                mensaje = 'Lo siento, ocurrió un error al buscar tu proveedor. '.msjTicket;
            },
            timeout: 15000
        });
    };

    Usuarios.prototype.renderUsuarios = function (response) {
        html = '';
        if (response.status) {
            if (response.usuarios.length > 0) {
                $.each(response.usuarios, function (registro, item) {
                    html += '<tr data="' + item.Id_Usuario + '">';
                    switch (item.Status) {
                        case '1':
                            html += '<td><span class="label label-success">Activo</span></td>';
                            break;
                        case '0':
                            html += '<td><span class="label label-default">Inactivo</span></td>';
                            break;
                        case '-1':
                            html += '<td><span class="label label-danger">Baja</span></td>';
                            break;
                        default:
                            html += '<td><span class="label">' + item.Status + '</span></td>';
                            break;

                    }
                    html += '<td>' + item.Nombre + ' ' + item.Apellido_Paterno + ' ' + item.Apellido_Materno + '</td>';
                    html += '<td>' + item.Usuario + '</td>';
                    html += '<td>' + item.Mail + '</td>';
                    html += '</tr>';
                });

                renderPaginacion(response, "pagina", $('#paginacion'));

                // var ul = $('<ul class="pagination" />');
                // pagina = parseInt(response.pagina);
                // paginas = parseInt(response.paginas);
                // if (pagina > 1) {
                //     $('<li />').html('<a class="pagina" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
                // }
                // else {
                //     $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
                // }
                // inferior = response.inferior;
                // superior = response.superior;
                // paginas = parseInt(response.paginas);
                // if (paginas < superior) {
                //     limite = paginas;
                // }
                // else {
                //     limite = superior;
                // }
                // for (i = inferior; i <= limite; i++) {
                //     if (pagina == i) {
                //         $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
                //     }
                //     else {
                //         $('<li />').html('<a class="pagina" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
                //     }
                // }
                // if (pagina < paginas) {
                //     $('<li />').html('<a class="pagina" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
                // }
                // else {
                //     $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
                // }
                // $('#paginacion').html(ul);
            } else {
                html += '<tr data="0">';
                html += '<td colspan="7">No hay registros</td>';
                html += '</tr>';
            }
        } else {
            html += '<tr data="0">';
            html += '<td colspan="7">No hay registros</td>';
            html += '</tr>';
        }

        $('#registroProveedores tbody').html(html);
    };

    Usuarios.prototype.cargarDatosPdf = function () {
        _this = this;
        var formulario = new FormData($('#cargarDatosPdfForm')[0]);

        $.ajax({
            url: url + 'application/usuarios/controllers/AjaxController.php',
            type: 'post',
            dataType: 'json',
            data: formulario,
            contentType: false,
            processData: false,
            beforeSend: function () {
                console.log("ENTRA AL BEFORE");
            },
            success: function (response) {
                abreAlerta(response.mensaje);
                $('#pdfRFC').val(response.rfc);
                $('#pdfRazonSocial').val(response.razon);
                $('#pdfCP').val(response.cp);
                $('#pdfRegimen').val(response.regimen);

                $('#user-nombre').val(response.nombre);
                $('#user-paterno').val(response.apePaterno);
                $('#user-materno').val(response.apeMaterno);
                $('#user-rfc').val(response.rfc);
                $('#enviarRFC').val(response.rfc);
                $('#dir-codigo').val(response.cp);

                for (i = 0; i < response.numero; i++){
                    $('#regimen').append('<option value="'+response.regimen[i]+'">'+response.regimen[i]+'</option>');
                    $("#regimen").selectpicker("refresh");
                }
            },
            error: function () {
                error = "NO SIRVE";
                abreAlerta(error);
            },
            // timeout: 15000
        });
    };

    return Usuarios;
})();

function renderStatusUsuario(status) {
    $('#activo').prop('checked', false).parent().removeClass('active');
    $('#inactivo').prop('checked', false).parent().removeClass('active');
    $('#baja').prop('checked', false).parent().removeClass('active');
    switch (status) {
        case '1':
            $('#activo').prop('checked', true).parent().addClass('active');
            break;
        case '0':
            $('#inactivo').prop('checked', true).parent().addClass('active');
            break;
        case '-1':
            $('#baja').prop('checked', true).parent().addClass('active');
    }
}

function renderPremiospuntualidad(status) {
    $('#premio_puntualidad_si').prop('checked', false).parent().removeClass('active');
    $('#premio_puntualidad_no').prop('checked', false).parent().removeClass('active');
    switch (status) {
        case 'si':
            $('#premio_puntualidad_si').prop('checked', true).parent().addClass('active');
            break;
        case 'no':
            $('#premio_puntualidad_no').prop('checked', true).parent().addClass('active');
            break;
        default:
            $('#premio_puntualidad_no').prop('checked', true).parent().addClass('active');
    }
}

function renderPremioAsistencia(status) {
    $('#premio_asistencia_si').prop('checked', false).parent().removeClass('active');
    $('#premio_asistencia_no').prop('checked', false).parent().removeClass('active');
    switch (status) {
        case 'si':
            $('#premio_asistencia_si').prop('checked', true).parent().addClass('active');
            break;
        case 'no':
            $('#premio_asistencia_no').prop('checked', true).parent().addClass('active');
            break;
        default:
            $('#premio_asistencia_no').prop('checked', true).parent().addClass('active');
    }
}

function renderPremioDespensa(status) {
    $('#premio_despensa_si').prop('checked', false).parent().removeClass('active');
    $('#premio_despensa_no').prop('checked', false).parent().removeClass('active');
    switch (status) {
        case 'si':
            $('#premio_despensa_si').prop('checked', true).parent().addClass('active');
            break;
        case 'no':
            $('#premio_despensa_no').prop('checked', true).parent().addClass('active');
            break;
        default:
            $('#premio_despensa_no').prop('checked', true).parent().addClass('active');
    }
}

function showFormularioBaja() {
    $('.contenedor-formulario-baja').show();
}

function hideFormularioBaja() {
    $('.contenedor-formulario-baja').hide();
}

function clearFormularioBaja() {
    $('.formulario-baja').val('');
}

$(function () {
    if ($('.selectpicker').length > 0) {
        $('.selectpicker').selectpicker({
            title: 'Seleccciona...'
        });
    }

    pagina = parseInt($('#pagina').val());
    registros = parseInt($('#registros').val());
    inferior = parseInt($('#inferior').val());
    superior = parseInt($('#superior').val());

    u = new Usuarios();
    u.getCuentasContables();
    u.cargaUsuarios(pagina, registros, inferior, superior);
    desactivarFormulario();

    $('.tarea-mod').jstree({
        'checkbox': {'three_state': false},
        'plugins': ["checkbox"],
        'core': {
            'themes': {
                'name': 'proton',
                'responsive': true
            },
            'dblclick_toggle': true
        }
    }).on("changed.jstree", function (e, data) {
        accion = data.action;
        if (accion == 'select_node' || accion == 'deselect_node') {
            status = accion == 'select_node' ? 1 : 0;
            tipo = data.node.li_attr.class;
            id = data.node.data.id;
            user = parseInt($('#user-id_usuario').val());
            if (user > 0) {
                $.post(url + 'application/usuarios/controllers/AjaxController.php',
                    {accion: 'modificaTareaController', id_usuario: user, tabla: tipo, id: id, estado: status},
                    function (response) {
                        if (!response.status) abreAlerta(response.mensaje);
                    }, 'json');
            }
        }
    });

    $('.tarea-mod').jstree('hide_icons');
    $('.tarea-mod').jstree('open_all');
    $('.tarea-mod').jstree('uncheck_all');

    $('.panel-mod').on('hidden.bs.collapse', function () {
        $(this).find('span.fa:eq(0)').removeClass('fa-minus-square-o').addClass('fa-plus-square-o');
    });
    $('.panel-mod').on('shown.bs.collapse', function () {
        $(this).find('span.fa:eq(0)').removeClass('fa-plus-square-o').addClass('fa-minus-square-o');
    });

});

$(document).on('click', '#nuevo', function () {
    activarFormulario();
    limpiar();
    limpiarExpediente();
    $('#nuevo').prop('disabled', true);
    $('#activo').attr('checked', 'checked').parent().addClass('active');
    $('#inactivo').parent().removeClass('active');
    $('input[type="hidden"]').val(0);
    $('input[id*=nomi-]').val(0);
    $('#tipo').val(1);
    $('#tabs-user a:first').tab('show');
    // $('#tabs-user li:last').addClass('hide');
    $('#tabs-user li').slice(-3).addClass('hide');
    // $('#tabs-user li:eq(2)').removeClass('hide');
    $('#user-contrasena').attr('placeholder', '');
    $('#user-fecha_ingreso').prop('readonly', false);
    $('.tarea-mod').jstree('open_all');
    $('.tarea-mod').jstree('uncheck_all');
    $('#accion').val('subirDocumentosController');
    $('.link-documento').html('');
    $('#user-nombre').focus();
});

$(document).on('click', '#cancelar', function () {
    $('#activo').attr('checked', false).prop('checked', false);
    $('#inactivo').attr('checked', false).prop('checked', false);
    limpiar();
    limpiarExpediente();
    $('#guardar').button('reset');
    desactivarFormulario();
    $('input[type="hidden"]').val(0);
    $('.tarea-mod').jstree('open_all');
    $('.tarea-mod').jstree('uncheck_all');
});

$(document).on('click', '#editar', function () {
    activarFormulario();
    $('#tipo').val(2);
    $('#user-fecha_ingreso').prop('readonly', true);
    //$('#tabs-user li:last').removeClass('hide');
    //$('#tabs-user li:eq(2)').addClass('hide');
});

$(document).on('click', '.grilla tbody tr', function () {
    $('#nuevo').prop('disabled', true);
    $('#editar').prop('disabled', false);
    $('#cancelar').prop('disabled', false);
    $('#btnLicencia').prop('disabled', false);
    // $('#tabs-user li:last').removeClass('hide');
    $('#tabs-user li').slice(-3).removeClass('hide');
    //$('#tabs-user li:eq(2)').addClass('hide');    
    $('.tarea-mod').jstree('open_all');
    $('.tarea-mod').jstree('uncheck_all');
    $('html,body').animate({scrollTop: 0}, 1000);
    idUsuario = $(this).attr('data');
    u = new Usuarios();
    u.getUsuario(idUsuario);
});

$(document).on('click', '.pagina', function () {
    pagina = $(this).data('pagina');
    registros = parseInt($('#registros').val());
    inferior = parseInt($('#inferior').val());
    superior = parseInt($('#superior').val());
    p = new Usuarios();
    p.cargaUsuarios(pagina, registros, inferior, superior);
});

$(document).on('change', '#registros', function () {
    registros = $(this).val();
    pagina = parseInt($('#pagina').val());
    inferior = parseInt($('#inferior').val());
    superior = parseInt($('#superior').val());
    p = new Usuarios();
    p.cargaUsuarios(pagina, registros, inferior, superior);
});

$(document).on('keyup', '#buscar', function () {
    termino = $(this).val();
    pagina = 1;
    registros = parseInt($('#registros').val());
    inferior = parseInt($('#inferior').val());
    superior = parseInt($('#superior').val());
    p = new Usuarios();
    if (termino != '') {
        p.buscarUsuario(termino, pagina, registros, inferior, superior);
    } else {
        p.cargaUsuarios(pagina, registros, inferior, superior);
    }
});

$(document).on('input', '.money', function (e) {
    e.preventDefault();
    var v = $(this).val(), vc = v.replace(/[^0-9,\.]/, '');
    if (v !== vc)
        $(this).val(vc);
});

$(document).on('change', '[id*="cta-"]', function (event) {
    event.preventDefault();
    $(this).parent().find('input:hidden').val($(this).val());
});

$(document).on('blur', '#user-usuario', function () {
    usuario = $(this).val();
    if (usuario != '') {
        u = new Usuarios();
        u.validarUsuario(usuario, $('#user-id_usuario').val());
    }
});

$(document).on('click', '#guardar', function () {
    tipo = parseInt($('#tipo').val());
    status = $('input[name=status]:checked').val();
    perfil = $('input[name=perfil]:checked').val();
    if($('#nomi-tipo_nomina').val() == 'mixta' || $('#nomi-tipo_nomina').val() == 'interna' ){
        premioAsistencia = $('input[name=nomi-premio_asistencia]:checked').val();
        premioPuntualidad = $('input[name=nomi-premio_puntualidad]:checked').val();
        premioDespensa = $('input[name=nomi-premio_despensa]:checked').val();

    }else{
        premioAsistencia = '';
        premioPuntualidad ='';
        premioDespensa = '';

    }

    numLicencia = $('#user-licencia').val();
    vigenciaLicencia = $('#user-vigencialicencia').val();

    $('span.error').remove();
    $('.has-error').removeClass('has-error');

    if (status == 'undefined') {
        setError($('#activo'), 'Debes seleccionar el status del usuario.');
        return false;
    } else if (perfil == undefined) {
        setError($('#director'), 'Debes seleccionar el perfil del usuario.');
        return false;
    }


    data = validaDatos();
    if (data != undefined) {
        archivos = 0;
        $.each($('input:file'), function (index, elem) {
            archivos += $(elem)[0].files.length;
        });
        /*if(archivos != 5){
            $('#userDocumentos .form-group:eq('+archivos+') .alert-info')
                    .removeClass('alert-info').addClass('alert-danger')
                    .html('Debe seleccionar todos los documentos');
            $('#tabs-user a[href="#userDocumentos"]').tab('show');
        }else{
            u = new Usuarios();
            u.guardar(tipo, status, perfil, data);
        }*/
        u = new Usuarios();
        // console.log(JSON.stringify(data.user), JSON.stringify(data.dir), JSON.stringify(data.nomi));
        console.log(JSON.stringify(data.nomi));
        u.guardar(tipo, status, perfil, data, premioAsistencia, premioPuntualidad, premioDespensa, numLicencia, vigenciaLicencia); // DESCOMENTAR ERICK
    } else {
        $(this).button('reset');
    }
});

$(document).on('click', '[id*=btndoc-]', function (e) {
    e.preventDefault();
    $(this).parents('.form-group').find('input:file').trigger('click');
});

$(document).on('change', '[id*=doc-]', function () {
    doc = $(this)[0].files[0];
    alert = $(this).parents('.form-group').find('.alert');
    tipo = doc.type;
    nombreDocumento = doc.name;
    if (tipo != 'application/pdf') {
        alert.removeClass('alert-info').removeClass('alert-success')
            .addClass('alert-danger').text('Solo se permiten documentos PDF');
        return false;
    } else {
        alert.removeClass('alert-info').removeClass('alert-danger')
            .addClass('alert-success').text(nombreDocumento);
        return true;
    }
});

$(document).on('click', '#btnSendDoc', function (e) {
    e.preventDefault();
    archivos = 0;
    $.each($('input:file'), function (index, elem) {
        archivos += $(elem)[0].files.length;
    });
    if (archivos > 0) u.sendFiles();
    $('#tabs-user li').removeClass('hide');
});

function validaDatos() {
    user = validaUser();

    if (user.success) {
        dir = validaDir();
        if (dir.success) {
            $idNomina = $('#nomi-id_nomina').val();
            $dataNomina = null;

            if($idNomina != 0){
                nomi = validaNomi();
                if (nomi.success) {
                    $dataNomina = nomi.data;
                } else {
                    $dataNomina = null;
                }
            }
                return {success: true, user: user.data, dir: dir.data, nomi: $dataNomina}
        }
    }
}

function validaUser() {
    data = {};

    $.each($("[id*=user-]"), function (index, el) {
        ide = $(el).attr('id');
        ide = ide.replace('user-', '');

        data[ide] = $.trim($(el).val());
    });

    if (data.nombre == '') {
        setError($('#user-nombre'), 'Debes ingresar el nombre del usuario.');
        return false;
    } else if (data.paterno == '') {
        setError($('#user-paterno'), 'Debes ingresar el apellido paterno.');
        return false;
    } else if (data.materno == '') {
        setError($('#user-materno'), 'Debes ingresar el apellido materno.');
        return false;
    } else if (data.usuario == '') {
        setError($('#user-usuario'), 'Debes ingresar el usuario.');
        return false;
    } else if ($('#tipo').val() == '1' && data.contrasena == '') {
        setError($('#user-contrasena'), 'Debes ingresar la contrasena.');
        return false;
    } else if (data.fecha_ingreso == '') {
        setError($('#user-fecha_ingreso'), 'Debes seleccionar la fecha de entrada.');
        return false;
    }/*else if(data.numero == ''){
        setError($('#user-numero'),'Debes ingresar el número de empleado.');
        return false;
    }else if(data.clabe == ''){
        setError($('#user-clabe'),'Debes ingresar la CLABE.');
        return false;
    }*/ else if (data.email == '') {
        setError($('#user-email'), 'Debes ingresar el correo electrónico.');
        return false;
    } else if (!validarEmail(data.email)) {
        setError($('#user-email'), 'Debes ingresar correo electrónico válido.');
        return false;
    } else if (!validarRFC(data.rfc)) {
        setError($('#user-rfc'), 'Debes ingresar un RFC válido.');
        return false;
    } else if (!validarCurp(data.curp)) {
        setError($('#user-curp'), 'Debes ingresar una CURP válida.');
        return false;
    } else if (data.nss == '') {
        setError($('#user-nss'), 'Debes ingresar el Número de seguridad social.');
        return false;
    } else if (data.periodicidad_pago == '') {
        setError($('#user-periodicidad_pago'), 'Debes seleccionar Periodicidad de pago.');
        return false;
    } else if (data.tipo_contratacion == '') {
        setError($('#user-tipo_contratacion'), 'Debes seleccionar Tipo contratación.');
        return false;
    } else if (data.tipo_jornada == '') {
        setError($('#user-tipo_jornada'), 'Debes seleccionar Tipo jornada.');
        return false;
    } else if (data.departamento == '') {
        setError($('#user-departamento'), 'Debes seleccionar Departamento.');
        return false;
    } else if (data.riesgo_puesto == '') {
        setError($('#user-riesgo_puesto'), 'Debes seleccionar Riesgo puesto.');
        return false;
    } else if (data.regimen_contratacion == '') {
        setError($('#user-regimen_contratacion'), 'Debes seleccionar Régimen contratación.');
        return false;
    } else if (data.banco_pago_nomina == '') {
        setError($('#user-banco_pago_nomina'), 'Debes seleccionar Banco de pago.');
        return false;
    }

    status = $('input[name=status]:checked').val();
    if (status == -1) {
        if (data.fecha_baja == '') {
            setError($('#user-fecha_baja'), 'Debes seleccionar la fecha de baja.');
            return false;
        }
        if (data.razon_baja == '') {
            setError($('#user-razon_baja'), 'Debes ingresar una razon de la baja.');
            return false;
        }
    }

    return {success: true, data: data}
}

function validaDir() {
    data = {};

    $.each($("[id*=dir-]"), function (index, el) {
        ide = $(el).attr('id');
        ide = ide.replace('dir-', '');

        data[ide] = $.trim($(el).val());
    });

    if (data.telefono == '') {
        setError($('#dir-telefono'), 'Debes ingresar el teléfono.');
        return false;
    } else if (data.celular == '') {
        setError($('#dir-celular'), 'Debes ingresar el celular.');
        return false;
    } else if (data.calle == '') {
        setError($('#dir-calle'), 'Debes ingresar calle.');
        return false;
    } else if (data.exterior == '') {
        setError($('#dir-exterior'), 'Debes ingresar el número exterior.');
        return false;
    } else if (data.colonia == '') {
        setError($('#dir-colonia'), 'Debes ingresar la colonia.');
        return false;
    } else if (data.ciudad == '') {
        setError($('#dir-ciudad'), 'Debes ingresar la ciudad.');
        return false;
    } else if (data.estado == '') {
        setError($('#dir-estado'), 'Debes ingresar el estado.');
        return false;
    } else if (data.codigo.length != 5) {
        setError($('#dir-codigo'), 'Debes ingresar un código postal válido.');
        return false;
    }
    return {success: true, data: data}
}

function validaNomi() {
    data = {}

    $.each($("[id*=nomi-]"), function (index, el) {
        ide = $(el).attr('id');
        ide = ide.replace('nomi-', '');

        data[ide] = $.trim($(el).val());
    });

    if (data.sueldo == '') {
        setError($('#nomi-sueldo'), 'Debes ingresar el sueldo.');
        return false;
    } else if (data.asistencia == '') {
        setError($('#nomi-asistencia'), 'Debes ingresar la asistencia.');
        return false;
    } else if (data.puntualidad == '') {
        setError($('#nomi-puntualidad'), 'Debes ingresar la puntualidad.');
        return false;
    } else if (data.dias_aguinaldo == '') {
        setError($('#nomi-dias_aguinaldo'), 'Debes ingresar los días de aguinaldo.');
        return false;
    } else if (data.dias_vacaciones == '') {
        setError($('#nomi-dias_vacaciones'), 'Debes ingresar los días de vacaciones.');
        return false;
    } else if (data.prima_vacacional == '') {
        setError($('#nomi-prima_vacacional'), 'Debes ingresar la prima  vacacional.');
        return false;
    } else if (data.prestamo_infonavit == '') {
        setError($('#nomi-prestamo_infonavit'), 'Debes ingresar el prestamo infonavit.');
        return false;
    } else if (data.pension_alimenticia == '') {
        setError($('#nomi-pension_alimenticia'), 'Debes ingresar la pensión alimenticia.');
        return false;
    }/*else if(data.cuenta_nomina == '0'){
        setError($('#nomi-cuenta_nomina'),'Debes seleccionar la cuenta de sueldos.');
        return false;
    }else if(data.cuenta_despensa == '0'){
        setError($('#nomi-cuenta_despensa'),'Debes seleccionar la cuenta de despensa.');
        return false;
    }else if(data.cuenta_asistencia == '0'){
        setError($('#nomi-cuenta_asistencia'),'Debes seleccionar la cuenta de asistencia.');
        return false;
    }else if(data.cuenta_puntualidad == '0'){
        setError($('#nomi-cuenta_puntualidad'),'Debes seleccionar la cuenta de puntualidad.');
        return false;
    }else if(data.cuenta_subsidio == '0'){
        setError($('#nomi-cuenta_subsidio'),'Debes seleccionar la cuenta de subsidio.');
        return false;
    }else if(data.cuenta_gastos == '0'){
        setError($('#nomi-cuenta_gastos'),'Debes seleccionar la cuenta de tarjeta empresarial.');
        return false;
    }else if(data.cuenta_deudor == '0'){
        setError($('#nomi-cuenta_deudor'),'Debes seleccionar la cuenta de deudor.');
        return false;
    }else if(data.cuenta_gastos_comprobar == '0'){
        setError($('#nomi-cuenta_gastos_comprobar'),'Debes seleccionar la cuenta de anticipo de gastos.');
        return false;
    }*/
    else if (data.servicio_fronterizo == '') {
        setError($('#nomi-servicio_fronterizo'), 'Debes ingresar el servicio fronterizo.');
        return false;
    } else if (data.forma_de_pago == '') {
        setError($('#nomi-forma_de_pago'), 'Debes ingresar la forma de pago.');
        return false;
    } else if (data.estado == '') {
        setError($('#nomi-estado'), 'Debes ingresar la entidad donde presta servicio el usuario.');
        return false;
    } else if (data.isr == '') {
        setError($('#nomi-isr'), 'Debes ingresar el ISR.');
        return false;
    } else if (data.tipo_infonavit == '') {
        setError($('#nomi-tipo_infonavit'), 'Debes ingresar si cuenta con descuento infonavit');
        return false;
    } /*else if(data.tipo_nomina == ''){
        setError($('#nomi-tipo_nomina'),'Debes ingresar el tipo de nomina.');
        return false;
    }*/ else if (data.tipo_nomina == 'externa') {
        if (data.proveedor == '') {
            setError($('#nomi-proveedor'), 'Debes ingresar un proveedor.');
            return false;
        }
    } else if (data.tipo_nomina == 'mixta') {
        // if(data.proveedor == ''){
        //     setError($('#nomi-proveedor'),'Debes ingresar un proveedor.');
        //     return false;
        // } else
        if (data.porcentaje_interna == '') {
            setError($('#nomi-porcentaje_interna'), 'Debes ingresar el porcentaje de nomina interna.');
            return false;
        } else if (data.porcentaje_externa == '') {
            setError($('#nomi-porcentaje_externa'), 'Debes ingresar el porcentaje de nomina externa.');
            return false;
        }
        sumaporcentajes = parseFloat(data.porcentaje_interna) + parseFloat(data.porcentaje_externa);
        if (sumaporcentajes != 100) {
            setError($('#nomi-porcentaje_interna'), 'La suma de los porcentajes no da 100 porciento');
            setError($('#nomi-porcentaje_externa'), 'La suma de los porcentajes no da 100 porciento');
            return false;
        }
    }

    // checkComisiones = $('#nomi-comisiones').prop("checked");
    // if(checkComisiones == true){
    //     data.comisiones = "1";
    // } else{
    //     data.comisiones = null;
    // }
    // checkImmsPatronal = $('#nomi-imms_patronal').prop("checked");
    // if(checkImmsPatronal == true){
    //     data.imms_patronal = "1";
    // } else{
    //     data.imms_patronal = null;
    // }

    if (validarVinculosConProveedor(data.tipo_nomina)) {
        data['vinculosConProveedor'] = obtenerVinculosConProveedor(data.tipo_nomina);
    } else {
        return false;
    }

    return {success: true, data: data}
}

function setError(elem, msg) {
    divp = elem.parents('.form-group');
    divp.addClass('has-error');
    divp.find('span.error').remove();

    divp.append('<span class="help-block error">' + msg + '</span>');

    tab = elem.parents('.tab-pane').attr('id');

    $('#tabs-user a[href="#' + tab + '"]').tab('show');
    if (elem.attr('type') != 'radio') elem.focus();
}


$(document).ready(function () {
    $("#nomi-tipo_nomina").click(function (event) {

        var valor = $(this).val();

        if (valor == "interna") {
            $(".proveedores").css("display", "none");
            $(".porcentajenominas").css("display", "none");
            $("#nomi-comisiones").prop("checked", false);
            $("#tablaVincularProveedores").css("display", "none");
            $(".premios").css("display", "block");
        } else if (valor == 'externa') {
            $(".proveedores").css("display", "block");
            $(".porcentajenominas").css("display", "none");
            $("#tablaVincularProveedores").css("display", "block");
            $(".premios").css("display", "none");
        } else if (valor == 'mixta') {
            $(".proveedores").css("display", "block");
            $(".porcentajenominas").css("display", "block");
            $("#tablaVincularProveedores").css("display", "block");
            $(".premios").css("display", "block");

        } else {
            $(".proveedores").css("display", "none");
            $(".porcentajenominas").css("display", "none");
            $("#nomi-comisiones").prop("checked", false);
            $("#tablaVincularProveedores").css("display", "none");
            $(".premios").css("display", "none");
        }
    });
});


$(document).on('change', '#nomi-tipo_infonavit', function () {
    var valor = $(this).val();

    console.log(valor, 'valor');

    if (valor == "no") {
        $("#prestamo_infonavit_cantidad").css("display", "block");
        $("#prestamo_infonavit_porcentaje").css("display", "none");
    } else if (valor == "porcentaje") {
        $("#prestamo_infonavit_cantidad").css("display", "none");
        $("#prestamo_infonavit_porcentaje").css("display", "block");
    } else if (valor == "cuotafija") {
        $("#prestamo_infonavit_cantidad").css("display", "block");
        $("#prestamo_infonavit_porcentaje").css("display", "none");
    } else if (valor == "smg") {
        $("#prestamo_infonavit_cantidad").css("display", "block");
        $("#prestamo_infonavit_porcentaje").css("display", "none");
    } else {
        $("#prestamo_infonavit_cantidad").css("display", "block");
        $("#prestamo_infonavit_porcentaje").css("display", "none");
    }
});

$(document).on('change', 'input:radio[name=status]', function () {
    status = $('input[name=status]:checked').val();

    if (status == -1) {
        showFormularioBaja();
        document.getElementById("fecha_baja").style.display = "block";
        document.getElementById("razon_baja").style.display = "block";
    } else {
        hideFormularioBaja();
        clearFormularioBaja();
        document.getElementById("fecha_baja").style.display = "none";
        document.getElementById("razon_baja").style.display = "none";
    }


});

$(document).on('click', '#consultarNominas', function () {
    if (validarParametrosConsultaHistorial($("#user-id_usuario"), $('#fechaInicialNominas'), $('#fechaFinalNominas'))) {
        usuario = $('#user-id_usuario').val();
        fechaInicio = $('#fechaInicialNominas').val();
        fechaFin = $('#fechaFinalNominas').val();
        pagina = parseInt($('#paginaNomina').val());
        registros = 10;
        inferior = parseInt($('#inferiorNomina').val());
        superior = parseInt($('#superiorNomina').val());
        consultarHistorialDeNominas(usuario, fechaInicio, fechaFin, pagina, registros, inferior, superior);
    }
});

function consultarHistorialDeNominas(idUsuario, fechaInicio, fechaFinal, pagina, registros, inferior, superior) {
    $.ajax({
        url: url + 'application/usuarios/controllers/AjaxController.php',
        type: 'get',
        dataType: 'json',
        data: {
            accion: 'obtenerHistorialDeNominas',
            idUsuario: idUsuario,
            fechaInicio: fechaInicio,
            fechaFinal: fechaFinal,
            pagina: pagina,
            registros: registros,
            inferior: inferior,
            superior: superior
        },
        success: function (response) {
            // console.log(response);
            if (response.status) {
                renderHistorialDeNominas(response);
            } else {
                abreAlerta(response.mensaje);
            }
        },
        error: function (error) {
            console.error(error.responseText);
            abreAlerta('A ocurrido un error al consultar las nominas. ' + msjTicket);
        },
        timeout: 15000
    });
}

function renderHistorialDeNominas(response) {
    var html = '';
    if (response.historial.length > 0) {
        $.each(response.historial, function (registro, item) {
            html += '<tr>';
            html += '<td> Del ' + item.fecha_inicial + ' al ' + item.fecha_final + '</td>';
            html += '<td>' + item.fecha_pago + '</td>';
            html += '<td>' + item.dias_pagados + '</td>';
            html += '<td>' + item.total + '</td>';

            if (item.status_Pago == 'timbrado') {

                html += '<td><a target="_blank" href="' + url + 'application/contabilidad/xmlNomina/' + item.Folio_Documento + '.xml"><span class="fa fa-file-code-o"></span></a></td>';
                html += '<td><a target="_blank" href="' + url + 'application/contabilidad/pdfNomina/' + item.Folio_Documento + '.pdf"><span class="fa fa-file-pdf-o"></span></a></td>';
            } else {
                html += '<td></td>';
                html += '<td></td>';
            }

            switch (item.status_Pago) {
                case 'pagado':
                    html += '<td> <span class="label label-success">' + item.status_Pago.toUpperCase() + '</span></td>';
                    break;
                case 'autorizado':
                    html += '<td> <span class="label label-info">' + item.status_Pago.toUpperCase() + '</span></td>';
                    break;
                case 'timbrado':
                    html += '<td> <span class="label label-primary">' + item.status_Pago.toUpperCase() + '</span></td>';
                    break;
                default:
                    html += '<td>' + item.status_Pago + '</td>';
                    break;
            }
            html += '</tr>';
        });
        renderPaginacion(response, "paginaNomina", $('#paginacionNomina'));
    } else {
        html += '<tr>';
        html += '<td colspan="5">No se encontraron resultados</td>';
        html += '</tr>';
    }
    $('#historialNomina tbody').html(html);
}

$(document).on('click', '.paginaNomina', function () {
    if (validarParametrosConsultaHistorial($("#user-id_usuario"), $('#fechaInicialNominas'), $('#fechaFinalNominas'))) {
        usuario = $('#user-id_usuario').val();
        fechaInicio = $('#fechaInicialNominas').val();
        fechaFin = $('#fechaFinalNominas').val();
        pagina = $(this).data('pagina');
        registros = 10;
        inferior = parseInt($('#inferiorNomina').val());
        superior = parseInt($('#superiorNomina').val());
        consultarHistorialDeNominas(usuario, fechaInicio, fechaFin, pagina, registros, inferior, superior);
    }
});

$(document).on('click', '#consultarHistorialVacaciones', function () {
    if (validarParametrosConsultaHistorial($("#user-id_usuario"), $('#fechaInicialVacaciones'), $('#fechaFinalVacaciones'))) {
        usuario = $("#user-id_usuario").val();
        fechaInicio = $('#fechaInicialVacaciones').val();
        fechaFin = $('#fechaFinalVacaciones').val();
        pagina = parseInt($('#paginaHistorialVacaciones').val());
        registros = 10;
        inferior = parseInt($('#inferiorHistorialVacaciones').val());
        superior = parseInt($('#superiorHistorialVacaciones').val());
        consultarHistorialDeVacaciones(usuario, fechaInicio, fechaFin, pagina, registros, inferior, superior);
    }
});

function consultarHistorialDeVacaciones(idUsuario, fechaInicio, fechaFinal, pagina, registros, inferior, superior) {
    $.ajax({
        url: url + 'application/usuarios/controllers/AjaxController.php',
        type: 'get',
        dataType: 'json',
        data: {
            accion: 'obtenerHistorialDeVacaciones',
            idUsuario: idUsuario,
            fechaInicio: fechaInicio,
            fechaFinal: fechaFinal,
            pagina: pagina,
            registros: registros,
            inferior: inferior,
            superior: superior
        },
        success: function (response) {
            // console.log(response);
            if (response.status) {
                renderHistorialDeVacaciones(response);
            } else {
                abreAlerta(response.mensaje);
            }
        },
        error: function (error) {
            console.error(error.responseText);
            abreAlerta('A ocurrido un error al consultar el historial de vacaciones. ' + msjTicket);
        },
        timeout: 15000
    });
}

function renderHistorialDeVacaciones(response) {
    var html = '';
    if (response.historial.length > 0) {
        $.each(response.historial, function (registro, item) {
            html += '<tr>';
            // html += '<td>' + item.Fecha_Inicio + ' a las '+ item.Hora_Inicial + '</td>';
            html += '<td>' + moment(item.Fecha_Inicio + " " + item.Hora_Inicial).locale('es').format('LLL') + '</td>';
            // html += '<td>' + item.Fecha_Fin + ' a las '+ item.Hora_Final +'</td>';
            html += '<td>' + moment(item.Fecha_Fin + " " + item.Hora_Final).locale('es').format('LLL') + '</td>';
            html += '<td>' + item.Dias_Solicitados + '</td>';
            html += '<td>' + item.Motivo + '</td>';
            html += '</tr>';
        });
        renderPaginacion(response, "paginaVacaciones", $('#paginacionHistorialVacaciones'))
    } else {
        html += '<tr>';
        html += '<td colspan="4">No se encontraron resultados</td>';
        html += '</tr>';
    }

    $('#historialVacaciones tbody').html(html);
}

$(document).on('click', '.paginaVacaciones', function () {
    if (validarParametrosConsultaHistorial($("#user-id_usuario"), $('#fechaInicialVacaciones'), $('#fechaFinalVacaciones'))) {
        usuario = $("#user-id_usuario").val();
        fechaInicio = $('#fechaInicialVacaciones').val();
        fechaFin = $('#fechaFinalVacaciones').val();
        pagina = $(this).data('pagina');
        registros = 10;
        inferior = parseInt($('#inferiorHistorialVacaciones').val());
        superior = parseInt($('#superiorHistorialVacaciones').val());
        consultarHistorialDeVacaciones(usuario, fechaInicio, fechaFin, pagina, registros, inferior, superior);
    }
});


$(document).on('click', '#consultarHistorialTarjetasAsistencia', function () {
    if (validarParametrosConsultaHistorial($("#user-id_usuario"), $('#fechaInicialTarjetasAsistencia'), $('#fechaFinalTarjetasAsistencia'))) {
        usuario = $("#user-id_usuario").val();
        fechaInicio = $('#fechaInicialTarjetasAsistencia').val();
        fechaFin = $('#fechaFinalTarjetasAsistencia').val();
        pagina = parseInt($('#paginaHistorialTarjetasAsistencia').val());
        registros = 10;
        inferior = parseInt($('#inferiorHistorialTarjetasAsistencia').val());
        superior = parseInt($('#superiorHistorialTarjetasAsistencia').val());
        consultarHistorialDeTarjetasFirmadas(usuario, fechaInicio, fechaFin, pagina, registros, inferior, superior);
    }
});

function consultarHistorialDeTarjetasFirmadas(idUsuario, fechaInicio, fechaFinal, pagina, registros, inferior, superior) {
    $.ajax({
        url: url + 'application/usuarios/controllers/AjaxController.php',
        type: 'get',
        dataType: 'json',
        data: {
            accion: 'obtenerHistorialDeTarjetasFirmadas',
            idUsuario: idUsuario,
            fechaInicio: fechaInicio,
            fechaFinal: fechaFinal,
            pagina: pagina,
            registros: registros,
            inferior: inferior,
            superior: superior
        },
        success: function (response) {
            // console.log(response);
            if (response.status) {
                renderHistorialDeTarjetasFirmadas(response);
            } else {
                abreAlerta(response.mensaje);
            }
        },
        error: function (error) {
            console.error(error.responseText);
            abreAlerta('A ocurrido un error al consultar el historial de tarjetas. ' + msjTicket);
        },
        timeout: 15000
    });
}

function renderHistorialDeTarjetasFirmadas(response) {
    var html = '';
    if (response.historial.length > 0) {
        $.each(response.historial, function (registro, item) {
            html += '<tr>';
            html += '<td>' + moment(item.fecha_inicio_corte).locale('es').format('LL') + '</td>';
            html += '<td>' + moment(item.fecha_final_corte).locale('es').format('LL') + '</td>';
            html += '<td class="text-center"><a href="' + url + 'application/contabilidad/tarjetasFirmadas/' + item.archivo_tarjeta_asistencia + '" target="_blank"><span class="fa fa-file"></span></a></td>';
            html += '</tr>';
        });
        renderPaginacion(response, "paginaTarjetasAsistencia", $('#paginacionHistorialTarjetasAsistencia'))
    } else {
        html += '<tr>';
        html += '<td colspan="3">No se encontraron resultados</td>';
        html += '</tr>';
    }

    $('#historialTarjetasAsistencia tbody').html(html);
}

$(document).on('click', '.paginaVacaciones', function () {
    if (validarParametrosConsultaHistorial($("#user-id_usuario"), $('#fechaInicialVacaciones'), $('#fechaFinalVacaciones'))) {
        usuario = $("#user-id_usuario").val();
        fechaInicio = $('#fechaInicialVacaciones').val();
        fechaFin = $('#fechaFinalVacaciones').val();
        pagina = $(this).data('pagina');
        registros = 10;
        inferior = parseInt($('#inferiorHistorialVacaciones').val());
        superior = parseInt($('#superiorHistorialVacaciones').val());
        consultarHistorialDeVacaciones(usuario, fechaInicio, fechaFin, pagina, registros, inferior, superior);
    }
});

function validarParametrosConsultaHistorial(jqueryUsuario, jqueryFechaInicial, jqueryFechaFinal) {
    if (validarUsuarioSeleccionado(jqueryUsuario)) {
        if (jqueryFechaInicial.val() != '' && jqueryFechaFinal.val() != '') {
            if (validarRangoFechas(jqueryFechaInicial, jqueryFechaFinal)) {
                return true
            } else {
                return false;
            }
        } else {
            return true;
        }
    } else {
        return false
    }
}


function renderPaginacion(response, classPagina, jqueryDivPaginacion) {
    var ul = $('<ul class="pagination" />');
    pagina = parseInt(response.pagina);
    paginas = parseInt(response.paginas);
    if (pagina > 1) {
        $('<li />').html('<a class="' + classPagina + '" href="javascript:void(0)" data-pagina="' + (parseInt(pagina - 1)) + '">&laquo;</a>').appendTo(ul);
    } else {
        $('<li class="disabled" />').html('<a href="javascript:void(0);">&laquo;</a>').appendTo(ul);
    }
    inferior = response.inferior;
    superior = response.superior;
    paginas = parseInt(response.paginas);
    if (paginas < superior) {
        limite = paginas;
    } else {
        limite = superior;
    }
    for (i = inferior; i <= limite; i++) {
        if (pagina == i) {
            $('<li class="active" />').html('<a href="javascript:void(0);">' + i + '</a>').appendTo(ul);
        } else {
            $('<li />').html('<a class="' + classPagina + '" href="javascript:void(0);" data-pagina="' + i + '">' + i + '</a>').appendTo(ul);
        }
    }
    if (pagina < paginas) {
        $('<li />').html('<a class="' + classPagina + '" href="javascript:void(0);" data-pagina="' + (parseInt(pagina + 1)) + '">&raquo;</a>').appendTo(ul);
    } else {
        $('<li class="disabled" />').html('<a href="javascript:void(0);">&raquo;</a>').appendTo(ul);
    }
    jqueryDivPaginacion.html(ul);
}

function limpiarExpediente() {
    $('#expedientelistadoDocumentos').html('');

    $('#fechaInicialNominas').val('');
    $('#fechaFinalNominas').val('');
    $('#historialNomina tbody').html('');
    $('#paginacionNomina').html('');

    $('#fechaInicialVacaciones').val('');
    $('#fechaFinalVacaciones').val('');
    $('#historialVacaciones tbody').html('');
    $('#paginacionHistorialVacaciones').html('');

    $('#fechaInicialTarjetasAsistencia').val('');
    $('#fechaFinalTarjetasAsistencia').val('');
    $('#historialTarjetasAsistencia tbody').html('');
    $('#paginacionHistorialTarjetasAsistencia').html('');
}

function renderExpedienteCompleto(responseFiles) {
    renderExpedienteListadoDocumentos(responseFiles);

    usuario = $('#user-id_usuario').val();
    consultarHistorialDeNominas(usuario, '', '', 1, 10, 1, 10);
    consultarHistorialDeVacaciones(usuario, '', '', 1, 10, 1, 10);
    consultarHistorialDeTarjetasFirmadas(usuario, '', '', 1, 10, 1, 10)
}

function renderExpedienteListadoDocumentos(responseFiles) {
    // console.log(responseFiles);
    var docsHtml = '';
    $.each(responseFiles, function (nameDock, linkDoc) {
        if (linkDoc != '') {
            switch (nameDock) {
                case 'rfc':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">RFC <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'ine':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">INE <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'imss':
                    console.log(linkDoc);
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">IMSS <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'domicilio':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Comprobante de domicilio <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'licencia':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Licencia de Conducir <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'curp':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">CURP <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'solicitudEmpleo':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Solicitud de Empleo<i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'carta1':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Carta de Recomendación <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'contrato':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Contrato <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'altaImss':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Alta IMSS <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'bajaImss':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Baja IMSS <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'constancia':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Constancia Fiscal <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'renuncia':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Carta de renuncia <i class="fa fa-file pull-right"></i> </a>';
                    break;
                case 'finiquito':
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Finiquito <i class="fa fa-file pull-right"></i> </a>';
                    break;
                default:
                    docsHtml += '<a href="' + linkDoc + '" class="list-group-item" target="_blank">Documento ' + nameDock + ' <i class="fa fa-file pull-right"></i> </a>';
                    break;
            }
        }
    });
    $('#expedientelistadoDocumentos').html(docsHtml);
}

$(document).on('click', '#agregarVinculoProveedor', function () {

    if (validarAgregarVinculoProveedor($('#idProveedorAgregarVinculoProveedor'), $('#comisionesAgregarVinculoProveedor'), $('#immsAgregarVinculoProveedor'), $('#porcentajeAgregarVinculoProveedor'))) {
        agregarVinculoProveedor($('#idProveedorAgregarVinculoProveedor').val(), $('#idProveedorAgregarVinculoProveedor option:selected').text(), $('#comisionesAgregarVinculoProveedor').val(), $('#immsAgregarVinculoProveedor').val(), $('#porcentajeAgregarVinculoProveedor').val(), $('#porcentajeComisionProveedor').val());
    }
});

function validarAgregarVinculoProveedor(jqueryProveedor, jqueryComisiones, jqueryImms, jqueryPorcentaje) {
    if (validarNoEmptyString(jqueryProveedor) &&
        validarNoEmptyString(jqueryComisiones) &&
        validarNoEmptyString(jqueryImms) &&
        validarNoEmptyString(jqueryPorcentaje) &&
        validarMayorQueCero(jqueryPorcentaje) &&
        validarMenorIgualQueCien(jqueryPorcentaje)) {
        return true;
    } else {
        return false;
    }
}

function agregarVinculoProveedor(idProveedor, nombreProveedor, banderaComisiones, banderaImms, porcentaje, porcentajeComisionProveedor) {
    tabla = $('#tablaVincularProveedores tbody');
    var tr = $('<tr data-id="' + idProveedor + '"></tr>');
    tr.append('<td>' + nombreProveedor + '</td>');
    tr.append('<td data-flag ="' + banderaComisiones + '">' + parseFlag(banderaComisiones) + '</td>');
    tr.append('<td data-flag ="' + banderaImms + '">' + parseFlag(banderaImms) + '</td>');
    tr.append('<td data-number ="' + porcentaje + '">' + porcentaje + ' %</td>');
    tr.append('<td data-number ="' + porcentajeComisionProveedor + '">' + porcentajeComisionProveedor + ' %</td>');
    tr.append('<td class="text-center"><button type="button" class="btn btn-danger eliminarVilculoProveedor" ><i class="fa fa-trash-o" aria-hidden="true"></i></button></td>');
    tr.appendTo(tabla);
    //disableOptionProveedor(idProveedor);
    cleenMinFormAgregarVinculoProveedor();
}

function disableOptionProveedor(idProveedor) {
    $('#idProveedorAgregarVinculoProveedor option[value="' + idProveedor + '"]').prop("disabled", true);
}

function cleenMinFormAgregarVinculoProveedor() {
    $('#idProveedorAgregarVinculoProveedor').val('');
    $('#comisionesAgregarVinculoProveedor').val('');
    $('#immsAgregarVinculoProveedor').val('');
    $('#porcentajeAgregarVinculoProveedor').val(0);
    $('#porcentajeComisionProveedor').val(0);
}

$('#tablaVincularProveedores').on('click', '.eliminarVilculoProveedor', function () {
    $(this).parents('tr').remove();
    enaableOptionProveedor($(this).parents('tr').data('id'));
});

function enaableOptionProveedor(idProveedor) {
    $('#idProveedorAgregarVinculoProveedor option[value="' + idProveedor + '"]').prop("disabled", false);
}

function validarVinculosConProveedor(tipoNomina) {
    if (tipoNomina == 'externa' || tipoNomina == 'mixta') {
        if ($('#tablaVincularProveedores > tbody > tr').length > 0) {
            removeBlockError($('#errorVinculosProveedores'));
            var sumaPorcentajes = 0;
            $('#tablaVincularProveedores tbody tr').each(function (index) {
                sumaPorcentajes += parseInt($(this).find('td:nth-child(4)').data('number'));
            });
            if (sumaPorcentajes == 100) {
                removeBlockError($('#errorVinculosProveedores'));
                return true
            } else {
                addBlockError($('#errorVinculosProveedores'), 'Se debe sumar 100% al vincular un proveedor');
                return false
            }
        } else {
            addBlockError($('#errorVinculosProveedores'), 'Debe haber un proveedor vinculado');
            return false;
        }
    } else {
        return true;
    }
}

function obtenerVinculosConProveedor(tipoNomina) {
    var vinculosProveedor = new Array();
    if (tipoNomina == 'externa' || tipoNomina == 'mixta') {
        $('#tablaVincularProveedores tbody tr').each(function (index) {
            var vinculo = {
                idProveedor: $(this).data('id'),
                banderaComisiones: $(this).find('td:nth-child(2)').data('flag'),
                banderaImms: $(this).find('td:nth-child(3)').data('flag'),
                porcentaje: $(this).find('td:nth-child(4)').data('number'),
                porcentajeComisionProveedor: $(this).find('td:nth-child(5)').data('number')
            };
            vinculosProveedor.push(vinculo);
        });
    }

    console.log(vinculosProveedor, "vinculos");
    return vinculosProveedor;
}

function renderProveedoresExternosDeNomina(nominaProveedoresExternos) {
    // console.log(nominaProveedoresExternos);
    $('#tablaVincularProveedores tbody').html('');
    nominaProveedoresExternos.forEach(function (proveedor) {
        agregarVinculoProveedor(proveedor.id_proveedor, proveedor.Nombre, proveedor.comisiones, proveedor.imms_patronal, proveedor.porcentaje, proveedor.porcentaje_comision_proveedor);
    });
}


$(document).on('blur', '.fixed-int', function () {
    var numberFixed = parseFloat($(this).val()).toFixed(0);
    $(this).val(numberFixed);
});

function parseFlag(flag) {
    var displayFlag;
    switch (flag) {
        case '0':
            displayFlag = 'No';
            break;
        case '1':
            displayFlag = 'Si';
            break;
        default:
            displayFlag = flag;
            break;
    }
    return displayFlag;
}

function validarUsuarioSeleccionado(jqueryElemUsuarioID) {
    if (jqueryElemUsuarioID.val() != "0") {
        return true;
    } else {
        abreAlerta('No se a seleccionado un usuario');
        return false;
    }
}

function validarRangoFechas(jqueryElemFechaInicio, jqueryElemFechaFin) {
    fechaInicio = new Date(jqueryElemFechaInicio.val());
    fechaInicio.setHours(0, 0, 1, 0);
    fechaFin = new Date(jqueryElemFechaFin.val());
    fechaFin.setHours(0, 0, 2, 0);
    if (fechaFin > fechaInicio) {
        removeBlockError(jqueryElemFechaFin);
        return true;
    } else {
        addBlockError(jqueryElemFechaFin, 'La fecha final debe ser mayor o igual a la fecha inicial');
        return false;
    }
}

function validarNoEmptyString(jqueryElem) {
    if (jqueryElem.val() != "") {
        removeBlockError(jqueryElem);
        return true;
    } else {
        addBlockError(jqueryElem, 'No puede estar vacío');
        return false;
    }
}

function validarMayorQueCero(jqueryElem) {
    if (parseInt(jqueryElem.val()) > 0) {
        removeBlockError(jqueryElem);
        return true;
    } else {
        addBlockError(jqueryElem, 'Debe ser mayor que cero');
        return false;
    }
}

function validarMenorIgualQueCien(jqueryElem) {
    if (parseInt(jqueryElem.val()) <= 100) {
        removeBlockError(jqueryElem);
        return true;
    } else {
        addBlockError(jqueryElem, 'Debe ser menor o igual a 100');
        return false;
    }
}

function addBlockError(jqueryElem, msg) {
    divp = jqueryElem.parents('.form-group');
    divp.addClass('has-error');
    divp.find('span.error').remove();
    divp.append('<span class="help-block error">' + msg + '</span>');
}

function removeBlockError(jqueryElem) {
    divp = jqueryElem.parents('.form-group');
    divp.removeClass('has-error');
    divp.find('span.error').remove();
}

function getHistorialCursosCapacitacion() {
    usu = $('#id_usuario').val();
    page = parseInt($('#examen-capacitacion-page').val());
    if (page == 0) $('#tbl-examen-capacitacion tbody').empty();
    if (usu > 0) {
        $.post(url + 'application/usuarios/controllers/AjaxCursosController.php',
            {accion: 'getHistorialCursosCapacitacion', idUsuario: usu, pagina: page},
            function (resp) {
                $('.capacitacion-more').remove();
                if (resp.cursos.length > 0) {
                    $.each(resp.cursos, function (index, item) {
                        tr = $('<tr ></tr>');
                        tr.append('<td class="text-center">' + item.fecha_inicio + '</td>');
                        tr.append('<td class="text-center">' + item.titulo + ' </td>');

                        if (item.status_examen = "finalizado") {
                            tr.append('<td data-id-curso="' + item.id_cursos_internos + '" class="text-center">' + item.calificacion + ' </td>');
                            tr.append('<td class="text-center hidden" >' + item.id_cursos_internos + ' </td>');
                            tr.append('<td class="text-center"><a href="' + url + 'usuarios/exportarReconocimientoCurso/' + usu + '/' + item.id_cursos_internos + '/" target="_blank"><span class="fa fa-file-pdf-o"></a></td>');
                        } else {
                            tr.append('<td class="text-center"></td>');
                            tr.append('<td class="text-center"></td>');
                        }
                        tr.append('<td class="text-center">' + item.status_examen + '</td>');

                        tr.append('<td><input type="checkbox" class="chk-file" title="Agregar a correo"></td>');
                        $('#tbl-examen-capacitacion tbody').append(tr);
                    });

                    if (resp.total > ((page + 1) * 20)) {
                        $('#tbl-examen-capacitacion tfoot').append('<tr><td colspan="8" class="text-center capacitacion-more"><button type="button" class="btn btn-default btn-xs btn-more-capacitacion">Cargar más facturas</button></td></tr>');
                        $('#examen-capacitacion-page').val(page + 1);
                    } else {
                        $('.capacitacion-more').remove();
                    }
                } else {
                    $('#tbl-examen-capacitacion tbody').append('<tr><td colspan="8"><small>No existen facturas para este cliente</small></td></tr>');
                }
            }, 'json');
    }
}

$(document).on('click', '.exp-examen-capacitacion', function () {

    getHistorialCursosCapacitacion();
});


$(document).on('click', '.btn-more-capacitacion', function (event) {
    event.preventDefault();
    $(this).addClass('disabled');
    $(this).html('Cargando..');
    getHistorialCursosCapacitacion();
});

$(document).on('click', '.exp-examen-induccion', function () {

    getHistorialCursosInduccion();
});


function getHistorialCursosInduccion() {
    usu = $('#id_usuario').val();
    page = parseInt($('#examen-induccion-page').val());
    if (page == 0) $('#tbl-examen-induccion tbody').empty();
    if (usu > 0) {
        $.post(url + 'application/usuarios/controllers/AjaxCursosController.php',
            {accion: 'getHistorialCursosInduccion', idUsuario: usu, pagina: page},
            function (resp) {
                $('.induccion-more').remove();
                if (resp.cursos.length > 0) {
                    $.each(resp.cursos, function (index, item) {
                        tr = $('<tr data-id-curso="' + item.id_cursos_internos + '">');
                        tr.append('<td class="text-center">' + item.fecha_limite + '</td>');
                        tr.append('<td data-id-curso="' + item.id_cursos_internos + '" class="text-center">' + item.calificacion + ' </td>');
                        tr.append('<td class="text-center hidden" >' + item.id_cursos_internos + ' </td>');

                        if (item.status_examen = "finalizado") {
                            tr.append('<td class="text-center"><a href="' + url + 'usuarios/exportarReconocimientoCurso/' + usu + '/' + item.id_cursos_internos + '/" target="_blank"><span class="fa fa-file-pdf-o"></a></td>');
                            tr.append('<td data-id-curso="' + item.id_cursos_internos + '" class="text-center">' + item.titulo + ' </td>');
                        } else {
                            tr.append('<td class="text-center"></td>');
                            tr.append('<td class="text-center"></td>');
                        }
                        tr.append('<td class="text-center">' + item.status_examen + '</td>');
                        tr.append('<td><input type="checkbox" class="chk-file" title="Agregar a correo"></td>');

                        $('#tbl-examen-induccion tbody').append(tr);
                    });
                    tr = $('</tr>');


                    if (resp.total > ((page + 1) * 20)) {
                        $('#tbl-examen-induccion tfoot').append('<tr><td colspan="8" class="text-center induccion-more"><button type="button" class="btn btn-default btn-xs btn-more-induccion">Cargar más facturas</button></td></tr>');
                        $('#examen-induccion-page').val(page + 1);
                    } else {
                        $('.induccion-more').remove();
                    }
                } else {
                    $('#tbl-examen-induccion tbody').append('<tr><td colspan="8"><small>No existen facturas para este cliente</small></td></tr>');
                }
            }, 'json');
    }
}

$(document).on('click', '.btn-more-induccion', function (event) {
    event.preventDefault();
    $(this).addClass('disabled');
    $(this).html('Cargando..');
    getHistorialCursosInduccion();
});

var arrFiles = [];
$(document).on('click', '.chk-file', function (event) {
    addFiles();
});

$(document).on('click', '.chk-all', function (event) {
    tbl = $(this).parents('table');//.attr('id');
    chk = $(this);
    $.each(tbl.find('.chk-file'), function (index, elem) {
        $(elem).prop('checked', $(chk).is(':checked'));
    });
    addFiles();
});


function addFiles() {
    arrFiles = [];
    $('#btnMail strong').html('');
    $('#frm-mail .alert:eq(0)').html('');
    var tipoStr = {'examen-capacitacion': 'examen-capacitacion', 'examen-induccion': 'examen-induccion',};
    $.each($('#tabs-exp .chk-file'), function (index, elem) {

        if ($(elem).is(':checked')) {
            tipo = $(elem).parents('table').attr('id').replace('tbl-', '');
            idCurso = $(this).parents("tr").find("td").eq(1);


            usu = $('#id_usuario').val();
            file = $(elem).parents('tr').find('a').eq(0).attr('href').split('/');
            nombre = $(this).parents("tr").find("td").eq(1).html();
            idCurso = $(this).parents("tr").find("td").eq(2).html();


            arrFiles.push({tipo: tipo, file: nombre, idUsuario: usu, idCurso: idCurso});
            $('#frm-mail .alert:eq(0)').append('<small><strong>' + (tipoStr[tipo] == undefined ? 'documento' : tipoStr[tipo]) + '</strong> ' + nombre + '</small><br>');

        }
    });
    $('#btnMail strong').html('(' + arrFiles.length + ')');
}

$('#btnMail').click(function () {
    //$('#mail-mail').val($('#emailFacturacion').val());
    $('#mail-asunto').val('');
    $('#mail-msg').val('');
    $('#frm-mail .alert:eq(1)').removeClass('alert-danger').removeClass('alert-success').addClass('alert-info').text('Aún no hay documento');
    ;
    $('#frm-mail .files').addClass('hide');
    $('#frm-mail').trigger('reset');
    if (arrFiles.length > 0) $('#frm-mail .files').removeClass('hide');
    $('#modal-mail').modal('show');
});


$('#btnSendMail').click(function () {
    // data = validaFormRes();
    //if(data){
    var formData = new FormData($('#frm-mail')[0]);
    formData.append('accion', 'sendMail');
    formData.append('idUsuario', $('#id_usuario').val());
    formData.append('files', JSON.stringify(arrFiles));
    $.ajax({
        url: url + 'application/usuarios/controllers/AjaxCursosController.php',
        type: 'post',
        dataType: 'json',
        contentType: false,
        processData: false,
        data: formData,
        beforeSend: function () {
            $('#btnSendMail').button('loading').prop('disabled', true);
            abreAlerta('Enviando correo. Por favor espere..');
            $('#btnCerrarModalAlerta').addClass('hide');
            $('#modal-mail').modal('hide');
        },
        success: function (resp) {
            $('#btnCerrarModalAlerta').removeClass('hide');
            if (resp.status) {
                abreAlerta(resp.mensaje);
                guardado = true;
                $('.chk-all').prop('checked', false);
                $('.chk-file').prop('checked', false);
                arrFiles = [];
                $('#btnMail strong').html('');
            } else {
                abreAlerta(resp.mensaje);
            }
            $('#btnSendMail').button('reset').prop('disabled', false);
        },
        error: function () {
            $('#btnSendMail').button('reset').prop('disabled', false);
            abreAlerta('Lo siento, ocurrió un error al enviar el correo. ' + msjTicket);
        }
    });
    //}
});

$(document).on('click', '.exp-cuestionario-riesgo-psicologico', function () {

    getHistorialCuestionarioRiesgos();
});

$(document).on('click', '.btn-more-cuestionario', function (event) {
    event.preventDefault();
    $(this).addClass('disabled');
    $(this).html('Cargando..');
    getHistorialCuestionarioRiesgos();
});

function getHistorialCuestionarioRiesgos() {
    usu = $('#id_usuario').val();
    page = parseInt($('#examen-cuestionario-page').val());
    if (page == 0) $('#tbl-cuestionario tbody').empty();
    if (usu > 0) {
        $.post(url + 'application/balance/controllers/AjaxCuestionarioController.php',
            {accion: 'getCuestionariosPorUsuario', idUsuario: usu, pagina: page},
            function (resp) {

                console.log(resp, 'resp');
                $('.cuestionario-more').remove();
                if (resp.cuestionarios.length > 0) {
                    $.each(resp.cuestionarios, function (index, item) {
                        tr = $('<tr data-id-curso="' + item.id_cuestionario_riesgos_psicologicos + '">');
                        tr.append('<td class="text-center">' + item.created_at + '</td>');
                        tr.append('<td class="text-center " >' + item.status + ' </td>');

                        if (item.status == "finalizado") {
                            tr.append('<td class="text-center"><a data-id="' + item.id_cuestionario_riesgos_psicologicos + '" href="javascript:void(0);" class=" pdfCuestionario " ><span class="fa fa-file-pdf-o"></a></td>');
                        } else {
                            tr.append('<td class="text-center " ></td>');

                        }
                        tr.append('<td><input type="checkbox" class="chk-file" title="Agregar a correo"></td>');

                        $('#tbl-cuestionario tbody').append(tr);
                    });
                    tr = $('</tr>');


                    if (resp.total > ((page + 1) * 20)) {
                        $('#tbl-cuestionario tfoot').append('<tr><td colspan="8" class="text-center cuestionario-more"><button type="button" class="btn btn-default btn-xs btn-more-cuestionario">Cargar más cuestionarios</button></td></tr>');
                        $('#examen-cuestionario-page').val(page + 1);
                    } else {
                        $('.cuestionario-more').remove();
                    }
                } else {
                    $('#tbl-cuestionario tbody').append('<tr><td colspan="8"><small>No existen cuestionarios para este usuario</small></td></tr>');
                }
            }, 'json');
    }
}


$(document).on('click', '.pdfCuestionario', function () {
    id = $(this).attr('data-id');
    console.log(id, ' id ');
    obtenerpdfCuestionario(id);
});

function obtenerpdfCuestionario(id) {

    $.ajax({
        url: app + 'obtenerPdfCuestionario',
        type: 'get',
        responseType: 'ArrayBuffer ',
        data: {
            idCuestionarioRiesgos: id
        },
        success: function (response) {

            let binaryString = window.atob(response);
            let binaryLen = binaryString.length;
            let bytes = new Uint8Array(binaryLen);

            for (let i = 0; i < binaryLen; i++) {
                let ascii = binaryString.charCodeAt(i);
                bytes[i] = ascii;
            }

            let blob = new Blob([bytes], {type: "application/pdf"});
            let link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            window.open(link.href);

        },
        error: function (xhr, responseText, thrownError) {

            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });

}


$(document).on('click', '.exp-sugerencias-alertas', function () {

    getHistorialSugerenciasAlertas();
});

$(document).on('click', '.btn-more-sugerencias', function (event) {
    event.preventDefault();
    $(this).addClass('disabled');
    $(this).html('Cargando..');
    getHistorialSugerenciasAlertas();
});

function getHistorialSugerenciasAlertas() {
    usu = $('#id_usuario').val();
    page = parseInt($('#examen-sugerencias-page').val());
    if (page == 0) $('#tbl-sugerencias-alertas tbody').empty();
    if (usu > 0) {
        $.post(url + 'application/usuarios/controllers/AjaxController.php',
            {accion: 'getSugerenciasYAlertasPorUsuario', idUsuario: usu, pagina: page},
            function (resp) {


                $('.sugerencias-more').remove();
                if (resp.tareas.length > 0) {
                    $.each(resp.tareas, function (index, item) {
                        tr = $('<tr >');
                        tr.append('<td class="text-center">' + item.descripcion + '</td>');
                        tr.append('<td class="text-center">' + item.created_at + '</td>');
                        tr.append('<td class="text-center " >' + item.status + ' </td>');

                        if (item.status != "rechazado") {
                            if (item.tipo == 'sugerencia') {

                                tr.append('<td class="text-center"><a data-id-seguridad="' + item.id_tareas_seguridad + '" data-id-tarea="' + item.id_tarea_no_conformidad + '"  href="javascript:void(0);" class="pdfSugerencia" ><span class="fa fa-file-pdf-o"></a></td>');
                            } else {
                                tr.append('<td class="text-center"><a data-id-seguridad="' + item.id_tareas_seguridad + '" data-id-tarea="' + item.id_tarea_no_conformidad + '"  href="javascript:void(0);" class=" pdfAlerta " ><span class="fa fa-file-pdf-o"></a></td>');

                            }
                        } else {
                            tr.append('<td class="text-center " ></td>');

                        }
                        tr.append('<td><input type="checkbox" class="chk-file" title="Agregar a correo"></td>');

                        $('#tbl-sugerencias-alertas tbody').append(tr);
                    });
                    tr = $('</tr>');


                    if (resp.total > ((page + 1) * 20)) {
                        $('#tbl-sugerencias-alertas tfoot').append('<tr><td colspan="8" class="text-center sugerencias-more"><button type="button" class="btn btn-default btn-xs btn-more-sugerencias">Cargar más tareas</button></td></tr>');
                        $('#examen-sugerencias-page').val(page + 1);
                    } else {
                        $('.sugerencias-more').remove();
                    }
                } else {
                    $('#tbl-sugerencias-alertas tbody').append('<tr><td colspan="8"><small>No existen tareas para este usuario</small></td></tr>');
                }
            }, 'json');
    }
}

$(document).on('click', '.pdfSugerencia', function () {
    idtareaNoConformidad = $(this).attr('data-id-tarea');
    idSeguridad = $(this).attr('data-id-seguridad');

    obtenerpdfSugerencia(idtareaNoConformidad, idSeguridad);
});

function obtenerpdfSugerencia(idtareaNoConformidad, idSeguridad) {

    $.ajax({
        url: app + 'obtenerPdfSugerencia',
        type: 'get',
        responseType: 'ArrayBuffer ',
        data: {
            idtareaNoConformidad: idtareaNoConformidad,
            idSeguridad: idSeguridad
        },
        success: function (response) {

            let binaryString = window.atob(response);
            let binaryLen = binaryString.length;
            let bytes = new Uint8Array(binaryLen);

            for (let i = 0; i < binaryLen; i++) {
                let ascii = binaryString.charCodeAt(i);
                bytes[i] = ascii;
            }

            let blob = new Blob([bytes], {type: "application/pdf"});
            let link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            window.open(link.href);

        },
        error: function (xhr, responseText, thrownError) {

            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });

}


$(document).on('click', '.pdfAlerta', function () {
    idtareaNoConformidad = $(this).attr('data-id-tarea');
    idSeguridad = $(this).attr('data-id-seguridad');

    obtenerpdfAlerta(idtareaNoConformidad, idSeguridad);
});

function obtenerpdfAlerta(idtareaNoConformidad, idSeguridad) {

    $.ajax({
        url: app + 'obtenerPdfAlerta',
        type: 'get',
        responseType: 'ArrayBuffer ',
        data: {
            idtareaNoConformidad: idtareaNoConformidad,
            idSeguridad: idSeguridad
        },
        success: function (response) {

            let binaryString = window.atob(response);
            let binaryLen = binaryString.length;
            let bytes = new Uint8Array(binaryLen);

            for (let i = 0; i < binaryLen; i++) {
                let ascii = binaryString.charCodeAt(i);
                bytes[i] = ascii;
            }

            let blob = new Blob([bytes], {type: "application/pdf"});
            let link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            window.open(link.href);

        },
        error: function (xhr, responseText, thrownError) {

            error = mostrarMensajeError(xhr, responseText, thrownError);
            abreAlerta(error);
        }
    });

}

$(document).on('click', '#btnConstancia', function () {
    console.log("ADFJHSDF");
    $('#pdfConstancia').click();
});

$(document).on('change', '#pdfConstancia', function () {
    clase = $('#pdfValidoConstancia').attr('class');
    archivo = this.files[0];
    tipo = archivo.type;

    if (tipo != 'application/pdf') {
        $('#pdfValidoConstancia').removeClass().addClass('alert alert-danger').text('Debes subir un archivo PDF. -_-').fadeIn("slow");
        $('#pdfValidoValueConstancia').val(0);
        document.getElementById('pdfConstancia').value = '';
        return false;
    } else {
        $('#pdfValidoConstancia').removeClass().text('');
        $('#pdfValidoValueConstancia').val(1);
        u.cargarDatosPdf();
    }

    $('#pdfValidoConstancia').val(1);
    $('#btnConstancia').html('<span class="fa fa-file-pdf-o"></span> PDF seleccionado');


});

