<?php
/**
 * AsistenciaDao.php
 * Modelo para la persistencia de datos de asistencias
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . 
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Asistencia.php';

class AsistenciaDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function validarAsistencia($fecha, $idUsuario)
    {
        $sql = "SELECT `Id_Asistencia` FROM `asistencia` WHERE `Fecha` = ? AND "
                . "`Id_Usuario` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['asistencia'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al validar la asistencia '
                    . 'del día. ' .TICKETS;
        }
        
        return $response;
    }

    public function obtenerAsistencia($fecha, $idUsuario)
    {
        $sql = "SELECT * FROM `asistencia` WHERE `Fecha` = ? AND "
                . "`Id_Usuario` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['asistencia'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al validar la asistencia '
                    . 'del día. ' .TICKETS;
        }
        
        return $response;
    }
    
    public function calcularTiempos($horaEntrada, $horaRegistro)
    {
        $h1 = strtotime($horaEntrada);
        $h2 = strtotime($horaRegistro);

        if ($h2 < $h1){
             $diferencia = date("H:i:s", strtotime("00:00:00") + strtotime($horaRegistro) - strtotime('09:01:00'));
        }

        $diferencia = date("H:i:s", strtotime("00:00:00") + strtotime($horaRegistro) - strtotime($horaEntrada));
        return $diferencia;
    }
    
    public function aDecimal($hora)
    {
        $desglose = explode(":", $hora);
        
        $decimales = $desglose[0] + ($desglose[1]/ 60);
        
        return $decimales;
    }
    
    public function registrarAsistencia(Asistencia $a)
    {
        $sql = "INSERT INTO `asistencia` (`Id_Usuario`, `Fecha`, `Hora_Entrada`,"
                . " `Hora_Salida`, `Id_Sucursal`, `Observaciones`, `Asistencia`) "
                . "VALUES(?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $a->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(2, $a->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(3, $a->__get('_horaEntrada'), PDO::PARAM_STR);
        $stmt->bindValue(4, $a->__get('_horaSalida'), PDO::PARAM_STR);
        $stmt->bindValue(5, $a->__get('_idSucursal'), PDO::PARAM_INT);
        $stmt->bindValue(6, $a->__get('_observaciones'), PDO::PARAM_STR);
        $stmt->bindValue(7, $a->__get('_asistencia'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al registrar la asistencia. ' . TICKETS;
        }
        
        return $response;
    }

    public function registrarSalida($hora, $idUsuario, $idAsistencia)
    {
        $sql = "UPDATE `asistencia` SET `Hora_Salida` = ? WHERE `Id_Usuario` = ? AND `Id_Asistencia` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $hora, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(3, $idAsistencia, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;            
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al registrar tu hora de salida. ';
        }

        return $response;
    }
    
    public function getAsistentes($fecha, $sucursal){
        $sql = "SELECT *, (SELECT CONCAT(Nombre,' ',Apellido_Paterno,' ',Apellido_Materno) FROM usuarios u WHERE u.Id_Usuario = a.Id_Usuario) AS nomUser FROM `asistencia` a WHERE `Fecha` = ? AND "
                . "`Id_Sucursal` = ? AND `a`.`Id_Usuario` not in (111, 30, 63)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $sucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['asistentes'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al traer los registros de asistencia '
                    . 'del día. ' .TICKETS;
        }
        
        return $response;
    }

    public function updateAsistencia($user, $status, $fecha, $sucursal){
        $sql = "UPDATE `asistencia` SET Asistencia = ? WHERE `Id_Usuario` = ? AND Fecha = ? AND Id_Sucursal = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_INT);
        $stmt->bindValue(2, $user, PDO::PARAM_INT);
        $stmt->bindValue(3, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(4, $sucursal, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al cambiar el status de asistencia '
                    . 'del día. ' .TICKETS;
        }
        
        return $response;
    }

    public function obtenerAsistencias($idUsuario, $fechaInicial, $fechaFinal)
    {
        $sql = "SELECT * FROM `asistencia` WHERE `Id_Usuario` = ? AND `Fecha` BETWEEN ? AND ? ORDER BY `Fecha` ASC";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFinal, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['asistencias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de asistencia '
                    . TICKETS;
        }

        return $response;
    }

    public function obtenerAsistenciasReporteSucursal($idSucursal, $fechaInicial, $fechaFinal)
    {
        $sql = "SELECT * FROM `asistencia`
 INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `asistencia`.`Id_Usuario`
 inner join nomina on nomina.Id_Usuario = usuarios.Id_Usuario
 WHERE `asistencia`.`Id_Sucursal` = ? 
 AND `asistencia`.`Fecha` BETWEEN ? AND ? and nomina.tipo_nomina is not null ORDER BY `asistencia`.`Fecha` ASC";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFinal, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = false;
            $response['asistencias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de asistencia '
                . TICKETS;
        }

        return $response;
    }


    public function obtenerAsistenciasReporteUsuario($idUsuario, $fechaInicial, $fechaFinal)
    {
        $sql = "SELECT * FROM `asistencia` INNER JOIN `usuarios` ON `usuarios`.`Id_Usuario` = `asistencia`.`Id_Usuario` WHERE `asistencia`.`Id_Usuario` = ? AND `asistencia`.`Fecha` BETWEEN ? AND ? ORDER BY `asistencia`.`Fecha` ASC";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFinal, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = false;
            $response['total'] = $stmt->rowCount();
            $response['asistencias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de asistencia '
                    . TICKETS;
        }

        return $response;
    }

    public function justificaAsistencia($idAsistencia, $status, $observaciones)
    {
        $sql = "UPDATE `asistencia` SET `Asistencia` = ? `Observaciones` = ? WHERE `Id_Asistencia` = ?";
    }

}