<?php
/**
 * CompetenciaMandoDao.php
 * Modelo para la persistencia de datos de competencia con mando
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'CompetenciaMando.php';

class CompetenciaMandoDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(CompetenciaMando $c)
    {
        $sql = "INSERT INTO `competencia_mando` (`Id_Periodo`, `Id_Usuario`, `Pregunta1`, "
                . "`Pregunta2`, `Pregunta3`, `Pregunta4`, `Pregunta5`, `Pregunta6`, "
                . "`Pregunta7`, `Pregunta8`, `Pregunta9`, `Pregunta10`, `pregunta11`, "
                . "`Pregunta12`, `Pregunta13`, `Pregunta14`, `Pregunta15`, `Total_Puntos`, `Total_Evaluacion`) "
                . "VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_idPeriodo'), PDO::PARAM_INT);
        $stmt->bindValue(2, $c->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(3, $c->__get('_pregunta1'), PDO::PARAM_INT);
        $stmt->bindValue(4, $c->__get('_pregunta2'), PDO::PARAM_INT);
        $stmt->bindValue(5, $c->__get('_pregunta3'), PDO::PARAM_INT);
        $stmt->bindValue(6, $c->__get('_pregunta4'), PDO::PARAM_INT);
        $stmt->bindValue(7, $c->__get('_pregunta5'), PDO::PARAM_INT);
        $stmt->bindValue(8, $c->__get('_pregunta6'), PDO::PARAM_INT);
        $stmt->bindValue(9, $c->__get('_pregunta7'), PDO::PARAM_INT);
        $stmt->bindValue(10, $c->__get('_pregunta8'), PDO::PARAM_INT);
        $stmt->bindValue(11, $c->__get('_pregunta9'), PDO::PARAM_INT);
        $stmt->bindValue(12, $c->__get('_pregunta10'), PDO::PARAM_INT);
        $stmt->bindValue(13, $c->__get('_pregunta11'), PDO::PARAM_INT);
        $stmt->bindValue(14, $c->__get('_pregunta12'), PDO::PARAM_INT);
        $stmt->bindValue(15, $c->__get('_pregunta13'), PDO::PARAM_INT);
        $stmt->bindValue(16, $c->__get('_pregunta14'), PDO::PARAM_INT);
        $stmt->bindValue(17, $c->__get('_pregunta15'), PDO::PARAM_INT);
        $stmt->bindValue(18, $c->__get('_totalPuntos'), PDO::PARAM_STR);
        $stmt->bindValue(19, $c->__get('_totalEvaluacion'), PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCompentencia'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos de competencia con mando. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function actualizar(CompetenciaMando $c)
    {
        $sql = "UPDATE `competencia_mando` SET `Pregunta1` = ?, `Pregunta2` = ?, `Pregunta3` = ?, `Pregunta4` = ?, "
                . "`Pregunta5` = ?, `Pregunta6` = ?, `Pregunta7` = ?, `Pregunta8` = ?, `Pregunta9` = ?, "
                . "`Pregunta10` = ?, `pregunta11` = ?, `Pregunta12` = ?, `Pregunta13` = ?, `Pregunta14` = ?, `Pregunta15` = ?, "
                . "`Total_Puntos` = ?, `Total_Evaluacion` = ? WHERE `Id_Usuario` = ? AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_pregunta1'), PDO::PARAM_INT);
        $stmt->bindValue(2, $c->__get('_pregunta2'), PDO::PARAM_INT);
        $stmt->bindValue(3, $c->__get('_pregunta3'), PDO::PARAM_INT);
        $stmt->bindValue(4, $c->__get('_pregunta4'), PDO::PARAM_INT);
        $stmt->bindValue(5, $c->__get('_pregunta5'), PDO::PARAM_INT);
        $stmt->bindValue(6, $c->__get('_pregunta6'), PDO::PARAM_INT);
        $stmt->bindValue(7, $c->__get('_pregunta7'), PDO::PARAM_INT);
        $stmt->bindValue(8, $c->__get('_pregunta8'), PDO::PARAM_INT);
        $stmt->bindValue(9, $c->__get('_pregunta9'), PDO::PARAM_INT);
        $stmt->bindValue(10, $c->__get('_pregunta10'), PDO::PARAM_INT);
        $stmt->bindValue(11, $c->__get('_pregunta11'), PDO::PARAM_INT);
        $stmt->bindValue(12, $c->__get('_pregunta12'), PDO::PARAM_INT);
        $stmt->bindValue(13, $c->__get('_pregunta13'), PDO::PARAM_INT);
        $stmt->bindValue(14, $c->__get('_pregunta14'), PDO::PARAM_INT);
        $stmt->bindValue(15, $c->__get('_pregunta15'), PDO::PARAM_INT);
        $stmt->bindValue(16, $c->__get('_totalPuntos'), PDO::PARAM_INT);
        $stmt->bindValue(17, $c->__get('_totalEvaluacion'), PDO::PARAM_INT);
        $stmt->bindValue(18, $c->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(19, $c->__get('_idPeriodo'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerCompetenciaMandoPorUsuario($idUsuario, $idPeriodo)
    {
        $sql = "SELECT * FROM `competencia_mando` WHERE `Id_Usuario` = ? AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idPeriodo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['compentencia'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['totalRegistros'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de evaluación de competencia. '
                    . TICKETS;
        }
        
        return $response;
    }
}