<?php
/**
 * CompetenciaTemporalDao.php
 * Modelo para la persistencia de datos de competencias
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'CompetenciaTemporal.php';

class CompetenciaTemporalDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(CompetenciaTemporal $c)
    {
        $sql = "INSERT INTO `competencias_actividades_temporal` (`Id_Usuario`, `Id_Periodo`, `Competencia`,"
                . "`Accion`, `Actividad`, `Fecha`) VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(2, $c->__get('_idPeriodo'), PDO::PARAM_INT);
        $stmt->bindValue(3, $c->__get('_competencia'), PDO::PARAM_STR);
        $stmt->bindValue(4, $c->__get('_accion'), PDO::PARAM_STR);
        $stmt->bindValue(5, $c->__get('_actividad'), PDO::PARAM_STR);
        $stmt->bindValue(6, $c->__get('_fecha'), PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar tus competencias. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerCompentencias($idUsuario, $idPeriodo)
    {
        $sql = "SELECT * FROM `competencias_actividades_temporal` WHERE `Id_Usuario` = ? "
                . "AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idPeriodo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['competencias'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['hayCompetencias'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de tus competencias. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function actualizarActividad($id, $actividad, $fecha)
    {
        $sql = "UPDATE `competencias_actividades_temporal` SET `Actividad` = ?, `Fecha` = ? WHERE "
                . "`Id_Competencia_Actividad` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $actividad, PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(3, $id, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar tus competencias. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function eliminaCompetencia($idCompetencia)
    {
        $sql = "DELETE FROM `competencias_actividades_temporal` WHERE `Id_Competencia_Actividad` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCompetencia, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al eliminar la actividad. ' . TICKETS;
        }
        
        return $response;
    }
}