<?php
/**
 * CompromisosMejoraDao.php
 * Modelo para la persistencia de datos de compromisos de mejora
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'CompromisosMejora.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class CompromisosMejoraDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(CompromisosMejora $c)
    {
        $sql = "INSERT INTO `compromisos_mejora_temporal` (`Id_Indicador`, `Expectativa`, `Actividad`, `Fecha`, "
                . "`Status`, `Id_Usuario`, `Id_Periodo`) VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $c->__get('_idIndicador'), PDO::PARAM_INT);
        $stmt->bindValue(2, $c->__get('_expectativa'), PDO::PARAM_STR);
        $stmt->bindValue(3, $c->__get('_actividad'), PDO::PARAM_STR);
        $stmt->bindValue(4, $c->__get('_fecha'), PDO::PARAM_STR);
        $stmt->bindValue(5, $c->__get('_status'), PDO::PARAM_INT);
        $stmt->bindValue(6, $c->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(7, $c->__get('_idPeriodo'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerCompromisosMejoraTemporal($idUsuario, $idPeriodo)
    {
        $sql = "SELECT * FROM `compromisos_mejora_temporal` WHERE `Id_Usuario` = ? "
                . "AND `Id_Periodo` = ? ORDER BY Id_Indicador ASC";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idPeriodo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['compromisos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['hayCompromisos'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los compromisos '
                    . 'de mejora. ' .TICKETS;
        }
        
        return $response;
    }    
    
    public function actualizaActividad($id, $actividad, $fecha)
    {
        $sql = "UPDATE `compromisos_mejora_temporal` SET `Actividad` = ?, "
                . "`Fecha` = ? WHERE `Id_Compromiso_Mejora` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $actividad, PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(3, $id, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar los datos de tu actividad '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function actualizarExpectativa($expectativa, $idIndicador, $idUsuario, $idPeriodo)
    {
        $sql = "UPDATE `compromisos_mejora_temporal` SET `Expectativa` = ? WHERE `Id_Indicador` = ? AND `Id_Usuario` = ? AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $expectativa, PDO::PARAM_STR);
        $stmt->bindValue(2, $idIndicador, PDO::PARAM_INT);
        $stmt->bindValue(3, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(4, $idPeriodo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = ':( Lo siento, ocurrió un error al actualizar la expectativa. ' . TICKETS;
        }
        
        return $response;   
    }
    
    public function rechazarActividad($idActividad)
    {
        $sql = "DELETE FROM `compromisos_mejora_temporal` WHERE `Id_Compromiso_Mejora` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idActividad, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al rechazar la actividad. ' . TICKETS;
        }
        
        return $response;
    }
}