<?php
/**
 * AsistenciaDao.php
 * Modelo para la persistencia de datos de asistencias
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class CursoInduccionDao extends Model
{
    public function __construct() {
        parent::__construct();
    }

    public function obtenerCursosPorUsuario( $status, $idUsuario ,$inicio, $registros){
        $sql = "select SQL_CALC_FOUND_ROWS * from curso_interno_induccion as cii
inner join cursos_internos as ci on ci.id_cursos_internos = cii.id_cursos_internos
where cii.status_examen = ? and cii.id_usuario = ? LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerPreguntasExamen( $id_curso_induccion){
        $sql = "select  * from curso_interno_induccion as cii
inner join cursos_internos as ci on ci.id_cursos_internos = cii.id_cursos_internos
inner join cursos_internos_preguntas as cip on cip.id_cursos_internos = cii.id_cursos_internos
where cii.id_curso_interno_induccion = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_curso_induccion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer las preguntas. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarCursoInduccion( $calificacion, $status_examen, $id_curso_induccion ){
        $sql = "update curso_interno_induccion set calificacion = ?, status_examen=? where id_curso_interno_induccion = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $calificacion, PDO::PARAM_STR);
        $stmt->bindValue(2, $status_examen, PDO::PARAM_STR);
        $stmt->bindValue(3, $id_curso_induccion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar el examen de induccion. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursoPorIdCursoInduccion( $id_curso_induccion){
        $sql = "select  * from curso_interno_induccion as cii
inner join cursos_internos as ci on ci.id_cursos_internos = cii.id_cursos_internos
inner join usuarios as u on u.Id_Usuario = cii.id_usuario
where cii.id_curso_interno_induccion = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_curso_induccion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['curso'] = $stmt->fetch(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener la informacion del curso. ' . TICKETS;
        }

        return $response;
    }

    public function asignarCursosInduccion( $idUsuario, $fechaLimite, $tipoUsuario){
        $sql = "insert into curso_interno_induccion (id_usuario, id_cursos_internos, status_examen, fecha_limite, calificacion)
select ?, ci.id_cursos_internos, 'progreso', ?, null
from cursos_internos as ci
inner join tipo_usuario_curso as tic on tic.id_cursos_internos = ci.id_cursos_internos
where tic.tipo_usuario = ? and ci.status = 1";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaLimite, PDO::PARAM_STR);
        $stmt->bindValue(3, $tipoUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al asignar los cursos de induccion. ' . TICKETS;
        }

        return $response;
    }


}