<?php
/**
 * AsistenciaDao.php
 * Modelo para la persistencia de datos de asistencias
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class CursoInternoParticipantesDao extends Model
{
    public function __construct() {
        parent::__construct();
    }

    public function obtenerCursosPorParticipante( $status, $idUsuario ,$inicio, $registros){
        $sql = "select SQL_CALC_FOUND_ROWS * from curso_interno_participantes as cip
inner join curso_interno_capacitacion as cir on cir.id_curso_interno_capacitacion = cip.id_curso_interno_capacitacion
inner join cursos_internos as ci on ci.id_cursos_internos = cir.id_cursos_internos
where cip.status_examen = ? and cip.id_usuario = ? LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerPreguntasExamen( $id_curso_interno_participantes){
        $sql = "select * from curso_interno_participantes as cia
inner join curso_interno_capacitacion as cic on cic.id_curso_interno_capacitacion = cia.id_curso_interno_capacitacion
inner join cursos_internos_preguntas as cip on cip.id_cursos_internos = cic.id_cursos_internos
where cia.id_curso_interno_participantes = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_curso_interno_participantes, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['preguntas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer las preguntas. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarExamen( $calificacion, $status_examen, $id_curso_interno_participantes ){
        $sql = "update curso_interno_participantes set calificacion = ?, status_examen=? where id_curso_interno_participantes = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $calificacion, PDO::PARAM_STR);
        $stmt->bindValue(2, $status_examen, PDO::PARAM_STR);
        $stmt->bindValue(3, $id_curso_interno_participantes, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar el examen. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursoPoiIdCursoInternoParticipantes( $id_curso_interno_participantes){
        $sql = "select * from curso_interno_participantes as cip
inner join curso_interno_capacitacion as cir on cir.id_curso_interno_capacitacion = cip.id_curso_interno_capacitacion
inner join cursos_internos as ci on ci.id_cursos_internos = cir.id_cursos_internos
inner join usuarios as u on u.Id_Usuario = cip.id_usuario
where  cip.id_curso_interno_participantes = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_curso_interno_participantes, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['curso'] = $stmt->fetch(PDO::FETCH_OBJ);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener la informacion del curso. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursosPorResponsable( $status, $idUsuario ,$inicio, $registros){
        $sql = "select SQL_CALC_FOUND_ROWS * from curso_interno_capacitacion as cir
inner join cursos_internos as ci on ci.id_cursos_internos = cir.id_cursos_internos
where cir.status_curso = ? and ci.id_usuario_responsable = ? LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al traer los cursos. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusCurso(  $statusCurso, $listaAsistencia,  $idCursoCapacitacion ){
        $sql = "update curso_interno_capacitacion set status_curso = ?, lista_asistencia = ? where id_curso_interno_capacitacion = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $statusCurso, PDO::PARAM_STR);
        $stmt->bindValue(2, $listaAsistencia, PDO::PARAM_STR);
        $stmt->bindValue(3, $idCursoCapacitacion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al actualizar el status del curso. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerProximosCursos( $fecha, $tipoUsuario ,$inicio, $registros){
        $sql = "select SQL_CALC_FOUND_ROWS * from cursos_internos as ci
inner join tipo_usuario_curso as tuc on tuc.id_cursos_internos = ci.id_cursos_internos
where ci.Fecha > ? and tuc.tipo_usuario =  ? LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $tipoUsuario, PDO::PARAM_INT);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los proximos cursos. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerAsistenciasEnAutorizacion( $status, $inicio, $registros, $tipoCurso){
        $sql = "select SQL_CALC_FOUND_ROWS *, ns.nombre_norma as norma_seguridad, cc.nombre_norma as norma_calidad from curso_interno_capacitacion as cir
inner join cursos_internos as ci on ci.id_cursos_internos = cir.id_cursos_internos
inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
left join codigo_calidad as cc on cc.id_codigo_calidad = ci.codigo_lista_asistencia
left join normas_seguridad as ns on ns.id_normas_seguridad = ci.id_normas_seguridad
where cir.status_curso = ? and ci.tipo_curso = ?  LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $tipoCurso, PDO::PARAM_STR);
        $stmt->bindValue(3, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(4, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener la lista de asistencias en autorizacion ' . TICKETS;
        }

        return $response;
    }

    public function autorizarListaAsistencia( $status, $idCursoCapacitacion ){
        $sql = "update curso_interno_capacitacion set status_curso =  ? where id_curso_interno_capacitacion = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idCursoCapacitacion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al autorizar la lista de asistencia. ' . TICKETS;
        }

        return $response;
    }

    public function rechazarListaAsistencia( $status, $fecha, $razon, $idCursoCapacitacion ){
        $sql = "update curso_interno_capacitacion set status_curso =  ?, fecha_limite_asistencia = ?, razon_rechazo = ? where id_curso_interno_capacitacion = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(3, $razon, PDO::PARAM_STR);
        $stmt->bindValue(4, $idCursoCapacitacion, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al rechazar la lista de asistencia. ' . TICKETS;
        }

        return $response;
    }

    public function agregarCursoCapacitacion( $idCursoInterno, $fecha, $status, $fechaLimiteAsistencia){
        $sql = "insert into curso_interno_capacitacion (id_cursos_internos,fecha_inicio,status_curso,fecha_limite_asistencia )
        VALUES (?, ?, ?, ?);";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCursoInterno, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(3, $status, PDO::PARAM_STR);
        $stmt->bindValue(4, $fechaLimiteAsistencia, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCursoCapacitacion'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al dar de alta un curso de capacitacion. ' . TICKETS;
        }

        return $response;
    }

    public function agregarCursoParticipante( $idUsuario, $idCursoCapacitacion, $status){
        $sql = "insert into curso_interno_participantes(id_usuario,id_curso_interno_capacitacion,status_examen )
        VALUES (?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCursoCapacitacion, PDO::PARAM_INT);
        $stmt->bindValue(3, $status, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCursoParticipante'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al dar de alta un curso al participante. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursosEnProgresoVencidos( $fecha, $idUsuario){
        $sql = "select * from cursos_internos as ci 
inner join curso_interno_capacitacion as cic on cic.id_cursos_internos = ci.id_cursos_internos
where fecha_limite_asistencia <= ? and status_curso = 'progreso' and id_usuario_responsable = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener la lista de asistencias en autorizacion ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursosParticipantesBloqueo( $idUsuario, $fecha){
        $sql = "select * from curso_interno_participantes as cip 
inner join curso_interno_capacitacion as cic on cic.id_curso_interno_capacitacion = cip.id_curso_interno_capacitacion 
inner join cursos_internos as ci on ci.id_cursos_internos = cic.id_cursos_internos
 inner join cursos_internos_preguntas as cipr on cipr.id_cursos_internos = ci.id_cursos_internos
 where cip.id_usuario = ? and cip.status_examen = 'progreso' and cic.fecha_inicio <= ? and ci.capacitacion = 1 GROUP by ci.id_cursos_internos";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);

        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los cursos en progreso del participante ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursoCapacitacionPorFecha( $idCursoInterno, $fecha){
        $sql = "select * from curso_interno_capacitacion as cir
inner join cursos_internos as ci on ci.id_cursos_internos = cir.id_cursos_internos
where ci.id_cursos_internos = ? and cir.fecha_inicio = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idCursoInterno, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los cursos por fecha. ' . TICKETS;
        }

        return $response;
    }

    public function actualizarCursoCapacitacion( $idCursoInterno, $fecha, $status, $fechaLimiteAsistencia){

        $sql = "update curso_interno_capacitacion set fecha_inicio = ?,  fecha_limite_asistencia = ? where id_cursos_internos = ? and fecha_inicio = ?";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fecha, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaLimiteAsistencia, PDO::PARAM_STR);
        $stmt->bindValue(3, $idCursoInterno, PDO::PARAM_INT);
        $stmt->bindValue(4, $fecha, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCursoCapacitacion'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al dar actualizar un curso de capacitacion. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerCursoParticipante( $idUsuario, $idCursoCapacitacion , $status){
        $sql = "select * from curso_interno_participantes as cip
inner join  curso_interno_capacitacion as cir on cir.id_curso_interno_capacitacion = cip.id_curso_interno_capacitacion
inner join cursos_internos as ci on ci.id_cursos_internos = cir.id_cursos_internos
where cip.id_usuario = ?  and cip.id_curso_interno_capacitacion = ? and cip.status_examen = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCursoCapacitacion, PDO::PARAM_INT);
        $stmt->bindValue(3, $status, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener los cursos asignados a participantes. ' . TICKETS;
        }

        return $response;
    }

    public function actulizarCursoParticipante( $idUsuario, $idCursoCapacitacion, $status){
        $sql = "insert into curso_interno_participantes(id_usuario,id_curso_interno_capacitacion,status_examen )
        VALUES (?, ?, ?)";
        $sql = "update curso_interno_participantes set fecha_inicio = ?,  fecha_limite_asistencia = ? where id_cursos_internos = ? and fecha_inicio = ?";

        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idCursoCapacitacion, PDO::PARAM_INT);
        $stmt->bindValue(3, $status, PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idCursoParticipante'] = $this->_dbh->lastInsertId();
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al dar de alta un curso al participante. ' . TICKETS;
        }

        return $response;
    }

    public function obtenerAsistenciasPorAutorizar( $status, $inicio, $registros ){
        $sql = "select SQL_CALC_FOUND_ROWS *, ns.nombre_norma as norma_seguridad, cc.nombre_norma as norma_calidad from curso_interno_capacitacion as cir
inner join cursos_internos as ci on ci.id_cursos_internos = cir.id_cursos_internos
inner join usuarios as u on u.Id_Usuario = ci.id_usuario_responsable
left join codigo_calidad as cc on cc.id_codigo_calidad = ci.codigo_lista_asistencia
left join normas_seguridad as ns on ns.id_normas_seguridad = ci.id_normas_seguridad
where cir.status_curso = ?   LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['cursos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $this->_dbh->query('SELECT FOUND_ROWS();')->fetch(PDO::FETCH_COLUMN);
        }catch(PDOException $e){
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Ocurrió un error al obtener la lista de asistencias en autorizacion ' . TICKETS;
        }

        return $response;
    }
}