<?php
/**
 * DriverDao.php
 * Modelo para la persistencia de datos de drivers
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Driver.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';

class DriverDao extends Model
{
    /**
     * Método constructor, obtiene la conexión a la base de datos
     * @access public
     */
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(Driver $d, $tipo)
    {
        if ($tipo == 1)
        {
            $sql = "INSERT INTO `drivers` (`Driver`, `Impacto`) VALUES (?, ?)";
        }
        else{
            $sql = "UPDATE `drivers` SET `Driver` = ?, `Impacto` = ? WHERE `Id_Driver` = ?";
        }
        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $d->__get('_driver'), PDO::PARAM_STR);
        $stmt->bindValue(2, $d->__get('_impacto'), PDO::PARAM_STR);
        if ($tipo == 2){
            $stmt->bindValue(3, $d->__get('_idDriver'), PDO::PARAM_INT);
        }
        
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idDriver'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos del Driver.';
        }
        
        return $response;
    }   
    
    public function obtenerDrivers()
    {
        $sql = "SELECT * FROM `drivers` ORDER BY `Id_Driver`";
        $stmt = $this->_dbh->prepare($sql);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['drivers'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la información de Drivers';
        }
        
        return $response;
    }
    
    public function obtenerDriver($idDriver)
    {
        $sql = "SELECT * FROM `drivers` WHERE `Id_Driver` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idDriver, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['driver'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos del driver.';
        }
        
        return $response;
    }
}