<?php
/**
 * EvaluacionDao.php
 * Modelo para la persistencia de datos de la evaluación
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Evaluacion.php';

class EvaluacionDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(Evaluacion $ev)
    {
        $sql = "INSERT INTO `evaluacion_personal` (`Id_Usuario`, `Id_Periodo`, `Logros`, `Comentarios`) "
                . "VALUES (?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $ev->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(2, $ev->__get('_idPeriodo'), PDO::PARAM_INT);
        $stmt->bindValue(3, $ev->__get('_logros'), PDO::PARAM_STR);
        $stmt->bindValue(4, $ev->__get('_comentarios'), PDO::PARAM_STR);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idEvaluacion'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar tus datos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerEvaluacion($idUsuario, $idPeriodo)
    {
        $sql = "SELECT * FROM `evaluacion_personal` WHERE `Id_Usuario` = ? AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idPeriodo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['datosEvaluacion'] = $stmt->fetch(PDO::FETCH_OBJ);
            $response['hayDatos'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener tus datos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function actualizarComentario(Evaluacion $ev)
    {
        $sql = "UPDATE `evaluacion_personal` SET `Comentarios` = ? WHERE `Id_Usuario` = ? AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $ev->__get('_comentarios'), PDO::PARAM_STR);
        $stmt->bindValue(2, $ev->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(3, $ev->__get('_idPeriodo'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar tus datos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function actualizarLogros(Evaluacion $ev)
    {
        $sql = "UPDATE `evaluacion_personal` SET `Logros` = ? WHERE `Id_Usuario` = ? AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $ev->__get('_logros'), PDO::PARAM_STR);
        $stmt->bindValue(2, $ev->__get('_idUsuario'), PDO::PARAM_INT);
        $stmt->bindValue(3, $ev->__get('_idPeriodo'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar tus datos. '
                    . TICKETS;
        }
        
        return $response;
    }
}