<?php
/**
 * IndicadorDao.php
 * Modelo para la persistencia de datos de Indicadores
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */


require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . DIRECTORY_SEPARATOR . 
        'models' . DIRECTORY_SEPARATOR . 'Indicador.php';

class IndicadorDao extends Model 
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardar(Indicador $i, $tipo)
    {
        if ($tipo == 1){
            $sql = "INSERT INTO `indicadores_driver` (`Indicador`, `Impacto`, `Objetivo`, "
                    . "`Id_Driver`) VALUES (?, ?, ?, ?)";
        }
        else{
            $sql = "UPDATE `indicadores_driver` SET `Indicador` = ?, `Impacto` = ?, `Objetivo` = ?, "
                    . "`Id_Driver` = ? WHERE `Id_Indicador` = ?";
        }
        
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $i->__get('_indicador'), PDO::PARAM_STR);
        $stmt->bindValue(2, $i->__get('_impacto'), PDO::PARAM_INT);
        $stmt->bindValue(3, $i->__get('_objetivo'), PDO::PARAM_INT);
        $stmt->bindValue(4, $i->__get('_idDriver'), PDO::PARAM_INT);
        if ($tipo == 2){
            $stmt->bindValue(5, $i->__get('_idIndicador'), PDO::PARAM_INT);
        }
        
        try{
            $stmt->execute();
            $response['status'] = true;
            if ($tipo == 1){
                $response['idIndicador'] = $this->_dbh->lastInsertId();
            }
            else{
                $response['idIndicador'] = $i->__get('_idIndicador');
            }
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los datos del Inidicador. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerIndicadores(Indicador $i)
    {
        $sql = "SELECT * FROM `indicadores_driver` WHERE `Id_Driver` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $i->__get('_idDriver'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['indicadores'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los datos de indicadores';
        }
        
        return $response;
    }
    
    public function obtenerIndicador($idInidicador)
    {
        $sql = "SELECT * FROM `indicadores_driver` WHERE `Id_Indicador` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idInidicador, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['indicador'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['mensaje'] = 'Lo siento, ocurrió un error al obtener los datos del inidicador. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function eliminar($idIndicador)
    {
        $sql = "DELETE FROM `indicadores_driver` WHERE `Id_Indicador` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idIndicador, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al eliminar el Indicador. ' . 
                    TICKETS;
        }
        
        return $response;
    }
}