<?php
/**
 * NominaDao.php
 * Modelo para la persistencia de datos de objetivos
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' .
    DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Nomina.php';

class NominaDao extends Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function actualizarConfiguracionNomina($uma, $umi, $segurobimestral, $factorDescuento)
    {
        $sql = "UPDATE `configuracion_nomina` SET `UMA` = ?, `umi` = ?, `seguro_bimestral_infonavit` = ? , `factor_descuento` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $uma, PDO::PARAM_STR);
        $stmt->bindValue(2, $umi, PDO::PARAM_STR);
        $stmt->bindValue(3, $segurobimestral, PDO::PARAM_STR);
        $stmt->bindValue(4, $factorDescuento, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la configuracion de la nomina. '
                . TICKETS;
        }

        return $response;

    }

    public function actualizarConfiguracionISR($idISR, $limiteInferior, $limiteSuperior, $cuotaFija, $porcentaje){
        $sql = "UPDATE tabla_isr SET limite_inferior=?, limite_superior=?, cuota_fija=?, porcentaje=? WHERE id_tabla_isr=?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $limiteInferior, PDO::PARAM_STR);
        $stmt->bindValue(2, $limiteSuperior, PDO::PARAM_STR);
        $stmt->bindValue(3, $cuotaFija, PDO::PARAM_STR);
        $stmt->bindValue(4, $porcentaje, PDO::PARAM_STR);
        $stmt->bindValue(5, $idISR, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la configuracion del ISR. '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarConfiguracionSubcidioEmpleo($idSubcidioEmpleo, $paraIngresos, $hastaIngresos, $cantidadSubcidio){
        $sql = "UPDATE subcidio_empleo SET para_ingresos=?, hasta_ingresos=?, cantidad_de_subsidio=? WHERE id_subcidio_empleo=?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $paraIngresos, PDO::PARAM_STR);
        $stmt->bindValue(2, $hastaIngresos, PDO::PARAM_STR);
        $stmt->bindValue(3, $cantidadSubcidio, PDO::PARAM_STR);
        $stmt->bindValue(4, $idSubcidioEmpleo, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la configuracion del subcidio de empleo. '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarConfiguracionPrestacionesDeLey($idPrestacionesLey, $aguinaldo, $vacaciones, $primaVacaciones, $factorIntegracion){
        $sql = "UPDATE prestaciones_de_ley SET aguinaldo=?, vacaciones=?, prima_vacaciones=?, factor_de_integracion=? WHERE id_prestaciones_de_ley=?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $aguinaldo, PDO::PARAM_STR);
        $stmt->bindValue(2, $vacaciones, PDO::PARAM_STR);
        $stmt->bindValue(3, $primaVacaciones, PDO::PARAM_STR);
        $stmt->bindValue(4, $factorIntegracion, PDO::PARAM_STR);
        $stmt->bindValue(5, $idPrestacionesLey, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la configuracion de la prestacion de ley. '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarConfiguracionSubcidioEmpleoMensual($idSubcidioEmpleoMensual, $paraIngresos, $hastaIngresos, $cantidadSubcidio){
        $sql = "UPDATE subcidio_empleo_mensual SET para_ingresos=?, hasta_ingresos=?, cantidad_de_subsidio=? WHERE id_subcidio_empleo_mensual=?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $paraIngresos, PDO::PARAM_STR);
        $stmt->bindValue(2, $hastaIngresos, PDO::PARAM_STR);
        $stmt->bindValue(3, $cantidadSubcidio, PDO::PARAM_STR);
        $stmt->bindValue(4, $idSubcidioEmpleoMensual, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la configuracion del subcidio de empleo mensual. '
                . TICKETS;
        }
        return $response;
    }

    public function obtenerConfiguracionNomina()
    {
        $sql = 'select * from configuracion_nomina';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['configuracion'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la configuracion de la nomina. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerConfiguracionISR()
    {
        $sql = 'select * from tabla_isr order by limite_inferior;';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['configuracionISR'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la configuracion del ISR. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerConfiguracionSubcidioEmpleo()
    {
        $sql = 'select * from subcidio_empleo order by para_ingresos;';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['configuracionSubcidioEmpleo'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la configuracion del subcidio de empleo. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerConfiguracionPrestacionesDeLey()
    {
        $sql = 'select * from prestaciones_de_ley order by años_de_servicio;';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['configuracionPrestacionesDeLey'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la configuracion de las prestaciones de ley. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerConfiguracionSubcidioEmpleoMensual()
    {
        $sql = 'select * from subcidio_empleo_mensual order by para_ingresos;';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['configuracionSubcidioEmpleoMensual'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la configuracion del subcidio de empleo mensual. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerISR($sueldo)
    {
        $sql = 'select * from tabla_isr where ? between limite_inferior and limite_superior';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->bindValue(1, $sueldo, PDO::PARAM_STR);
            $stmt->execute();
            $response['status'] = true;
            $response['isr'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el ISR. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerSubsidioEmpleo($sueldo)
    {
        $sql = 'select * from subcidio_empleo where ? between para_ingresos and hasta_ingresos';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->bindValue(1, $sueldo, PDO::PARAM_STR);
            $stmt->execute();
            $response['status'] = true;
            $response['subsidio'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el ISR. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerPrestaciones_de_ley($year)
    {
        $sql = 'select * from prestaciones_de_ley where años_de_servicio = ?';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->bindValue(1, $year, PDO::PARAM_STR);
            $stmt->execute();
            $response['status'] = true;
            $response['prestacion'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las prestaciones. '
                . TICKETS;
        }

        return $response;
    }

   /* public function mandar_autorizacion_nomina($sueldo_quincenal, $retencion_infonavit, $aguinaldo, $cuotaImmsMensual, $vacaciones, $cuotaImmsBimestral, $banderaSubsidio, $diferenciaSubsidio, $subtotalPercepcion, $subtotalDeduccion, $total, $status,$id_usuario, $fechaInicial, $fechaFinal, $fecha_pago, $dias_pagados, $cp )
    {
        $sql = "INSERT INTO `autorizacion_nomina` (`sueldo_quincenal`, `retencion_infonavit`, `aguinaldo`, `cuotaImmsMensual`, `vacaciones`, `cuotaImmsBimestral`, `banderaSubsidio`, `diferenciaSubsidio`, `subtotalPercepcion`, `subtotalDeduccion`, `total`, `status`, `id_usuario` ,`fecha_inicial`, `fecha_final`, `fecha_pago`, `dias_pagados`, `cp`)  "
            . "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,?, ?, ?,?)";
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->bindValue(1, $sueldo_quincenal, PDO::PARAM_STR);
            $stmt->bindValue(2, $retencion_infonavit, PDO::PARAM_STR);
            $stmt->bindValue(3, $aguinaldo, PDO::PARAM_STR);
            $stmt->bindValue(4, $cuotaImmsMensual, PDO::PARAM_STR);
            $stmt->bindValue(5, $vacaciones, PDO::PARAM_STR);
            $stmt->bindValue(6, $cuotaImmsBimestral, PDO::PARAM_STR);
            $stmt->bindValue(7, $banderaSubsidio, PDO::PARAM_STR);
            $stmt->bindValue(8, $diferenciaSubsidio, PDO::PARAM_STR);
            $stmt->bindValue(9, $subtotalPercepcion, PDO::PARAM_STR);
            $stmt->bindValue(10, $subtotalDeduccion, PDO::PARAM_STR);
            $stmt->bindValue(11, $total, PDO::PARAM_STR);
            $stmt->bindValue(12, $status, PDO::PARAM_INT);
            $stmt->bindValue(13, $id_usuario, PDO::PARAM_INT);
            $stmt->bindValue(14, $fechaInicial, PDO::PARAM_STR);
            $stmt->bindValue(15, $fechaFinal, PDO::PARAM_STR);
            $stmt->bindValue(16, $fecha_pago, PDO::PARAM_STR);
            $stmt->bindValue(17, $dias_pagados, PDO::PARAM_INT);
            $stmt->bindValue(18, $cp, PDO::PARAM_STR);
            $stmt->execute();
            $response['status'] = true;
            $response['autorizacionNomina'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al mandar a autorizar la nomina. '
                . TICKETS;
        }
        return $response;
    }*/


    public function mandar_autorizacion_nomina($id_usuario, $status, $fecha_inicial, $fecha_final, $fecha_pago, $dias_pagados, $fechaInicioCorte, $fechaFinalCorte )
    {
        $sql = "INSERT INTO `autorizacion_nomina` (`id_usuario`, `status`, `fecha_inicial`, `fecha_final`, `fecha_pago`, `dias_pagados`, `fecha_inicio_corte`, `fecha_final_corte`)  "
            . "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->bindValue(1, $id_usuario, PDO::PARAM_INT);
            $stmt->bindValue(2, $status, PDO::PARAM_STR);
            $stmt->bindValue(3, $fecha_inicial, PDO::PARAM_STR);
            $stmt->bindValue(4, $fecha_final, PDO::PARAM_STR);
            $stmt->bindValue(5, $fecha_pago, PDO::PARAM_STR);
            $stmt->bindValue(6, $dias_pagados, PDO::PARAM_STR);
            $stmt->bindValue(7, $fechaInicioCorte, PDO::PARAM_STR);
            $stmt->bindValue(8, $fechaFinalCorte, PDO::PARAM_STR);
            $stmt->execute();
            $response['status'] = true;
            $response['autorizacionNomina'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al mandar a autorizar la nomina. '
                . TICKETS;
        }
        return $response;
    }

     public function insertar_detalle_autorizacion_nomina(NominaAutorizar $n )
    {
        $sql = "INSERT INTO `detalle_autorizacion_nomina` (`sueldo_quincenal`, `retencion_infonavit`, `aguinaldo`, 
                                           `cuotaImmsMensual`, `vacaciones`, `cuotaImmsBimestral`, `banderaSubsidio`, `diferenciaSubsidio`,
                                           `subtotalPercepcion`, `subtotalDeduccion`, `total`, `finiquito`, `id_documento`, `id_autorizacion_nomina`, 
                                           `tipo_nomina`, `comisiones`, `status_Pago`, `vacacionesFiniquito`,`primaVacacionalFiniquito`,
                                           `aguinaldoFiniquito`,`isrFiniquito`,`isr`,`subsidio_empleado`,`ajuste_subsidio`, `id_proveedor`, premio_asistencia,
                                           premio_puntualidad, despensa)  "
            . "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->bindValue(1, $n->__get('_sueldo_quincenal'), PDO::PARAM_STR);
            $stmt->bindValue(2, $n->__get('_retencion_infonavit'), PDO::PARAM_STR);
            $stmt->bindValue(3, $n->__get('_aguinaldo'), PDO::PARAM_STR);
            $stmt->bindValue(4, $n->__get('_cuotaImmsMensual'), PDO::PARAM_STR);
            $stmt->bindValue(5, $n->__get('_vacaciones'), PDO::PARAM_STR);
            $stmt->bindValue(6, $n->__get('_cuotaImmsBimestral'), PDO::PARAM_STR);
            $stmt->bindValue(7, $n->__get('_banderaSubsidio'), PDO::PARAM_STR);
            $stmt->bindValue(8, $n->__get('_diferenciaSubsidio'), PDO::PARAM_STR);
            $stmt->bindValue(9, $n->__get('_subtotalPercepcion'), PDO::PARAM_STR);
            $stmt->bindValue(10, $n->__get('_subtotalDeduccion'), PDO::PARAM_STR);
            $stmt->bindValue(11, $n->__get('_total'), PDO::PARAM_STR);
            $stmt->bindValue(12, $n->__get('_finiquito'), PDO::PARAM_STR);
            $stmt->bindValue(13, $n->__get('_id_documento'), PDO::PARAM_INT);
            $stmt->bindValue(14, $n->__get('_id_autorizacion_nomina'), PDO::PARAM_INT);
            $stmt->bindValue(15, $n->__get('_tipo_nomina'), PDO::PARAM_STR);
            $stmt->bindValue(16, $n->__get('_comisiones'), PDO::PARAM_STR);
            $stmt->bindValue(17, $n->__get('_status'), PDO::PARAM_STR);
            $stmt->bindValue(18, $n->__get('_vacacionesFiniquito'), PDO::PARAM_STR);
            $stmt->bindValue(19, $n->__get('_primaVacacionalFiniquito'), PDO::PARAM_STR);
            $stmt->bindValue(20, $n->__get('_aguinaldoFiniquito'), PDO::PARAM_STR);
            $stmt->bindValue(21, $n->__get('_isrFiniquito'), PDO::PARAM_STR);
            $stmt->bindValue(22, $n->__get('_isr'), PDO::PARAM_STR);
            $stmt->bindValue(23, $n->__get('_subsidioEmpleado'), PDO::PARAM_STR);
            $stmt->bindValue(24, $n->__get('_ajusteSubsidio'), PDO::PARAM_STR);
            $stmt->bindValue(25, $n->__get('_idProveedor'), PDO::PARAM_STR);
            $stmt->bindValue(26, $n->__get('_premioPuntualidad'), PDO::PARAM_STR);
            $stmt->bindValue(27, $n->__get('_premioAsistencia'), PDO::PARAM_STR);
            $stmt->bindValue(28, $n->__get('_despensa'), PDO::PARAM_STR);


            $stmt->execute();
            $response['status'] = true;
            $response['detalleNomina'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al insertar el detalle de la nomina. '
                . TICKETS;
        }
        return $response;
    }






    public function totalAutorizacionesNomina()
    {
        $sql = "select * from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
 where an.status= 'calculado' and (dan.status_Pago = 'inicializado' or dan.status_Pago = 'en revision') and an.id_usuario !=16  
 and an.id_usuario !=17 and an.id_usuario !=28 and an.id_usuario !=29 and an.id_usuario !=27 group by an.id_autorizacion_nomina
 ";
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerAutorizacionesNomina($inicio, $registros)
    {
        $sql = "select  an.*, u.* from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
 where an.status= 'calculado' and (dan.status_Pago = 'inicializado' or dan.status_Pago = 'en revision') and an.id_usuario !=16  
 and an.id_usuario !=17 and an.id_usuario !=28 and an.id_usuario !=29 and an.id_usuario !=27 group by an.id_autorizacion_nomina  LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerAutorizacionNomina($idNomina)
    {
        $sql = "select * from autorizacion_nomina as an
inner join usuarios as u on u.Id_Usuario = an.id_usuario
inner join detalle_autorizacion_nomina as da on da.id_autorizacion_nomina = an.id_autorizacion_nomina
where an.status = 'calculado' 
and (da.status_Pago = 'inicializado' or da.status_Pago = 'en revision') 
and an.id_autorizacion_nomina = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la nomina para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusNomina($idNomina, $status)
    {
        $sql = 'update autorizacion_nomina set `status` = ? where id_autorizacion_nomina = ?';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la nomina. '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusDetalleAutorizacionNomina($idDetalleAutorizacionNomina, $status)
    {
        $sql = 'update detalle_autorizacion_nomina set status_Pago = ? where id_detalle_autorizacion_nomina = ?;';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idDetalleAutorizacionNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el status de la nomina. '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarObservacionDetalleAutorizacionNomina($idDetalleAutorizacionNomina, $observacion)
    {
        $sql = 'update detalle_autorizacion_nomina set observaciones = ? where id_detalle_autorizacion_nomina = ?;';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $observacion, PDO::PARAM_STR);
        $stmt->bindValue(2, $idDetalleAutorizacionNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la observacion de la nomina. '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusDetalleAutorizacionNominaPorIdDocumento($idDocumento, $status)
    {
        $sql = 'update detalle_autorizacion_nomina set status_Pago = ? where id_documento = ?;';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idDocumento, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el status de la nomina. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerUltimoInsertado()
    {
        $sql = 'select * from autorizacion_nomina ORDER BY `id_autorizacion_nomina` DESC LIMIT 1 ';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el ultimo id insertado. '
                . TICKETS;
        }

        return $response;
    }

    public function  actualizar_detalle_autorizacion_nomina(NominaAutorizar $n )
    {
        $sql = "update detalle_autorizacion_nomina set sueldo_quincenal = ?, retencion_infonavit = ?, aguinaldo = ?, cuotaImmsMensual = ?, vacaciones = ?,
cuotaImmsBimestral = ?, banderaSubsidio = ?, diferenciaSubsidio = ?, subtotalPercepcion = ?, subtotalDeduccion = ?, total = ?, finiquito = ?, tipo_nomina = ?,
comisiones = ?, vacacionesFiniquito = ?, primaVacacionalFiniquito = ?, aguinaldoFiniquito = ?, isrFiniquito = ?, isr = ?, subsidio_empleado = ?, ajuste_subsidio = ?
 , premio_asistencia = ? , premio_puntualidad = ? , despensa = ?
where id_detalle_autorizacion_nomina = ? ";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $n->__get('_sueldo_quincenal'), PDO::PARAM_STR);
        $stmt->bindValue(2, $n->__get('_retencion_infonavit'), PDO::PARAM_STR);
        $stmt->bindValue(3, $n->__get('_aguinaldo'), PDO::PARAM_STR);
        $stmt->bindValue(4, $n->__get('_cuotaImmsMensual'), PDO::PARAM_STR);
        $stmt->bindValue(5, $n->__get('_vacaciones'), PDO::PARAM_STR);
        $stmt->bindValue(6, $n->__get('_cuotaImmsBimestral'), PDO::PARAM_STR);
        $stmt->bindValue(7, $n->__get('_banderaSubsidio'), PDO::PARAM_STR);
        $stmt->bindValue(8, $n->__get('_diferenciaSubsidio'), PDO::PARAM_STR);
        $stmt->bindValue(9, $n->__get('_subtotalPercepcion'), PDO::PARAM_STR);
        $stmt->bindValue(10, $n->__get('_subtotalDeduccion'), PDO::PARAM_STR);
        $stmt->bindValue(11, $n->__get('_total'), PDO::PARAM_STR);
        $stmt->bindValue(12, $n->__get('_finiquito'), PDO::PARAM_STR);
        $stmt->bindValue(13, $n->__get('_tipo_nomina'), PDO::PARAM_STR);
        $stmt->bindValue(14, $n->__get('_comisiones'), PDO::PARAM_STR);
        $stmt->bindValue(15, $n->__get('_vacacionesFiniquito'), PDO::PARAM_STR);
        $stmt->bindValue(16, $n->__get('_primaVacacionalFiniquito'), PDO::PARAM_STR);
        $stmt->bindValue(17, $n->__get('_aguinaldoFiniquito'), PDO::PARAM_STR);
        $stmt->bindValue(18, $n->__get('_isrFiniquito'), PDO::PARAM_STR);
        $stmt->bindValue(19, $n->__get('_isr'), PDO::PARAM_STR);
        $stmt->bindValue(20, $n->__get('_subsidioEmpleado'), PDO::PARAM_INT);
        $stmt->bindValue(21, $n->__get('_ajusteSubsidio'), PDO::PARAM_INT);
        $stmt->bindValue(22, $n->__get('_premioPuntualidad'), PDO::PARAM_STR);
        $stmt->bindValue(23, $n->__get('_premioAsistencia'), PDO::PARAM_STR);
        $stmt->bindValue(24, $n->__get('_despensa'), PDO::PARAM_STR);
        $stmt->bindValue(25, $n->__get('_id_detalle_autorizacion_nomina'), PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la nomina. '
                . TICKETS;
        }
        return $response;
    }

    public function actualizar_dias_pagados($dias_pagados, $id_autorizacion_nomina)
    {
        $sql = "update autorizacion_nomina set dias_pagados = ? where id_autorizacion_nomina = ? ";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $dias_pagados, PDO::PARAM_INT);
        $stmt->bindValue(2, $id_autorizacion_nomina, PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar los dias pagados. '
                . TICKETS;
        }
        return $response;
    }

    public function obtenerTablaIsr()
    {
        $sql = 'select * from tabla_isr';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['isr'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la tabla del isr . '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerTarjetasPorAutorizar()
    {
        $sql = 'select an.*, dan.*, n.proveedor   from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
where an.status = 1';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['tarjetas'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las tarjetas por autorizar. '
                . TICKETS;
        }

        return $response;
    }

    public function insertarAutorizacionNominaContabilidad($tipoNomina, $status)
    {
        $sql = 'INSERT INTO `autorizacion_nomina_contabilidad` (`tipo_nomina`, `status`) VALUES (?, ?)';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $tipoNomina, PDO::PARAM_STR);
        $stmt->bindValue(2, $status, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['id'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al crear la autorizacion de la nomina. '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarAutorizacionNomina($idAutorizacionNominaContabilidad, $tipoNomina)
    {
        $sql = 'update detalle_autorizacion_nomina as dan 
inner join autorizacion_nomina as an on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
set dan.id_autorizacion_nomina_contabilidad = ?
where an.status = 1 and dan.tipo_nomina = ?  ';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idAutorizacionNominaContabilidad, PDO::PARAM_INT);
        $stmt->bindValue(2, $tipoNomina, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['id'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al mandar a autorizar las nominas. '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusAutorizacionNomina( $status, $status_pago)
    {
        $sql = "update detalle_autorizacion_nomina as dan 
inner join autorizacion_nomina as an on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
set  an.status = ?, dan.status_Pago = ?
where an.status = 'calculado' and (dan.status_Pago = 'inicializado' or dan.status_Pago = 'en revision')";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $status_pago, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['id'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el status de la autorizacion. '
                . TICKETS;
        }

        return $response;
    }

    public function totalAutorizacionesContabilidadNomina()
    {
        $sql = "select * from autorizacion_nomina_contabilidad where `status`= 'calculado'";
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerAutorizacionesContabilidadNomina($inicio, $registros)
    {
        $sql = "select * from autorizacion_nomina_contabilidad where status = 'calculado' LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function totalTarjetasAutorizadas()
    {
        $sql = "select * from autorizacion_nomina where `status`= 'aprobado' and archivo_tarjeta_asistencia is null and archivo_tarjeta_asistencia is null and id_usuario !=16 and id_usuario !=17 and id_usuario !=111 and id_usuario !=29 and id_usuario !=28";
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerTarjetasAutorizadas($inicio, $registros)
    {
        $sql = "select * from autorizacion_nomina as an
inner join usuarios as u on u.Id_Usuario = an.id_usuario
where an.status= 'aprobado' and an.archivo_tarjeta_asistencia is null 
and archivo_tarjeta_asistencia is null and an.id_usuario !=16 and an.id_usuario !=17 and an.id_usuario !=111 and an.id_usuario !=29 and an.id_usuario !=28 and an.id_usuario !=27 LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(2, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerAutorizacionNominaPorId($id)
    {
        $sql = 'select * from autorizacion_nomina where id_autorizacion_nomina = ? ';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $id, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el ultimo id insertado. '
                . TICKETS;
        }

        return $response;
    }

    public function subirArchivoTarjetaAsistencia($archivo, $id_autorizacion_nomina)
    {
        $sql = "update autorizacion_nomina set archivo_tarjeta_asistencia = ? where id_autorizacion_nomina = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $archivo, PDO::PARAM_STR);
        $stmt->bindValue(2, $id_autorizacion_nomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al subir el archivo de tarjeta de asistencia. '
                . TICKETS;
        }

        return $response;

    }

    public function obtenerDetalleDeNominasParaAutorizar($id_autorizacion_nomina_contabilidad)
    {
        $sql = 'select * from autorizacion_nomina_contabilidad as anc
inner join detalle_autorizacion_nomina as dac on dac.id_autorizacion_nomina_contabilidad = anc.id_autorizacion_nomina_contabilidad
inner join autorizacion_nomina as an on an.id_autorizacion_nomina = dac.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
where anc.id_autorizacion_nomina_contabilidad = 2 order by n.proveedor';
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_autorizacion_nomina_contabilidad, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el detalle de  nomina para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerNominasExternaParaAutorizar()
    {
        $sql = "select an.*,dan.*, n.*, pi.*, concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, pe.imms_patronal as imms_proveedor, pe.porcentaje_comision_proveedor from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
inner join nomina_proveedores_externos as pe on pe.id_nomina_proveedores_externos = dan.id_proveedor
inner join proveedores_indirectos as pi on pi.Id_Proveedor = pe.id_proveedor
inner join usuarios as u on an.id_usuario = u.Id_Usuario
where dan.status_Pago = 'en autorizacion contabilidad' and dan.tipo_nomina = 'externa' and pe.id_usuario = an.id_usuario 
";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nominasExterna'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }
    public function obtenerNominasExternaConRequisicionParaAutorizar()
    {
        $sql = "select an.*,dan.*, n.*, pi.*, concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, ner.* from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
inner join nomina_proveedores_externos as pe on pe.id_nomina_proveedores_externos = dan.id_proveedor
inner join proveedores_indirectos as pi on pi.Id_Proveedor = pe.id_proveedor
inner join usuarios as u on an.id_usuario = u.Id_Usuario
inner join nomina_externa_requisicion as ner on dan.id_detalle_autorizacion_nomina = ner.id_detalle_autorizacion_nomina
where (dan.status_Pago = 'en autorizacion' ) and dan.tipo_nomina = 'externa'
";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['nominasExternaConRequisicion'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerProveedoresNominaPorAutorizar()
    {
        $sql = "select pe.id_proveedor, pi.Nombre from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
inner join nomina_proveedores_externos as pe on pe.id_nomina_proveedores_externos = dan.id_proveedor
inner join proveedores_indirectos as pi on pi.Id_Proveedor = pe.id_proveedor
where (dan.status_Pago = 'en autorizacion') and dan.tipo_nomina = 'externa' group by pe.id_proveedor ";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['proveedores'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerNominasInternasParaAutorizar()
    {
        $sql = "select * from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
where (dan.status_Pago = 'en autorizacion') and dan.tipo_nomina = 'interna' ";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['nominasInterna'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerNominasInternasParaTimbrar($idUsuario)
    {
        $sql = "select * from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
where an.status = 'aprobado' and dan.status_Pago = 'autorizado' and dan.tipo_nomina = 'interna' and u.Id_Usuario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);

        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nominasInternas'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas internas para timbrar '
                . TICKETS;
        }

        return $response;
    }

    public function autorizaNominasInternas()
    {
        $sql = "update autorizacion_nomina as an 
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
set dan.status_Pago = 'autorizado'
where  (dan.status_Pago = 'en autorizacion' ) and dan.tipo_nomina = 'interna' ";
        $stmt = $this->_dbh->prepare($sql);

        try {
            $stmt->execute();
            $response['status'] = true;;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al autorizar las nomias. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerTotalDeNominasPagadasPorFechasYUsuario($fechaInicio, $fechaFin, $nombreUsuario) {
        $nombre = '%'.$nombreUsuario.'%';
        $sql = "select an.*,concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, dan.total, dan.status_Pago, d.Folio_Documento, dan.tipo_nomina as tipoDeNomina from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
left join documentos as d on d.Id_Documento = dan.id_documento  
inner join usuarios as u on u.Id_Usuario = an.id_usuario
where an.status = 'aprobado'
and (dan.status_Pago = 'autorizado' or dan.status_Pago = 'pagado' or dan.status_Pago = 'timbrado')
and an.fecha_inicial >= ?
and an.fecha_final <= ?
and concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) like ?
order by an.fecha_inicial;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFin, PDO::PARAM_STR);
        $stmt->bindValue(3, $nombre, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al contar los datos del historial de nominas pagadas. ' . TICKETS;
        }
        return $response;
    }

    public function obtenerHistorialDeNominasPagadasPorFechasYUsuario($fechaInicio, $fechaFin, $nombreUsuario, $inicio, $registros) {
        $nombre = '%'.$nombreUsuario.'%';
        $sql = "select an.*,concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, dan.total, dan.status_Pago, d.Folio_Documento, dan.tipo_nomina as tipoDeNomina from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina 
inner join usuarios as u on u.Id_Usuario = an.id_usuario
left join documentos as d on d.Id_Documento = dan.id_documento
where an.status = 'aprobado'
and (dan.status_Pago = 'autorizado' or dan.status_Pago = 'pagado' or dan.status_Pago = 'timbrado')
and an.fecha_inicial >= ?
and an.fecha_final <= ?
and concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) like ?
order by an.fecha_inicial LIMIT ?, ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicio, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFin, PDO::PARAM_STR);
        $stmt->bindValue(3, $nombre, PDO::PARAM_STR);
        $stmt->bindValue(4, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(5, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['historial'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el historial de nominas. ' . TICKETS;
        }
        return $response;
    }

    public function obtenerTodasNominasInternasParaTimbrar()
    {
        $sql = "select * from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
where dan.status_Pago = 'autorizado' and dan.tipo_nomina = 'interna'";
        $stmt = $this->_dbh->prepare($sql);

        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nominasInternas'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas internas para timbrar '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerDetalleNominaPorId($IdDetalleNomina)
    {
        $sql = "select *, dan.tipo_nomina as tipo_de_nomina from detalle_autorizacion_nomina as dan
inner join autorizacion_nomina as an on an.id_autorizacion_nomina = dan.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
inner join usuarios as u on u.Id_Usuario = an.id_usuario
where dan.id_detalle_autorizacion_nomina = ?";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $IdDetalleNomina, PDO::PARAM_INT);

        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el detalle de la nomina '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarIdDocumento($idDocumento, $idDetalleNomina)
    {
        $sql = "update detalle_autorizacion_nomina set id_documento = ? where id_detalle_autorizacion_nomina = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idDocumento, PDO::PARAM_INT);
        $stmt->bindValue(2, $idDetalleNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el documento. '
                . TICKETS;
        }

        return $response;

    }


    public function obtenerRequisicionNominaExternaPorIdDetalleAutorizacionNomina($idDetalleAutorizacionNomina) {
        $sql = "select * from nomina_externa_requisicion
where id_detalle_autorizacion_nomina = ?; ";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idDetalleAutorizacionNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['requisicion'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la requisicion de la nomina externa. ' . TICKETS;
        }
        return $response;
    }

    public function insertarRequisicionNominaExterna(RequisicionNominaExterna $requisicionNominaExterna) {
        $sql = 'INSERT INTO nomina_externa_requisicion (total_pago, imms_patronal, isn, costo_nomina, comision, subtotal, iva, ret, total_factura, id_detalle_autorizacion_nomina) 
VALUES (:totalPago, :immsPatronal, :isn, :costoNomina, :comision, :subTotal, :iva, :ret, :totalFactura, :idDetalleNomina); ';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(':totalPago', $requisicionNominaExterna->__get('_totalPago'), PDO::PARAM_STR);
        $stmt->bindValue(':immsPatronal', $requisicionNominaExterna->__get('_immsPatronal'), PDO::PARAM_STR);
        $stmt->bindValue(':isn', $requisicionNominaExterna->__get('_isn'), PDO::PARAM_STR);
        $stmt->bindValue(':costoNomina', $requisicionNominaExterna->__get('_costoNomina'), PDO::PARAM_STR);
        $stmt->bindValue(':comision', $requisicionNominaExterna->__get('_comision'), PDO::PARAM_STR);
        $stmt->bindValue(':subTotal', $requisicionNominaExterna->__get('_subTotal'), PDO::PARAM_STR);
        $stmt->bindValue(':iva', $requisicionNominaExterna->__get('_iva'), PDO::PARAM_STR);
        $stmt->bindValue(':ret', $requisicionNominaExterna->__get('_ret'), PDO::PARAM_STR);
        $stmt->bindValue(':totalFactura', $requisicionNominaExterna->__get('_totalFactura'), PDO::PARAM_STR);
        $stmt->bindValue(':idDetalleNomina', $requisicionNominaExterna->__get('_idDetalleNomina'), PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['id'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al crear la requisicion de la nomina externa. '
                . TICKETS;
        }

        return $response;
    }
    public function actualizarRequisicionNominaExterna($idNominaExternaRequisicion, RequisicionNominaExterna $requisicionNominaExterna) {
        $sql = 'UPDATE nomina_externa_requisicion SET total_pago=:totalPago, imms_patronal=:immsPatronal, isn=:isn, costo_nomina=:costoNomina, comision=:comision
, subtotal=:subTotal, iva=:iva, ret=:ret, total_factura=:totalFactura WHERE id_nomina_externa_requisicion=:idNominaExternaRequisicion;';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(':totalPago', $requisicionNominaExterna->__get('_totalPago'), PDO::PARAM_STR);
        $stmt->bindValue(':immsPatronal', $requisicionNominaExterna->__get('_immsPatronal'), PDO::PARAM_STR);
        $stmt->bindValue(':isn', $requisicionNominaExterna->__get('_isn'), PDO::PARAM_STR);
        $stmt->bindValue(':costoNomina', $requisicionNominaExterna->__get('_costoNomina'), PDO::PARAM_STR);
        $stmt->bindValue(':comision', $requisicionNominaExterna->__get('_comision'), PDO::PARAM_STR);
        $stmt->bindValue(':subTotal', $requisicionNominaExterna->__get('_subTotal'), PDO::PARAM_STR);
        $stmt->bindValue(':iva', $requisicionNominaExterna->__get('_iva'), PDO::PARAM_STR);
        $stmt->bindValue(':ret', $requisicionNominaExterna->__get('_ret'), PDO::PARAM_STR);
        $stmt->bindValue(':totalFactura', $requisicionNominaExterna->__get('_totalFactura'), PDO::PARAM_STR);
        $stmt->bindValue(':idNominaExternaRequisicion', $idNominaExternaRequisicion, PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar la requisicion de la nomina externa. '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarIdDocumentoDetalleAutorizacionNomina($idAutorizacionNomina, $idDocumento)
    {
        $sql = 'UPDATE detalle_autorizacion_nomina SET id_documento=? WHERE id_detalle_autorizacion_nomina=?; ';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idDocumento, PDO::PARAM_INT);
        $stmt->bindValue(2, $idAutorizacionNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el id del documneto. '
                . TICKETS;
        }

        return $response;
    }

    public function actualizarStatusDetalleAutorizacion( $id_detalle_autorizacion_nomina)
    {
        $sql = 'UPDATE detalle_autorizacion_nomina SET status_Pago ="timbrado" WHERE id_detalle_autorizacion_nomina = ?; ';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $id_detalle_autorizacion_nomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el status del documneto. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerDetallesAutorizacionNominaPorIdDocumneto($idDocumento) {
        $sql = "select * from detalle_autorizacion_nomina where id_documento = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idDocumento, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['detalles'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los detalles de la autorizacion de la nomina. ' . TICKETS;
        }
        return $response;
    }

    public function obtenerCalulosNominaExternaPorIdDocumento($idDocumento) {
        $sql = "select ner.* from nomina_externa_requisicion as ner
inner join detalle_autorizacion_nomina as dan on ner.id_detalle_autorizacion_nomina = dan.id_detalle_autorizacion_nomina
where dan.id_documento = ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idDocumento, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['calculos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los calculos de la nomina externa. ' . TICKETS;
        }
        return $response;
    }


    public function obtenerComisiones($status, $idUsuario) {
        $sql = " select ifnull(sum(comision),0) as comisiones from autorizacion_comisiones where status = ? and idUsuario = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $status, PDO::PARAM_STR);
        $stmt->bindValue(2, $idUsuario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['comisiones'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los calculos de las comisiones ' . TICKETS;
        }
        return $response;
    }

    public function obtenerObservacionesDeNominasEnRevision() {
        $sql = "select an.id_autorizacion_nomina, an.status, dan.id_detalle_autorizacion_nomina, dan.tipo_nomina, dan.status_Pago, dan.observaciones 
from autorizacion_nomina as an 
inner join detalle_autorizacion_nomina as dan on an.id_autorizacion_nomina = dan.id_autorizacion_nomina
where dan.status_Pago='en revision'; ";
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['observaciones'] = $stmt->fetchAll(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las observaciones de las nominas. ' . TICKETS;
        }
        return $response;
    }

    public function obtenerNominaQuincenalDelMismoMes($usuario, $fecha_final,$tipoNomina)
    {
        $sql = "select * from detalle_autorizacion_nomina as dan
inner join autorizacion_nomina as an on an.id_autorizacion_nomina = dan.id_autorizacion_nomina
where an.id_usuario = ? and an.fecha_final = ? and dan.tipo_nomina = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $usuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha_final, PDO::PARAM_STR);
        $stmt->bindValue(3, $tipoNomina, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['nomina'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener la ultima nomina quincenal. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerSubsidioMensual($sueldo)
    {
        $sql = 'select * from subcidio_empleo_mensual where ? between para_ingresos and hasta_ingresos';
        $stmt = $this->_dbh->prepare($sql);
        try {
            $stmt->bindValue(1, $sueldo, PDO::PARAM_STR);
            $stmt->execute();
            $response['status'] = true;
            $response['subsidio'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el subsidio mensual. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerNominasDeUsuarioPorFecha($idUsuario, $fechaInicial, $fechaFinal){
        $sql = "select * from autorizacion_nomina as an 
where an.id_usuario = ? 
and an.fecha_inicial >= ? 
and an.fecha_final <= ?;";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(3, $fechaFinal, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nominas'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas del usuario. ' . TICKETS;
        }
        return $response;
    }

    public function obtenerProveedoresExternos($idUsuario)
    {
        $sql = 'select * from nomina_proveedores_externos where id_usuario = ? ';
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['proveedoresExternos'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los proveedores externos del usuaio. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerProveedorExterno( $idProveedor)
    {
        $sql = 'select * from nomina_proveedores_externos where id_nomina_proveedores_externos = ? ';
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idProveedor, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['proveedoresExternos'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los proveedores externos del usuaio. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerProveedoresExternosDeLaNominaPorIdNomina($idNomina){
        $sql = "select n.*, pi.Nombre from nomina_proveedores_externos as n
inner join proveedores_indirectos as pi on pi.Id_Proveedor = n.id_proveedor where Id_Nomina = :idNomina";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(':idNomina', $idNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['proveedoresExternosDeNomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los provedores externos de la nomina. ' . TICKETS;
        }
        return $response;
    }

    public function insertarProveedorExternoDeLaNomina($idProveedor, $IdUsuario, $banderaComisiones, $banderaImms, $porcentaje, $idNomina, $porcentajeComisionProveedor) {
        $sql = 'INSERT INTO nomina_proveedores_externos (id_proveedor, id_usuario, comisiones, imms_patronal, porcentaje, Id_Nomina, porcentaje_comision_proveedor) 
VALUES (:idProveedor, :IdUsuario, :banderaComisiones, :banderaImms, :porcentaje, :idNomina, :porcentajeComisionProveedor);';
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(':idProveedor', $idProveedor, PDO::PARAM_INT);
        $stmt->bindValue(':IdUsuario', $IdUsuario, PDO::PARAM_INT);
        $stmt->bindValue(':banderaComisiones', $banderaComisiones, PDO::PARAM_INT);
        $stmt->bindValue(':banderaImms', $banderaImms, PDO::PARAM_INT);
        $stmt->bindValue(':porcentaje', $porcentaje, PDO::PARAM_INT);
        $stmt->bindValue(':idNomina', $idNomina, PDO::PARAM_INT);
        $stmt->bindValue(':porcentajeComisionProveedor', $porcentajeComisionProveedor, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['id'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al insertar el proveedor externo de la nomina. '
                . TICKETS;
        }
        return $response;
    }

    public function actualizarProveedorExternoDeLaNomina($idNominaProveedoresExternos, $banderaComisiones, $banderaImms, $porcentaje) {
        $sql = 'UPDATE nomina_proveedores_externos SET comisiones=:banderaComisiones, imms_patronal=:banderaImms, porcentaje=:porcentaje 
WHERE id_nomina_proveedores_externos=:idNominaProveedoresExternos; ';
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(':banderaComisiones', $banderaComisiones, PDO::PARAM_INT);
        $stmt->bindValue(':banderaImms', $banderaImms, PDO::PARAM_INT);
        $stmt->bindValue(':porcentaje', $porcentaje, PDO::PARAM_INT);
        $stmt->bindValue(':idNominaProveedoresExternos', $idNominaProveedoresExternos, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['id'] = $idNominaProveedoresExternos;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar el proveedor externo de la nomina. '
                . TICKETS;
        }
        return $response;
    }

    public function eliminarProveedorExternoDeLaNomina($idNominaProveedoresExternos) {
        $sql = 'DELETE FROM nomina_proveedores_externos WHERE id_nomina_proveedores_externos=:idNominaProveedoresExternos; ';
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(':idNominaProveedoresExternos', $idNominaProveedoresExternos, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['id'] = $idNominaProveedoresExternos;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al eliminar el proveedor externo de la nomina. '
                . TICKETS;
        }
        return $response;
    }

    public function eliminarDetalleAutorizacionNomina($id_detalle_autorizacion_nomina)
    {
        $sql = 'delete from detalle_autorizacion_nomina where id_detalle_autorizacion_nomina = ?';
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_detalle_autorizacion_nomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al eliminar el id detalle. '
                . TICKETS;
        }

        return $response;
    }

    public function eliminarNominaExternaRequisicion($id_detalle_autorizacion_nomina)
    {
        $sql = 'delete from nomina_externa_requisicion where id_detalle_autorizacion_nomina = ?';
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_detalle_autorizacion_nomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al eliminar la requisicion de la nomina externa. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerDetalleAutorizacionNominaEnRevision($idNomina){
        $sql = "select n.*, pi.Nombre from nomina_proveedores_externos as n
inner join proveedores_indirectos as pi on pi.Id_Proveedor = n.id_proveedor where Id_Nomina = :idNomina";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(':idNomina', $idNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['proveedoresExternosDeNomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los provedores externos de la nomina. ' . TICKETS;
        }
        return $response;
    }

    public function obtenerProveedoresExternosDeLaNominaPorIdUsuario($idUsuario){
        $sql = "select n.*, pi.Nombre from nomina_proveedores_externos as n
inner join proveedores_indirectos as pi on pi.Id_Proveedor = n.id_proveedor where n.id_usuario = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['proveedoresExternosDeNomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los provedores externos de la nomina. ' . TICKETS;
        }
        return $response;
    }

    public function borrarProveedoresExternosDeLaNominaPorIdNomina($idNomina){
        $sql = "delete from nomina_proveedores_externos where Id_Nomina = :idNomina";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(':idNomina', $idNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al cambiar los provedores externos de la nomina. ' . TICKETS;
        }
        return $response;
    }


    public function eliminarDetallesAutorizacionesNomina($id_autorizacion_nomina)
    {
        $sql = "delete from detalle_autorizacion_nomina where tipo_nomina = 'externa' and id_autorizacion_nomina = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_autorizacion_nomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al eliminar las nominas. '
                . TICKETS;
        }

        return $response;
    }

    public function autorizaNominasInternasContabilidad()
    {
        $sql = "update autorizacion_nomina as an 
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
set dan.status_Pago = 'en autorizacion'
where  ( dan.status_Pago = 'en autorizacion contabilidad') and dan.tipo_nomina = 'interna' ";
        $stmt = $this->_dbh->prepare($sql);

        try {
            $stmt->execute();
            $response['status'] = true;;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al autorizar las nomias. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerProveedoresNominaPorRevisarContabilidad()
    {
        $sql = "select pe.id_proveedor, pi.Nombre from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
inner join nomina_proveedores_externos as pe on pe.id_nomina_proveedores_externos = dan.id_proveedor
inner join proveedores_indirectos as pi on pi.Id_Proveedor = pe.id_proveedor
where ( dan.status_Pago = 'en autorizacion contabilidad') and dan.tipo_nomina = 'externa' group by pe.id_proveedor ";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['proveedores'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerNominasExternaConRequisicionParaRevisarContabilidad()
    {
        $sql = "select an.*,dan.*, n.*, pi.*, concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, ner.* from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
inner join nomina_proveedores_externos as pe on pe.id_nomina_proveedores_externos = dan.id_proveedor
inner join proveedores_indirectos as pi on pi.Id_Proveedor = pe.id_proveedor
inner join usuarios as u on an.id_usuario = u.Id_Usuario
inner join nomina_externa_requisicion as ner on dan.id_detalle_autorizacion_nomina = ner.id_detalle_autorizacion_nomina
where ( dan.status_Pago = 'en autorizacion contabilidad') and dan.tipo_nomina = 'externa'
";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();
            $response['nominasExternaConRequisicion'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerNominasInternasPorRevisarContabilidad()
    {
        $sql = "select * from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
where (dan.status_Pago = 'en autorizacion contabilidad') and dan.tipo_nomina = 'interna' ";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nominasInterna'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }


    public function insertarEntradaFacturaNominaExterna($id_documento, $pago, $idPolizasRegistros)
    {
        $sql = 'INSERT INTO `entrada_facturas_requisiciones_nomina_externa` (`id_documento`, `pago`, `id_polizas_registros`) VALUES (?, ?, ?)';
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $id_documento, PDO::PARAM_INT);
        $stmt->bindValue(2, $pago, PDO::PARAM_STR);
        $stmt->bindValue(3, $idPolizasRegistros, PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['id'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al dar entrada a la factura. '
                . TICKETS;
        }

        return $response;
    }


    public function obtenerTotalEntradasFacturasNominasExternas($idDocumento)
    {
        $sql = "select ifnull(sum((pago)),0) as pago from entrada_facturas_requisiciones_nomina_externa where id_documento = ? ";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idDocumento, PDO::PARAM_INT);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['pago'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }

    public function revisarTarjetaAsistenciaGerente($idAutorizacionNomina)
    {
        $sql = "update autorizacion_nomina set revision_tarjeta_gerente = 'revisado' where id_autorizacion_nomina = ? ";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idAutorizacionNomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al revisar la tarjeta de asistencia. '
                . TICKETS;
        }

        return $response;
    }

    public function totalAutorizacionesNominaGerente($idSucursal)
    {
        $sql = "select * from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
 where an.status= 'calculado' and (dan.status_Pago = 'inicializado' or dan.status_Pago = 'en revision') and u.Id_Sucursal = ?  and an.id_usuario !=16  
 and an.id_usuario !=17 and an.id_usuario !=28 and an.id_usuario !=29 and an.id_usuario !=27 group by an.id_autorizacion_nomina
 ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerAutorizacionesNominaGerente($inicio, $registros, $idSucursal)
    {
        $sql = "select  an.*, u.* from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
 where an.status= 'calculado' and (dan.status_Pago = 'inicializado' or dan.status_Pago = 'en revision') and u.Id_Sucursal = ? and an.id_usuario !=16  
 and an.id_usuario !=17 and an.id_usuario !=28 and an.id_usuario !=29 and an.id_usuario !=27 group by an.id_autorizacion_nomina  LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }
    
    public function totalNominasGerente($fechaInicial, $fechaFinal, $idSucursal)
    {
        $sql = "select * from autorizacion_nomina as an
                inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
                inner join usuarios as u on u.Id_Usuario = an.id_usuario
                where an.fecha_inicial >= ? and an.fecha_final <= ? and u.Id_Sucursal = ? and an.id_usuario !=16  
                and an.id_usuario !=17 and an.id_usuario !=28 and an.id_usuario !=29 and an.id_usuario !=27 group by an.id_autorizacion_nomina";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $fechaInicial, PDO::PARAM_STR);
        $stmt->bindValue(2, $fechaFinal, PDO::PARAM_STR);
        $stmt->bindValue(3, $idSucursal, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerUltimaFechaDeCorte()
    {
        $sql = "select fecha_final_corte from autorizacion_nomina order by fecha_final_corte desc limit 1";
        $stmt = $this->_dbh->prepare($sql);

        try {
            $stmt->execute();
            $response['status'] = true;
            $response['fechaCorte'] = $stmt->fetch(PDO::FETCH_OBJ);


        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener . '
                . TICKETS;
        }

        return $response;
    }


    public function obtenerNominasEnAutorizacionContabilidad()
    {
        $sql = "select an.*, concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, s.Nombre as nombre_sucursal, d.* from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on an.id_usuario = u.Id_Usuario
inner join sucursal as s on s.Id_Sucursal = u.Id_Sucursal
inner join direcciones as d on d.Id_Direccion =s.Id_Direccion
where dan.status_Pago = 'en autorizacion contabilidad' and dan.tipo_nomina = 'externa' group by an.id_usuario";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nominasExterna'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas en autorizacion contabilidad '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerNominasExternaParaRevisarContabilidadPorProveedor($id_Proveedor)
    {
        $sql = "select an.*,dan.*, n.*, pi.*, concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, ner.* from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join nomina as n on n.Id_Usuario = an.id_usuario
inner join nomina_proveedores_externos as pe on pe.id_nomina_proveedores_externos = dan.id_proveedor
inner join proveedores_indirectos as pi on pi.Id_Proveedor = pe.id_proveedor
inner join usuarios as u on an.id_usuario = u.Id_Usuario
inner join nomina_externa_requisicion as ner on dan.id_detalle_autorizacion_nomina = ner.id_detalle_autorizacion_nomina
where ( dan.status_Pago = 'en autorizacion contabilidad') and dan.tipo_nomina = 'externa'  and pi.Id_Proveedor = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_Proveedor, PDO::PARAM_INT);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nominasExternaConRequisicion'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas externas para autorizar '
                . TICKETS;
        }

        return $response;
    }

    public function obtenerNominasEnAutorizacionContabilidadPorSucursal($idSucursal)
    {
        $sql = "select an.*, concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, s.Nombre as nombre_sucursal, d.* from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on an.id_usuario = u.Id_Usuario
inner join sucursal as s on s.Id_Sucursal = u.Id_Sucursal
inner join direcciones as d on d.Id_Direccion =s.Id_Direccion
where dan.status_Pago = 'en autorizacion contabilidad' and s.Id_Sucursal = ? and an.id_usuario !=16  
 and an.id_usuario !=17 and an.id_usuario !=28 and an.id_usuario !=29 and an.id_usuario !=27 group by an.id_usuario";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nominasExterna'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas en autorizacion contabilidad '
                . TICKETS;
        }

        return $response;
    }
    
    public function obtenerNominasInternasEnAutorizacionContabilidad()
    {
        $sql = "select * from autorizacion_nomina as an inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina inner join usuarios as u on an.id_usuario = u.Id_Usuario where ( dan.status_Pago = 'en autorizacion contabilidad') and dan.tipo_nomina = 'interna';";
        $stmt = $this->_dbh->prepare($sql);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['total'] =  $stmt->rowCount();
            $response['nominasInternas'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas en autorizacion contabilidad '
                . TICKETS;
        }

        return $response;
    }
    
    public function validarTarjetasAsistenciaAutorizadas($idSucursal, $fecha)
    {
        $sql = "select * from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on u.Id_Usuario = an.id_usuario
 where u.Id_Sucursal = ? and an.id_usuario !=16  
 and an.id_usuario !=17 and an.id_usuario !=28 and an.id_usuario !=29 and an.id_usuario !=27 and an.fecha_final_corte > ? group by an.id_autorizacion_nomina
 ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idSucursal, PDO::PARAM_INT);
        $stmt->bindValue(2, $fecha, PDO::PARAM_STR);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las tarjetas autorizadas. '
                . TICKETS;
        }

        return $response;
    }
    
      public function obtenerEntradaFacturasNominasExternas($idPoliza)
    {
        $sql = "SELECT * FROM `entrada_facturas_requisiciones_nomina_externa` WHERE `id_polizas_registros` = ?";
        $stmt = $this->_dbh->prepare($sql);

        $stmt->bindValue(1, $idPoliza, PDO::PARAM_INT);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['pago'] = $stmt->fetch(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nomina externa '
                . TICKETS;
        }

        return $response;
    }
    
   public function obtenerNominasTarjetasAsistencia($sucursal)
    {
        $sql = "select an.*, concat(u.Nombre,' ',u.Apellido_Paterno, ' ', u.Apellido_Materno) as nombre_usuario, s.Nombre as nombre_sucursal, d.* from autorizacion_nomina as an
inner join detalle_autorizacion_nomina as dan on dan.id_autorizacion_nomina = an.id_autorizacion_nomina
inner join usuarios as u on an.id_usuario = u.Id_Usuario
inner join sucursal as s on s.Id_Sucursal = u.Id_Sucursal
inner join direcciones as d on d.Id_Direccion =s.Id_Direccion
where dan.status_Pago = 'en autorizacion contabilidad'  AND s.Nombre = ? group by an.id_usuario";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $sucursal, PDO::PARAM_STR);
        try {

            $stmt->execute();
            $response['status'] = true;
            $response['nominasExterna'] = $stmt->fetchAll(PDO::FETCH_OBJ);

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas en autorizacion contabilidad '
                . TICKETS;
        }

        return $response;
    }
    
    public function obtenerNominasTimbradas($idUsuario, $inicio, $registros)
    {
        $sql = "SELECT * FROM `detalle_autorizacion_nomina` as da INNER JOIN `autorizacion_nomina` as an ON an.`id_autorizacion_nomina` = da.`id_autorizacion_nomina` 
                INNER JOIN `usuarios` as u ON an.`id_usuario` = u.`Id_Usuario` INNER JOIN `usuarios` as usu ON usu.`Id_Usuario` = an.`id_usuario` 
                WHERE da.`status_Pago` = 'timbrado' AND an.`archivo_nomina_firmada` is null AND an.id_usuario !=17 and an.id_usuario !=111 AND usu.`Id_Usuario` = ? 
                AND an.id_usuario !=29 and an.id_usuario !=28 and an.id_usuario !=27 ORDER BY an.`fecha_pago` DESC LIMIT ?, ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $inicio, PDO::PARAM_INT);
        $stmt->bindValue(3, $registros, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['nomina'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

    public function subirArchivoNominaFirmada($archivo, $id_autorizacion_nomina)
    {
        $sql = "update autorizacion_nomina set archivo_nomina_firmada = ? where id_autorizacion_nomina = ? ";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $archivo, PDO::PARAM_STR);
        $stmt->bindValue(2, $id_autorizacion_nomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al subir el archivo de tarjeta de asistencia. '
                . TICKETS;
        }

        return $response;

    }

    public function obtenerFolioNomina($id_autorizacion_nomina)
    {
        $sql = "SELECT * FROM `detalle_autorizacion_nomina` as dan INNER JOIN `documentos` as doc ON doc.`Id_Documento` = dan.`id_documento` WHERE dan.`id_autorizacion_nomina` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $id_autorizacion_nomina, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['folioNomina'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al subir el archivo de tarjeta de asistencia. '
                . TICKETS;
        }

        return $response;

    }
    
    public function totalNominasTimbradas($idUsuario)
    {
        $sql = "SELECT da.* FROM `detalle_autorizacion_nomina` as da INNER JOIN `autorizacion_nomina` as an ON an.`id_autorizacion_nomina` = da.`id_autorizacion_nomina` 
                INNER JOIN `usuarios` as u ON an.`id_usuario` = u.`Id_Usuario` INNER JOIN `usuarios` as usu ON usu.`Id_Usuario` = an.`id_usuario` 
                WHERE da.`status_Pago` = 'timbrado' AND an.`archivo_nomina_firmada` is null AND an.id_usuario !=17 and an.id_usuario !=111 AND usu.`Id_Usuario` = 9 
                AND an.id_usuario !=29 and an.id_usuario !=28 and an.id_usuario !=27";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        try {
            $stmt->execute();
            $response['status'] = true;
            $response['total'] = $stmt->rowCount();

        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener las nominas para autorizarlas. '
                . TICKETS;
        }

        return $response;
    }

}
