<?php
/**
 * ObjetivoDao.php
 * Modelo para la persistencia de datos de objetivos
 * @copyright (c) 2016, Merdiz
 * @author José Francisco Montaño Andriano
 * @version 1.0 Beta
 * @package usuarios
 */

require_once BASEPATH . 'core' . DIRECTORY_SEPARATOR . 'Model.php';
require_once BASEPATH . 'helpers' . DIRECTORY_SEPARATOR . 'Utils.php';
require_once BASEPATH . 'application' . DIRECTORY_SEPARATOR . 'usuarios' . 
        DIRECTORY_SEPARATOR . 'models' . DIRECTORY_SEPARATOR . 'Objetivo.php';

class ObjetivoDao extends Model
{
    public function __construct() {
        parent::__construct();
    }
    
    public function guardarObjetivo(Objetivo $o)
    {
        $sql = "INSERT INTO `objetivos_evaluacion` (`Id_Driver`, `Expectativa`, `Id_Indicador`, "
                . "`Resultado`, `Cumplimiento`, `Puntos`, `Id_Periodo`, `Id_Usuario`) "
                . "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $o->__get('_idDriver'), PDO::PARAM_INT);
        $stmt->bindValue(2, $o->__get('_expectativa'), PDO::PARAM_STR);
        $stmt->bindValue(3, $o->__get('_idIndicador'), PDO::PARAM_INT);
        $stmt->bindValue(4, $o->__get('_resultado'), PDO::PARAM_INT);
        $stmt->bindValue(5, $o->__get('_cumplimiento'), PDO::PARAM_INT);
        $stmt->bindValue(6, $o->__get('_puntos'), PDO::PARAM_INT);
        $stmt->bindValue(7, $o->__get('_idPeriodo'), PDO::PARAM_INT);
        $stmt->bindValue(8, $o->__get('_idUsuario'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['idObjetivo'] = $this->_dbh->lastInsertId();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al guardar los objetivos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function actualizarObjetivos(Objetivo $o)
    {
        $sql = "UPDATE `objetivos_evaluacion` SET `Expectativa` = ?, `Resultado` = ? WHERE `Id_Indicador` = ? "
                . "AND `Id_Periodo` = ? AND `Id_Usuario` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $o->__get('_expectativa'), PDO::PARAM_STR);
        $stmt->bindValue(2, $o->__get('_resultado'), PDO::PARAM_STR);
        $stmt->bindValue(3, $o->__get('_idIndicador'), PDO::PARAM_INT);
        $stmt->bindvalue(4, $o->__get('_idPeriodo'), PDO::PARAM_INT);
        $stmt->bindValue(5, $o->__get('_idUsuario'), PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al actualizar los datos. '
                    . TICKETS;
        }
        
        return $response;
        
    }
    
    public function obtenerTotalPuntosPorUsuario($idUsuario, $idPeriodo)
    {
        $sql = "SELECT SUM(`Puntos`) AS `Total_Puntos` FROM `objetivos_evaluacion` "
                . "WHERE `Id_Usuario` = ? AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idPeriodo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['puntos'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los puntos de los objetivos. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerAspectoAMejorar($idUsuario, $idPeriodo)
    {
        $sql = "SELECT * FROM `objetivos_evaluacion` WHERE `Cumplimiento` < 100 "
                . "AND `Id_Usuario` = ? AND `Id_Periodo` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idUsuario, PDO::PARAM_INT);
        $stmt->bindValue(2, $idPeriodo, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['mejoras'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['total'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los aspectos a mejorar. '
                    . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerObjetivosPorUsuario($idUsuario, $idPeriodo)
    {
        $sql = "SELECT * FROM `objetivos_evaluacion` WHERE `Id_Periodo` = $idPeriodo AND `Id_Usuario` = $idUsuario";       
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindvalue(1, $idPeriodo, PDO::PARAM_INT);
        $stmt->bindvalue(2, $idUsuario, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['objetivos'] = $stmt->fetchAll(PDO::FETCH_OBJ);
            $response['totalRegistros'] = $stmt->rowCount();
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener los objetivos. ' . TICKETS;
        }
        
        return $response;
    }
    
    public function obtenerObjetivoIndicador($idDriver, $idIndicador, $idPeriodo, $idEvaluado)
    {
        $sql = "SELECT * FROM `objetivos_evaluacion` WHERE `Id_Periodo` = ? AND `Id_Driver` = ? AND `Id_Indicador` = ? AND `Id_Usuario` = ?";
        $stmt = $this->_dbh->prepare($sql);
        $stmt->bindValue(1, $idPeriodo, PDO::PARAM_INT);
        $stmt->bindValue(2, $idDriver, PDO::PARAM_INT);
        $stmt->bindValue(3, $idIndicador, PDO::PARAM_INT);
        $stmt->bindValue(4, $idEvaluado, PDO::PARAM_INT);
        try{
            $stmt->execute();
            $response['status'] = true;
            $response['datosObjetivo'] = $stmt->fetch(PDO::FETCH_OBJ);
        } catch (PDOException $e) {
            Utils::log($e->getMessage(), $e->getFile(), $e->getLine());
            $response['status'] = false;
            $response['error'] = 'Lo siento, ocurrió un error al obtener el objetivo';
        }
        
        return $response;
    }
}